/*global Mojo _ MojoLoader ModifyAssistant LoginUtil TemplateListAssistant ACCOUNT_KIND PalmCall Util RB ChangeLoginAssistant */

var AccountsListWidget = (function () {
	
	var stylesheets = ["stylesheets/accounts-list.css"];
	
	function styleop(op, div, relativePath) {
		var fn;
		if (op === 'load') {
			fn = Mojo.loadStylesheet;
		} else if (op === 'unload') {
			fn = Mojo.unloadStylesheet;
		}
		if (fn) {
			fn(div.ownerDocument, relativePath, MojoLoader.root);
		}
	}
	
	function toggleAppStylesheets(doc, enable) {
		var links = doc.querySelectorAll('link[type="text/css"]');
		var href;
		var libPrefix = "file://" + MojoLoader.root;
		
		// Mojo.Log.error("toggleAppStylesheets len=%d to %s", links.length, !!enable);
		
		for (var i = 0; i < links.length; i++) {
			href = links[i].href;
			if (!(href.indexOf(libPrefix) === 0 || href.match(/\/usr\/palm\/frameworks\/mojo/))) {
				// Mojo.Log.error("toggling %s to %s", href, !!enable);
				links[i].disabled = !enable;
			}
		}
	}
	
	function handleListTap(e) {
		var template, account = _.clone(e.item);
		account.capabilityProviders = account.capabilityProviders.map(_.clone);
		template = Util.getTemplateById(this.templates, account.templateId);
		
		if (this.attrs.handleListTap) {
			if(e.originalEvent.target.className == "notifications icon selected")
				this.attrs.handleListTap(account, template, "notifications");
			else
				this.attrs.handleListTap(account, template);	
		} else if (account.templateId === "com.palm.sim") {
			// Push SIM scene
			this.stage.pushScene({
				name: "sim",
				assistantConstructor: SimAssistant,
				templateRoot: MojoLoader.root,
				sceneTemplate: "templates/sim-scene",
				templateModel: account
			}, {
				account: account,
				onSetup: this.disableAppStyles,
				onCleanup: this.enableAppStyles
			});
		} else {			
			this.stage.pushScene({
				name: "modify",
				assistantConstructor: ModifyAssistant,
				templateRoot: MojoLoader.root,
				sceneTemplate: "templates/modify-scene",
				templateModel: account
			}, {
				template: template,
				account: account,
				onSetup: this.disableAppStyles,
				onCleanup: this.enableAppStyles
			});
		}
	}
	
	function handleListAdd(options) {
		var sceneTemplate;
		var selectedTemplates = Util.filterTemplates(this.templates, this.filterBy);
		var capability = this.filterBy && this.filterBy.capability;
		
		if (selectedTemplates.length === 0) {
			
			// TODO: localize this error?  It's more of an invalid software configuration than a user-facing condition
			Mojo.Controller.errorDialog("No services implement this functionality: " + this.filterBy.capability);
			
		} else if (false && selectedTemplates.length === 1) {  // disabled until I can figure out how this works in First Launch
			
			LoginUtil.pushLoginScene(this.stage, selectedTemplates[0], this.templates, capability);
			
		} else {
			sceneTemplate = "templates/";
			if (this.filterBy) {
				sceneTemplate += "template-list-firstlaunch-scene";
			} else {
				sceneTemplate += "template-list-scene";
			}
			
			if (!options) {
				options = {};
			}
			options.filterBy = this.filterBy;
			this.stage.pushScene({
				name: "template-list",
				assistantConstructor: TemplateListAssistant,
				templateRoot: MojoLoader.root,
				sceneTemplate: sceneTemplate
			}, selectedTemplates, this.templates, options, this.disableAppStyles, this.enableAppStyles);
			
		}
	}
	
	function decorateItem(item) {
		var selected, 
		    iconPath,
		    displayText,
		    match,
		    annotated = Util.annotateAccount(item, this.templates);
		_.extend(item, annotated);
		
		if (annotated.icon) {
			iconPath = annotated.icon.loc_32x32;
		}
		
		// displayText is either alias, capability-specific name, or general name
		displayText = annotated.loc_name;
		if (this.filterBy && this.filterBy.capability) {
			selected = this.filterBy.capability;
			match = _.detect(annotated.capabilityProviders, function (cp) {
				return cp.capability === selected;
			});
			if (match) {
				if (match.loc_name) {
					displayText = match.loc_name;
				}
				if (match.icon && match.icon.loc_32x32) {
					iconPath = match.icon.loc_32x32;
				}
			}
		}
		
		if (item.alias) {
			displayText = item.alias;
		}
		
		return {
			displayText: displayText,
			icon_32x32: iconPath
		};
	}
	
	function setupList(that) {
		var ctrl = that.controller,
		    scene = ctrl.scene,
		    div = ctrl.element,
		    listAttrs,
		    listModel;
		
		listAttrs = {
			templates: {
				item: "templates/accounts-list-item",
				empty: "templates/accounts-list-empty"
			},
			templateRoot: MojoLoader.root,
			uniquenessProperty: "_id",
			dataSource: that.dataSource,
			decorator: decorateItem.bind(that)
		};
		
		listModel = {
			listTitle: that.attrs.listTitle
		};
		
		if (listModel.listTitle !== "disabled") {
			listAttrs.templates.container = Mojo.Widget.ListTemplate.GROUP_CONTAINER_TITLE;
			if (!listModel.listTitle) {
				listModel.listTitle = RB.$L("Accounts");
			}
		}
		
		scene.setupWidget(that.listId, listAttrs, listModel);
		ctrl.instantiateChildWidgets(div);
	}
	
	function onServiceFailure(response) {
		Mojo.Controller.errorDialog(JSON.stringify(response));
	}
	
	// wraps 'fetchData' so it doesn't respond to fetch requests until
	// the given future is complete
	function wrapFetch(that, future, dsa) {
		var origFetchData = dsa.fetchData;
		
		dsa.fetchData = function () {
			var fetchArgs = arguments;
			
			future.then(function () {
				var r;
				r = future.result;

				origFetchData.apply(dsa, fetchArgs);

				// set the result again to ensure that future invocations
				// pass through
				future.result = r;
			});
		};
		
		return dsa;
	}
	
	function wrapGetItems(dsa) {
		var origGetItems = dsa.getItemsToRender;
		
		dsa.getItemsToRender = function (memo, callback) {
			function dedupe(items) {
				callback(Util.dedupeByProperty(items, "_id"));
			}
			return origGetItems.call(dsa, memo, dedupe);
		};
		
		return dsa;
	}
	
	function createDataSource(that) {
		var templatesFuture,
			mojodbDsa,
			wrappedDsa,
			result;
		
		mojodbDsa = new Mojo.DataSource.DBDataSourceAssistant({
			kind: ACCOUNT_KIND,
			// orderBy: "alias",
			watch: true,
			makeWhere: Util.createWhere.bind(undefined, that.filterBy)
		});
		
		templatesFuture = PalmCall.call("palm://com.palm.service.accounts/", "listAccountTemplates", {});
		templatesFuture.onError(function (f) {
			onServiceFailure(f.exception);
		});
		templatesFuture.then(function (f) {
			result = f.result;
			that.templates = result.results;
			PalmCall.cancel(f);
			f.result = result;
		});
		
		that.templatesFuture = templatesFuture;
		
		wrappedDsa = wrapFetch(that, templatesFuture, mojodbDsa);
		
		// Specifying an array of capabilities means we have to de-dupe on the JS side.
		// De-duping does not work beyond account list lengths of 500 (one db8 window).
		if (that.filterBy && that.filterBy.capability && _.isArray(that.filterBy.capability)) {
			wrappedDsa = wrapGetItems(wrappedDsa);
		}
		return new Mojo.DataSource(wrappedDsa);
	}
	
	function Widget() {
		this.handleListTap = handleListTap.bind(this);
		this.handleListAdd = handleListAdd.bind(this);
	}
	
	Widget.prototype = {
		setup: function () {
			var ctrl, div, prefix;
			var that = this;
			
			ctrl = this.controller;
			this.attrs = ctrl.attributes || {};
			// var model = ctrl.model;
			div = ctrl.element;
			
			this.scene = ctrl.scene;
			this.stage = ctrl.stageController;
			this.doc = ctrl.document;
			
			// var prefix = scene.makeUniqueElementId();
			prefix = Mojo.View.makeUniqueId() + this.scene.sceneId + div.id;
			
			this.listId = prefix + "-accountslist";
			this.filterBy = this.attrs.filterBy;
			
			div.innerHTML = Mojo.View.render({
				object: {
					prefix: prefix
				},
				templateRoot: MojoLoader.root,
				template: "templates/accounts-list"
			});
				
			this.dataSource = createDataSource(this);
			setupList(this);
			
			stylesheets.forEach(styleop.bind(undefined, 'load', div));
			
			this.controller.exposeMethods(['addAccount']);
			
			this.disableAppStyles = function() {
				toggleAppStylesheets(that.doc, false);
			};
			this.enableAppStyles = function() {
				toggleAppStylesheets(that.doc, true);
			};
			
			if (!this.attrs.disableListTap) {
				this.scene.listen(this.listId, Mojo.Event.listTap, this.handleListTap);
			}
		},
		
		cleanup: function () {
			stylesheets.forEach(styleop.bind(undefined, 'unload', this.controller.element));
			
			if (!this.attrs.disableListTap) {
				this.scene.stopListening(this.listId, Mojo.Event.listTap, this.handleListTap);
			}
		},
		
		addAccount: function () {
			var that = this,
			    args = arguments;
			
			// add requests may come in while waiting for templates
			// enqueue and de-bounce the requests
			if (this.templatesFuture.addPending) {
				return;
			}
			this.templatesFuture.addPending = true;
			this.templatesFuture.then(function (f) {
				var r;
				r = f.result;
				
				that.handleListAdd.apply(that, args);
				f.addPending = undefined;
				f.result = r;
			});
		}
	};

	return Widget;
})();
