var IMPORTS=MojoLoader.require({name:"underscore",version:"1.0"},{name:"contacts",version:"1.0"},{name:"globalization",version:"1.0"},{name:"foundations",version:"1.0"},{name:"accounts.ui",version:"1.0"});var _=IMPORTS.underscore._,Contacts=IMPORTS.contacts,Foundations=IMPORTS.foundations,AccountsLib=IMPORTS["accounts.ui"],Assert=Foundations.Assert,Future=Foundations.Control.Future,PalmCall=Foundations.Comms.PalmCall,LIB_ROOT=MojoLoader.root,Globalization=IMPORTS.globalization.Globalization;
var resourceBundleFactory=new Globalization.ResourceBundleFactory(MojoLoader.root);var RB=resourceBundleFactory.getResourceBundle();AccountsLib.enableExtensions();var PersonListWidget=exports.PersonListWidget=function(){Assert.requireDefined(Mojo,"PersonListWidget: Failed to detect the Mojo framework");var _sceneController,_div,_model,_uniqueId="PFLW_"+Date.now(),_stylesheets=[Utils.getStylesheetPath("common.css"),Utils.getStylesheetPath("list.css")],_eventListenerManager=new EventListenerManager,_personListScrollPosition,_favoriteListScrollPosition,_personListDataSource,_favoriteListDataSource,_personListElement,_favoriteListElement,_currentView,_filterString=
"",getWidgetElementId=function(id){return _uniqueId+id},getWidgetElement=function(id){return _sceneController.get(getWidgetElementId(id))},transformListItem=function(person){if(!person)return person;person=Contacts.PersonFactory.createPersonDisplayLite(person,_model.sortOrder);if(_model.exclusions&&Array.isArray(_model.exclusions))if(_model.exclusions.indexOf(person._id)!==-1)person.exclude="exclude";return person},dividerLabelCallback=function(person){if(person&&!person.exclude)return person.dividerText;
else return""},personDecorator=function(itemModel){var decorations={},displayName=Foundations.StringUtils.escapeHTML(itemModel.displayName);if(_filterString)decorations.displayName=Mojo.PatternMatching.addContactMatchFormatting(displayName,_filterString);else decorations.displayName=displayName;return decorations},createAsyncPersonDecorator=function(items,callback){return new PersonAsyncDecorator(items,callback)},setupPersonList=function(){var dataSourceAssistant=Contacts.ListWidget.getTypedownDBDataSourceAssistant({favoritesOnly:_model.favoritesOnly,
excludeFavorites:_model.excludeFavorites}),wrappedDataSourceAssistant=Utils.formatDataSourceAssistant(dataSourceAssistant,transformListItem),dividerTemplate;_personListDataSource=new Mojo.DataSource(wrappedDataSourceAssistant);_personListElement=getWidgetElement("person-list");_model.personListTapCallback=_model.personListTapCallback||_model.listTapCallback;_model.personListDeleteCallback=_model.personListDeleteCallback;if(_model.sortOrder===Contacts.ListWidget.SortOrder.firstLast||_model.sortOrder===Contacts.ListWidget.SortOrder.lastFirst)dividerTemplate=Utils.getTemplatePath("person-filter-list-widget/group-separator");
else dividerTemplate=Utils.getTemplatePath("person-filter-list-widget/multiline-separator");if(_model.personListDeleteCallback&&_.isFunction(_model.personListDeleteCallback))var allowDelete=true;else var allowDelete=false;_sceneController.setupWidget(getWidgetElementId("person-list"),{templateRoot:LIB_ROOT,templates:{item:Utils.getTemplatePath("person-filter-list-widget/person-item"),empty:Utils.getTemplatePath("person-filter-list-widget/empty")},uniquenessProperty:"_id",dataSource:_personListDataSource,dividers:{labelCallback:dividerLabelCallback,template:dividerTemplate},decorator:personDecorator,asyncDecorator:createAsyncPersonDecorator,swipeDelete:true},
{});if(_model.personListTapCallback&&_.isFunction(_model.personListTapCallback))_eventListenerManager.addListener(_personListElement,Mojo.Event.listTap,_model.personListTapCallback);else console.warn("PersonListWidget (setupPersonList) was set up without a listTapCallback.  Do you really want to do this?");if(_model.personListDeleteCallback&&_.isFunction(_model.personListDeleteCallback))_eventListenerManager.addListener(_personListElement,Mojo.Event.listDelete,_model.personListDeleteCallback);},handleAddFavorite=function(person){person.makeFavorite(true)},handleFavoriteDelete=function(items,callback){items.forEach(function(item){var person=Contacts.PersonFactory.createPersonDisplay(item);person.unfavorite(true)});callback()},setupFavoriteList=function(){var dataSourceAssistant=Contacts.ListWidget.getTypedownDBDataSourceAssistant({favoritesOnly:true}),wrappedDataSourceAssistant=Utils.formatDataSourceAssistant(dataSourceAssistant,transformListItem);_favoriteListDataSource=new Mojo.DataSource(wrappedDataSourceAssistant);
_favoriteListElement=getWidgetElement("favorite-list");_model.favoriteListTapCallback=_model.favoriteListTapCallback||_model.listTapCallback;_favoriteListDataSource.removeItems=handleFavoriteDelete;_sceneController.setupWidget(getWidgetElementId("favorite-list"),{templateRoot:LIB_ROOT,templates:{item:Utils.getTemplatePath("person-filter-list-widget/person-item")},uniquenessProperty:"_id",dataSource:_favoriteListDataSource,decorator:personDecorator,asyncDecorator:createAsyncPersonDecorator,
swipeDelete:{deleteText:RB.$L("Remove")}},{});if(_model.favoriteListTapCallback&&_.isFunction(_model.favoriteListTapCallback))_eventListenerManager.addListener(_favoriteListElement,Mojo.Event.listTap,_model.favoriteListTapCallback);else console.warn("PersonListWidget (setupFavoriteList) was set up without a listTapCallback.  Do you really want to do this?");_eventListenerManager.addListener(_favoriteListElement,Mojo.Event.listDelete,handleFavoriteDelete)},swapLists=function(elementIdToShow,elementIdToHide,
useTransition,state){var elementToShow=getWidgetElement(elementIdToShow),elementToHide=getWidgetElement(elementIdToHide),transition;if(useTransition)transition=_sceneController.prepareTransition(Mojo.Transition.crossFade,false);Mojo.Dom.show(elementToShow);Mojo.Dom.hide(elementToHide);_sceneController.showWidgetContainer(elementToShow);_sceneController.hideWidgetContainer(elementToHide);if(state)_sceneController.sceneScroller.mojo.setState(state);if(transition)transition.run()};return{setup:function(sceneController,
div,model){Assert.requireFalse(_sceneController,"PersonListWidget setup() has already been called! Aborting.");Assert.require(sceneController,"PersonListWidget requires a sceneController");_sceneController=sceneController;_div=div&&_.isString(div)?sceneController.get(div):div;_model=model||{};_model.mode=_model.mode||PersonListWidget.MODE.PERSON_AND_FAVORITE_LIST;Assert.require(div,"PersonListWidget requires a div element");if(!_model.sortOrder){Mojo.Log.warning("PersonListWidget: no sort order provided!  Defaulting to Contacts.ListWidget.SortOrder.defaultSortOrder");
_model.sortOrder=Contacts.ListWidget.SortOrder.defaultSortOrder}Utils.loadSceneStyles(_sceneController,_stylesheets,_uniqueId);var listWidgetModel={uniqueId:_uniqueId},hasPersonList=false,hasFavoriteList=false;div.innerHTML=Mojo.View.render({object:listWidgetModel,templateRoot:LIB_ROOT,template:Utils.getTemplatePath("person-filter-list-widget/widget-template")});if(_model.mode===PersonListWidget.MODE.PERSON_AND_FAVORITE_LIST||_model.mode===PersonListWidget.MODE.PERSON_LIST){setupPersonList();hasPersonList=
true}if(_model.mode===PersonListWidget.MODE.PERSON_AND_FAVORITE_LIST||_model.mode===PersonListWidget.MODE.FAVORITE){setupFavoriteList();hasFavoriteList=true}if(_model.defaultView===PersonListWidget.VIEW.PERSON_LIST)this.showPersonList();else if(_model.defaultView===PersonListWidget.VIEW.FAVORITE_LIST)this.showFavoriteList();else if(hasPersonList)this.showPersonList();else if(hasFavoriteList)this.showFavoriteList()},getCurrentView:function(){return _currentView},teardown:function(){Utils.unloadSceneStyles(_sceneController,
_stylesheets,_uniqueId);_eventListenerManager.destroyListeners()},showPersonList:function(useTransition){if(_currentView===PersonListWidget.VIEW.PERSON_LIST)return;_currentView=PersonListWidget.VIEW.PERSON_LIST;_favoriteListScrollPosition=_sceneController.sceneScroller.mojo.getState();swapLists("person-list-container","favorite-list-container",useTransition,_personListScrollPosition)},showFavoriteList:function(useTransition){if(_currentView===PersonListWidget.VIEW.FAVORITE_LIST)return;_currentView=
PersonListWidget.VIEW.FAVORITE_LIST;_personListScrollPosition=_sceneController.sceneScroller.mojo.getState();swapLists("favorite-list-container","person-list-container",useTransition,_favoriteListScrollPosition)},showAddFavorite:function(){pushPeoplePickerScene(_sceneController.stageController,{excludeFavorites:true,iconClass:"icon-add-fav",message:RB.$L("Add to Favorites"),callback:handleAddFavorite});},filter:function(str,setCountFn){var dataSource,listElement;if(_currentView===PersonListWidget.VIEW.FAVORITE_LIST){dataSource=_favoriteListDataSource;listElement=_favoriteListElement}else{dataSource=_personListDataSource;listElement=_personListElement}_filterString=str;dataSource.setFilterString(str);
dataSource.getCount(setCountFn);listElement.mojo.invalidate()},invalidate:function(){_favoriteListElement.mojo.invalidate();_personListElement.mojo.invalidate()}}};PersonListWidget.MODE={PERSON_LIST:"mode_person_list",FAVORITE_LIST:"mode_favorite_list",PERSON_AND_FAVORITE_LIST:"mode_person_and_favorite_list"};PersonListWidget.VIEW={PERSON_LIST:"view_person_list",FAVORITE_LIST:"view_favorite_list"};var DetailWidget=exports.DetailWidget=function(){Assert.requireDefined(Mojo,"DetailWidget: Failed to detect the Mojo framework");this.controller=undefined;this._widget={div:undefined,model:undefined,stylesheets:[Utils.getStylesheetPath("common.css"),Utils.getStylesheetPath("detail.css"),Utils.getStylesheetPath("sandbox-styles.css")],uniqueId:"PFLW_"+Date.now()};this.person=undefined;this.personId=undefined;this.personRev=undefined;this.clippedModel={};this.currentlyLinking=false;this.listConfigs=
[{listName:"phone",listId:"phoneList",itemTemplate:"phone-item"},{listName:"email",listId:"emailList",itemTemplate:"email-item"},{listName:"messaging",listId:"messagingList",itemTemplate:"messaging-item"},{listName:"address",listId:"addressList",itemTemplate:"address-item"},{listName:"url",listId:"urlList",itemTemplate:"url-item"},{listName:"notes",listId:"notesList",itemTemplate:"notes-item"},{listName:"moredetails",listId:"moredetailsList",itemTemplate:"moredetails-item"}];this.eventListenerManager=
new EventListenerManager;this.listManager=new MultipleListManager;this.imStatusWatchers={}};
DetailWidget.prototype.setup=function(sceneController,div,model,accountList){var widgetSetupFuture=new Future;Assert.requireFalse(this.controller,"DetailWidget setup() has already been called! Aborting.");Assert.require(sceneController,"DetailWidget requires a sceneController");this.controller=sceneController;this._widget.div=div&&_.isString(div)?this.controller.get(div):div;this._widget.model=model||{};this.accountList=accountList||new AccountList;this.boundAccountsUpdatedFunction=this.accountsUpdated.bind(this);
this.accountList.addListener(this.boundAccountsUpdatedFunction);Assert.require(div,"DetailWidget requires a div element");Assert.require(this._widget.model.person||this._widget.model.personId,"DetailWidget requires a personId or a decorated personDisplay");Utils.loadSceneStyles(this.controller,this._widget.stylesheets,this._widget.uniqueId);this._widget.div.innerHTML=Mojo.View.render({object:{uniqueId:this._widget.uniqueId},templateRoot:LIB_ROOT,template:Utils.getTemplatePath("detail-widget/widget-template")});
if(this._widget.model.skypeCallingEnabled!==undefined){this.skypeCallingEnabled=this._widget.model.skypeCallingEnabled;widgetSetupFuture.now(this,function(){return true})}else{widgetSetupFuture.now(this,function(){return PalmCall.call("palm://com.palm.service.accounts/","listAccountTemplates",{capability:"VOICE"})});widgetSetupFuture.then(this,function(){var result=widgetSetupFuture.result;if(!result||!result.results||!_.isArray(result.results)){this.skypeCallingEnabled=false;return true}this.skypeCallingEnabled=
result.results.some(function(accountTemplate){return accountTemplate.templateId==="com.skype"});return true})}if(this._widget.model.person)widgetSetupFuture.then(this,function(){var dummy=widgetSetupFuture.result;return this._widget.model.person});else if(this._widget.model.personId){this.personId=this._widget.model.personId;widgetSetupFuture.then(this,function(){var dummy=widgetSetupFuture.result;return Contacts.Person.getDisplayablePersonAndContactsById(this._widget.model.personId)})}this.personDetailElement=
this.controller.get("contact_detail");this.header=this.controller.get("detail-header");this.headerDrawer=this.controller.get("clipped-info-drawer");this.linkedContactsDiv=this.controller.get("clipped-list");this.linkMoreButton=this.controller.get("clip-button");this.reminderContainer=this.controller.get("reminderContainer");this.controller.setupWidget("clipped-info-drawer",{open:false},{});this.clippedModel={items:[]};this.clippedList={templateRoot:LIB_ROOT,itemTemplate:Utils.getTemplatePath("detail-widget/clipped-item")};
this.controller.setupWidget("clipped-list",this.clippedList,this.clippedModel);if(!this._widget.model.hideLinkedContacts){this.linkedContactsTapDestructor=TinyList.setupTapHandler(this.linkedContactsDiv,this.clippedModel,this.handleLinkedContactsListTap.bind(this));this.eventListenerManager.addListener(this.header,Mojo.Event.tap,this.toggleLinked.bind(this));this.eventListenerManager.addListener(this.linkMoreButton,Mojo.Event.tap,this.handleLinkMore.bind(this))}this.setupLists();widgetSetupFuture.then(this,
function(){var person=widgetSetupFuture.result,contacts;this.setCurrentPerson(person);this.renderPerson();if(this._widget.model.contactsFuture)return this._widget.model.contactsFuture;else{contacts=person.getContacts();if(_.isArray(contacts)&&contacts.length>0)return contacts;else return person.reloadContacts(Contacts.ContactFactory.ContactType.DISPLAYABLE)}});widgetSetupFuture.then(this,function(){var contacts=widgetSetupFuture.result;this.setAndRenderLinkedContactsList(contacts);return true});this.openWith=
new OpenWithMenu({isMimeType:false,urlOrMime:"mapto:",controller:this.controller,listId:"addressList"});this.eventListenerManager.addListener(this.reminderContainer,Mojo.Event.tap,this.handleReminderTap.bind(this));return widgetSetupFuture};DetailWidget.prototype.accountsUpdated=function(){this.renderLinkedContactsList()};
DetailWidget.prototype.teardown=function(){Utils.unloadSceneStyles(this.controller,this._widget.stylesheets,this._widget.uniqueId);this.eventListenerManager.destroyListeners();if(this.linkedContactsTapDestructor)this.linkedContactsTapDestructor();this.listManager.destroy();this.openWith.destroy();var that=this;Object.keys(this.imStatusWatchers).forEach(function(imStatusWatcherKey){that.imStatusWatchers[imStatusWatcherKey].cancel()});this.accountList.removeListener(this.boundAccountsUpdatedFunction);
if(this.personWatchFuture)this.person.stopWatchingForDatabaseChanges(this.personWatchFuture)};DetailWidget.prototype.getPerson=function(){return this.person};DetailWidget.prototype.getPersonId=function(){return this.personId};DetailWidget.prototype.isCurrentlyLinking=function(){return this.currentlyLinking};DetailWidget.prototype.fireRenderAfterUpdateCallback=function(){if(_.isFunction(this._widget.model.onRenderAfterUpdateCallback))this._widget.model.onRenderAfterUpdateCallback()};
DetailWidget.prototype.firePersonRenderedCallback=function(){if(_.isFunction(this._widget.model.onPersonRenderedCallback))this._widget.model.onPersonRenderedCallback()};DetailWidget.prototype.getWidgetElementId=function(id){return this._widget.uniqueId+id};DetailWidget.prototype.getWidgetElement=function(id){return this.controller.get(this.getWidgetElementId(id))};
DetailWidget.prototype.setupLists=function(){var that=this;this.listConfigs.forEach(function(listConfig){var attributes={itemTemplate:Utils.getTemplatePath("detail-widget/"+listConfig.itemTemplate),listTemplate:Utils.getTemplatePath("detail-widget/group-container-unlabeled"),templateRoot:LIB_ROOT},model={items:[]},div=that.controller.get(listConfig.listId),updateFn=TinyList.renderData.bind(that,div,attributes),tapEventListenerDestructor=TinyList.setupTapHandler(div,model,that.handleListTap.bind(that));
that.listManager.addListConfig(listConfig.listName,attributes,model,div,updateFn,tapEventListenerDestructor)})};DetailWidget.prototype.setCurrentPerson=function(person,isTemporary){this.person=person;this.personId=this.person.getId();this.personRev=this.person.getRev();if(!isTemporary&&person.getId())this.createPersonWatch()};
DetailWidget.prototype.createPersonWatch=function(){if(this.personWatchFuture)this.person.stopWatchingForDatabaseChanges(this.personWatchFuture);this.personWatchFuture=this.person.watchForDatabaseChanges().then(this,this.handlePersonDBUpdate)};
DetailWidget.prototype.handlePersonDBUpdate=function(future){var result=future.result,person,getContactsFuture;if(result.fired){console.log("PERSON WATCH FIRED!!");this.createPersonWatch()}else{future.then(this,this.handlePersonDBUpdate);console.log("WATCH FUTURE RESULT: "+JSON.stringify(result));person=Contacts.PersonFactory.createPersonDisplay(result);if(person.getRev()>this.personRev){getContactsFuture=person.reloadContacts(Contacts.ContactFactory.ContactType.DISPLAYABLE);getContactsFuture.then(this,
function(){var result=getContactsFuture.result;console.log("finished fetching contacts: "+person.getContacts().toString());this.setCurrentPerson(person);this.renderPersonAndLinkedContacts();this.fireRenderAfterUpdateCallback();getContactsFuture.result=true})}else console.log("New person has a revId that is not greater than the currently rendered person")}};
DetailWidget.prototype.renderPerson=function(){this.renderHeader();this.renderContactPropertyLists();this.showDeferrals();this.renderReminder();this.firePersonRenderedCallback()};DetailWidget.prototype.renderLinkedContacts=function(){this.setAndRenderLinkedContactsList(this.person.getContacts())};DetailWidget.prototype.renderPersonAndLinkedContacts=function(){this.renderPerson();this.renderLinkedContacts()};
DetailWidget.prototype.renderHeader=function(dontReloadPhotos){if(this.person){this.renderHeaderHelper();if(!dontReloadPhotos){var future=this.person.getPhotos().getPhotoPath(Contacts.PersonPhotos.TYPE.SQUARE);future.then(this,function(){var newHeaderPhotoPath=future.result;if(newHeaderPhotoPath!==this.person.headerPhotoPath)this.renderHeaderHelper()})}}else console.log("Aborting renderHeader because this.person is null")};
DetailWidget.prototype.renderHeaderHelper=function(){this.header.innerHTML=Mojo.View.render({templateRoot:LIB_ROOT,template:Utils.getTemplatePath("detail-widget/header"),object:this.person})};DetailWidget.prototype.setAndRenderLinkedContactsList=function(contacts){if(!this._widget.model.hideLinkedContacts){this.clippedModel.items=contacts;this.renderLinkedContactsList()}};DetailWidget.prototype.appendLinkedContact=function(contact){this.clippedModel.items.push(contact);this.renderLinkedContactsList()};
DetailWidget.prototype.renderLinkedContactsList=function(){var that=this,future;if(this.clippedModel.items.length===1)this.clippedModel.items[0].singleItem="x";else if(this.clippedModel.items.length)this.clippedModel.items[0].singleItem="";if(this.clippedModel.items.length>0)this.clippedModel.items[0].primary="primary";this.clippedModel.items.forEach(function(item){item.iconPath=that.accountList.getAccountIcon(item.getAccountId().getValue(),item.getKindName(true))});TinyList.renderData(this.linkedContactsDiv,
this.clippedList,this.clippedModel.items);future=Contacts.ContactPhoto.attachPhotoPathsToContacts(this.clippedModel.items,Contacts.ContactPhoto.TYPE.SQUARE,"drawerPhotoPath");future.then(this,function(){var dummy=future.result;TinyList.renderData(this.linkedContactsDiv,this.clippedList,this.clippedModel.items)})};
DetailWidget.prototype.handleLinkedContactsListTap=function(event){var choices=[],contact=event.item,itemNode=event.itemElement;if(contact.isFakeContact||this.person.getContacts().length<2)return;choices.push({label:RB.$L("Unlink this profile"),value:"UNCLIP"});if(this.person.getContactIds().getArray()[0].getValue()!==contact.getId())choices.push({label:RB.$L("Set as primary profile"),value:"MAKE_PRIMARY"});if(!this.accountList.isContactReadOnly(contact))choices.push({label:RB.$L("Delete this profile"),
value:"DELETE_PROFILE",type:"negative"});choices.push({label:RB.$L("Cancel"),value:"CANCEL",type:"dismiss"});this.controller.showAlertDialog({onChoose:this.onClippedChoose.bind(this,contact,itemNode),title:contact.displayName,choices:choices})};
DetailWidget.prototype.linkExisting=function(personDisplay){var fakeContact=Contacts.ContactFactory.createContactDisplay();fakeContact.populateFromPerson(personDisplay);fakeContact.generateDisplayParams();this.appendLinkedContact(fakeContact);this.currentlyLinking=true;Contacts.Person.manualLink(this.person.getId(),personDisplay.getId()).then(this,function(future){var result=future.result})};
DetailWidget.prototype.handleLinkMore=function(){var headerMessage,headerTemplate;if(this.isPseudoCard)headerMessage=RB.$L("Link To Existing Contact");else headerMessage=RB.$L("Link to #{name}");headerTemplate=new Mojo.Format.Template(headerMessage);headerMessage=headerTemplate.evaluate({name:this.person.displayName});pushPeoplePickerScene(this.controller.stageController,{exclusions:[this.person.getId()],iconClass:"icon-clip",message:headerMessage,callback:this.linkExisting.bind(this)})};
DetailWidget.prototype.setFavoriteAppearance=function(newFavoriteState){this.person.toggleFavoriteAppearance(newFavoriteState);this.renderHeaderHelper()};DetailWidget.prototype.onSynchronousChange=function(){};
DetailWidget.prototype.renderContactPropertyLists=function(){var that=this,phoneNumberItems,messagingItems;this.listManager.updateListItems("email",this.person.getEmails().getArray());this.listManager.updateListItems("address",this.person.getAddresses().getArray());this.listManager.updateListItems("url",this.person.getUrls().getArray());this.listManager.updateListItems("notes",this.person.getNotes().getArray());this.listManager.updateListItems("moredetails",this.generateMoreDetailsItems());phoneNumberItems=
this.person.getPhoneNumbers().getArray();phoneNumberItems.forEach(function(phoneNumberItem){phoneNumberItem.hasSpeedDial=phoneNumberItem.getSpeedDial()?"show-quick-dial":""});this.listManager.updateListItems("phone",phoneNumberItems);messagingItems=this.person.getIms().getArray();messagingItems.forEach(function(messagingItem){var hashKey,imStatusWatcher;hashKey=messagingItem.getNormalizedHashKey();if(!that.imStatusWatchers[hashKey]){imStatusWatcher=new ImAddressStatusWatcher(messagingItem.getValue(),
messagingItem.getType(),that.imStatusChangedCallback.bind(that));that.imStatusWatchers[hashKey]=imStatusWatcher}messagingItem.imStatusClassName=that.imStatusWatchers[hashKey].getCurrentStatus().imStatusClassName;if(that.skypeCallingEnabled&&messagingItem.getType()===Contacts.IMAddress.TYPE.SKYPE)messagingItem.skypeIconDisabled="";else messagingItem.skypeIconDisabled="hide-skype"});this.listManager.updateListItems("messaging",messagingItems)};
DetailWidget.prototype.imStatusChangedCallback=function(newImStatus){var messagingItems=this.person.getIms().getArray(),messagingItem=_.detect(messagingItems,function(imAddress){return newImStatus.imAddress===imAddress.getValue()&&newImStatus.type===imAddress.getType()});if(messagingItem){messagingItem.imStatusClassName=newImStatus.imStatusClassName;this.listManager.updateListItems("messaging",messagingItems)}};
DetailWidget.prototype.generateMoreDetailsItems=function(){var moreDetailsItems=[],birthday=this.person.getBirthday().getDisplayValue(),relations=this.person.getRelations().getArray(),spouse=_.detect(relations,function(relation){return relation.getType()===Contacts.Relation.TYPE.SPOUSE}),child=_.detect(relations,function(relation){return relation.getType()===Contacts.Relation.TYPE.CHILD}),nickname=this.person.getNickname().getDisplayValue();if(birthday)moreDetailsItems.push({key:RB.$L("birthday"),
value:birthday});if(spouse)moreDetailsItems.push({key:RB.$L("spouse"),value:spouse.getDisplayValue()});if(child)moreDetailsItems.push({key:RB.$L("children"),value:child.getDisplayValue()});if(nickname)moreDetailsItems.push({key:RB.$L("nickname"),value:nickname});return moreDetailsItems};
DetailWidget.prototype.renderReminder=function(){var reminder=this.person.getReminder().getValue();if(reminder&&reminder.length>0){this.reminderContainer.innerHTML=Mojo.View.render({templateRoot:LIB_ROOT,template:Utils.getTemplatePath("detail-widget/reminder"),object:{reminder:reminder}});Mojo.Dom.show(this.reminderContainer)}else Mojo.Dom.hide(this.reminderContainer)};
DetailWidget.prototype.handleReminderTap=function(){pushReminderScene(this.controller.stageController,{person:this.person,fullName:this.person.getName().getFullName(),reminderText:this.person.getReminder().getValue()||"",focusField:true})};
DetailWidget.prototype.showDeferrals=function(){var deferrals,i;if(this.hasShowDeferralsBeenExecuted)return;deferrals=this.controller.select(".new-defer");for(i=0;i<deferrals.length;i+=1){deferrals[i].style.display="inherit";this.controller.showWidgetContainer(deferrals[i])}this.hasShowDeferralsBeenExecuted=true};DetailWidget.prototype.moreDetailNames=["birthday","spouse","children","nickname"];
DetailWidget.prototype.toggleLinked=function(event){if(!this._widget.model.hideLinkedContacts){Mojo.Dom.toggleClassName(this.header,"drawer-open");this.headerDrawer.mojo.toggleState()}};
DetailWidget.prototype.onClippedChoose=function(contact,node,selection){var foundPrimary=false,future;if(selection==="UNCLIP"){Mojo.Log.info("manualunlink contact.getId(): "+contact.getId());future=Contacts.Person.manualUnlink(this.person.getId(),contact.getId());future.then(this,function(future){var result=future.result;Mojo.Log.info("\n\n\n^^^^^^^manualUnLink RESULT!!!!: "+JSON.stringify(result));this.onSynchronousChange();future.result=true})}else if(selection==="MAKE_PRIMARY"){foundPrimary=this.person.setContactWithIdAsPrimary(contact.getId());
if(foundPrimary){future=this.person.fixup();future.then(this,function(future){var result=future.result;return this.person.save()});future.then(this,function(){var result=future.result;return this.onSynchronousChange()})}}else if(selection==="DELETE_PROFILE"){Mojo.Dom.addClassName(node,"deleting");future=contact.deleteContact();future.then(this,function(){var dummy=future.result;console.log("Finished deleting contact. calling renderPersonAndLinkedContacts()");this.renderPersonAndLinkedContacts();this.fireRenderAfterUpdateCallback();
future.result=true})}};DetailWidget.prototype.launchOtherApp=function(appId,params){Mojo.Log.info("Launching app "+appId);return this.controller.serviceRequest("palm://com.palm.applicationManager",{method:"open",parameters:{id:appId,params:params}})};
DetailWidget.prototype.handleListTap=function(e){var eventTarget=this.controller.get(e.originalEvent.target),item=e.item,useMessaging=false,usePhone=false,launchParams;if(Mojo.Dom.hasClassName(eventTarget,"messaging"))useMessaging=true;if(Mojo.Dom.hasClassName(eventTarget,"phone"))usePhone=true;if(!useMessaging&&!usePhone)if(item instanceof Contacts.IMAddress)useMessaging=true;else if(item instanceof Contacts.PhoneNumber)usePhone=true;if(useMessaging){launchParams={compose:{personId:this.person.getId()}};
if(item instanceof Contacts.IMAddress)launchParams.compose.ims=[item.getDBObject()];else launchParams.compose.phoneNumbers=[item.getDBObject()];return this.launchOtherApp("com.palm.app.messaging",launchParams)}else if(usePhone){launchParams={personId:this.person.getId(),address:item.getValue(),addressLabel:item.getType()};if(item instanceof Contacts.IMAddress)launchParams.service=item.getType();return this.launchOtherApp("com.palm.app.phone",launchParams)}else if(item instanceof Contacts.Address)this.openWith.shouldOpenOpenWith(e);
else if(item instanceof Contacts.EmailAddress)return this.launchOtherApp("com.palm.app.email",{uri:"mailto:"+item.getValue()});else if(item instanceof Contacts.Url)return this.launchOtherApp("com.palm.app.browser",{scene:"page",url:item.getValue()})};var PeoplePickerAssistant=function(params){this.eventListenerManager=new EventListenerManager;if(params){this.popSceneOnPersonSelect=params.popSceneOnPersonSelect!==undefined?params.popSceneOnPersonSelect:true;this.focusWindow=params.focusWindow;this.favoritesOnly=params.favoritesOnly;this.excludeFavorites=params.excludeFavorites;this.personExclusions=params.exclusions;this.pickerMessage=params.message;this.iconClass=params.iconClass;this.returnRawResult=params.returnRawResult;this.peoplePickerCallback=
params.callback}};
PeoplePickerAssistant.prototype.setup=function(){var personListModel,sortOrder;this.listDiv=this.controller.get("peoplepicker-person-list");this.listHeader=this.controller.get("peoplepicker-header");if(this.pickerMessage)this.listHeader.innerHTML=Mojo.View.render({templateRoot:LIB_ROOT,template:Utils.getTemplatePath("peoplepicker/header"),object:{message:this.pickerMessage,iconClass:this.iconClass}});this.spinnerModel={spinning:false};this.controller.setupWidget("list-saving-spinner",{spinnerSize:"large"},
this.spinnerModel);sortOrder=Contacts.ListWidget.SortOrder.defaultSortOrder;this.filterFieldElement=this.controller.get("peoplePickerFilterField");this.controller.setupWidget("peoplePickerFilterField",{delay:0},{});this.eventListenerManager.addListener(this.filterFieldElement,Mojo.Event.filter,this.handleFilter.bind(this));this.eventListenerManager.addListener(this.filterFieldElement,Mojo.Event.filterOpened,this.handleFilterOpened.bind(this));this.eventListenerManager.addListener(this.filterFieldElement,
Mojo.Event.filterClosed,this.handleFilterClosed.bind(this));this.personListWidget=new PersonListWidget;personListModel={mode:PersonListWidget.MODE.PERSON_LIST,defaultView:PersonListWidget.VIEW.PERSON_LIST,listTapCallback:this.handleListTap.bind(this),exclusions:this.personExclusions||[],favoritesOnly:this.favoritesOnly,excludeFavorites:this.excludeFavorites,sortOrder:sortOrder};this.personListWidget.setup(this.controller,this.listDiv,personListModel);Mojo.Dom.addClassName(this.controller.document.body,
"no-wallpaper")};PeoplePickerAssistant.prototype.activate=function(){if(this.focusWindow){this.focusWindow=false;this.controller.stageController.activate()}};PeoplePickerAssistant.prototype.deactivate=function(){Mojo.Dom.removeClassName(this.controller.document.body,"no-wallpaper")};PeoplePickerAssistant.prototype.cleanup=function(){this.personListWidget.teardown();this.eventListenerManager.destroyListeners()};PeoplePickerAssistant.prototype.handleFilterOpened=function(event){Mojo.Dom.hide(this.listHeader)};
PeoplePickerAssistant.prototype.handleFilterClosed=function(event){Mojo.Dom.show(this.listHeader)};PeoplePickerAssistant.prototype.handleFilter=function(event){this.personListWidget.filter(event.filterString,this.filterFieldElement.mojo.setCount)};PeoplePickerAssistant.prototype.handleSortOrder=function(response){this.sortOrder=response.order};PeoplePickerAssistant.prototype.handleCommand=function(event){};
PeoplePickerAssistant.prototype.handleListTap=function(event){var personLite=event.item,person;Mojo.Log.info("tapped on "+event.item.display+" at time="+Date.now());if(this.returnRawResult)person=personLite;else person=Contacts.PersonFactory.createPersonDisplay(personLite);if(_.isFunction(this.peoplePickerCallback)){if(this.popSceneOnPersonSelect)this.controller.stageController.popScene();this.peoplePickerCallback(person)}else;};
PeoplePickerAssistant.prototype.showListSavingScrim=function(){Mojo.Dom.show(this.controller.get("list-saving-div"));this.spinnerModel.spinning=true;this.controller.modelChanged(this.spinnerModel)};PeoplePickerAssistant.prototype.showErrorMessage=function(error){this.controller.showAlertDialog({message:error,choices:[{label:RB.$L("OK"),command:"ok"}],onChoose:function(){}})};var PseudoDetailAssistant=function(params,contactsFuture){this.params=params||{};this.contactsFuture=contactsFuture;this.mode=PseudoDetailAssistant.MODE.EDIT;this.focusWindow=this.params.focusWindow;if(this.params.contact)Assert.require(this.params.contact instanceof Contacts.Contact,"PseudoDetailAssistant requires a decorated Contact");if(this.params.person)Assert.require(this.params.person instanceof Contacts.Person,"PseudoDetailAssistant requires a decorated Person");Assert.require(this.params.contact||
this.params.person||this.params.personId,"PseudoDetailAssistant requires a decorated Person, a decorated Contact, or a person id");this.handleStageBlur=this.handleStageBlur.bind(this)};
PseudoDetailAssistant.prototype.setup=function(){var future=new Future;future.now(this,function(){this.detailWidget=new DetailWidget;this.contact=this.params.contact;var detailModel={person:this.contact?Contacts.PersonFactory.createPersonDisplay(this.contact):this.params.person,personId:this.params.personId,contactsFuture:this.contactsFuture},commandMenuItemModel={visible:true,items:[]};if(this.contact){detailModel.hideLinkedContacts=true;this.mode=PseudoDetailAssistant.MODE.ADD}if(this.mode===PseudoDetailAssistant.MODE.EDIT)commandMenuItemModel.items.push({label:RB.$L("Edit"),
command:"edit"});else commandMenuItemModel.items.push({label:RB.$L("Add To Contacts"),command:"add"});this.controller.setupWidget(Mojo.Menu.commandMenu,undefined,commandMenuItemModel);return this.detailWidget.setup(this.controller,this.controller.get("pseudodetail"),detailModel)});return future};
PseudoDetailAssistant.prototype.activate=function(){if(this.focusWindow){this.focusWindow=false;this.controller.stageController.activate()}this.controller.listen(this.controller.document,Mojo.Event.stageDeactivate,this.handleStageBlur)};PseudoDetailAssistant.prototype.deactivate=function(){this.controller.stopListening(this.controller.document,Mojo.Event.stageDeactivate,this.handleStageBlur)};PseudoDetailAssistant.prototype.cleanup=function(){this.detailWidget.teardown()};
PseudoDetailAssistant.prototype.handleCommand=function(event){if(event.type===Mojo.Event.command)if(event.command==="edit")this.launchContactsAppToEditView();else if(event.command==="add")this.addToContactsPopup()};PseudoDetailAssistant.prototype.handleStageBlur=function(){this.controller.stageController.popScene()};PseudoDetailAssistant.prototype.launchContactsAppToEditView=function(){this.launchContactsApp({launchType:"editContact",person:this.detailWidget.getPerson().getDBObject()})};
PseudoDetailAssistant.prototype.addToContactsPopup=function(){this.controller.showAlertDialog({onChoose:this.addToContactsPopupChoice.bind(this),choices:[{label:RB.$L("Add New Contact"),value:"NEW"},{label:RB.$L("Add to existing"),value:"EXISTING"},{label:RB.$L("Cancel"),value:"CANCEL"}]})};
PseudoDetailAssistant.prototype.addToContactsPopupChoice=function(choice){if(choice==="CANCEL")return;else if(choice==="NEW")this.launchContactsApp({contact:this.contact.getDBObject(),launchType:"newContact"});else if(choice==="EXISTING")this.launchContactsApp({person:this.detailWidget.getPerson().getDBObject(),launchType:"addToExisting"})};
PseudoDetailAssistant.prototype.launchContactsApp=function(params){this.controller.serviceRequest("palm://com.palm.applicationManager",{method:"launch",parameters:{id:"com.palm.app.contacts",params:params}});this.controller.stageController.popScene()};PseudoDetailAssistant.MODE={EDIT:"mode_edit",ADD:"mode_add"};var ReminderAssistant=function(params){this.focusField=params.focusField;this.focusWindow=params.focusWindow;this.person=params.person;this.personId=params.personId;this.reminderText=params.reminderText;this.fullName=params.fullName;this.hasReminderTextToLoad=params.hasReminderTextToLoad;this.deleteReminder=false;this.fetchPersonFuture=new Future;Assert.require(this.person&&this.person instanceof Contacts.Person||this.personId,"ReminderAssistant requires that you pass a decorated person or personId")};
ReminderAssistant.prototype.setup=function(){var hintTextToDisplay;this.fetchPersonFuture.now(this,function(){if(this.person&&this.person instanceof Contacts.Person)this.fetchPersonFuture.result=this.person;else this.fetchPersonFuture.nest(Contacts.Person.findById(this.personId))});this.reminderModel={reminder:this.reminderText};hintTextToDisplay=ReminderAssistant.reminderTextFieldHintValues.create;if(this.hasReminderTextToLoad)hintTextToDisplay=ReminderAssistant.reminderTextFieldHintValues.loading;
this.reminderAttributes={multiline:true,modelProperty:"reminder",hintText:hintTextToDisplay};this.controller.setupWidget("reminderTextField",this.reminderAttributes,this.reminderModel);this.controller.setupWidget(Mojo.Menu.commandMenu,undefined,{items:[{icon:"delete",label:"Clear",command:"clear"}]});if(!this.focusField)this.controller.setInitialFocusedElement(null);this.fetchPersonFuture.then(this,function(){this.person=this.fetchPersonFuture.result;this.renderHeader(this.person.getName().getFullName());
this.reminderModel.reminder=this.person.getReminder().getValue();this.reminderAttributes.hintText=ReminderAssistant.reminderTextFieldHintValues.create;this.controller.modelChanged(this.reminderModel);this.fetchPersonFuture.result=this.person})};ReminderAssistant.prototype.renderHeader=function(fullName){var header=Mojo.View.render({templateRoot:LIB_ROOT,template:Utils.getTemplatePath("reminder/header"),object:{fullName:fullName}});this.controller.get("reminderHeader").innerHTML=header};
ReminderAssistant.prototype.handleCommand=function(event){if(event.type===Mojo.Event.command&&event.command==="clear")this.clearReminder()};ReminderAssistant.prototype.serviceFailed=function(){this.controller.stageController.popScene()};ReminderAssistant.prototype.activate=function(){if(this.focusWindow){this.controller.stageController.activate();this.focusWindow=false}};ReminderAssistant.prototype.clearReminder=function(){this.deleteReminder=true;this.reminderModel.reminder=null;this.controller.stageController.popScene()};
ReminderAssistant.prototype.cleanup=function(){if(this.person){this.person.getReminder().setValue(this.deleteReminder?"":this.reminderModel.reminder.trim());this.person.save()}};ReminderAssistant.reminderTextFieldHintValues={loading:RB.$L("Loading reminder text..."),create:RB.$L("Create new reminder...")};var ContactPointPickerAssistant=function(params){Assert.require(params.type,"ContactPointPickerAssistant requires a type");if(_.isString(params.type))this.types=[params.type];else if(_.isArray(params.type))this.types=params.type;Assert.requireArray(this.types,"ContactPointPickerAssistant invalid type param");this.person=params.person;this.personId=params.personId;this.message=params.message;this.callback=params.callback;this.popSceneOnItemSelect=params.popSceneOnItemSelect!==undefined?params.popSceneOnItemSelect:
true;this.showSpeedDialButtons=params.showSpeedDialButtons;this.saveSelectionAsPrimary=params.saveSelectionAsPrimary;this.uniqueId="CPP_"+Date.now();this.stylesheets=[Utils.getStylesheetPath("contactpointpicker.css")];this.listIndexForDefault=params.listIndexForDefault;this.auxFavoriteDataForDefault=params.auxFavoriteDataForDefault};
ContactPointPickerAssistant.prototype.setup=function(){Utils.loadSceneStyles(this.controller,this.stylesheets,this.uniqueId);Mojo.Dom.addClassName(this.controller.document.body,"no-wallpaper");this.listAttrs={itemTemplate:Utils.getTemplatePath("contactpointpicker/item"),templateRoot:LIB_ROOT};this.listModel={items:[]};this.controller.setupWidget("contactpoint-picker-list",this.listAttrs,this.listModel);this.controller.listen("contactpoint-picker-list",Mojo.Event.listTap,this.handleItemTap.bind(this));
if(this.person)this.renderHeaderAndContactPoints();else if(this.personId)Contacts.Person.findById(this.personId).then(this,function(future){this.person=future.result;this.renderHeaderAndContactPoints();future.result=true})};ContactPointPickerAssistant.prototype.deactivate=function(){Mojo.Dom.removeClassName(this.controller.document.body,"no-wallpaper")};
ContactPointPickerAssistant.prototype.cleanup=function(){this.controller.stopListening("contactpoint-picker-list",Mojo.Event.listTap,this.handleItemTap.bind(this));Utils.unloadSceneStyles(this.controller,this.stylesheets,this.uniqueId)};
ContactPointPickerAssistant.prototype.renderHeaderAndContactPoints=function(){var i,type,items=[];this.controller.get("contactpoint-picker-header").innerHTML=Mojo.View.render({templateRoot:LIB_ROOT,template:Utils.getTemplatePath("contactpointpicker/header"),object:{displayName:this.person.generateDisplayName(),message:this.message}});for(i=0;i<this.types.length;i+=1){type=this.types[i].contactPoint?this.types[i].contactPoint:this.types[i];switch(type){case Contacts.ContactPointTypes.PhoneNumber:items.push.apply(items,
Utils.getCPsForPersonForType(this.person,Contacts.ContactPointTypes.PhoneNumber,this.types[i].type));break;case Contacts.ContactPointTypes.EmailAddress:items.push.apply(items,Utils.getCPsForPersonForType(this.person,Contacts.ContactPointTypes.EmailAddress,this.types[i].type));break;case Contacts.ContactPointTypes.IMAddress:items.push.apply(items,Utils.getCPsForPersonForType(this.person,Contacts.ContactPointTypes.IMAddress,this.types[i].type));break;default:console.warn("Encountered an unsupported type: "+
type);break}}this.decorateItems(items);this.listModel.items=items;this.controller.modelChanged(this.listModel)};
ContactPointPickerAssistant.prototype.decorateItems=function(items){var that=this;if(!items||!_.isArray(items))items=[];items.forEach(function(item){if(item.getPrimary()||item.getFavoriteDataForAppWithId(Mojo.appInfo.id))item.primaryClass=ContactPointPickerAssistant.PRIMARY_CLASS;if(that.showSpeedDialButtons&&_.isFunction(item.getSpeedDial)&&item.getSpeedDial())item.hasSpeedDial="show-quick-dial"});return items};
ContactPointPickerAssistant.prototype.handleItemTap=function(e){var item=e.item;if(this.saveSelectionAsPrimary)ContactPointPickerAssistant.setItemAsDefault(item,this.person,this.listIndexForDefault,this.auxFavoriteDataForDefault,this.callback);else ContactPointPickerAssistant.callCallback(this.callback,item,this.person);if(this.popSceneOnItemSelect)this.controller.stageController.popScene()};
ContactPointPickerAssistant.callCallback=function(callback,item,person){if(callback&&_.isFunction(callback))callback(item,person)};
ContactPointPickerAssistant.setItemAsDefault=function(item,person,listIndex,auxFavoriteDataForDefault,callback){var param={defaultData:{value:item.getValue(),listIndex:listIndex,auxData:auxFavoriteDataForDefault}};if(item instanceof Contacts.PhoneNumber)param.defaultData.contactPointType=Contacts.ContactPointTypes.PhoneNumber;else if(item instanceof Contacts.IMAddress)param.defaultData.contactPointType=Contacts.ContactPointTypes.IMAddress;else if(item instanceof Contacts.EmailAddress)param.defaultData.contactPointType=
Contacts.ContactPointTypes.EmailAddress;if(param.defaultData.contactPointType){ContactPointPickerAssistant.callCallback(callback,item,person);person.setFavoriteDefault(param)}else ContactPointPickerAssistant.callCallback(callback,item,person)};ContactPointPickerAssistant.PRIMARY_CLASS="primary";var FavoritePersonWidget=exports.FavoritePersonWidget=function(params){Assert.require(params.defaultType,"FavoritePersonWidget requires a contact point default type");if(_.isString(params.defaultType))this.defaultType=[params.defaultType];else if(_.isArray(params.defaultType))this.defaultType=params.defaultType;Assert.requireArray(this.defaultType,"FavoritePersonWidget invalid defaultType param");this.hashedDefaultType=FavoritePersonWidget._transformDefaultTypesArrayIntoHash(this.defaultType);this.scenesToPush=
FavoritePersonWidget._transformArrayIntoHash(params.scenesToPush||[FavoritePersonWidget.SCENES.CONTACT_POINT_PICKER]);this.stageController=params.stageController;Assert.require(this.stageController,"FavoritePersonWidget you must specify the stageController");this.personPickerMessage=params.personPickerMessage||"";this.contactPointPickerMessage=params.contactPointPickerMessage||"";Assert.require(this.scenesToPush[FavoritePersonWidget.SCENES.PERSON_PICKER]||params.person||params.personId,"FavoritePersonWidget you must provide either a person or personId param or add the person picker to the scenes to push");
this.person=params.person;if(this.person)Assert.require(this.person instanceof Contacts.Person,"FavoritePersonWidget person param must be an instance of Person");this.personId=params.personId;this.callback=params.callback;Assert.require(this.callback,"FavoritePersonWidget you must specify a callback function");this.auxFavoriteDataForDefault=params.auxFavoriteDataForDefault;this.listIndexForDefault=params.listIndexForDefault;if(!this.listIndexForDefault&&this.listIndexForDefault!==0)this.listIndexForDefault=
-1};
FavoritePersonWidget.prototype.pushScene=function(){var param;if(this.scenesToPush[FavoritePersonWidget.SCENES.PERSON_PICKER]){param={excludeFavorites:true,iconClass:"icon-add-fav",message:this.personPickerMessage,popSceneOnPersonSelect:false,callback:this._tappedOnPersonToFavorite.bind(this)};pushPeoplePickerScene(this.stageController,param)}else{param={type:this.defaultType,message:this.contactPointPickerMessage,saveSelectionAsPrimary:true,listIndexForDefault:this.listIndexForDefault,auxFavoriteDataForDefault:this.auxFavoriteDataForDefault,callback:this.callback};
if(this.person)param.person=this.person;else param.personId=this.personId;pushContactPointPickerScene(this.stageController,param)}};
FavoritePersonWidget.prototype.shouldPushCPPickerOrGetDefaultItem=function(){var contactPoints=[],that=this;Object.keys(Contacts.ContactPointTypes).forEach(function(key){if(that.hashedDefaultType[Contacts.ContactPointTypes[key]])contactPoints=contactPoints.concat(Utils.getCPsForPersonForType(that.person,Contacts.ContactPointTypes[key],that.hashedDefaultType[Contacts.ContactPointTypes[key]].type))});if(contactPoints.length>1)return true;else if(contactPoints.length===1)return contactPoints[0];else return false};
FavoritePersonWidget.prototype._tappedOnPersonToFavorite=function(person){this.person=person;this.person.makeFavorite(true).then(this,function(future){var result=future.result;if(!result)throw new Error("Making person favorite failed!");});var shouldPushContactPointPickerOrDefaultItem=this.shouldPushCPPickerOrGetDefaultItem(),isRetValABoolean=typeof shouldPushContactPointPickerOrDefaultItem==="boolean";if(isRetValABoolean&&shouldPushContactPointPickerOrDefaultItem)pushContactPointPickerScene(this.stageController,
{person:this.person,type:this.defaultType,message:this.contactPointPickerMessage,saveSelectionAsPrimary:true,popSceneOnItemSelect:false,listIndexForDefault:this.listIndexForDefault,auxFavoriteDataForDefault:this.auxFavoriteDataForDefault,callback:function(item,person){this.stageController.popScene();this.stageController.popScene();this.callback(item,person)}.bind(this)});else if(isRetValABoolean)this.callback(undefined,this.person);else if(shouldPushContactPointPickerOrDefaultItem)ContactPointPickerAssistant.setItemAsDefault(shouldPushContactPointPickerOrDefaultItem,
this.person,this.listIndexForDefault,this.auxFavoriteDataForDefault,this.callback)};FavoritePersonWidget._transformDefaultTypesArrayIntoHash=function(array){var toReturn={};array.forEach(function(item){if(_.isString(item))toReturn[item]={contactPoint:item};else if(item.contactPoint&&_.isString(item.contactPoint))toReturn[item.contactPoint]=item});return toReturn};
FavoritePersonWidget._transformArrayIntoHash=function(array){var toReturn={};array.forEach(function(item){if(_.isString(item))toReturn[item]=true});return toReturn};FavoritePersonWidget.SCENES={PERSON_PICKER:"favorite_person_picker",CONTACT_POINT_PICKER:"favorite_contact_point_picker"};var SimloginAssistant=exports.SimloginAssistant=function(params){this.attrs=params.attrs;this.model=params.model;this.uniqueId="SLA_"+Date.now();this.eventListenerManager=new EventListenerManager;this.stylesheets=[Utils.getStylesheetPath("common.css")]};
SimloginAssistant.prototype.setup=function(){var simSection,userName,phoneNumber;Utils.loadSceneStyles(this.controller,this.stylesheets,this.uniqueId);this.controller.get("phoneIdLabel").innerText=this.attrs.phoneIdLabel;this.controller.get("simTitle").innerText=this.attrs.simTitle;this.controller.get("simText").innerText=this.attrs.simText;phoneNumber=Globalization.Format.formatPhoneNumber(Globalization.Phone.parsePhoneNumber(this.model.phoneId));userName={value:phoneNumber,disabled:true};this.controller.setupWidget("phoneId",
{},userName);try{this.controller.get("LoginHeaderDiv").innerHTML=Mojo.View.render({object:{iconPath:this.model.account.icon.loc_32x32},template:Utils.getTemplatePath("simlogin/simlogin-header"),templateRoot:LIB_ROOT})}catch(e){console.log("Exception caught: "+e);console.log(e.stack())}simSection=this.controller.get("sim");if(simSection&&this.model.hideSimRemovedMessage)Mojo.Dom.hide(simSection);this.removeAccountAttributes={type:Mojo.Widget.activityButton};this.removeAccountModel={label:RB.$L("Remove Account"),
disabled:false,buttonClass:"negative"};this.controller.setupWidget("removeAccount-button",this.removeAccountAttributes,this.removeAccountModel);this.removeAccountButton=this.controller.get("removeAccount-button");if(this.model.hideSimRemovedMessage)Mojo.Dom.hide(this.removeAccountButton);else{Mojo.Dom.show(this.removeAccountButton);this.eventListenerManager.addListener(this.removeAccountButton,Mojo.Event.tap,this.handleRemoveDialog.bind(this))}Assert.require(this.model.fetchContactCount&&typeof this.model.fetchContactCount===
"function","SimloginAssistant.setup: fetchContactCount callback is not function");this.fetchFuture=this.model.fetchContactCount(this.model.account._id,this.controller.get("PersonCountBlock"),this.controller.get("NumberOfPeople"))};SimloginAssistant.prototype.cleanup=function(){Utils.unloadSceneStyles(this.controller,this.stylesheets,this.uniqueId);this.eventListenerManager.destroyListeners()};
SimloginAssistant.prototype.handleRemoveDialog=function(){var that=this;this.controller.showAlertDialog({onChoose:function(value){var future;if(value==="remove"){that.removeAccountButton.mojo.activate();that.removeAccountButton.buttonLabel=RB.$L("Removing Account...");that.removeAccountButton.disabled=true;Assert.require(that.model.handleRemoveAccount&&typeof that.model.handleRemoveAccount==="function","SimloginAssistant.handleRemoveDialog: handleRemoveAccount callback is not function");future=that.model.handleRemoveAccount(that.model.account);
future.then(that,function(){that.removeAccountButton.mojo.deactivate();Assert.require(that.model.endFetchContactCount&&typeof that.model.endFetchContactCount==="function","SimloginAssistant.handleRemoveDialog: endFetchContactCount callback is not function");that.model.endFetchContactCount();that.controller.stageController.popScene()})}else{that.removeAccountButton.buttonLabel=RB.$L("Remove Account");that.removeAccountButton.mojo.deactivate();that.removeAccountButton.disabled=false;return}},title:RB.$L("Remove Account"),
message:RB.$L("Are you sure you want to remove this Contact account, and all linked data, from this device?"),preventCancel:true,choices:[{label:RB.$L("Remove contact account"),value:"remove",type:"negative"},{label:RB.$L("Keep contact account"),value:"keep"}]})};var AccountList=exports.AccountList=function(onReady){this.list=[];this.ids={};this.providersBySubKinds={};this.templateIds={};this._fetchingAccounts=false;this._onReady=onReady;this.refresh();Contacts.Utils.mixInBroadcaster(this);this._defaultAccountsListeners=[]};AccountList.prototype.addDefaultAccountsListener=function(callback){if(callback)this._defaultAccountsListeners.push(callback)};
AccountList.prototype._notifyDefaultAccountsListeners=function(newDefaultAccountsList,oldDefaultAccountsList){_.invoke(this._defaultAccountsListeners,"apply",undefined,arguments)};AccountList.prototype.removeDefaultAccountsListener=function(callback){var i=this._defaultAccountsListeners.indexOf(callback);if(i!==-1)this._defaultAccountsListeners.splice(i,1);else console.error("removeDefaultAccountsListener: Cannot find callback to remove.")};
AccountList.prototype.refresh=function(){this._fetchingAccounts=true;if(this._listObj)this._listObj.cancel();this._listObj=AccountsLib.AccountsList.listAccounts(this._accountsChanged.bind(this),{subscribe:true})};
AccountList.prototype.getIconById=function(accountId,big){var provider,account,iconData;provider=this.getProvider(accountId);if(provider&&provider.icon)iconData=provider.icon;else{account=this.getAccount(accountId);if(account&&account.icon)iconData=account.icon}if(iconData)if(big)return iconData.loc_48x48;else return iconData.loc_32x32};
AccountList.prototype.getIconByKind=function(kindName,big){var provider=this.getProviderByKind(kindName);if(provider&&provider.icon)if(big)return provider.icon.loc_48x48;else return provider.icon.loc_32x32};AccountList.prototype.getAccountIcon=function(accountId,kindName){var icon;if(kindName)icon=this.getIconByKind(kindName,false);if(!icon&&accountId)icon=this.getIconById(accountId,false);return icon||"images/header-icon-contacts.png"};
AccountList.prototype.getDisplayName=function(account){if(account.alias)return account.alias;return account.username};AccountList.prototype.getAccountName=function(accountId){var account=this.getAccount(accountId);return account?account.loc_name:""};
AccountList.prototype.isContactReadOnly=function(contact){var isReadOnly=false,provider=this.getProvider(contact.getAccountId().getValue());if(provider&&provider.readOnlyData)isReadOnly=true;else if(contact&&contact.getDBObject()&&contact.getDBObject().simEntryType==="sdn")isReadOnly=true;return isReadOnly};AccountList.prototype.getAccount=function(accountId){return this.ids[accountId]};AccountList.prototype.getAccountsByTemplateId=function(templateId){return this.templateIds[templateId]};
AccountList.prototype.getProvider=function(accountId){var account=this.ids[accountId];if(!account||!account.capabilityProviders)return;return _.detect(account.capabilityProviders,function(p){return p.capability==="CONTACTS"})};AccountList.prototype.getProviderByKind=function(kindName){return this.providersBySubKinds[kindName]};AccountList.prototype.getAccountsList=function(){return this.list};AccountList.prototype.getDefaultAccountsList=function(){return this.defaultAccountsList};
AccountList.prototype.getDefaultAccountsDisplayList=function(){return this.defaultAccountsDisplayList};
AccountList.prototype._accountsChanged=function(accounts){var that=this,oldDefaultAccountsList=this.defaultAccountsList;this.list=accounts;Mojo.Log.info("ContactsApp._accountsChanged: %d accounts.",accounts.length);this.ids={};this.templateIds={};this.defaultAccountsList=[];this.defaultAccountsDisplayList=[];accounts.forEach(function(account){var id=account._id,templateId=account.templateId;that.ids[id]=account;if(that.templateIds[templateId])that.templateIds[templateId].push(account);else that.templateIds[templateId]=
[account];account.capabilityProviders.forEach(function(capabilityProvider){var accountDisplayName;if(capabilityProvider&&capabilityProvider.dbkinds&&capabilityProvider.dbkinds.contact)that.providersBySubKinds[capabilityProvider.dbkinds.contact]=capabilityProvider;if(capabilityProvider&&capabilityProvider.capability==="CONTACTS"&&!capabilityProvider.readOnlyData&&account.templateId!=="com.palm.sim"){that.defaultAccountsList.push(account);accountDisplayName=account.alias||capabilityProvider.loc_name||
account.loc_name;that.defaultAccountsDisplayList.push({label:account.username?accountDisplayName+" ("+account.username+")":accountDisplayName,secondaryIconPath:capabilityProvider.icon?capabilityProvider.icon.loc_32x32:account.icon.loc_32x32,command:account._id})}})});this._fetchingAccounts=false;this.broadcast();this._notifyDefaultAccountsListeners(this.defaultAccountsList,oldDefaultAccountsList);if(this._onReady){this._gotAccounts=true;this._onReady();this._onReady=undefined}};
AccountList.defaultAccountPriority=["com.palm.eas","com.palm.google"];AccountList.prototype.isReady=function(){return this._gotAccounts};AccountList.prototype.isFetchingAccounts=function(){return this._fetchingAccounts};var EventListenerManager=exports.EventListenerManager=function(){var _listeners=[];return{addListener:function(element,event,callback,useCapture){_listeners.push({element:element,event:event,callback:callback,capture:useCapture});element.addEventListener(event,callback,useCapture)},destroyListeners:function(){var listener,i,len=_listeners.length;if(!len)return;for(i=0;i<len;i+=1){listener=_listeners[i];listener.element.removeEventListener(listener.event,listener.callback,listener.capture)}_listeners=
[]}}};var PersonAsyncDecorator=exports.PersonAsyncDecorator=function(items,decorateItemsCallback){Mojo.Log.info("Created PersonAsyncDecorator for %d items.",items.length);if(!items||!_.isArray(items)||items.length===0||!decorateItemsCallback||!_.isFunction(decorateItemsCallback)){Mojo.Log.error("Tried to create PersonAsyncDecorator with invalid params. %s %s",Contacts.Utils.stringify(items),Contacts.Utils.stringify(decorateItemsCallback));return}this._decorateItemsCallback=decorateItemsCallback;this._decoratorCache=
{};this.imStatusDecorator=new PersonImStatusAsyncDecorator(items,this.callback.bind(this));this.photoDecorator=new PersonPhotoAsyncDecorator(items,this.callback.bind(this))};
PersonAsyncDecorator.prototype.cancel=function(){Mojo.Log.info("Cancelling PersonAsyncDecorator for %d items.",this._personIds&&this._personIds.length);if(this.imStatusDecorator){this.imStatusDecorator.cancel();this.imStatusDecorator=undefined}if(this.photoDecorator){this.photoDecorator.cancel();this.photoDecorator=undefined}this._decoratorCache={}};
PersonAsyncDecorator.prototype.callback=function(newDecorators){var that=this,extendedDecorators;if(!newDecorators||!Array.isArray(newDecorators)){Mojo.Log.error("PersonAsyncDecorator.decorateItemsCallback called with non-array arg. %s",Contacts.Utils.stringify(newDecorators));return}extendedDecorators=newDecorators.map(function(newDecorator){var personId=newDecorator._id,completeDecorator;completeDecorator=that._decoratorCache[personId]||{};_.extend(completeDecorator,newDecorator);that._decoratorCache[personId]=
completeDecorator;return completeDecorator});this._decorateItemsCallback(extendedDecorators)};var PersonImStatusAsyncDecorator=exports.PersonImStatusAsyncDecorator=function(items,decorateItemsCallback){Mojo.Log.info("Created PersonImStatusAsyncDecorator for %d items.",items.length);if(!items||!_.isArray(items)||items.length===0||!decorateItemsCallback||!_.isFunction(decorateItemsCallback)){Mojo.Log.error("Tried to create PersonImStatusAsyncDecorator with invalid params. %s %s",Contacts.Utils.stringify(items),Contacts.Utils.stringify(decorateItemsCallback));return}var that=this,query;this._personIds=
[];this._currentStatusMap={};items.forEach(function(item){that._personIds.push(item._id);that._currentStatusMap[item._id]=Contacts.IMAddress.STATUS.NO_PRESENCE});query={select:["personId","personAvailability"],from:"com.palm.imbuddystatus:1",where:[{prop:"personId",op:"=",val:this._personIds}]};this._decorateItemsCallback=decorateItemsCallback;this._dbWatcher=new Contacts.Utils.DBWatcher(query,this._watchFireHandler.bind(this),true)};
PersonImStatusAsyncDecorator.prototype.cancel=function(){Mojo.Log.info("Cancelling PersonImStatusAsyncDecorator for %d items.",this._personIds&&this._personIds.length);if(this._dbWatcher){this._dbWatcher.cancel();this._dbWatcher=undefined}this._personIds=undefined;this._currentStatusMap=undefined};
PersonImStatusAsyncDecorator.prototype._watchFireHandler=function(queryResults){var that=this,personsSeen={},decorators=[];queryResults=queryResults||[];queryResults.forEach(function(buddyStatus){var personId=buddyStatus.personId,oldStatus,newStatus;if(personsSeen[personId])return;personsSeen[personId]=true;oldStatus=that._currentStatusMap[personId];newStatus=buddyStatus.personAvailability;if(newStatus!==undefined&&newStatus!==oldStatus){Mojo.Log.info("PersonImStatusAsyncDecorator: person %s now has presence %d",
personId,newStatus);that._currentStatusMap[personId]=newStatus;decorators.push({_id:personId,imStatus:newStatus,imStatusClassName:Contacts.PersonDisplay.getImStatusClassName(newStatus)})}});if(decorators.length>0)this._decorateItemsCallback(decorators)};var PersonPhotoAsyncDecorator=exports.PersonPhotoAsyncDecorator=function(items,decorateItemsCallback){Mojo.Log.info("Created PersonPhotoAsyncDecorator for %d items.",items.length);if(!items||!_.isArray(items)||items.length===0||!decorateItemsCallback||!_.isFunction(decorateItemsCallback)){Mojo.Log.error("Tried to create PersonPhotoAsyncDecorator with invalid params. %s %s",Contacts.Utils.stringify(items),Contacts.Utils.stringify(decorateItemsCallback));return}this._decorateItems(items,decorateItemsCallback)};
PersonPhotoAsyncDecorator.prototype.cancel=function(){Mojo.Log.info("Cancelling PersonPhotoAsyncDecorator for %d items.",this._personIds&&this._personIds.length);if(this._future){this._future.cancel();this._future=undefined}};
PersonPhotoAsyncDecorator.prototype._decorateItems=function(items,decorateItemsCallback){var that=this;this._future=Foundations.Control.mapReduce({map:function(person){var origListPhotoPath=person&&person.listPhotoPath,mapFuture=Contacts.PersonPhotos.getPhotoPath(person.photos,Contacts.PersonPhotos.TYPE.LIST,true);mapFuture.then(that,function(){try{var filepath=mapFuture.result;mapFuture.result={_id:person._id,listPhotoPath:filepath,origListPhotoPath:origListPhotoPath}}catch(ex){Mojo.Log.error("PersonPhotoAsyncDecorator: exception! "+
Contacts.Utils.stringify(ex));mapFuture.result={}}});return mapFuture}},items);this._future.then(this,function(){var wrappedDecorators=this._future.result,decorators=wrappedDecorators.map(function(wrappedDecorator){return wrappedDecorator.result});decorators=decorators.filter(function(decorator){return decorator&&decorator.listPhotoPath&&decorator.listPhotoPath!==decorator.origListPhotoPath});decorateItemsCallback(decorators)})};var ImAddressStatusWatcher=function(imAddress,type,itemWatchCallback){Mojo.Log.info("Created ImAddressStatusWatcher for item %s on %s.",imAddress,type);if(!imAddress||!_.isString(imAddress)||!type||!_.isString(type)||!itemWatchCallback||!_.isFunction(itemWatchCallback)){Mojo.Log.error("Tried to create ImAddressStatusWatcher with invalid params. %s %s %s",imAddress,type,itemWatchCallback);return}this._imAddress=imAddress;this._type=type;this._currentStatus=Contacts.IMAddress.STATUS.NO_PRESENCE;var query=
{select:["username","serviceName","availability"],from:"com.palm.imbuddystatus:1",where:[{prop:"username",op:"=",val:this._imAddress},{prop:"serviceName",op:"=",val:this._type}]};this._itemWatchCallback=itemWatchCallback;this._dbWatcher=new Contacts.Utils.DBWatcher(query,this.watchFireHandler.bind(this),true)};
ImAddressStatusWatcher.prototype.cancel=function(){Mojo.Log.info("Cancelling ImAddressStatusWatcher for item %s on %s.",this._imAddress,this._type);if(this._dbWatcher){this._dbWatcher.cancel();this._dbWatcher=undefined}this._imAddress=undefined;this._type=undefined;this._currentStatus=undefined};
ImAddressStatusWatcher.prototype.watchFireHandler=function(queryResults){if(!queryResults||!_.isArray(queryResults)){Mojo.Log.info("Invalid ImAddressStatusWatcher queryResults %s.",Contacts.Utils.stringify(queryResults));return}var newStatus=queryResults.reduce(function(curBestStatus,curQueryResult){if(curQueryResult.availability<curBestStatus)return curQueryResult.availability;else return curBestStatus},Contacts.IMAddress.STATUS.NO_PRESENCE);if(newStatus!==undefined&&newStatus!==this._currentStatus){Mojo.Log.info("ImAddressStatusWatcher: item %s on %s now has presence %d",
this._imAddress,this._type,newStatus);this._currentStatus=newStatus;this._itemWatchCallback({imAddress:this._imAddress,serviceName:this._type,type:this._type,imStatus:newStatus,imStatusClassName:Contacts.PersonDisplay.getImStatusClassName(newStatus)})}};ImAddressStatusWatcher.prototype.getCurrentStatus=function(){return{imAddress:this._imAddress,type:this._type,imStatus:this._currentStatus,imStatusClassName:Contacts.PersonDisplay.getImStatusClassName(this._currentStatus)}};var MultipleListManager=function(){var configs={};return{addListConfig:function(listName,attributes,model,div,updateFn,tapEventListenerDestructor){Assert.requireString(listName,"addListConfig missing listName");Assert.requireDefined(attributes,"addListConfig missing attributes");Assert.requireDefined(model,"addListConfig missing model");Assert.requireDefined(updateFn,"addListConfig missing update function");var listConfig=configs[listName];Assert.requireFalse(listConfig,"addListConfig a list with the same listName already exists");
configs[listName]={list:attributes,model:model,div:div,update:updateFn,tapEventListenerDestructor:tapEventListenerDestructor}},updateListItems:function(listName,items){Assert.requireString(listName,"updateListItems requires a listName");Assert.requireArray(items,"updateListItems requires an items array");var listConfig=configs[listName];Assert.require(listConfig,"unable to find listConfig for listName: "+listName);listConfig.model.items=items;listConfig.update(listConfig.model.items)},destroy:function(){Object.keys(configs).forEach(function(listName){var item=
configs[listName];if(item.tapEventListenerDestructor&&_.isFunction(item.tapEventListenerDestructor))item.tapEventListenerDestructor()})}}};var MenuHandler={createAppMenu:function(that,menuModel){that.goToPrefs=this.goToPrefs;that.handleCommand=this.handleCommand;var items=[Mojo.Menu.editItem];if(menuModel)items=items.concat(menuModel);items.push(MenuHandler.prefsItem);items.push({label:$LL("Help"),command:Mojo.Menu.helpCmd});that.appMenuModel=that.appMenuModel||{visible:true,label:RB.$L("Contacts Menu"),items:items};that.appMenuModel.items=items;that.controller.setupWidget(Mojo.Menu.appMenu,{omitDefaultItems:true},that.appMenuModel)},
goToPrefs:function(){this.controller.stageController.pushScene("prefs")},handleCommand:function(event){if(event.type===Mojo.Event.command){if(event.command===Mojo.Menu.prefsCmd){Mojo.Event.stop(event);this.goToPrefs();return}if(event.command===MenuHandler.deleteContact){Mojo.Event.stop(event);this.handleDelete();return}if(event.command===MenuHandler.addToLauncher){Mojo.Event.stop(event);this.handleAddToLauncher();return}if(event.command===MenuHandler.noop){Mojo.Event.stop(event);return}if(event.command===
MenuHandler.linkProfiles){Mojo.Event.stop(event);this.handleClipMore();return}if(typeof event.command==="function"){event.command();Mojo.Event.stop(event)}if(event.command===MenuHandler.editContact){this.handleEdit();Mojo.Event.stop(event);return}if(event.command===MenuHandler.setSpeedDial){this.setSpeedDial();Mojo.Event.stop(event);return}if(event.command===MenuHandler.addReminder){this.handleReminder();Mojo.Event.stop(event);return}if(event.command===MenuHandler.addToSIM){this.addToSIM();Mojo.Event.stop(event);
return}if(event.command===MenuHandler.copyContact){this.copyDetailsToClipboard();Mojo.Event.stop(event);return}}}};MenuHandler.editContact="edit-contact";MenuHandler.deleteContact="deleteContact";MenuHandler.preferences="preferences";MenuHandler.noop="noop";MenuHandler.addToLauncher="addToLauncher";MenuHandler.linkProfiles="linkProfiles";MenuHandler.setSpeedDial="setSpeedDial";MenuHandler.addReminder="addReminder";MenuHandler.addToSIM="addToSIM";MenuHandler.copyContact="copyContact";
MenuHandler.prefsItem={label:RB.$L("Preferences & Accounts"),command:Mojo.Menu.prefsCmd,disabled:true};MenuHandler.launchHelp=function(){var request=new Mojo.Service.Request("palm://com.palm.applicationManager",{method:"open",parameters:{id:"com.palm.app.help",params:{target:"http://help.palm.com/contacts/index.html"}}})};var OpenWithMenu=function(params){this.isMimeType=params.isMimeType;this.urlOrMime=params.urlOrMime;this.controller=params.controller;this.listId=params.listId;this.pushLoading=false;this.loadingModel=[{label:RB.$L("Copy"),command:"openwith-copyCommand"},{label:RB.$L("Open With")},{label:RB.$L("Loading..."),command:"loading"}];this.handlers=[];this.bareData="";this.data=null;this.originalEventForShowMenu=null;this.mimeSystemService="palm://com.palm.applicationManager";this.mimeAppListMethod="listAllHandlersForMime";
this.urlAppListMethod="listAllHandlersForUrl";this.launchDefaultFailed=RB.$L("Launching Default Application Failed");this.openWithTitle=RB.$L("Open With");this.shouldOpenOpenWithBound=this.shouldOpenOpenWith.bind(this);this.controller.listen(this.listId,Mojo.Event.listTap,this.shouldOpenOpenWithBound)};
OpenWithMenu.prototype.shouldOpenOpenWith=function(e){var fullAddress=e.item.getDisplayValue(),data={target:this.urlOrMime+fullAddress.replace(/[\n\r]/g," ")};this.bareData=fullAddress;if(e.originalEvent.down.altKey)this.showMenu(e.originalEvent,data);else this.launchDefault(data)};OpenWithMenu.prototype.destroy=function(){this.controller.stopListening(this.listId,Mojo.Event.listTap,this.shouldOpenOpenWithBound)};
OpenWithMenu.prototype.showMenu=function(event,data){var params,method,request;this.originalEventForShowMenu=event;this.showLoadingMenu(event);if(data)this.data=data;params={};method="";if(this.isMimeType){params={mime:this.urlOrMime};method=this.mimeAppListMethod}else{params={url:this.urlOrMime};method=this.urlAppListMethod}request=new Mojo.Service.Request(this.mimeSystemService,{method:method,parameters:params,onSuccess:function(e){this.listAllHandlersSuccess(e,event)}.bind(this),onFailure:function(e){this.displayMimeSystemFailed()}.bind(this)})};
OpenWithMenu.prototype.showLoadingMenu=function(event){if(this.pushLoading){if(this.popUpMenu)this.popUpMenu.mojo.close();this.popUpMenu=this.controller.popupSubmenu({onChoose:this.clickedMenu.bind(this),placeNear:event.target,items:this.loadingModel})}};
OpenWithMenu.prototype.listAllHandlersSuccess=function(result,originalEvent){if(this.popUpMenu)this.popUpMenu.mojo.close();if(result.returnValue){this.pushHandlersInitialItems();if(result.redirectHandlers)result=result.redirectHandlers;else if(result.resourceHandlers)result=result.resourceHandlers;if(result.activeHandler.appName)result.activeHandler.label=result.activeHandler.appName;else result.activeHandler.label=result.activeHandler.appId;result.activeHandler.command=result.activeHandler.appId;
this.handlers.push(result.activeHandler);if(result.alternates)result.alternates.forEach(function(handler){if(handler.appName)handler.label=handler.appName;else handler.label=handler.appId;handler.command=handler.appId;this.handlers.push(handler)}.bind(this));this.popUpMenu=this.controller.popupSubmenu({onChoose:this.clickedMenu.bind(this),placeNear:originalEvent.target,items:this.handlers})}else this.displayMimeSystemFailed()};
OpenWithMenu.prototype.pushHandlersInitialItems=function(){this.handlers=[];this.handlers.push({label:RB.$L("Copy"),command:"openwith-copyCommand"});this.handlers.push({label:RB.$L("Open With")})};
OpenWithMenu.prototype.getActiveHandlerForDefault=function(result){if(result.returnValue)if(result.redirectHandlers)return result.redirectHandlers.activeHandler.appId;else{if(result.resourceHandlers)return result.resourceHandlers.activeHandler.appId}else{this.displayFailedMessage(this.launchDefaultFailed);return false}};
OpenWithMenu.prototype.clickedMenu=function(appId){if(appId)if(appId==="openwith-copyCommand")this.controller.stageController.setClipboard(this.bareData);else if(appId!=="loading")this.launchApp(appId,this.data);else this.showLoadingMenu(this.originalEventForShowMenu)};
OpenWithMenu.prototype.launchDefault=function(data){var params,method,request;this.data=data;params={};method="";if(this.isMimeType){params={mime:this.urlOrMime};method=this.mimeAppListMethod}else{params={url:this.urlOrMime};method=this.urlAppListMethod}request=new Mojo.Service.Request(this.mimeSystemService,{method:method,parameters:params,onSuccess:function(e){var defaultHandler=this.getActiveHandlerForDefault(e);if(defaultHandler)this.launchApp(defaultHandler,this.data);else this.displayFailedMessage(this.launchDefaultFailed)}.bind(this),
onFailure:function(e){this.displayFailedMessage(this.launchDefaultFailed)}.bind(this)})};OpenWithMenu.prototype.launchApp=function(appid,data){var tempData,request;if(appid==="com.palm.app.maps"){tempData=data.target.substr(this.urlOrMime.length);data.target="maploc:"+tempData}request=new Mojo.Service.Request(this.mimeSystemService,{method:"open",parameters:{id:appid,params:data},onFailure:function(e){this.displayAppLaunchFailed(appid)}.bind(this)})};
OpenWithMenu.prototype.displayAppLaunchFailed=function(appid){var template,appDisplay,message;template=new Mojo.Format.Template(RB.$L("#{appName} Failed To Launch"));appDisplay=this.getAppNameFromHandlers(appid);message=template.evaluate({appName:appDisplay});this.displayFailedMessage(message)};OpenWithMenu.prototype.displayMimeSystemFailed=function(){this.displayFailedMessage(RB.$L("Failed To Get Applications List"))};
OpenWithMenu.prototype.displayFailedMessage=function(message){if(this.popUpMenu)this.popUpMenu.mojo.close();this.controller.showAlertDialog({message:message,title:this.openWithTitle,choices:[{label:RB.$L("OK")}]})};OpenWithMenu.prototype.getAppNameFromHandlers=function(appid){if(!this.handlers)return appid;var toReturn=_.detect(this.handlers,function(handler){if(handler.appId===appid)return handler});if(!toReturn)return appid;if(toReturn.label)return toReturn.label;else return toReturn.appId};var TinyList={};TinyList.setupTapHandler=function(div,model,handler){var wrappedHandler=TinyList._handleListTap.bind(undefined,model,div,handler);Mojo.Event.listen(div,Mojo.Event.tap,wrappedHandler);return Mojo.Event.stopListening.bind(this,div,Mojo.Event.tap,wrappedHandler)};
TinyList.renderData=function(div,attrs,items){if(!items||items.length===0){div.innerHTML="";return}TinyList._processListItems(items);var list=Mojo.View.render({templateRoot:attrs.templateRoot,template:attrs.itemTemplate,collection:items});if(attrs.listTemplate)list=Mojo.View.render({templateRoot:attrs.templateRoot,template:attrs.listTemplate,object:{listElements:list}});div.innerHTML=list};
TinyList._processListItems=function(items){if(!items||items.length===0)return;if(items.length===1)items[0].rowClass="single";else{items[0].rowClass="first";items[items.length-1].rowClass="last"}for(var i=0;i<items.length;i+=1)items[i].listIndex=i};
TinyList._handleListTap=function(model,listDiv,handler,e){e.originalEvent=e;var indexAndElem=TinyList._getIndexOfTap(e.target,listDiv);if(!indexAndElem.index){Mojo.Log.error("Couldn't find x-list-index target for list tap");return}e.item=model.items[indexAndElem.index];e.itemElement=indexAndElem.element;handler(e)};
TinyList._getIndexOfTap=function(element,toplevel){var index=element.getAttribute("x-list-index");while(index===null&&element&&element!==toplevel){element=element.parentElement;index=element.getAttribute("x-list-index")}return{index:index,element:element}};var Utils={loadSceneStyles:function(sceneController,stylesheetPath,identifier){if(!_.isArray(stylesheetPath))stylesheetPath=[stylesheetPath];for(var i=0;i<stylesheetPath.length;i+=1){Mojo.loadStylesheet(sceneController.document,stylesheetPath[i],LIB_ROOT,identifier);Mojo.Locale._loadLocalizedStylesheet(sceneController.document,stylesheetPath[i],LIB_ROOT,identifier)}},unloadSceneStyles:function(sceneController,stylesheetPath,identifier){if(!_.isArray(stylesheetPath))stylesheetPath=[stylesheetPath];
for(var i=0;i<stylesheetPath.length;i+=1)Utils.unloadAllInstancesOfSceneStyle(sceneController,stylesheetPath[i],identifier)},unloadAllInstancesOfSceneStyle:function(sceneController,path,identifier){var i,theDocument=sceneController.document,links=theDocument.querySelectorAll('link[type="text/css"][href$="'+path+'"]'),head=theDocument.querySelector("head"),link,linkAttr;if(!head){Mojo.Log.warn("No <head> element!");return}for(i=0;i<links.length;i+=1){link=links[i];if(identifier){linkAttr=link.getAttribute("x-mojo-css-identifier");
if(linkAttr&&linkAttr===identifier){link.disabled=true;head.removeChild(link)}}else{link.disabled=true;head.removeChild(link)}}},formatDataSourceAssistant:function(dsa,formatter){var getItemsToRenderOriginal;getItemsToRenderOriginal=dsa.getItemsToRender.bind(dsa);dsa.getItemsToRender=function(response,callback){getItemsToRenderOriginal(response,function(items){if(items)for(var i=0;i<items.length;i+=1)items[i]=formatter(items[i]);callback(items)})};return dsa},getTemplatePath:function(template){return"templates/"+
template},getStylesheetPath:function(stylesheet){return"stylesheets/"+stylesheet},executeFunctionIfExists:function(item,argsArray,scope){var i,fn;if(_.isArray(item));else item=[item];for(i=0;i<item.length;i+=1){fn=item[i];if(fn&&_.isFunction(fn))fn.apply(scope,argsArray)}},getCPsForPersonForType:function(person,type,filter){var mappingFunction=function(array,filter){if(filter){var toReturn=[];array.forEach(function(contactPoint){if(contactPoint.getType()===filter)toReturn.push(contactPoint)});return toReturn}else return array};
switch(type){case Contacts.ContactPointTypes.PhoneNumber:return mappingFunction(person.getPhoneNumbers().getArray(),filter);case Contacts.ContactPointTypes.EmailAddress:return mappingFunction(person.getEmails().getArray(),filter);case Contacts.ContactPointTypes.IMAddress:return mappingFunction(person.getIms().getArray(),filter);default:return[]}}};var GALHelper=function(assistant){this.asst=assistant;this.toggler=this.asst.controller.get("GalDrawerOpener");this.counter=this.asst.controller.get("GALCountResults");this.counterContainer=this.asst.controller.get("GALCountContainer");this.listDiv=this.asst.lookups;this.lookupsModel=this.asst.lookupsModel;this.controller=this.asst.controller;this.timeout=1;this.searching=false;this.currentCountQuery=null};GALHelper.prototype.setup=function(){};
GALHelper.prototype.toggle=function(){Mojo.Dom.toggleClassName(this.toggler,"open");Mojo.Dom.toggle(this.listDiv)};GALHelper.prototype.reset=function(){this.lookupsModel.items=[];this.controller.modelChanged(this.lookupsModel);Mojo.Dom.removeClassName(this.toggler,"open");Mojo.Dom.hide(this.listDiv);this.counter.innerHTML="";Mojo.Dom.hide(this.counterContainer)};GALHelper.prototype.isOpen=function(){return Mojo.Dom.hasClassName(this.toggler,"open")};
GALHelper.prototype.doSearch=function(q){this.searching=true;this.currentCountQuery=this.asst.controller.serviceRequest("palm://com.palm.mail",{method:"queryGAL",onSuccess:this.updateCount.bind(this),parameters:{target:this.asst.filter,offset:0,limit:1}})};GALHelper.prototype.scheduleCountLookup=function(){if(!this.searching)this.doSearch();else{window.clearTimeout(this.queued);this.queued=window.setTimeout(this.doSearch.bind(this),this.timeout)}};
GALHelper.prototype.cancelCountLookup=function(){if(this.currentCountQuery){this.currentCountQuery.cancel();window.clearTimeout(this.queued);this.searching=false}this.reset()};GALHelper.prototype.updateCount=function(results){this.counter.innerHTML=results;Mojo.Dom.show(this.counterContainer)};
GALHelper.prototype.makeContact=function(rawC){var c,email,number,address;c=new Contact;c.firstName=rawC.firstName;c.lastName=rawC.lastName;c.jobTitle=rawC.jobTitle;c.companyName=rawC.companyName;rawC.addressList.forEach(function(addr){if(addr.type==="EMAIL"){email=new Email(addr.value);_.extend(email,addr);c.emailAddresses.push(email)}else if(addr.type==="PHONE"){number=new PhoneNumber(addr.value);_.extend(number,addr);c.phoneNumbers.push(number)}else if(addr.type==="ADDRESS"){address=new Address({freeformAddress:addr.value});
_.extend(address,addr);c.addresses.push(address)}});return c};var pushPeoplePickerScene=exports.pushPeoplePickerScene=function(stageController,launchParams,pushSceneParams){Assert.requireDefined(stageController&&stageController.pushScene&&_.isFunction(stageController.pushScene),"pushPeoplePicker requires a stageController to be passed");pushSceneParams=_.extend(pushSceneParams||{},{name:"contactsPeoplePickerView",assistantConstructor:PeoplePickerAssistant,templateRoot:LIB_ROOT,sceneTemplate:Utils.getTemplatePath("peoplepicker/peoplepicker-scene")});stageController.pushScene.apply(stageController,
[pushSceneParams,launchParams])};
var pushSimLoginScene=exports.pushSimLoginScene=function(stageController,attributes,model){Assert.requireDefined(stageController&&stageController.pushScene&&_.isFunction(stageController.pushScene),"pushSimLoginScene requires a stageController to be passed");model=_.extend(model||{},{name:"contactsSimloginView",assistantConstructor:SimloginAssistant,templateRoot:LIB_ROOT,sceneTemplate:Utils.getTemplatePath("simlogin/simlogin-scene")});stageController.pushScene.apply(stageController,[model,attributes])};
var pushPseudoDetailScene=exports.pushPseudoDetailScene=function(stageController,launchParams,pushSceneParams){Assert.requireDefined(stageController&&stageController.pushScene&&_.isFunction(stageController.pushScene),"pushDetailView requires a stageController to be passed");var person=launchParams.person,contactsFuture;if(person&&person instanceof Contacts.Person&&person.getContacts().length!==person.getContactIds().getLength())contactsFuture=person.reloadContacts();pushSceneParams=_.extend(pushSceneParams||
{},{name:"pseudoDetailView",assistantConstructor:PseudoDetailAssistant,templateRoot:LIB_ROOT,sceneTemplate:Utils.getTemplatePath("pseudodetail/pseudodetail-scene")});stageController.pushScene.apply(stageController,[pushSceneParams,launchParams,contactsFuture])};
var pushReminderScene=exports.pushReminderScene=function(stageController,launchParams,pushSceneParams){Assert.requireDefined(stageController&&stageController.pushScene&&_.isFunction(stageController.pushScene),"pushReminderScene requires a stageController to be passed");pushSceneParams=_.extend(pushSceneParams||{},{name:"contactsReminderView",assistantConstructor:ReminderAssistant,templateRoot:LIB_ROOT,sceneTemplate:Utils.getTemplatePath("reminder/reminder-scene")});stageController.pushScene.apply(stageController,
[pushSceneParams,launchParams])};
var pushContactPointPickerScene=exports.pushContactPointPickerScene=function(stageController,launchParams,pushSceneParams){Assert.requireDefined(stageController&&stageController.pushScene&&_.isFunction(stageController.pushScene),"pushContactPointPickerScene requires a stageController to be passed");pushSceneParams=_.extend(pushSceneParams||{},{name:"contactPointPicker",assistantConstructor:ContactPointPickerAssistant,templateRoot:LIB_ROOT,sceneTemplate:Utils.getTemplatePath("contactpointpicker/contactpointpicker-scene")});stageController.pushScene.apply(stageController,
[pushSceneParams,launchParams])};
