this._root["__MojoFramework_metascene.photos.full"] = function(MojoLoader, exports, root) {


//@ sourceURL=metascene.photos.full/model.js

/*globals FullModel: true */

function FullModel() {}

FullModel.prototype.setController = function(controller) {
	this.controller = controller;
};

FullModel.prototype.onHeaderTap = function() {
	this.controller.stageController.popScene();
};

FullModel.prototype.manageBaseStyles = function() {
	return true;
};

FullModel.prototype.activate = function(params) {
};

FullModel.prototype.getName = function(callback) {
	callback("");
};

FullModel.prototype.getDescription = function(callback) {
	callback("");
};

FullModel.prototype.getCounter = function(callback) {
	callback(1, 1);
};

FullModel.prototype.installMenus = function(setupMenu, modelChanged) {
};

FullModel.prototype.handleCommand = function(command) {
	return false;
};



//@ sourceURL=metascene.photos.full/assistant.js

/*global Mojo: false, MojoLoader: false, internals: true */

var libraries = MojoLoader.require(
	{name: "metascene.base", version: "1.0"},
	{name: "metascene.photos.base", version: "1.0"}
);

var root = MojoLoader.root;

var internals = {};
libraries["metascene.base"].loadResources(internals, root);

function FullAssistant(params) {
	Mojo.Log.error("PCW metascene-photos-full UNcompressed concatenated.js PCW");
	this.model = (params && params.model);
	if (!this.model) {
		throw new Error("Full metascene requires a scene model!");
	}
	this.uiVisible = true;
	this.inDrag = false;
	this.hideTimeout = undefined;
	this.cropParams = {};
}

FullAssistant.prototype = (function() {
	function f() {}
	f.prototype = libraries["metascene.base"].Base;
	return new f();
})();

FullAssistant.prototype.activate = function activate(params) {
	if (this.aboutToActivateCallback) {
		this.aboutToActivateCallback = undefined;
	}
	this.model.activate(params);
};

FullAssistant.prototype.handleWindowResize = function(event) {
	Mojo.Log.info("Window resize!", 
				this.controller.window.innerWidth,
				this.controller.window.innerHeight);
	if (this.flipviewElement && this.flipviewElement.mojo) {
		this.flipviewElement.mojo.manualSize(
				this.controller.window.innerWidth,
				this.controller.window.innerHeight);
	}
};

FullAssistant.prototype.preActivate = function preActivate() {
	this.model.preActivate();
	this.showUI();
	this.controller.stageController.setWindowOrientation("free");
};

FullAssistant.prototype.cleanup = function cleanup() {
	this.unloadSceneStyles(root);
	if (this.model.manageBaseStyles()) {
		libraries["metascene.photos.base"].unloadBaseStylesheet(
			this.controller.stageController);
	}

	if (this.model) {
		if (this.model.cleanup) {
			this.model.cleanup();
		}
		this.model = undefined;
	}
	this.stopHideTimer();
	this.removeAutoListeners();
};

FullAssistant.prototype.setup = function setup() {
	libraries["metascene.photos.base"].AddHeader(
		this.controller.sceneElement);
	this.model.setController(this.controller);
	var canvas = this.sceneGet('image_canvas');
	// there is a stretch from the impolementation to the styled size
	// if these are not equal.
	canvas.width = Mojo.Environment.DeviceInfo.screenWidth;
	canvas.height = Mojo.Environment.DeviceInfo.screenHeight;
	canvas.style.width = canvas.width + "px";
	canvas.style.height = canvas.height + "px";
	this.controller.enableFullScreenMode(true);

	this.extractfsParams = "720:720:3";
	this.flipviewElement = canvas;
	Mojo.Log.error("PCW setting up imageview widget concatenated.js PCW");
	Mojo.Log.error("PCW app id", Mojo.Controller.appInfo.id);
	var canvasmodel = {
		extractfsParams: this.extractfsParams,
		highResolutionTimeout: 0.4
	};
	if (Mojo.Controller.appInfo.id == "com.palm.app.photos") {
		canvasmodel.highResolutionTimeout =  60 * 60 * 24; // 1 day
		canvasmodel.lowResExtractfsParams = "720:720:3";
	}
	this.controller.setupWidget(this.flipviewElement.id, canvasmodel, {
		background: "black",
		onLeftFunction: this.model.goLeft.bind(this.model),
		onRightFunction: this.model.goRight.bind(this.model)
	});
	this.autoListen(this.flipviewElement,
		Mojo.Event.imageViewChanged,
		this.flipViewChanged.bind(this));
	this.model.setCallbacks(
		this.providedCenterUrl.bind(this),
		this.providedLeftUrl.bind(this),
		this.providedRightUrl.bind(this));
	this.autoListen(this.controller.window, 'resize',
		this.handleWindowResize.bind(this));

	var self = this;
	function updateName(text) {
		self.sceneGet('name').innerHTML = text;
	}

	this.sceneGet('description').style.display = "none";
	function updateDescription(text) {
		var element = self.sceneGet('description');
		if (text) {
			element.style.display = "block";
			element.innerHTML = text;
		} else {
			element.style.display = "none";
		}
	}

	function updateCounter(position, total) {
		self.sceneGet("count").innerHTML =
			self.counterTemplate.evaluate({
			position: parseInt(position, 10),
			total: parseInt(total, 10)
		});
	}

	this.counterTemplate =
		new Mojo.Format.Template(internals.$L("#{position}/#{total}"));

	this.model.getName(updateName);
	this.model.getDescription(updateDescription);
	this.model.getCounter(updateCounter);

	this.autoListen(canvas, Mojo.Event.tap,
		this.handleTap.bind(this));
	this.autoListen(canvas, Mojo.Event.dragStart,
		this.dragStart.bind(this), true);
	this.autoListen(canvas, Mojo.Event.dragEnd,
		this.dragEnd.bind(this), true);
	this.autoListen(this.sceneGet('header_info'), Mojo.Event.tap,
		this.model.onHeaderTap.bind(this.model));

	if (this.model.manageBaseStyles()) {
		libraries["metascene.photos.base"].loadBaseStylesheet(
			this.controller.stageController);
	}

	this.model.installMenus(function addMenu(id, attributes, model) {
		self.controller.setupWidget(id, attributes, model);
	}, function menuChanged(model) {
		self.controller.modelChanged(model);
	});

	this.loadSceneStyles(root);
};

FullAssistant.prototype.flipViewChanged = function(event) {
	if (event.url === this.cropParams.filePath) {
		return;
	}

	this.cropParams = this.flipviewElement.mojo.getCurrentParams();
	this.cropParams.filePath = event.url;
	if (event.error) {
		Mojo.Log.error("File was corrupt: " + event.url);
	}
	this.continueToActivate();
};

FullAssistant.prototype.providedLeftUrl = function(url, thumbUrl, name) {
	this.flipviewElement.mojo.leftUrlProvided(url, thumbUrl);
};

FullAssistant.prototype.providedRightUrl = function(url, thumbUrl, name) {
	this.flipviewElement.mojo.rightUrlProvided(url, thumbUrl);
};

FullAssistant.prototype.providedCenterUrl = function(url, thumbUrl, name) {
	Mojo.Log.info("providing center url to widget", url);
	this.flipviewElement.mojo.centerUrlProvided(url, thumbUrl);
};

FullAssistant.prototype.deactivate = function deactivate() {
	this.controller.stageController.setWindowOrientation("up");
};

FullAssistant.prototype.updateCounter = function(text) {
	this.sceneGet("album_count").innerHTML = parseInt(text, 10);
};

FullAssistant.prototype.startHideTimer = function() {
	this.stopHideTimer();
	this.hideTimeout = this.controller.window.setTimeout(
		this.hideUI.bind(this), 5000);
};

FullAssistant.prototype.stopHideTimer = function() {
	if (!this.hideTimeout) {
		return;
	}
	this.controller.window.clearTimeout(this.hideTimeout);
	this.hideTimeout = undefined;
};

FullAssistant.prototype.hideUI = function() {
	this.stopHideTimer();
	this.controller.setMenuVisible(Mojo.Menu.commandMenu, false);
	this.sceneGet('header_info').style.display = "none";
	this.uiVisible = false;
};

FullAssistant.prototype.showUI = function() {
	this.uiVisible = true;
	this.controller.setMenuVisible(Mojo.Menu.commandMenu, true);
	this.sceneGet('header_info').style.display = "block";
	this.startHideTimer();
};

FullAssistant.prototype.handleTap = function(event) {
	if (event.count !== 1) {
		return;
	}
	event.stopPropagation();
	event.preventDefault();
	if (this.uiVisible) {
		this.hideUI();
	} else {
		this.showUI();
	}
};

FullAssistant.prototype.dragStart = function() {
	this.inDrag = true;
	this.stopHideTimer();
};

FullAssistant.prototype.dragEnd = function() {
	this.inDrag = false;
	this.startHideTimer();
};

FullAssistant.prototype.handleCommand = function(event) {
	if (event.type !== Mojo.Event.command) {
		return;
	}

	if (this.model.handleCommand(event.command, this.cropParams)) {
		event.stopPropagation();
		event.preventDefault();
	}
};



//@ sourceURL=metascene.photos.full/base.js


/*globals exports: true, MojoLoader: false, FullModel: false, FullAssistant: false */

var root = MojoLoader.root;
exports.Root = root;
exports.Template = root + "views/scene";
exports.Assistant = FullAssistant;
exports.Model = FullModel;
exports.Name = "full";


}
