
function SetuppalmcontactsVersion1_0() {
	
	var Infinity = global.Infinity,
		NaN = global.NaN,
		undefined = global.undefined;

	
	var Array = global.Array,
		Boolean = global.Boolean,
		Date = global.Date,
		Error = global.Error,
		Function = global.Function,
		Number = global.Number,
		Object = global.Object,
		RegExp = global.RegExp,
		String = global.String,
		EvalError = global.EvalError,
		RangeError = global.RangeError,
		ReferenceError = global.ReferenceError,
		SyntaxError = global.SyntaxError,
		TypeError = global.TypeError,
		URIError = global.URIError;

	
	var Math = global.Math;

	
	var JSON = global.JSON;

	
	var PalmSystem = global.PalmSystem;

	
	var window = global;
	var MojoLoader;
	var Mojo;
	var document = window.document;
	var console;
	var PalmServiceBridge;
	var XMLHttpRequest;

	var inBuiltinEnv = true;

	
	function setPrototype(fn, proto) {
		;%FunctionSetPrototype(fn, proto);
	}

	
	
	function setInterval() {
		return window.setInterval.apply(window, arguments);
	}
	function clearInterval() {
		return window.clearInterval.apply(window, arguments);
	}
	function setTimeout() {
		return window.setTimeout.apply(window, arguments);
	}
	function clearTimeout() {
		return window.clearTimeout.apply(window, arguments);
	}
	function palmGetResource() {
		return window.palmGetResource.apply(window, arguments);
	}
	function palmRequire() {
		return window.palmRequire.apply(window, arguments);
	}
	function palmInclude() {
		return window.palmInclude.apply(window, arguments);
	}
	function eval() {
		return window.eval.apply(window, arguments);
	}
	function encodeURIComponent() {
		return window.encodeURIComponent.apply(window, arguments);
	}
	function decodeURIComponent() {
		return window.decodeURIComponent.apply(window, arguments);
	}
	function encodeURI() {
		return window.encodeURI.apply(window, arguments);
	}
	function decodeURI() {
		return window.decodeURI.apply(window, arguments);
	}
	function parseInt() {
		return window.parseInt.apply(window, arguments);
	}
	function parseFloat() {
		return window.parseFloat.apply(window, arguments);
	}
	function isNaN() {
		return window.isNaN.apply(window, arguments);
	}
	function isFinite() {
		return window.isFinite.apply(window, arguments);
	}

	var exports = new $Object();

	exports.onLoad = function() {
		var IMPORTS=MojoLoader.require({name:"foundations",version:"1.0"},{name:"underscore",version:"1.0"},{name:"foundations.crypto",version:"1.0"},{name:"foundations.io",version:"1.0"},{name:"globalization",version:"1.0"});var Crypto=IMPORTS["foundations.crypto"];var Foundations=IMPORTS.foundations;var Globalization=IMPORTS.globalization.Globalization;exports.Globalization=Globalization;var _=IMPORTS.underscore._;var Assert=Foundations.Assert;var Class=Foundations.Class;var DB=Foundations.Data.DB;
var TempDB=Foundations.Data.TempDB;var Future=Foundations.Control.Future;var ObjectUtils=Foundations.ObjectUtils;var PalmCall=Foundations.Comms.PalmCall;var StringUtils=Foundations.StringUtils;var LIB_ROOT=MojoLoader.root;var resourceBundleFactory=new Globalization.ResourceBundleFactory(MojoLoader.root);var RB=resourceBundleFactory.getResourceBundle();var RECORD_TIMINGS_FOR_SPEED=false;if(typeof require==="undefined")require=IMPORTS.require;var stringifyIMPORTS=MojoLoader.require({name:"underscore",version:"1.0"});var stringify_=stringifyIMPORTS.underscore._;
function stringify(root,printFunctionCode,indentSize,maxDepth){var keysFn=Object.keys||function(obj){var keys=[],key;for(key in obj)if(obj.hasOwnProperty(key))keys.push(key);return keys},newline="",indentToken="",gap="";if(!indentSize&&indentSize!==0)indentSize=4;if(!maxDepth&&maxDepth!==0)maxDepth=5;if(indentSize){indentSize=indentSize>10?10:indentSize;newline="\n";indentToken="          ".substring(0,indentSize);gap=" "}function visitNode(visitedNodes,node){var visited=false,i;for(i=0;i<visitedNodes.length;i+=
1)if(visitedNodes[i]===node){visited=true;break}if(!visited)visitedNodes.push(node);return visited}function type(model){if(model===null)return"null";else if(model===undefined)return"undefined";else if(typeof model==="number")return"number";else if(typeof model==="string")return"string";else if(model===true||model===false)return"boolean";else if(Object.prototype.toString.call(model)==="[object Array]")return"array";else if(typeof model==="function")return"function";else return"object"}function stringifyHelper(curDepth,
curNodeName,curNode,visitedNodes,curIndent){var curNodeType=type(curNode),name=curIndent+(curNodeName?'"'+curNodeName+'":'+gap:""),innerVisitedNodes,visited,i,keys,retVal;curDepth+=1;if(curDepth>maxDepth)return name+"<Truncated: Max Depth Reached>";switch(curNodeType){case "null":return name+"null";case "undefined":return name+"undefined";case "number":return name+curNode;case "string":return name+JSON.stringify(curNode);case "boolean":return name+curNode;case "array":innerVisitedNodes=stringify_.clone(visitedNodes);
visited=visitNode(innerVisitedNodes,curNode);if(visited)return name+"<Already Visited Array>";else{retVal=name+"[";for(i=0;i<curNode.length;i+=1){retVal+=i===0?newline:"";retVal+=stringifyHelper(curDepth,"",curNode[i],innerVisitedNodes,curIndent+indentToken);retVal+=i<curNode.length-1?",":"";retVal+=newline}retVal+=i>0?curIndent:"";retVal+="]";return retVal}break;case "function":if(printFunctionCode)return name+curNode.toString();else return name+"<Function>";break;case "object":innerVisitedNodes=
stringify_.clone(visitedNodes);visited=visitNode(innerVisitedNodes,curNode);if(visited)return name+"<Already Visited Object>";else{retVal=name+"{";keys=keysFn(curNode);for(i=0;i<keys.length;i+=1){retVal+=i===0?newline:"";retVal+=stringifyHelper(curDepth,keys[i],curNode[keys[i]],innerVisitedNodes,curIndent+indentToken);retVal+=i<keys.length-1?",":"";retVal+=newline}retVal+=i>0?curIndent:"";retVal+="}";return retVal}}}return stringifyHelper(0,"",root,[],"")};var BatchDBWriter=function(usePseudoDeepCompare){this._objectCount=0;this._usePseudoDeepCompare=usePseudoDeepCompare};
BatchDBWriter.prototype.batchWrite=function(obj,prop,val){var writes,oldVal,id;if(val===undefined)val=null;oldVal=obj[prop];if(oldVal===undefined)oldVal=null;if(this._usePseudoDeepCompare&&JSON.stringify(oldVal)===JSON.stringify(val))return;else if(!this._usePseudoDeepCompare&&oldVal===val)return;obj[prop]=val;id=obj._id;writes=this._batchedWrites;if(writes&&!writes[id])if(this._objectCount>(this.bufferCommitSize?this.bufferCommitSize:500)-1)this.commitBatchedWrites();this._objectCount+=1;this._batchedWrites=
this._batchedWrites||{};writes=this._batchedWrites;writes[id]=writes[id]||{_id:id};writes[id][prop]=val};BatchDBWriter.prototype.setBufferCommitSize=function(bufferCommitSize){if(bufferCommitSize&&typeof bufferCommitSize==="number"&&this._objectCount===0)if(bufferCommitSize<2||bufferCommitSize>500)return false;else{this.bufferCommitSize=bufferCommitSize;return true}else return false};
BatchDBWriter.prototype.commitBatchedWrites=function(){var writes=this._batchedWrites,id,objList;if(!writes){console.log("commitBatchedWrites: no writes, skipping.");return}objList=[];Object.keys(writes).forEach(function(property){objList.push(writes[property])});if(objList.length>0){console.log("commitBatchedWrites: sending "+objList.length+" writes.");DB.merge(objList)}else console.log("commitBatchedWrites: no writes, not sending.");this._batchedWrites=undefined;this._objectCount=0};var DBWatcher=function(query,watchFiredCallback,useTempDB){console.log("Creating DBWatcher.");if(!query||!watchFiredCallback||!_.isFunction(watchFiredCallback)){console.warn("Tried to create DBWatcher with invalid params. %s %s",query,watchFiredCallback);return}this._watchFiredCallback=watchFiredCallback;this._query=query;this._useTempDB=!!useTempDB;this._doQuery()};
DBWatcher.prototype.cancel=function(){console.log("Cancelling DBWatcher.");if(this._dbFindFuture){PalmCall.cancel(this._dbFindFuture);this._dbFindFuture.cancel();this._dbFindFuture=undefined}};DBWatcher.prototype._doQuery=function(){var DBObject=this._useTempDB?TempDB:DB;if(this._dbFindFuture){PalmCall.cancel(this._dbFindFuture);this._dbFindFuture.cancel()}this._dbFindFuture=DBObject.find(this._query,true);this._dbFindFuture.onError(this,this._queryError);this._dbFindFuture.then(this,this._queryResponse)};
DBWatcher.prototype._queryError=function(){console.warn("DBWatcher query failed.")};
DBWatcher.prototype._queryResponse=function(){var result=this._dbFindFuture.result,results;this._dbFindFuture.then(this,this._queryResponse);if(!result){console.warn("DBWatcher: Falsy query result: "+Utils.stringify(result));return}if(result.fired){console.warn("DBWatcher: watch fired, re-issuing query.");this._doQuery();return}results=result.results;if(!results||!_.isArray(results)){console.warn("DBWatcher: Query result did not contain results array: "+Utils.stringify(results));return}this._watchFiredCallback(results)};var FingerWalker=function(objects){this.objects=objects;this.currentIndex=0};FingerWalker.prototype.getCurrentValue=function(){if(this.hasValueLeft())return this.objects[this.currentIndex]};FingerWalker.prototype.usedCurrentValue=function(){this.currentIndex+=1};FingerWalker.prototype.hasValueLeft=function(){return this.currentIndex<this.objects.length};var FingerWalkerSorter=function(arrayOfArrays,compareFunction){var that=this;this.fingerWalkers=[];this.compareFunction=compareFunction;arrayOfArrays.forEach(function(array){that.fingerWalkers.push(new FingerWalker(array))})};
FingerWalkerSorter.prototype.sort=function(){var sortedValues=[],objectsToCompare=this._getObjectsToCompare(),highestValueIndex;while(objectsToCompare.values.length>0){highestValueIndex=this.compareFunction(objectsToCompare.values);Assert.require(highestValueIndex>-1&&highestValueIndex<objectsToCompare.values.length,"FingerWalkerSorter - compareFunction returned an index '"+highestValueIndex+"' outside of the bounds of the values it was passed");sortedValues.push(objectsToCompare.values[highestValueIndex]);
objectsToCompare.fingerWalkers[highestValueIndex].usedCurrentValue();objectsToCompare=this._getObjectsToCompare()}return sortedValues};FingerWalkerSorter.prototype._getObjectsToCompare=function(){var objectsToCompare={values:[],fingerWalkers:[]};this.fingerWalkers.forEach(function(fingerWalker){if(fingerWalker.hasValueLeft()){objectsToCompare.values.push(fingerWalker.getCurrentValue());objectsToCompare.fingerWalkers.push(fingerWalker)}});return objectsToCompare};var SpeedDialSaver=function(personOrPersons){this.savedSpeedDials=[];var that=this,personArray;if(personOrPersons){personArray=_.isArray(personOrPersons)?personOrPersons:[personOrPersons];this.people=personArray;personArray.forEach(function(person){if(person)person.getPhoneNumbers().getArray().forEach(function(phoneNumber){var speedDial=phoneNumber.getSpeedDial();if(speedDial)that.savedSpeedDials.push({speedDial:speedDial,value:phoneNumber.getValue(),person:person})})})}};
SpeedDialSaver.prototype.saveBackupRecordsForSpeedDials=function(){var contactLinkHashCache={},future=new Future,speedDialHashes={};future.now(this,function(){this.savedSpeedDials.forEach(function(speedDial){var tempSpeedDialHash=new SpeedDialHash({key:speedDial.speedDial});tempSpeedDialHash.setPlainValue(speedDial.value);if(!speedDialHashes[speedDial.person.getId()]){speedDialHashes[speedDial.person.getId()]=[];speedDialHashes[speedDial.person.getId()].push(tempSpeedDialHash)}else speedDialHashes[speedDial.person.getId()].push(tempSpeedDialHash)});
return Foundations.Control.mapReduce({map:function(person){var mapFuture=new Future,contactLinkHashes=[],toMapReduce=[];mapFuture.now(function(){if(person.getContacts().length===0)return person.reloadContacts();else return true});mapFuture.then(function(){var result=mapFuture.result;return Foundations.Control.mapReduce({map:function(contact){var contactLinkHashFuture=new Future;contactLinkHashFuture.now(function(){if(!contactLinkHashCache[contact.getId()])return ContactLinkable.getLinkHash(contact).then(function(getLinkHashFuture){var result=
getLinkHashFuture.result;contactLinkHashes.push(result.linkHash);contactLinkHashCache[contact.getId()]=result.linkHash;return true});else return true});return contactLinkHashFuture}},person.getContacts())});mapFuture.then(function(){var dummy=future.result;return Foundations.Control.mapReduce({map:function(contactLinkHash){var getLinkHashBackupFuture=new Future;getLinkHashBackupFuture.now(function(){return SpeedDialBackup.getBackupForLinkHash(contactLinkHash)});getLinkHashBackupFuture.then(function(){var result=
getLinkHashBackupFuture.result,tempBackup;if(result)tempBackup=result;else tempBackup=new SpeedDialBackup({contactBackupHash:contactLinkHash,speedDials:[]});tempBackup.getSpeedDials().clear();if(speedDialHashes[person.getId()]&&speedDialHashes[person.getId()].length>0){tempBackup.getSpeedDials().add(speedDialHashes[person.getId()]);toMapReduce.push({"function":tempBackup.save,object:tempBackup})}else if(tempBackup.getId())toMapReduce.push({"function":tempBackup.deleteSpeedDialBackup,object:tempBackup});
return true});return getLinkHashBackupFuture}},contactLinkHashes)});mapFuture.then(function(){var dummy=mapFuture.result;return Utils.mapReduceAndVerifyResultsTrue(toMapReduce)});return mapFuture}},this.people)});return future};
SpeedDialSaver.prototype.restoreSpeedDials=function(personToRestoreTo){this.savedSpeedDials.forEach(function(savedSpeedDial){var matchingPhoneNumber=_.detect(personToRestoreTo.getPhoneNumbers().getArray(),function(phoneNumber){var matchQuality=Globalization.Phone.comparePhoneNumbers(phoneNumber.getValue(),savedSpeedDial.value);return matchQuality>0});if(matchingPhoneNumber)matchingPhoneNumber.setSpeedDial(savedSpeedDial.speedDial)})};
SpeedDialSaver.prototype.restoreSpeedDialsFromBackups=function(personToRestoreTo){var future=new Future;future.now(this,function(){return this.getLinkHashesForPeople()});future.then(this,function(){var linkHashes=future.result;return SpeedDialBackup.getBackupsForLinkHashes(linkHashes)});future.then(this,function(){var backupRecords=future.result;backupRecords.forEach(function(backupRecord){var speedDials=backupRecord.getSpeedDials().getArray();speedDials.forEach(function(speedDial){personToRestoreTo.getPhoneNumbers().getArray().some(function(phoneNumber){if(speedDial.isPlainValueEqual(phoneNumber.getValue()))if(!phoneNumber.getSpeedDial()){phoneNumber.setSpeedDial(speedDial.getKey());
return true}return false})})});return true});return future};
SpeedDialSaver.prototype.getLinkHashesForPeople=function(){var future=new Future,contactLinkHashes=[],contactLinkHashCache={};future.now(this,function(){return Foundations.Control.mapReduce({map:function(person){var mapFuture=new Future,toMapReduce=[];mapFuture.now(function(){if(person.getContacts().length===0)return person.reloadContacts();else return true});mapFuture.then(function(){var result=mapFuture.result;return Foundations.Control.mapReduce({map:function(contact){var contactLinkHashFuture=new Future;
contactLinkHashFuture.now(function(){if(!contactLinkHashCache[contact.getId()])return ContactLinkable.getLinkHash(contact).then(function(getLinkHashFuture){var result=getLinkHashFuture.result;contactLinkHashes.push(result.linkHash);contactLinkHashCache[contact.getId()]=result.linkHash;return true});else{contactLinkHashes.push(contactLinkHashCache[contact.getId()]);return true}});return contactLinkHashFuture}},person.getContacts())});return mapFuture}},this.people)});future.then(function(){var dummy=
future.result;return contactLinkHashes});return future};var TimingRecorder=function(turnOffTimings,process){this.timings={};this.turnOffTimings=turnOffTimings;this.process=process};TimingRecorder.prototype.startTimingForJob=function(jobName){if(!this.turnOffTimings||!this.process)return;var time=this.process.uptime();if(!this.timings[jobName])this.timings[jobName]=[];this.timings[jobName].push({startTime:time})};
TimingRecorder.prototype.stopTimingForJob=function(jobName){var time,tempJobTimings;if(!this.turnOffTimings||!this.process)return;time=this.process.uptime();tempJobTimings=this.timings[jobName];if(!tempJobTimings)console.log("Job '"+jobName+"' did not have a startTiming call!!!!!");tempJobTimings[tempJobTimings.length-1].endTime=time};
TimingRecorder.prototype.printTimings=function(){var tempTimingsForJob,jobAverage,that=this;if(!this.turnOffTimings)return;Object.keys(this.timings).forEach(function(key){jobAverage=0;console.log("Timings for job '"+key+"'");tempTimingsForJob=that.timings[key];console.log(tempTimingsForJob.length+" recordings where made");tempTimingsForJob.forEach(function(timing,index){console.log(index+1+": "+(timing.endTime-timing.startTime)/1E3+"s");jobAverage+=timing.endTime-timing.startTime});jobAverage=jobAverage/
tempTimingsForJob.length;console.log("For an average time spent of: "+jobAverage/1E3+"s")})};var Utils=exports.Utils={stringify:stringify,FingerWalker:FingerWalker,FingerWalkerSorter:FingerWalkerSorter,BatchDBWriter:BatchDBWriter,DBWatcher:DBWatcher,TimingRecorder:TimingRecorder,defineConstant:function(name,value,applyToObject){var obj=applyToObject||{};obj.__defineGetter__(name,function(){return value});obj.__defineSetter__(name,function(){throw new Error(name+" is a constant!");});return obj},defineConstants:function(definitionObj,applyToObject){var obj=applyToObject||{},key;for(key in definitionObj)if(definitionObj.hasOwnProperty(key))Utils.defineConstant(key,
definitionObj[key],obj);return obj},functionArgsToArray:function(args,startIndex){var argsArray=[],i;if(!args)return[];startIndex=startIndex||0;for(i=startIndex;i<args.length;i=i+1)argsArray.push(args[i]);return argsArray},curry:function(method){Assert.requireFunction(method,"curry requires a function");if(!arguments.length)return method;var args=Utils.functionArgsToArray(arguments,1);return function(){var total=args.concat(Utils.functionArgsToArray(arguments));return method.apply(this,total)}},instiantiateAndApply:function(klass,
args){function F(){return klass.apply(this,args)}F.prototype=klass.prototype;return new F},lazyWrapper:function(klass,args){return{isLazyWrapper:true,createInstance:Utils.curry(Utils.instiantiateAndApply,klass,args)}},generateGettersFromPropertyNames:function(scope,obj){var field="",getterName="",getterFunction=function(fieldName){return obj[fieldName]};for(field in obj)if(obj.hasOwnProperty(field)&&field[0]!=="_"){getterName="get"+field[0].toUpperCase()+field.slice(1,field.length);scope[getterName]=
Utils.curry(getterFunction,field)}},getDBObjectForAllProperties:function(accessor,fieldNames){var dbObj={},i,prop,fieldName;Assert.requireFunction(accessor,"getDBObjectForAllProperties requires an accessor function");Assert.requireArray(fieldNames,"getDBObjectForAllProperties requires a fieldNames array");for(i=0;i<fieldNames.length;i+=1){fieldName=fieldNames[i];prop=accessor(fieldName);if(prop!==undefined&&typeof prop==="object"&&prop.getDBObject)dbObj[fieldName]=prop.getDBObject();else dbObj[fieldName]=
prop}return dbObj},getDBObjectForAllDirtyProperties:function(accessor,fieldNames){var dbObj={},i,prop,fieldName,propDBObj;Assert.requireFunction(accessor,"getDBObjectForAllDirtyProperties requires an accessor function");Assert.requireArray(fieldNames,"getDBObjectForAllDirtyProperties requires a fieldNames array");for(i=0;i<fieldNames.length;i+=1){fieldName=fieldNames[i];prop=accessor(fieldName);if(prop!==undefined)if(typeof prop==="object"){propDBObj=prop.getDBObject();if(propDBObj){if(prop instanceof
PropertyArray&&prop.containsDirtyEntry()||prop instanceof PropertyBase&&prop.isDirty())dbObj[fieldName]=propDBObj}else if(prop.isDirty())dbObj[fieldName]=propDBObj}else{if(fieldName!=="_rev")dbObj[fieldName]=prop}else dbObj[fieldName]=prop}return dbObj},generateDisplayName:function(obj,includeBasedOnField){var displayName="",basedOnField=null,fullName=obj.getName().getFullName(),org;if(fullName){displayName=fullName;basedOnField=DisplayNameType.NAME}else if(obj.getNickname().getValue()){displayName=
obj.getNickname().getValue();basedOnField=DisplayNameType.NICKNAME}if(!displayName)if(obj instanceof Person)if(obj.getOrganization().getTitle()&&obj.getOrganization().getName()){displayName=obj.getOrganization().getTitle()+", "+obj.getOrganization().getName();basedOnField=DisplayNameType.TITLE_AND_ORGANIZATION_NAME}else if(!obj.getOrganization().getTitle()&&obj.getOrganization().getName()){displayName=obj.getOrganization().getName();basedOnField=DisplayNameType.ORGANIZATION_NAME}else{if(obj.getOrganization().getTitle()&&
!obj.getOrganization().getName()){displayName=obj.getOrganization().getTitle();basedOnField=DisplayNameType.TITLE}}else if(obj instanceof Contact){org=obj.getBestOrganization();if(org)if(org.getTitle()&&org.getName()){displayName=org.getTitle()+", "+org.getName();basedOnField=DisplayNameType.TITLE_AND_ORGANIZATION_NAME}else if(!org.getTitle()&&org.getName()){displayName=org.getName();basedOnField=DisplayNameType.ORGANIZATION_NAME}else if(org.getTitle()&&!org.getName()){displayName=org.getTitle();
basedOnField=DisplayNameType.TITLE}}if(!displayName)if(obj.getEmails().getArray().length){displayName=obj.getEmails().getArray()[0].getDisplayValue();basedOnField=DisplayNameType.EMAIL}else if(obj.getIms().getArray().length){displayName=obj.getIms().getArray()[0].getDisplayValue();basedOnField=DisplayNameType.IM}else if(obj.getPhoneNumbers().getArray().length){displayName=obj.getPhoneNumbers().getArray()[0].getDisplayValue();basedOnField=DisplayNameType.PHONE}else{displayName=RB.$L("[No Name Available]");
basedOnField=DisplayNameType.NONE}if(includeBasedOnField)return{displayName:displayName,basedOnField:basedOnField};else return displayName},dedupeEntries:function(hashNonDupes,arrayToAdd,keyGenFunc){var toReturn=[];arrayToAdd.forEach(function(itemToAdd){var key;if(keyGenFunc)key=itemToAdd[keyGenFunc]();else key=itemToAdd;if(key&&!hashNonDupes[key]){hashNonDupes[key]=true;toReturn.push(itemToAdd)}});return toReturn},getSearchTermsFromContact:function(contact){var name,familyName,givenName,toReturn=
[];if(!contact||!(contact instanceof Contact)){console.log("Error getSearchTermsFromContact - was called with an invalid contact object");return[]}name=contact.getName();if(name){familyName=name.getFamilyName();givenName=name.getGivenName();if(givenName&&familyName){givenName=givenName.toLowerCase();familyName=familyName.toLowerCase();if(givenName&&givenName.length>0&&familyName){toReturn.push(givenName.substring(0,1)+familyName);toReturn.push(familyName+givenName)}}}return toReturn},createLabelFunctions:function(arr,
sortLabels){Assert.requireArray(arr,"labelsConstantCreator requires an array");var labelsArray=arr,labelsHash={},popupLabelsHash={},defaultPopupLabels,labelItemCompare=function(a,b){return a.displayValue.localeCompare(b.displayValue)},getLabelHelper=function(labelType,value){if(!value)return"";var item=labelsHash[value];if(item)return item[labelType]||"";else return""};if(sortLabels)labelsArray.sort(labelItemCompare);defaultPopupLabels=function(){var popupLabels=[],i,item,popupLabelItem;for(i=0;i<
labelsArray.length;i=i+1){item=labelsArray[i];labelsHash[item.value]={label:item.displayValue,shortLabel:item.shortDisplayValue};if(item.isPopupLabel){popupLabelItem={value:item.value,label:item.displayValue,shortLabel:item.shortDisplayValue,command:item.value};popupLabelsHash[item.value]=popupLabelItem;popupLabels.push(popupLabelItem)}}return popupLabels}();return{getLabel:function(value){return getLabelHelper("label",value)},getShortLabel:function(value){return getLabelHelper("shortLabel",value)},
getPopupLabels:function(labels){if(!labels)return defaultPopupLabels;if(!_.isArray(labels)){console.warn("Error: getPopupLabels requires an array param");return[]}var popupLabels=[],i,item;for(i=0;i<labels.length;i=i+1){item=popupLabelsHash[labels[i]];if(item)popupLabels.push(_.clone(item));else console.warn("Error: getPopupLabels: label not found: "+labels[i])}return popupLabels}}},DBResultHelper:function(result){if(result&&result.results)return result.results;return result},getContactsCapabilityProvider:function(account){return _.detect(account.capabilityProviders,
function(capabilityProvider){return capabilityProvider.capability==="CONTACTS"})},mapReduceAndVerifyResultsTrue:function(dataToMapReduce,propertyToCheck){var failedTest=false,reduceFuture;return Utils._mapReduceUsingThisReduceFunction(dataToMapReduce,function(result,mapReduceFuture){var i;if(_.isArray(result))for(i=0;i<result.length;i+=1){if(!result[i].result){console.log("A function passed to Utils.mapReduceAndVerifyResultsTrue failed");failedTest=true;break}}else{Assert.require(propertyToCheck&&
typeof propertyToCheck==="string","When using a map function that only returns a single result you must specify a propertyToCheck");if(!result[propertyToCheck])failedTest=true}reduceFuture=new Future;if(failedTest)reduceFuture.result=false;else reduceFuture.result=true;return reduceFuture})},mapReduceAndReturnResults:function(dataToMapReduce){var failedTest=false,reduceFuture,results=[];return Utils._mapReduceUsingThisReduceFunction(dataToMapReduce,function(result,mapReduceFuture){var i;for(i=0;i<
result.length;i+=1)results.push(result[i].result);reduceFuture=new Future;reduceFuture.result=results;return reduceFuture})},_mapReduceUsingThisReduceFunction:function(dataToMapReduce,reduceFunction){var failedTest=false,reduceFuture;return Foundations.Control.mapReduce({map:function(data){var fn=data["function"];Assert.require(fn&&_.isFunction(fn),"_mapReduceUsingThisReduceFunction requires a 'function' params");if(data.object)return fn.apply(data.object,data.parameters?data.parameters:[]);else return fn()},
reduce:reduceFunction},dataToMapReduce)},mixInBroadcaster:function(obj){var listeners=[];Assert.require(!obj.addListener&&!obj.removeListener&&!obj.broadcast&&!obj.countListeners,"mixInBroadcaster: obj already has these methods defined!");obj.addListener=function(callback){if(callback)listeners.push(callback)};obj.removeListener=function(callback){var i=listeners.indexOf(callback);if(i!==-1)listeners.splice(i,1);else console.error("removeListener: Cannot find callback to remove.")};obj.countListeners=
function(){return listeners.length};obj.broadcast=function(){_.invoke(listeners,"apply",undefined,arguments)};return obj},dbMap:function dbMap(query,mapFunc){var future=DB.find(query),next;future.then(function(){next=future.result.next;future.nest(Foundations.Control.mapReduce({map:mapFunc},future.result.results))});future.then(this,function(){if(next){query.page=next;future.nest(dbMap(query,mapFunc))}else future.result=true});return future},callFunctionsOnProperties:function(accessorFunction,propertyObjectNames,
objectFunctionName,propertyArrayNames,arrayFunctionName){var toReturn=false;Assert.requireFunction(accessorFunction,"callFunctionsOnAllProperties - You must specify an accessor function");if(propertyObjectNames&&_.isArray(propertyObjectNames)){Assert.require(objectFunctionName,"callFunctionsOnAllProperties - You must define a function name to be called on each object");propertyObjectNames.forEach(function(currentPropertyName){toReturn=toReturn||accessorFunction(currentPropertyName)[objectFunctionName]()})}if(propertyArrayNames&&
_.isArray(propertyArrayNames)){Assert.require(arrayFunctionName,"callFunctionsOnAllProperties - You must define a function name to be called on each array object");propertyArrayNames.forEach(function(currentPropertyName){toReturn=toReturn||accessorFunction(currentPropertyName)[arrayFunctionName]()})}return toReturn}};var ArrayUtil={pushAll:function(dst,src){var i;for(i=0;i<src.length;i+=1)dst.push(src[i]);return dst},removeValue:function(src,toRemove){var i,found=false;for(i=0;i<src.length;i+=1)if(src[i]===toRemove){src.splice(i,1);found=true;return found}return found},copyOfArray:function(src){var toReturn=[],i;if(src)for(i=0;i<src.length;i+=1)toReturn[i]=src[i];return toReturn}};var PropertyArray=Class.create({initialize:function(propertyClass,obj){Assert.requireFunction(propertyClass,"PropertyArray requires a propertyClass to be constructed");this._propertyClass=propertyClass;this._isDirty=false;this._propertyClassArray=[];if(obj)this.add(obj)},set:function(obj){this._propertyClassArray=[];this.add(obj)},add:function(obj){Assert.requireDefined(obj,"add obj is not defined");if(obj instanceof PropertyArray)obj=obj.getArray();if(_.isArray(obj))for(var i=0;i<obj.length;i=i+
1)this._addHelper(obj[i]);else this._addHelper(obj);this._isDirty=true},_addHelper:function(obj){if(obj instanceof this._propertyClass)if(_.indexOf(this._propertyClassArray,obj)<0)this._propertyClassArray.push(obj);else console.log("Item already exists! Aborting add.");else this._propertyClassArray.push(new this._propertyClass(obj))},remove:function(obj){Assert.requireDefined(obj,"remove requires an object to be passed in");var i,item;for(i=0;i<this._propertyClassArray.length;i=i+1){item=this._propertyClassArray[i];
if(item.equals(obj)){this._propertyClassArray.splice(i,1);this._isDirty=true;return true}}return false},contains:function(obj){Assert.requireDefined(obj,"remove requires an object to be passed in");Assert.require(obj instanceof this._propertyClass,"does not contain objects of this type");var i,item;for(i=0;i<this._propertyClassArray.length;i=i+1){item=this._propertyClassArray[i];if(item===obj)return true}return false},getArray:function(){return _.clone(this._propertyClassArray)},containsDirtyEntry:function(){return this._isDirty||
this._propertyClassArray.some(function(currentObject){return currentObject.isDirty()})},markElementsNotDirty:function(){this.markArrayNotDirty();this._propertyClassArray.forEach(function(currentObject){currentObject.markNotDirty()})},markArrayNotDirty:function(){this._isDirty=false},clear:function(){this._propertyClassArray=[];this._isDirty=true},getLength:function(){return this._propertyClassArray.length},getClass:function(){return this._propertyClass},getDBObject:function(){var db=[],i;for(i=0;i<
this._propertyClassArray.length;i=i+1)db.push(this._propertyClassArray[i].getDBObject());return db},toString:function(){return JSON.stringify(this.getDBObject())}});var PropertyBase=Class.create({});
PropertyBase.create=function(config){Assert.requireDefined(config,"PropertyBase: config is undefined");Assert.require(config.data&&config.data.length,"PropertyBase requires at least one field to be specified");var _PropertyBase,_PropertyBaseMethods,_configData=config.data,_superClass=config.superClass||PropertyBase,_configDataHash={},_isPrimitiveType=false,_CONST={DYNAMIC_SETTER_PREFIX:"fn_set_",DYNAMIC_GETTER_PREFIX:"fn_get_",DYNAMIC_PROPERTY_PREFIX:"x_",PRIMITIVE_TYPE_FIELD_NAME:"value",ACCESSOR_SET:"set",
ACCESSOR_GET:"get"},_isDirty=false;function _initPropertyBase(){var i,field;if(_configData.length===1&&!_configData[0].dbFieldName){_isPrimitiveType=true;_configData[0].dbFieldName=_CONST.PRIMITIVE_TYPE_FIELD_NAME}for(i=0;i<_configData.length;i=i+1){field=_configData[i];Assert.require(field.dbFieldName,"PropertyBase: field is missing required dbFieldName param");_configDataHash[field.dbFieldName]=field;if(field.classObject&&!_.isFunction(field.classObject))throw new Error("classObject must be a function");
if(!field.setterName)field.setterName=_CONST.DYNAMIC_SETTER_PREFIX+field.dbFieldName;if(!field.getterName)field.getterName=_CONST.DYNAMIC_GETTER_PREFIX+field.dbFieldName;if(!field.propertyName)field.propertyName=_CONST.DYNAMIC_PROPERTY_PREFIX+field.dbFieldName}}function _createGettersSettersProperties(ClassObj){var i,j,field,item,propertyName,setterFunction=function(setterFunctionName,value,inInit){var fn=this[setterFunctionName];Assert.requireFunction(fn,"Dynamic setter function does not exist: "+
setterFunctionName);fn.call(this,value,inInit)},getterFunction=function(getterFunctionName){var fn=this[getterFunctionName];Assert.requireFunction(fn,"Dynamic getter function does not exist: "+getterFunctionName);return fn.apply(this)},accessorWrapper=function(type,fieldName,subObj,value,inInit){var i,fetchedValue,accessor,configDataHash;if(subObj&&type===_CONST.ACCESSOR_SET&&(typeof value!=="object"||typeof value==="object"&&!(value instanceof subObj)))throw new Error("Calling setter of sub object: "+
fieldName+" with a value that is the incorrect type");for(i=this.privateAccessors.length-1;i>=0;i-=1){accessor=this.privateAccessors[i].accessor;configDataHash=this.privateAccessors[i].configDataHash;if(configDataHash[fieldName])return accessor(type,fieldName,value,inInit)}return};for(i=0;i<_configData.length;i=i+1){field=_configData[i];item={};for(j in field)if(field.hasOwnProperty(j))item[j]=field[j];ClassObj.__CLASS_CONFIG.push(item);ClassObj.prototype[field.setterName]=Utils.curry(accessorWrapper,
_CONST.ACCESSOR_SET,field.dbFieldName,field.classObject);ClassObj.prototype[field.getterName]=Utils.curry(accessorWrapper,_CONST.ACCESSOR_GET,field.dbFieldName,field.classObject,undefined);ClassObj.prototype.__defineSetter__(field.propertyName,Utils.curry(setterFunction,field.setterName));ClassObj.prototype.__defineGetter__(field.propertyName,Utils.curry(getterFunction,field.getterName))}}function _accessor(data,type,fieldName,value,initializingData){var field=_configDataHash[fieldName];Assert.require(type,
"Accessor type not found");Assert.require(field,"Accessor ["+type+"] field not found: "+fieldName);if(type===_CONST.ACCESSOR_SET){if(!initializingData)_isDirty=true;if(field.beforeSet&&_.isFunction(field.beforeSet))data[field.dbFieldName]=field.beforeSet.apply(this,[value]);else data[field.dbFieldName]=value;return true}else if(field.beforeGet&&_.isFunction(field.beforeGet))return field.beforeGet.apply(this,[data[field.dbFieldName]]);else return data[field.dbFieldName]}function _initFields(scope,
obj,isFromDB){var i,field,initValue;for(i=0;i<_configData.length;i=i+1){field=_configData[i];initValue=undefined;if(obj)if(typeof obj!=="object"){Assert.require(_isPrimitiveType,"PropertyBase - Sanity check failed: argument passed is not an object and there is more than one field: "+"field name: "+field.dbFieldName+" OBJ: "+JSON.stringify(obj)+" isPrimitiveType: "+_isPrimitiveType+" config length: "+_configData.length);initValue=obj}else if(undefined!==obj[field.dbFieldName])initValue=obj[field.dbFieldName];
if(!isFromDB&&undefined===initValue&&undefined!==field.defaultValue)initValue=field.defaultValue;if(field.classObject)initValue=new field.classObject(initValue);if(undefined!==initValue)scope[field.setterName].apply(scope,[initValue,true])}}_initPropertyBase();_PropertyBase=Class.create(_superClass,{initialize:function initialize(obj,isFromDB){if(obj&&obj instanceof PropertyBase)obj=obj.getDBObject();this._origData=obj||{};this.privateAccessors=this.privateAccessors||[];this._dbObjects=this._dbObjects||
[];if(_superClass)this.$super(initialize)(obj,isFromDB);var _data={};if(obj&&obj._id)_data._id=obj._id;this.privateAccessors.push({accessor:_.bind(_accessor,this,_data),configDataHash:_configDataHash});_initFields(this,obj,isFromDB);this._dbObjects.push(_data)},getDBObject:function getDBObject(){var retVal,i,subObj;if(_isPrimitiveType&&this._dbObjects.length===1)retVal=this._dbObjects[0][_CONST.PRIMITIVE_TYPE_FIELD_NAME];else{retVal={};for(i=0;i<this._dbObjects.length;i+=1)_.extend(retVal,_.clone(this._dbObjects[i]));
for(i in retVal)if(retVal.hasOwnProperty(i)){subObj=retVal[i];if(subObj instanceof PropertyBase)subObj=_.clone(subObj.getDBObject())}retVal=_.extend(this._origData,retVal)}if(this._extendedGetDBObject)return this._extendedGetDBObject.apply(this,[retVal]);return retVal},reinitialize:function(obj,isFromDB){_initFields(this,obj,isFromDB);this.forceMarkDirty()},clear:function(){_initFields(this,undefined)},isDirty:function(){return _isDirty},markNotDirty:function(){_isDirty=false},forceMarkDirty:function(){_isDirty=
true},_equals:function(otherObject){var thisValue,otherValue,i,field;try{for(i=0;i<_configData.length;i=i+1){field=_configData[i];thisValue=this[field.getterName]();otherValue=otherObject[field.getterName]();if(thisValue&&otherValue)if(thisValue instanceof PropertyBase&&otherValue instanceof PropertyBase){if(!thisValue.equals(otherValue))return false}else if(thisValue!==otherValue)return false}}catch(e){console.log(e.message);return false}return true},equals:function(otherObject){return this._equals(otherObject)},
toString:function(){return JSON.stringify(this.getDBObject())}});_PropertyBase.__CLASS_CONFIG=[];_PropertyBase.isPrimitiveType=function(){return _isPrimitiveType};_createGettersSettersProperties.apply(this,[_PropertyBase]);return _PropertyBase};var AccountId=exports.AccountId=PropertyBase.create({data:[{dbFieldName:"",defaultValue:"",setterName:"setValue",getterName:"getValue"}]});var Account=PropertyBase.create({data:[{dbFieldName:"domain",defaultValue:"",setterName:"setDomain",getterName:"getDomain"},{dbFieldName:"userName",defaultValue:"",setterName:"setUserName",getterName:"getUserName"},{dbFieldName:"userid",defaultValue:"",setterName:"setUserId",getterName:"getUserId"}]});var Address=exports.Address=PropertyBase.create({data:[{dbFieldName:"streetAddress",defaultValue:"",setterName:"setStreetAddress",getterName:"getStreetAddress"},{dbFieldName:"locality",defaultValue:"",setterName:"setLocality",getterName:"getLocality"},{dbFieldName:"postalCode",defaultValue:"",setterName:"setPostalCode",getterName:"getPostalCode"},{dbFieldName:"region",defaultValue:"",setterName:"setRegion",getterName:"getRegion"},{dbFieldName:"country",defaultValue:"",setterName:"setCountry",getterName:"getCountry"},
{dbFieldName:"type",defaultValue:"type_work",setterName:"setType",getterName:"getType"},{dbFieldName:"primary",defaultValue:false,setterName:"setPrimary",getterName:"getPrimary"}]});Address.prototype.__defineGetter__("x_displayValue",function(){return this.getDisplayValue()});
Address.prototype.__defineSetter__("x_displayValue",function(newAddressValue){var parsedAddress=Globalization.Address.parseAddress(newAddressValue);this.setStreetAddress(parsedAddress.streetAddress||"");this.setLocality(parsedAddress.locality||"");this.setRegion(parsedAddress.region||"");this.setPostalCode(parsedAddress.postalCode||"");this.setCountry(parsedAddress.country||"")});
Address.prototype.getDisplayValue=function(onlyOneLine){var address=Globalization.Address.formatAddress(this.getDBObject());if(onlyOneLine)address=address.replace(/\n/g," ");return address};Address.prototype.getStringValue=function(insertSpaces){var space=insertSpaces?" ":"";return this.getStreetAddress()+space+this.getLocality()+space+this.getPostalCode()+space+this.getRegion()+space+this.getCountry()+space+this.getType()};Address.prototype.__defineGetter__("x_displayType",function(){return this.getDisplayType()});
Address.prototype.getDisplayType=function(){return Address.Labels.getLabel(this.getType())||Address.Labels.getLabel(Address.TYPE.OTHER)};Address.prototype.getNormalizedHashKey=function(){var toReturn="";toReturn+=this.getStringValue();toReturn=toReturn.toUpperCase();return toReturn.replace(/\W/g,"")};Address.prototype.__defineGetter__("x_displayType",function(){return this.getDisplayType()});Address.TYPE=Utils.defineConstants({HOME:"type_home",WORK:"type_work",OTHER:"type_other"});
Address.Labels=Utils.createLabelFunctions([{value:Address.TYPE.HOME,displayValue:RB.$L("Home"),isPopupLabel:true},{value:Address.TYPE.WORK,displayValue:RB.$L("Work"),isPopupLabel:true},{value:Address.TYPE.OTHER,displayValue:RB.$L("Other"),isPopupLabel:true}]);var Anniversary=PropertyBase.create({data:[{dbFieldName:"",defaultValue:"",setterName:"setValue",getterName:"getValue"}]});var Birthday=exports.Birthday=PropertyBase.create({data:[{dbFieldName:"",defaultValue:"",setterName:"setValue",getterName:"getValue"}]});Birthday.prototype.getDisplayValue=function(options){var date=this.getDateObject(),formatObj={};formatObj.date="long";if(date)if(Mojo&&Mojo.Format&&Mojo.Format.formatDate){if(date.getFullYear()===1900)formatObj.dateComponents="dm";options=options||formatObj;return Mojo.Format.formatDate(date,options)}else return date.toLocaleDateString();else return""};
Birthday.prototype.getDateObject=function(){var value=this.getValue(),splitDateValue=value?value.split("-"):[];if(splitDateValue.length>2)return new Date(splitDateValue[0],parseInt(splitDateValue[1],10)-1,splitDateValue[2]);else if(splitDateValue.length>1&&value.length>6)return new Date(splitDateValue[0],splitDateValue[1],-1);else if(splitDateValue.length>1&&value.length>4)return new Date(-1,parseInt(splitDateValue[0],10)-1,splitDateValue[1]);else if(splitDateValue.length>0)return new Date(splitDateValue[0]);
else return};Birthday.prototype.__defineGetter__("x_displayValue",function(){return this.getDisplayValue()});Birthday.translateBirthdayFromCurrentForm=function(unformatted){return unformatted?unformatted.replace(/-/gi,""):unformatted};
Birthday.parseBirthday=function(unformatted){var date,options={};options.date="long";unformatted=Birthday.translateBirthdayFromCurrentForm(unformatted);date=parseInt(unformatted,10);if(date==="NaN"){console.log("The birthday "+unformatted+" is not in the localdate int format");return Mojo.Format.formatDate(new Date,options)}date=Birthday.localDateToDate(date);if(date.getFullYear()===1900||date.getFullYear()===0)options.dateComponents="dm";return Mojo.Format.formatDate(date,options)};
Birthday.localDateToDate=function(date){var day,month,year,returnDate;if(!date)return null;day=date%100;date=Math.floor(date/100);month=date%100;month=month-1;date=Math.floor(date/100);year=date;returnDate=new Date(year,month,day);return returnDate};var ContactBackupHash=PropertyBase.create({data:[{dbFieldName:"",defaultValue:false,setterName:"setValue",getterName:"getValue"}]});ContactBackupHash.prototype.equals=function(value){if(value instanceof ContactBackupHash)return this.getValue()===value.getValue();else return this.getValue()===value};var ContactId=PropertyBase.create({data:[{dbFieldName:"",defaultValue:"",setterName:"setValue",getterName:"getValue"}]});ContactId.prototype.equals=function(value){if(value instanceof ContactId)return this.getValue()===value.getValue();else return this.getValue()===value};var DefaultPropertyHash=PropertyBase.create({data:[{dbFieldName:"value",defaultValue:null,setterName:"setValue",getterName:"getValue"},{dbFieldName:"type",defaultValue:null,setterName:"setType",getterName:"getType"},{dbFieldName:"favoriteData",defaultValue:null,setterName:"setFavoriteData",getterName:"getFavoriteData"}]});DefaultPropertyHash.prototype.equals=function(value){if(value instanceof DefaultPropertyHash)return this.getValue()===value.getValue()&&this.getType()===value.getType();return false};
DefaultPropertyHash.prototype.setPlainValue=function(value){this.setValue(value?Crypto.MD5.b64_md5(value):null)};DefaultPropertyHash.prototype.isPlainValueEqual=function(value){return value?Crypto.MD5.b64_md5(value)===this.getValue():value===this.getValue()};var DisplayName=PropertyBase.create({data:[{dbFieldName:"",defaultValue:"",setterName:"setValue",getterName:"getValue"}]});var EmailAddress=exports.EmailAddress=PropertyBase.create({data:[{dbFieldName:"value",defaultValue:"",setterName:"setValue",getterName:"getValue"},{dbFieldName:"type",defaultValue:"type_home",setterName:"setType",getterName:"getType"},{dbFieldName:"primary",defaultValue:false,setterName:"setPrimary",getterName:"getPrimary"}]});EmailAddress.prototype.getNormalizedHashKey=function(){return this.getNormalizedValue()};EmailAddress.prototype.getNormalizedValue=function(){return EmailAddress.normalizeEmail(this.getValue())};
EmailAddress.normalizeEmail=function(str){if(!str||!_.isString(str))str="";return str.toLowerCase().trim()};EmailAddress.prototype.getDisplayValue=function(){return this.getValue()};EmailAddress.prototype.__defineGetter__("x_displayValue",function(){return this.getDisplayValue()});EmailAddress.prototype.getDisplayType=function(){return EmailAddress.getDisplayType(this.getType())};EmailAddress.prototype.__defineGetter__("x_displayType",function(){return this.getDisplayType()});
EmailAddress.getDisplayType=function(type){return EmailAddress.Labels.getLabel(type)||EmailAddress.Labels.getLabel(EmailAddress.TYPE.OTHER)};EmailAddress.TYPE=Utils.defineConstants({HOME:"type_home",WORK:"type_work",OTHER:"type_other"});EmailAddress.Labels=Utils.createLabelFunctions([{value:EmailAddress.TYPE.HOME,displayValue:RB.$L("Home"),isPopupLabel:true},{value:EmailAddress.TYPE.WORK,displayValue:RB.$L("Work"),isPopupLabel:true},{value:EmailAddress.TYPE.OTHER,displayValue:RB.$L("Other"),isPopupLabel:true}]);var FavoritablePersonField={};FavoritablePersonField.data=[{dbFieldName:"favoriteData",defaultValue:{},setterName:"setFavoriteData",getterName:"getFavoriteData"}];
FavoritablePersonField.functions={addFavoriteData:function(applicationId,favoriteData){this.getFavoriteData()[applicationId]=favoriteData},hasFavoriteDataForAnyApp:function(){return _.keys(this.getFavoriteData()).length?true:false},getFavoriteDataForAppWithId:function(applicationId){return this.getFavoriteData()[applicationId]},removeFavoriteDefaultForAppWithId:function(applicationId){this.getFavoriteData()[applicationId]=undefined},removeAllFavoriteData:function(){this.setFavoriteData({})}};var FavoritableEmailAddress=PropertyBase.create({superClass:EmailAddress,data:FavoritablePersonField.data});FavoritableEmailAddress.prototype.addFavoriteData=FavoritablePersonField.functions.addFavoriteData;FavoritableEmailAddress.prototype.hasFavoriteDataForAnyApp=FavoritablePersonField.functions.hasFavoriteDataForAnyApp;FavoritableEmailAddress.prototype.getFavoriteDataForAppWithId=FavoritablePersonField.functions.getFavoriteDataForAppWithId;
FavoritableEmailAddress.prototype.removeFavoriteDefaultForAppWithId=FavoritablePersonField.functions.removeFavoriteDefaultForAppWithId;FavoritableEmailAddress.prototype.removeAllFavoriteData=FavoritablePersonField.functions.removeAllFavoriteData;var EmailAddressExtended=PropertyBase.create({superClass:FavoritableEmailAddress,data:[{dbFieldName:"value",defaultValue:"",setterName:"setValue",getterName:"getValue",beforeSet:function(value){this.doGenerateNormalizedValue=true;return value}},{dbFieldName:"normalizedValue",defaultValue:"",setterName:"setNormalizedValue",getterName:"getNormalizedValue",beforeGet:function(origNormalizedValue){var normalizedValue=origNormalizedValue,value=this.getValue();if(!value||this.doGenerateNormalizedValue){normalizedValue=
EmailAddress.normalizeEmail(value);this.setNormalizedValue(normalizedValue);this.doGenerateNormalizedValue=false}return normalizedValue}}]});EmailAddressExtended.prototype._extendedGetDBObject=function(dbObject){dbObject.normalizedValue=this.getNormalizedValue();return dbObject};var Favorite=PropertyBase.create({data:[{dbFieldName:"",defaultValue:false,setterName:"setValue",getterName:"getValue"}]});Favorite.prototype.equals=function(value){if(value instanceof Favorite)return this.getValue()===value.getValue();else return this.getValue()===value};var FavoriteBackup=exports.FavoriteBackup=Class.create({initialize:function(obj){if(!obj)obj={};var rawFavoriteBackup=obj,_data={_kind:FavoriteBackup.kind,_id:rawFavoriteBackup._id,_rev:rawFavoriteBackup._rev,_del:rawFavoriteBackup._del,contactBackupHash:Utils.lazyWrapper(ContactBackupHash,[rawFavoriteBackup.contactBackupHash,true]),defaultPropertyHashes:Utils.lazyWrapper(PropertyArray,[DefaultPropertyHash,rawFavoriteBackup.defaultPropertyHashes,true])};this.accessor=function(fieldName){var field=
_data[fieldName];Assert.requireDefined(fieldName,"fieldName must be specified for the accessor");if(field&&typeof field==="object"&&field.isLazyWrapper)field=_data[fieldName]=field.createInstance();return field};this.setId=function(id){_data._id=id};this.setRev=function(rev){_data._rev=rev};this.getDBObject=function(){return Utils.getDBObjectForAllProperties(this.accessor,_.keys(_data))}},getId:function(){return this.accessor("_id")},getKind:function(){return this.accessor("_kind")},getContactBackupHash:function(){return this.accessor("contactBackupHash")},
getContactBackupHashContactId:function(){var backupHash=this.getContactBackupHash().getValue();return Contact.getIdFromLinkHash(backupHash)},getDefaultPropertyHashes:function(){return this.accessor("defaultPropertyHashes")},getDefaultsForContactPointType:function(contactPointType){var propertyHashes=this.getDefaultPropertyHashes().getArray(),i,tempProperty,toReturn=[];for(i=0;i<propertyHashes.length;i+=1){tempProperty=propertyHashes[i];if(tempProperty.getType()===contactPointType)toReturn.push(tempProperty)}return toReturn},
setDefaultForContactPointType:function(value,contactPointType,favoriteData){var propertyHashes=this.getDefaultPropertyHashes(),propertyHashesArray=propertyHashes.getArray(),i,tempProperty,foundEntry=false;for(i=0;i<propertyHashesArray.length;i+=1){tempProperty=propertyHashesArray[i];if(tempProperty.getType()===contactPointType&&tempProperty.isPlainValueEqual(value)){foundEntry=true;tempProperty.setFavoriteData(favoriteData);break}else if(tempProperty.getType()===contactPointType&&tempProperty.isPlainValueEqual(null)){foundEntry=
true;tempProperty.setFavoriteData(favoriteData);tempProperty.setType(contactPointType);tempProperty.setPlainValue(value);break}}if(!foundEntry){tempProperty=new DefaultPropertyHash;tempProperty.setPlainValue(value);tempProperty.setType(contactPointType);tempProperty.setFavoriteData(favoriteData);propertyHashes.add(tempProperty)}return true},deleteFavoriteBackup:function(){var id=this.getId();Assert.requireDefined(id,"deleteFavoriteBackup unable to delete, there is no _id param");return DB.del([id])},
save:function(){return DB.put([this.getDBObject()]).then(this,function(future){var result=Utils.DBResultHelper(future.result);Assert.require(result,"FavoriteBackup save put - result is null");Assert.requireArray(result,"FavoriteBackup save");Assert.require(result.length,"FavoriteBackup save put - result length is zero");this.setId(result[0].id);this.setRev(result[0].rev);future.result=true})},toString:function(){return JSON.stringify(this.getDBObject())}});FavoriteBackup.kind="com.palm.person.favoritebackup:1";
FavoriteBackup.getBackupForContact=function(contact){Assert.require(contact,"FavoriteBackup.getBackupForContact requires a contact");var future=new Future;future.now(function(){return ContactLinkable.getLinkHash(contact)});future.then(function(){var result=future.result.linkHash;return FavoriteBackup.getBackupForLinkhash(result)});return future};
FavoriteBackup.getBackupForLinkhash=function(linkHash){var future=new Future;future.now(function(){return DB.find({from:FavoriteBackup.kind,where:[{prop:"contactBackupHash",op:"=",val:linkHash}]})});future.then(function(){var result=Utils.DBResultHelper(future.result);if(result&&result[0])future.result=new FavoriteBackup(result[0]);else future.result=undefined});return future};
FavoriteBackup.removeBackupForContact=function(contact){Assert.require(contact,"FavoriteBackup.removeBackupForContact requires a contact");var future=new Future;future.now(function(){return ContactLinkable.getLinkHash(contact)});future.then(function(){var contactHash=future.result.linkHash,query={from:FavoriteBackup.kind,where:[{prop:"contactBackupHash",op:"=",val:contactHash}]};return DB.del(query)});future.then(function(){var result=Utils.DBResultHelper(future.result);return result&&result.count>
0});return future};var Gender=PropertyBase.create({data:[{dbFieldName:"",defaultValue:"",setterName:"setValue",getterName:"getValue"}]});var IMAddress=exports.IMAddress=PropertyBase.create({data:[{dbFieldName:"value",defaultValue:"",setterName:"setValue",getterName:"getValue"},{dbFieldName:"type",defaultValue:"",setterName:"setType",getterName:"getType"},{dbFieldName:"label",defaultValue:"",setterName:"setLabel",getterName:"getLabel"},{dbFieldName:"primary",defaultValue:false,setterName:"setPrimary",getterName:"getPrimary"}]});IMAddress.prototype.getNormalizedHashKey=function(){return this.getNormalizedValue()+":(|)"+this.getType()};
IMAddress.prototype.getDisplayValue=function(){return this.getValue()};IMAddress.normalizeIm=function(str){if(!str||!_.isString(str))str="";return str.toLowerCase().trim()};IMAddress.prototype.getNormalizedValue=function(){return IMAddress.normalizeIm(this.getValue())};IMAddress.prototype.__defineGetter__("x_displayValue",function(){return this.getDisplayValue()});IMAddress.prototype.getDisplayType=function(){return IMAddress.getDisplayType(this.getType())};
IMAddress.prototype.__defineGetter__("x_displayType",function(){return this.getDisplayType()});IMAddress.getDisplayType=function(type){return IMAddress.Labels.getLabel(type)||IMAddress.Labels.getLabel(IMAddress.TYPE.DEFAULT)};IMAddress.STATUS=Utils.defineConstants({ONLINE:0,BUSY:2,OFFLINE:4,NO_PRESENCE:6});
IMAddress.TYPE=Utils.defineConstants({AIM:"type_aim",YAHOO:"type_yahoo",GTALK:"type_gtalk",MSN:"type_msn",JABBER:"type_jabber",ICQ:"type_icq",IRC:"type_irc",QQ:"type_qq",SKYPE:"type_skype",YJP:"type_yjp",LCS:"type_lcs",DOTMAC:"type_dotmac",FACEBOOK:"type_facebook",MYSPACE:"type_myspace",GADUGADU:"type_gadugadu",DEFAULT:"type_default"});IMAddress.LABEL=Utils.defineConstants({HOME:"label_home",WORK:"label_work",OTHER:"label_other"});
IMAddress.Labels=Utils.createLabelFunctions([{value:IMAddress.TYPE.AIM,displayValue:RB.$L("AIM"),isPopupLabel:true},{value:IMAddress.TYPE.GTALK,displayValue:RB.$L("GTalk"),isPopupLabel:true},{value:IMAddress.TYPE.YAHOO,displayValue:RB.$L("Yahoo!"),isPopupLabel:true},{value:IMAddress.TYPE.SKYPE,displayValue:RB.$L("Skype"),isPopupLabel:true},{value:IMAddress.TYPE.MSN,displayValue:RB.$L("Messenger"),isPopupLabel:true},{value:IMAddress.TYPE.JABBER,displayValue:RB.$L("Jabber"),isPopupLabel:true},{value:IMAddress.TYPE.ICQ,
displayValue:RB.$L("ICQ"),isPopupLabel:true},{value:IMAddress.TYPE.IRC,displayValue:RB.$L("IRC"),isPopupLabel:true},{value:IMAddress.TYPE.QQ,displayValue:RB.$L("QQ"),isPopupLabel:true},{value:IMAddress.TYPE.YJP,displayValue:RB.$L("Y! Japan"),isPopupLabel:true},{value:IMAddress.TYPE.LCS,displayValue:RB.$L("LCS"),isPopupLabel:true},{value:IMAddress.TYPE.DOTMAC,displayValue:RB.$L(".Mac"),isPopupLabel:true},{value:IMAddress.TYPE.FACEBOOK,displayValue:RB.$L("Facebook"),isPopupLabel:true},{value:IMAddress.TYPE.MYSPACE,
displayValue:RB.$L("MySpace"),isPopupLabel:true},{value:IMAddress.TYPE.GADUGADU,displayValue:RB.$L("GaduGadu"),isPopupLabel:true},{value:IMAddress.TYPE.DEFAULT,displayValue:RB.$L("IM"),isPopupLabel:false}],true);var FavoritableIMAddress=PropertyBase.create({superClass:IMAddress,data:FavoritablePersonField.data});FavoritableIMAddress.prototype.addFavoriteData=FavoritablePersonField.functions.addFavoriteData;FavoritableIMAddress.prototype.hasFavoriteDataForAnyApp=FavoritablePersonField.functions.hasFavoriteDataForAnyApp;FavoritableIMAddress.prototype.getFavoriteDataForAppWithId=FavoritablePersonField.functions.getFavoriteDataForAppWithId;FavoritableIMAddress.prototype.removeFavoriteDefaultForAppWithId=FavoritablePersonField.functions.removeFavoriteDefaultForAppWithId;
FavoritableIMAddress.prototype.removeAllFavoriteData=FavoritablePersonField.functions.removeAllFavoriteData;var IMAddressExtended=PropertyBase.create({superClass:FavoritableIMAddress,data:[{dbFieldName:"value",defaultValue:"",setterName:"setValue",getterName:"getValue",beforeSet:function(value){this.doGenerateNormalizedValue=true;return value}},{dbFieldName:"normalizedValue",defaultValue:"",setterName:"setNormalizedValue",getterName:"getNormalizedValue",beforeGet:function(origNormalizedValue){var normalizedValue=origNormalizedValue,value=this.getValue();if(!value||this.doGenerateNormalizedValue){normalizedValue=
IMAddress.normalizeIm(value);this.setNormalizedValue(normalizedValue);this.doGenerateNormalizedValue=false}return normalizedValue}}]});IMAddressExtended.prototype._extendedGetDBObject=function(dbObject){dbObject.normalizedValue=this.getNormalizedValue();return dbObject};var LauncherId=exports.LauncherId=PropertyBase.create({data:[{dbFieldName:"",defaultValue:"",setterName:"setValue",getterName:"getValue"}]});var Name=exports.Name=PropertyBase.create({data:[{dbFieldName:"givenName",defaultValue:"",setterName:"setGivenName",getterName:"getGivenName"},{dbFieldName:"middleName",defaultValue:"",setterName:"setMiddleName",getterName:"getMiddleName"},{dbFieldName:"familyName",defaultValue:"",setterName:"setFamilyName",getterName:"getFamilyName"},{dbFieldName:"honorificPrefix",defaultValue:"",setterName:"setHonorificPrefix",getterName:"getHonorificPrefix"},{dbFieldName:"honorificSuffix",defaultValue:"",setterName:"setHonorificSuffix",
getterName:"getHonorificSuffix"}]});Name.prototype.getNormalizedHashKey=function(){return this.getNormalizedGivenName()+":(|)"+this.getNormalizedFamilyName()};Name.prototype.getNormalizedGivenName=function(){return Name.normalizeName(this.getGivenName())};Name.prototype.getNormalizedMiddleName=function(){return Name.normalizeName(this.getMiddleName())};Name.prototype.getNormalizedFamilyName=function(){return Name.normalizeName(this.getFamilyName())};
Name.prototype.getNormalizedHonorificPrefixName=function(){return Name.normalizeName(this.getHonorificPrefix())};Name.prototype.getNormalizedHonorificSuffixName=function(){return Name.normalizeName(this.getHonorificSuffix())};Name.normalizeName=function(str){if(!str||!_.isString(str))str="";return str.toLowerCase().trim()};
Name.prototype.set=function(nameObj){Assert.requireClass(nameObj,Name,"this.set requires an argument of type Name");this.setFamilyName(nameObj.getFamilyName()||"");this.setGivenName(nameObj.getGivenName()||"");this.setMiddleName(nameObj.getMiddleName()||"");this.setHonorificPrefix(nameObj.getHonorificPrefix()||"");this.setHonorificSuffix(nameObj.getHonorificSuffix()||"")};
Name.prototype.getFullName=function(doNotStrip){return Globalization.Name.formatPersonalName({prefix:this.getHonorificPrefix(),givenName:this.getGivenName(),middleName:this.getMiddleName(),familyName:this.getFamilyName(),suffix:this.getHonorificSuffix()},Globalization.Name.longName)};
Name.prototype.parseName=function(freeformName){var structuredName=Globalization.Name.parsePersonalName(freeformName);this.setFamilyName(structuredName.familyName||"");this.setGivenName(structuredName.givenName||"");this.setMiddleName(structuredName.middleName||"");this.setHonorificPrefix(structuredName.prefix||"");this.setHonorificSuffix(structuredName.suffix||"")};Name.prototype.clear=function(){this.setFamilyName("");this.setGivenName("");this.setMiddleName("");this.setHonorificPrefix("");this.setHonorificSuffix("")};
Name.prototype.__defineGetter__("x_fullName",function(){return this.getFullName()});Name.prototype.__defineSetter__("x_fullName",function(value){this.parseName(value)});Name.getFullNameFromRawObject=function(rawName,doNotStrip){return Globalization.Name.formatPersonalName({prefix:rawName.honorificPrefix,givenName:rawName.givenName,middleName:rawName.middleName,familyName:rawName.familyName,suffix:rawName.honorificSuffix},Globalization.Name.longName)};var Nickname=PropertyBase.create({data:[{dbFieldName:"",defaultValue:"",setterName:"setValue",getterName:"getValue"}]});Nickname.prototype.getDisplayValue=function(){return this.getValue()};Nickname.prototype.__defineGetter__("x_displayValue",function(){return this.getDisplayValue()});var Note=PropertyBase.create({data:[{dbFieldName:"",defaultValue:"",setterName:"setValue",getterName:"getValue"}]});Note.prototype.getNormalizedHashKey=function(){var toReturn=this.getValue();return toReturn.toUpperCase()};Note.prototype.getDisplayValue=function(){var temp=this.getValue();temp=Foundations.StringUtils.escapeHTML(temp);temp=temp.replace(/\n/g,"<br>");return temp};Note.prototype.__defineGetter__("x_displayValue",function(){return this.getDisplayValue()});var Organization=exports.Organization=PropertyBase.create({data:[{dbFieldName:"name",defaultValue:"",setterName:"setName",getterName:"getName"},{dbFieldName:"department",defaultValue:"",setterName:"setDepartment",getterName:"getDepartment"},{dbFieldName:"title",defaultValue:"",setterName:"setTitle",getterName:"getTitle"},{dbFieldName:"type",defaultValue:"",setterName:"setType",getterName:"getType"},{dbFieldName:"startDate",defaultValue:"",setterName:"setStartDate",getterName:"getStartDate"},{dbFieldName:"endDate",
defaultValue:"",setterName:"setEndDate",getterName:"getEndDate"},{dbFieldName:"location",defaultValue:{},setterName:"setLocation",getterName:"getLocation",classObject:Address},{dbFieldName:"description",defaultValue:"",setterName:"setDescription",getterName:"getDescription"}]});
Organization.prototype._extendedGetDBObject=function(data){var address=this.getLocation(),newData=_.clone(data);if(address&&address.getDBObject)newData.location=address.getDBObject();else console.warn("Organization: address does not appear to be a correct wrapped object.  Unable to call getDBObject()");return newData};Organization.TYPE=Utils.defineConstants({HOME:"type_home",WORK:"type_work",SCHOOL:"type_school",OTHER:"type_other"});
Organization.Labels=Utils.createLabelFunctions([{value:Organization.TYPE.HOME,displayValue:RB.$L("Home"),isPopupLabel:true},{value:Organization.TYPE.WORK,displayValue:RB.$L("Work"),isPopupLabel:true},{value:Organization.TYPE.SCHOOL,displayValue:RB.$L("School"),isPopupLabel:true},{value:Organization.TYPE.OTHER,displayValue:RB.$L("Other"),isPopupLabel:true}]);var PhoneNumber=exports.PhoneNumber=PropertyBase.create({data:[{dbFieldName:"value",defaultValue:"",setterName:"setValue",getterName:"getValue"},{dbFieldName:"type",defaultValue:"",setterName:"setType",getterName:"getType"},{dbFieldName:"primary",defaultValue:false,setterName:"setPrimary",getterName:"getPrimary"}]});
PhoneNumber.prototype.equals=function(obj){if(obj instanceof PhoneNumber)return this.getValue()===obj.getValue()&&this.getType()===obj.getType()&&this.getPrimary()===obj.getPrimary();return false};PhoneNumber.prototype.getNormalizedHashKey=function(){return this.getNormalizedValue()};PhoneNumber.prototype.getNormalizedValue=function(){return PhoneNumber.normalizePhoneNumber(this.getValue())};PhoneNumber.prototype.getDisplayValue=function(){return PhoneNumber.format(this.getValue())};
PhoneNumber.prototype.__defineGetter__("x_displayValue",function(){return this.getDisplayValue()});PhoneNumber.prototype.getDisplayType=function(){return PhoneNumber.getDisplayType(this.getType())};PhoneNumber.prototype.__defineGetter__("x_displayType",function(){return this.getDisplayType()});
PhoneNumber.normalizePhoneNumber=function(numberParam,wantSearchFormat){var numberParamType=ObjectUtils.type(numberParam),parsedPhoneNumber,normalizedValue;Assert.require(numberParamType==="object"||numberParamType==="string","PhoneNumber.normalizePhoneNumber - number passed is not a string or an object");parsedPhoneNumber=numberParamType==="string"?Globalization.Phone.parsePhoneNumber(numberParam):numberParam;if(!parsedPhoneNumber||Object.keys(parsedPhoneNumber).length===0)return"";normalizedValue=
"";if(parsedPhoneNumber.extension)normalizedValue+=parsedPhoneNumber.extension.split("").reverse().join("");normalizedValue+=PhoneNumber.PART_DELIMITER;if(parsedPhoneNumber.subscriberNumber)normalizedValue+=parsedPhoneNumber.subscriberNumber.split("").reverse().join("");else if(parsedPhoneNumber.serviceCode)normalizedValue+=parsedPhoneNumber.serviceCode.split("").reverse().join("");else if(parsedPhoneNumber.emergency)normalizedValue+=parsedPhoneNumber.emergency.split("").reverse().join("");else if(parsedPhoneNumber.vsc)normalizedValue+=
parsedPhoneNumber.vsc.split("").reverse().join("");normalizedValue+=PhoneNumber.PART_DELIMITER;if(!wantSearchFormat){if(parsedPhoneNumber.areaCode)normalizedValue+=parsedPhoneNumber.areaCode.split("").reverse().join("");normalizedValue+=PhoneNumber.PART_DELIMITER;if(parsedPhoneNumber.countryCode)normalizedValue+=parsedPhoneNumber.countryCode.split("").reverse().join("");normalizedValue+=PhoneNumber.PART_DELIMITER;if(parsedPhoneNumber.iddPrefix)normalizedValue+=parsedPhoneNumber.iddPrefix.split("").reverse().join("")}return normalizedValue};
PhoneNumber.strip=function(numberStr){if(!numberStr){console.warn("PhoneNumber.strip - empty argument");return numberStr}if(typeof numberStr==="number")numberStr=""+numberStr;return numberStr.replace(/-*\(*\)*\**#*\/*\.*\s*/g,"")};PhoneNumber.format=function(numberStr){if(!numberStr){console.warn("PhoneNumber.format - empty argument");return numberStr}return Globalization.Phone.reformat(numberStr)};
PhoneNumber.unformatForVCard=function(numberStr){var toReturn="";numberStr.replace(/[0123456789\+\*wpt#]/gi,function(substr){toReturn+=substr});return toReturn};PhoneNumber.getDisplayType=function(type){return PhoneNumber.Labels.getLabel(type)||PhoneNumber.Labels.getLabel(PhoneNumber.TYPE.MOBILE)};PhoneNumber.PART_DELIMITER="-";
PhoneNumber.TYPE=Utils.defineConstants({MOBILE:"type_mobile",HOME:"type_home",HOME2:"type_home2",WORK:"type_work",WORK2:"type_work2",MAIN:"type_main",PERSONAL_FAX:"type_personal_fax",WORK_FAX:"type_work_fax",PAGER:"type_pager",PERSONAL:"type_personal",SIM:"type_sim",ASSISTANT:"type_assistant",CAR:"type_car",RADIO:"type_radio",COMPANY:"type_company",OTHER:"type_other"});
PhoneNumber.Labels=Utils.createLabelFunctions([{value:PhoneNumber.TYPE.MOBILE,displayValue:RB.$L("Mobile"),shortDisplayValue:RB.$L("M"),isPopupLabel:true},{value:PhoneNumber.TYPE.HOME,displayValue:RB.$L("Home"),shortDisplayValue:RB.$L("H"),isPopupLabel:true},{value:PhoneNumber.TYPE.WORK,displayValue:RB.$L("Work"),shortDisplayValue:RB.$L("W"),isPopupLabel:true},{value:PhoneNumber.TYPE.WORK_FAX,displayValue:RB.$L("Fax"),shortDisplayValue:RB.$L("F"),isPopupLabel:true},{value:PhoneNumber.TYPE.OTHER,displayValue:RB.$L("Other"),
shortDisplayValue:RB.$L("O"),isPopupLabel:true},{value:PhoneNumber.TYPE.PAGER,displayValue:RB.$L("Pager"),shortDisplayValue:RB.$L("P"),isPopupLabel:false},{value:PhoneNumber.TYPE.PERSONAL,displayValue:RB.$L("Personal"),shortDisplayValue:RB.$L("Pe"),isPopupLabel:false},{value:PhoneNumber.TYPE.SIM,displayValue:RB.$L("SIM"),shortDisplayValue:RB.$L("S"),isPopupLabel:false},{value:PhoneNumber.TYPE.MAIN,displayValue:RB.$L("Main"),shortDisplayValue:RB.$L("Ma"),isPopupLabel:false},{value:PhoneNumber.TYPE.PERSONAL_FAX,
displayValue:RB.$L("Fax"),shortDisplayValue:RB.$L("P"),isPopupLabel:false},{value:PhoneNumber.TYPE.ASSISTANT,displayValue:RB.$L("Assistant"),shortDisplayValue:RB.$L("A"),isPopupLabel:false},{value:PhoneNumber.TYPE.CAR,displayValue:RB.$L("Car"),shortDisplayValue:RB.$L("Ca"),isPopupLabel:false},{value:PhoneNumber.TYPE.RADIO,displayValue:RB.$L("Radio"),shortDisplayValue:RB.$L("R"),isPopupLabel:false},{value:PhoneNumber.TYPE.COMPANY,displayValue:RB.$L("Company"),shortDisplayValue:RB.$L("C"),isPopupLabel:false},
{value:PhoneNumber.TYPE.WORK2,displayValue:RB.$L("Work 2"),shortDisplayValue:RB.$L("W2"),isPopupLabel:false},{value:PhoneNumber.TYPE.HOME2,displayValue:RB.$L("Home 2"),shortDisplayValue:RB.$L("H2"),isPopupLabel:false}]);var FavoritablePhoneNumber=PropertyBase.create({superClass:PhoneNumber,data:FavoritablePersonField.data});FavoritablePhoneNumber.prototype.addFavoriteData=FavoritablePersonField.functions.addFavoriteData;FavoritablePhoneNumber.prototype.hasFavoriteDataForAnyApp=FavoritablePersonField.functions.hasFavoriteDataForAnyApp;FavoritablePhoneNumber.prototype.getFavoriteDataForAppWithId=FavoritablePersonField.functions.getFavoriteDataForAppWithId;
FavoritablePhoneNumber.prototype.removeFavoriteDefaultForAppWithId=FavoritablePersonField.functions.removeFavoriteDefaultForAppWithId;FavoritablePhoneNumber.prototype.removeAllFavoriteData=FavoritablePersonField.functions.removeAllFavoriteData;var PersonPhotos=exports.PersonPhotos=PropertyBase.create({data:[{dbFieldName:"bigPhotoPath",defaultValue:"",setterName:"setBigPhotoPath",getterName:"getBigPhotoPath"},{dbFieldName:"squarePhotoPath",defaultValue:"",setterName:"setSquarePhotoPath",getterName:"getSquarePhotoPath"},{dbFieldName:"listPhotoPath",defaultValue:"",setterName:"setListPhotoPath",getterName:"getListPhotoPath"},{dbFieldName:"listPhotoSource",defaultValue:"",setterName:"setListPhotoSource",getterName:"getListPhotoSource"},{dbFieldName:"bigPhotoId",
defaultValue:"",setterName:"setBigPhotoId",getterName:"getBigPhotoId"},{dbFieldName:"squarePhotoId",defaultValue:"",setterName:"setSquarePhotoId",getterName:"getSquarePhotoId"},{dbFieldName:"contactId",defaultValue:"",setterName:"setContactId",getterName:"getContactId"},{dbFieldName:"accountId",defaultValue:"",setterName:"setAccountId",getterName:"getAccountId"}]});
PersonPhotos.prototype.getListPhotoSourcePath=function(){return this.getListPhotoSource()===PersonPhotos.TYPE.BIG?this.getBigPhotoPath():this.getSquarePhotoPath()};PersonPhotos.prototype.getListPhotoSourceId=function(){return this.getListPhotoSource()===PersonPhotos.TYPE.BIG?this.getBigPhotoId():this.getSquarePhotoId()};PersonPhotos.prototype.getPhotoPath=function(photoType,disallowOtherTypes){return PersonPhotos.getPhotoPath(this.getDBObject(),photoType,disallowOtherTypes)};
PersonPhotos.getPhotoPath=function(rawPersonPhotos,photoType,disallowOtherTypes){var future=new Future,filePathToReturn;future.now(function(){var fileType,savePathFuture,filePath;photoType=photoType||PersonPhotos.TYPE.SQUARE;Assert.requireObject(rawPersonPhotos,"PersonPhotos.getPhotoPath requires an object for the rawPersonPhotos argument");Assert.requireString(photoType,"You must pass a valid photoType");Assert.require(photoType===PersonPhotos.TYPE.BIG||photoType===PersonPhotos.TYPE.SQUARE||photoType===
PersonPhotos.TYPE.LIST,"You must pass a valid photoType");if(rawPersonPhotos.bigPhotoPath===""&&rawPersonPhotos.squarePhotoPath===""&&rawPersonPhotos.listPhotoPath===""){future.result="";return}if(!disallowOtherTypes){fileType=_.detect(PersonPhotos.TYPE_SIMILARITIES[photoType],function(similarPhotoType){var sptFilePath=PersonPhotos.getPhotoPathFromType(rawPersonPhotos,similarPhotoType);return PersonPhotos.fileExists(sptFilePath)});if(fileType)filePath=PersonPhotos.getPhotoPathFromType(rawPersonPhotos,
fileType);if(filePath){future.result=filePath;return}else{future.nest(PersonPhotos._refetchPhoto(photoType,rawPersonPhotos.accountId,rawPersonPhotos.contactId,PersonPhotos._getPhotoIdToRefetch(rawPersonPhotos,photoType)));return}}else{filePath=PersonPhotos.getPhotoPathFromType(rawPersonPhotos,photoType);if(PersonPhotos.fileExists(filePath)){future.result=filePath;return}else{if(photoType===PersonPhotos.TYPE.LIST){filePath=rawPersonPhotos.squarePhotoPath;if(!filePath||!PersonPhotos.fileExists(filePath)){filePath=
rawPersonPhotos.bigPhotoPath;if(!filePath||!PersonPhotos.fileExists(filePath))filePath=""}if(filePath){savePathFuture=ContactPhoto.cropAndGetPath(filePath,{},PersonPhotos.TYPE.LIST);savePathFuture.then(function(){rawPersonPhotos.listPhotoPath=savePathFuture.result;return Person.findByContactIds([rawPersonPhotos.contactId])});savePathFuture.then(function(){var person=savePathFuture.result;person.getPhotos().reinitialize(rawPersonPhotos);person.save()});return savePathFuture}}future.nest(PersonPhotos._refetchPhoto(photoType,
rawPersonPhotos.accountId,rawPersonPhotos.contactId,PersonPhotos._getPhotoIdToRefetch(rawPersonPhotos,photoType)));return}}});future.then(function(){filePathToReturn=future.result;if(filePathToReturn){var innerFuture=PalmCall.call("palm://com.palm.filecache","TouchCacheObject",{pathName:filePathToReturn});innerFuture.onError(function(){console.warn("Ignoring error while touching filecache object.  The filepath we tried to touch: "+Utils.stringify(filePathToReturn));future.result=true});future.nest(innerFuture)}else future.result=
true});future.then(function(){var dummy=future.result;future.result=filePathToReturn||PersonPhotos.getDefaultPhotoPathFromType(photoType)});return future};
PersonPhotos.getPhotoPathFromType=function(rawPersonPhotos,photoType){Assert.requireObject(rawPersonPhotos,"PersonPhotos.getPhotoPathFromType requires an object for the rawPersonPhotos argument");Assert.requireString(photoType,"PersonPhotos.getPhotoPathFromType requires a string for the photoType argument");Assert.require(photoType===PersonPhotos.TYPE.BIG||photoType===PersonPhotos.TYPE.SQUARE||photoType===PersonPhotos.TYPE.LIST,"PersonPhotos.getPhotoPathFromType requires either PersonPhotos.TYPE.SQUARE, PersonPhotos.TYPE.BIG, or PersonPhotos.TYPE.LIST for the photoType argument");
switch(photoType){case PersonPhotos.TYPE.BIG:return rawPersonPhotos.bigPhotoPath;case PersonPhotos.TYPE.SQUARE:return rawPersonPhotos.squarePhotoPath;case PersonPhotos.TYPE.LIST:return rawPersonPhotos.listPhotoPath}};
PersonPhotos.getDefaultPhotoPathFromType=function(photoType){Assert.requireString(photoType,"PersonPhotos.getDefaultPhotoPathFromType requires a string for the photoType argument");Assert.require(photoType===PersonPhotos.TYPE.BIG||photoType===PersonPhotos.TYPE.SQUARE||photoType===PersonPhotos.TYPE.LIST,"PersonPhotos.getDefaultPhotoPathFromType requires either PersonPhotos.TYPE.SQUARE, PersonPhotos.TYPE.BIG, or PersonPhotos.TYPE.LIST for the photoType argument");switch(photoType){case PersonPhotos.TYPE.BIG:return PersonPhotos.DEFAULT_DETAILS_AVATAR;
case PersonPhotos.TYPE.SQUARE:return PersonPhotos.DEFAULT_DETAILS_AVATAR;case PersonPhotos.TYPE.LIST:return PersonPhotos.DEFAULT_LIST_AVATAR}};
PersonPhotos._getPhotoIdToRefetch=function(rawPersonPhotos,photoType){Assert.requireObject(rawPersonPhotos,"PersonPhotos._getPhotoIdToRefetch requires an object for the rawPersonPhotos argument");Assert.requireString(photoType,"PersonPhotos._getPhotoIdToRefetch requires a string for the photoType argument");Assert.require(photoType===PersonPhotos.TYPE.BIG||photoType===PersonPhotos.TYPE.SQUARE||photoType===PersonPhotos.TYPE.LIST,"PersonPhotos._getPhotoIdToRefetch requires either PersonPhotos.TYPE.SQUARE, PersonPhotos.TYPE.BIG, or PersonPhotos.TYPE.LIST for the photoType argument");
switch(photoType){case PersonPhotos.TYPE.BIG:return rawPersonPhotos.bigPhotoId;case PersonPhotos.TYPE.SQUARE:return rawPersonPhotos.squarePhotoId;case PersonPhotos.TYPE.LIST:return rawPersonPhotos.listPhotoSource===PersonPhotos.TYPE.BIG?rawPersonPhotos.bigPhotoId:rawPersonPhotos.squarePhotoId}};PersonPhotos.fileExists=function(filePath){Assert.requireString(filePath,"PersonPhotos.fileExists requires a string for the filePath argument");try{if(!palmGetResource(filePath))return false;return true}catch(ex){return false}};
PersonPhotos._refetchPhoto=function(photoType,accountId,contactId,photoId){var future=new Future;future.now(function(){Assert.requireString(photoType,"PersonPhotos._refetchPhoto requires a string for the photoType argument");Assert.require(photoType===PersonPhotos.TYPE.BIG||photoType===PersonPhotos.TYPE.SQUARE||photoType===PersonPhotos.TYPE.LIST,"PersonPhotos._refetchPhoto requires either PersonPhotos.TYPE.SQUARE, PersonPhotos.TYPE.BIG, or PersonPhotos.TYPE.LIST for the photoType argument");Assert.requireString(accountId,
"PersonPhotos._refetchPhoto requires a string for the accountId argument");Assert.requireString(contactId,"PersonPhotos._refetchPhoto requires a string for the contactId argument");Assert.requireString(photoId,"PersonPhotos._refetchPhoto requires a string for the photoId argument");future.nest(PalmCall.call("palm://com.palm.service.accounts","getAccountInfo",{accountId:accountId}))});future.then(function(){var result=future.result,account,contactsCapability;if(result&&result.returnValue){account=
result.result;contactsCapability=Utils.getContactsCapabilityProvider(account);if(contactsCapability&&contactsCapability.refetchPhoto)future.nest(PalmCall.call(contactsCapability.refetchPhoto,"",{accountId:accountId,contactId:contactId,photoId:photoId}));else future.result=""}else future.result=""});future.then(function(){var result=future.result;if(result&&result.returnValue)future.result=result.localPath;else future.result=""});return future};
Utils.defineConstant("DEFAULT_LIST_AVATAR",LIB_ROOT+"images/generic-avatar-50x50.png",PersonPhotos);Utils.defineConstant("DEFAULT_DETAILS_AVATAR",LIB_ROOT+"images/generic-avatar-50x50.png",PersonPhotos);Utils.defineConstant("LIST_PHOTO_WIDTH",50,PersonPhotos);Utils.defineConstant("LIST_PHOTO_HEIGHT",50,PersonPhotos);Utils.defineConstant("PHOTO_FILETYPE","jpg",PersonPhotos);Utils.defineConstant("LIST_PHOTO_FILECACHE_SIZE",8192,PersonPhotos);Utils.defineConstant("BIG_PHOTO_WIDTH",320,PersonPhotos);
Utils.defineConstant("BIG_PHOTO_HEIGHT",480,PersonPhotos);Utils.defineConstant("BIG_PHOTO_FILECACHE_SIZE",15E4,PersonPhotos);PersonPhotos.TYPE=Utils.defineConstants({BIG:"type_big",SQUARE:"type_square",LIST:"type_list"});
PersonPhotos.TYPE_SIMILARITIES=function(){var typeSimilarities={};typeSimilarities[PersonPhotos.TYPE.BIG]=[PersonPhotos.TYPE.BIG,PersonPhotos.TYPE.SQUARE,PersonPhotos.TYPE.LIST];typeSimilarities[PersonPhotos.TYPE.SQUARE]=[PersonPhotos.TYPE.SQUARE,PersonPhotos.TYPE.LIST,PersonPhotos.TYPE.BIG];typeSimilarities[PersonPhotos.TYPE.LIST]=[PersonPhotos.TYPE.LIST,PersonPhotos.TYPE.SQUARE,PersonPhotos.TYPE.BIG];return typeSimilarities}();var ContactPhoto=exports.ContactPhoto=PropertyBase.create({data:[{dbFieldName:"value",defaultValue:"",setterName:"setValue",getterName:"getValue"},{dbFieldName:"type",defaultValue:"type_square",setterName:"setType",getterName:"getType"},{dbFieldName:"primary",defaultValue:false,setterName:"setPrimary",getterName:"getPrimary"},{dbFieldName:"localPath",defaultValue:"",setterName:"setLocalPath",getterName:"getLocalPath"}]});ContactPhoto.prototype.getId=function(){return this.getDBObject()._id};
ContactPhoto.getPhotoPath=function(contact,photoType){var future=new Future;future.now(function(){var drawerPhotoPath,drawerPhotoId,photosArray,squarePhoto;photoType=photoType||ContactPhoto.TYPE.SQUARE;Assert.requireString(photoType,"ContactPhoto.attachPhotoPathsToContacts requires a string for the photoType argument");Assert.require(photoType===ContactPhoto.TYPE.BIG||photoType===ContactPhoto.TYPE.SQUARE,"ContactPhoto.attachPhotoPathsToContacts requires either ContactPhoto.TYPE.SQUARE or ContactPhoto.TYPE.BIG for the photoType argument");
if(contact.getPhotos()&&contact.getPhotos().getArray()){photosArray=contact.getPhotos().getArray();if(photosArray&&_.isArray(photosArray)){squarePhoto=_.detect(photosArray,function(photo){return photo.getType()===photoType});squarePhoto=squarePhoto||photosArray[0];if(squarePhoto){drawerPhotoPath=squarePhoto.getLocalPath();drawerPhotoId=squarePhoto.getId()}}}if(drawerPhotoPath)if(PersonPhotos.fileExists(drawerPhotoPath)){future.result=drawerPhotoPath;return}else{future.nest(PersonPhotos._refetchPhoto(photoType,
contact.getAccountId().getValue(),contact.getId(),drawerPhotoId));return}else{future.result=ContactPhoto.DEFAULT_DRAWER_PHOTO;return}});return future};
ContactPhoto.attachPhotoPathsToContacts=function(contacts,photoType,fieldName){var future=Foundations.Control.mapReduce({map:function(contact){var future=new Future;future.now(function(){photoType=photoType||ContactPhoto.TYPE.SQUARE;Assert.requireString(photoType,"ContactPhoto.attachPhotoPathsToContacts requires a string for the photoType argument");Assert.require(photoType===ContactPhoto.TYPE.BIG||photoType===ContactPhoto.TYPE.SQUARE,"ContactPhoto.attachPhotoPathsToContacts requires either ContactPhoto.TYPE.SQUARE or ContactPhoto.TYPE.BIG for the photoType argument");
fieldName=fieldName||"drawerPhotoPath";Assert.requireString(fieldName,"ContactPhoto.attachPhotoPathsToContacts requires a string for the fieldName argument");future.nest(ContactPhoto.getPhotoPath(contact,photoType))});future.then(function(){contact[fieldName]=future.result;future.result=true});return future}},contacts);return future};
ContactPhoto.cropAndGetPathToMediaInternal=function(fromPath,cropInfo,type,timingRecorderParam){var destWidth=PersonPhotos.LIST_PHOTO_WIDTH,cropWidth=PersonPhotos.LIST_PHOTO_WIDTH,cropHeight=PersonPhotos.LIST_PHOTO_HEIGHT,size=PersonPhotos.LIST_PHOTO_FILECACHE_SIZE,scale,fromFile,toPath,future=new Future,cacheFuture;future.now(function(){if(type===ContactPhoto.TYPE.BIG){destWidth=PersonPhotos.BIG_PHOTO_WIDTH;cropWidth=PersonPhotos.BIG_PHOTO_WIDTH;cropHeight=PersonPhotos.BIG_PHOTO_HEIGHT;size=PersonPhotos.BIG_PHOTO_FILECACHE_SIZE}scale=
cropInfo.scale||destWidth/cropInfo.window.suggestedXSize;fromFile=fromPath.split("/");if(fromFile.length-1>=0)fromFile=fromFile[fromFile.length-1];else fromFile="default."+PersonPhotos.PHOTO_FILETYPE;toPath="/media/internal/.contactphotos/";toPath+=Date.now();toPath+="."+PersonPhotos.PHOTO_FILETYPE;var imageConvertParams={src:fromPath,dest:toPath,destType:PersonPhotos.PHOTO_FILETYPE,focusX:cropInfo.window.focusX,focusY:cropInfo.window.focusY,scale:scale,cropW:cropWidth,cropH:cropHeight};return PalmCall.call("palm://com.palm.image",
"convert",imageConvertParams)});future.then(function(){var result;try{result=future.result}catch(e){throw e;}return toPath});return future};
ContactPhoto.cropAndGetPath=function(fromPath,cropInfo,type,timingRecorderParam){var destWidth=PersonPhotos.LIST_PHOTO_WIDTH,cropWidth=PersonPhotos.LIST_PHOTO_WIDTH,cropHeight=PersonPhotos.LIST_PHOTO_HEIGHT,size=PersonPhotos.LIST_PHOTO_FILECACHE_SIZE,toPath,future=new Future,cacheFuture,timingRecorder=timingRecorderParam||{startTimingForJob:function(){},stopTimingForJob:function(){}};if(type===ContactPhoto.TYPE.BIG){destWidth=PersonPhotos.BIG_PHOTO_WIDTH;cropWidth=PersonPhotos.BIG_PHOTO_WIDTH;cropHeight=
PersonPhotos.BIG_PHOTO_HEIGHT;size=PersonPhotos.BIG_PHOTO_FILECACHE_SIZE}future.now(function(){var fromFile=fromPath.split("/");if(fromFile.length-1>=0)fromFile=fromFile[fromFile.length-1];else fromFile="default."+PersonPhotos.PHOTO_FILETYPE;timingRecorder.startTimingForJob("Fixup_Photos_FileCache_Insert");cacheFuture=PalmCall.call("palm://com.palm.filecache","InsertCacheObject",{typeName:"contactphoto",size:size,fileName:fromFile,subscribe:true});return cacheFuture});future.then(function(result){toPath=
future.result.pathName;timingRecorder.stopTimingForJob("Fixup_Photos_FileCache_Insert");var imageConvertParams={src:fromPath,dest:toPath,destType:PersonPhotos.PHOTO_FILETYPE};timingRecorder.startTimingForJob("Fixup_Photos_Image_Convert");if(type===PersonPhotos.TYPE.LIST){imageConvertParams.destSizeW=cropWidth;imageConvertParams.destSizeH=cropHeight;return PalmCall.call("palm://com.palm.image","ezResize",imageConvertParams)}imageConvertParams.focusX=cropInfo.window.focusX;imageConvertParams.focusY=
cropInfo.window.focusY;imageConvertParams.scale=cropInfo.scale||destWidth/cropInfo.window.suggestedXSize;imageConvertParams.cropW=cropWidth;imageConvertParams.cropH=cropHeight;return PalmCall.call("palm://com.palm.image","convert",imageConvertParams)});future.then(function(){var result;timingRecorder.stopTimingForJob("Fixup_Photos_Image_Convert");try{result=future.result}catch(e){throw e;}finally{if(cacheFuture)PalmCall.cancel(cacheFuture)}return toPath});return future};
ContactPhoto.expire=function(photoPath){var future;if(!photoPath)return new Future({});future=PalmCall.call("palm://com.palm.filecache","ExpireCacheObject",{pathName:photoPath});future.then(function(){try{var result=future.result;future.result=result}catch(ex){console.error("Exception when expiring photo at '"+photoPath+"': "+ex);future.result={}}});return future};Utils.defineConstant("DEFAULT_DRAWER_PHOTO",LIB_ROOT+"images/generic-avatar-34x34.jpg",ContactPhoto);
ContactPhoto.TYPE=Utils.defineConstants({BIG:PersonPhotos.TYPE.BIG,SQUARE:PersonPhotos.TYPE.SQUARE});var PhoneNumberExtended=PropertyBase.create({superClass:FavoritablePhoneNumber,data:[{dbFieldName:"value",defaultValue:"",setterName:"setValue",getterName:"getValue",beforeSet:function(value){this.doGenerateNormalizedValue=true;return value}},{dbFieldName:"normalizedValue",defaultValue:"",setterName:"setNormalizedValue",getterName:"getNormalizedValue",beforeGet:function(origNormalizedValue){var normalizedValue=origNormalizedValue,value=this.getValue();if(!value||this.doGenerateNormalizedValue){normalizedValue=
PhoneNumber.normalizePhoneNumber(value);this.setNormalizedValue(normalizedValue);this.doGenerateNormalizedValue=false}return normalizedValue}},{dbFieldName:"speedDial",defaultValue:"",setterName:"setSpeedDial",getterName:"getSpeedDial"}]});PhoneNumberExtended.prototype._extendedGetDBObject=function(dbObject){dbObject.normalizedValue=this.getNormalizedValue();return dbObject};var ReadOnly=PropertyBase.create({data:[{dbFieldName:"",defaultValue:false,setterName:"setValue",getterName:"getValue"}]});var Relation=exports.Relation=PropertyBase.create({data:[{dbFieldName:"value",defaultValue:"",setterName:"setValue",getterName:"getValue"},{dbFieldName:"type",defaultValue:"",setterName:"setType",getterName:"getType"},{dbFieldName:"primary",defaultValue:false,setterName:"setPrimary",getterName:"getPrimary"}]});Relation.prototype.getNormalizedHashKey=function(){return this.getValue()+":(|)"+this.getType()};
Relation.prototype.equals=function(obj){if(obj instanceof Relation)return this.getValue()===obj.getValue()&&this.getType()===obj.getType()&&this.getPrimary()===obj.getPrimary();return false};Relation.prototype.getDisplayValue=function(){return this.getValue()};Relation.prototype.__defineGetter__("x_displayValue",function(){return this.getDisplayValue()});
Relation.TYPE=Utils.defineConstants({ASSISTANT:"type_assistant",BROTHER:"type_brother",CHILD:"type_child",DOMESTIC_PARTNER:"type_domestic_partner",FATHER:"type_father",FRIEND:"type_friend",MANAGER:"type_manager",MOTHER:"type_mother",PARENT:"type_parent",PARTNER:"type_partner",REFERRED_BY:"type_referred_by",RELATIVE:"type_relative",SISTER:"type_sister",SPOUSE:"type_spouse",OTHER:"type_other"});var Reminder=PropertyBase.create({data:[{dbFieldName:"",defaultValue:"",setterName:"setValue",getterName:"getValue"}]});var Ringtone=PropertyBase.create({data:[{dbFieldName:"name",defaultValue:"",setterName:"setName",getterName:"getName"},{dbFieldName:"location",defaultValue:"",setterName:"setLocation",getterName:"getLocation"}]});var CallAlert=PropertyBase.create({data:[{dbFieldName:"alert",defaultValue:"",setterName:"setAlert",getterName:"getAlert"}]});var CallAction=PropertyBase.create({data:[{dbFieldName:"action",defaultValue:"",setterName:"setAction",getterName:"getAction"}]});var MsgRingtone=PropertyBase.create({data:[{dbFieldName:"name",defaultValue:"",setterName:"setName",getterName:"getName"},{dbFieldName:"location",defaultValue:"",setterName:"setLocation",getterName:"getLocation"}]});var MsgAlert=PropertyBase.create({data:[{dbFieldName:"alert",defaultValue:"",setterName:"setAlert",getterName:"getAlert"}]});var IMsgRingtone=PropertyBase.create({data:[{dbFieldName:"name",defaultValue:"",setterName:"setName",getterName:"getName"},{dbFieldName:"location",defaultValue:"",setterName:"setLocation",getterName:"getLocation"}]});var IMsgAlert=PropertyBase.create({data:[{dbFieldName:"alert",defaultValue:"",setterName:"setAlert",getterName:"getAlert"}]});var SearchTerm=PropertyBase.create({data:[{dbFieldName:"",defaultValue:"",setterName:"setValue",getterName:"getValue"}]});var SimEntryType=PropertyBase.create({data:[{dbFieldName:"",defaultValue:"",setterName:"setValue",getterName:"getValue"}]});var SimIndex=PropertyBase.create({data:[{dbFieldName:"",defaultValue:-1,setterName:"setValue",getterName:"getValue"}]});var SearchTerm=PropertyBase.create({data:[{dbFieldName:"",defaultValue:"",setterName:"setValue",getterName:"getValue"}]});var SimEntryType=PropertyBase.create({data:[{dbFieldName:"",defaultValue:"",setterName:"setValue",getterName:"getValue"}]});var SimIndex=PropertyBase.create({data:[{dbFieldName:"",defaultValue:-1,setterName:"setValue",getterName:"getValue"}]});var SortKey=exports.SortKey=PropertyBase.create({data:[{dbFieldName:"",defaultValue:"",setterName:"setValue",getterName:"getValue"}]});
SortKey.generateSortKey=function(person,optionalConfigParams){var future=new Future,configParams;future.now(function(){Assert.require(person,"SortKey.generateSortKey requires a person that is truthy");configParams=optionalConfigParams||{};if(configParams.listSortOrder)return true;else var appPrefs=new AppPrefs(future.callback(function(){var dummy=future.result;configParams.listSortOrder=appPrefs.get(AppPrefs.Pref.listSortOrder);future.result=true}))});future.then(function(){var dummy=future.result;
return SortKey._generateSortKeyFromSortOrder(person,configParams)});return future};
SortKey._generateSortKeyFromSortOrder=function(person,configParams){var future=new Future,givenName="",familyName="",companyName="",displayName="";future.now(function(){var name,company;Assert.require(person,"SortKey.generateSortKey requires a person that is truthy");Assert.requireObject(configParams,"SortKey.generateSortKey requires an object as the configParams");Assert.requireString(configParams.listSortOrder,"SortKey.generateSortKey requires a listSortOrder that is a string");if(person instanceof
Person){name=person.getName();if(name){givenName=name.getGivenName()||"";familyName=name.getFamilyName()||""}company=person.getOrganization();if(company)companyName=company.getName()||"";displayName=person.generateDisplayName()||""}else{name=person.name;if(name){givenName=name.givenName||"";familyName=name.familyName||""}company=person.organization;if(company)companyName=company.name||"";displayName=Person.generateDisplayNameFromRawPerson(person)||""}familyName=Globalization.Name.getSortName(familyName);
return SortKey._generateSortKeyHelper(configParams,givenName,familyName,companyName,displayName)});return future};
SortKey._generateSortKeyHelper=function(configParams,givenName,familyName,companyName,displayName){var listSortOrder=configParams.listSortOrder,sortKey="",sortKeyDefaultItem=SortKey.DEFAULT_CHAR+SortKey.DEFAULT_CHAR,sortKeyDelimiter="\t",firstChar;givenName=givenName||"";familyName=familyName||"";companyName=companyName||"";displayName=displayName||"";givenName=givenName.trim();familyName=familyName.trim();companyName=companyName.trim();displayName=displayName.trim();if(listSortOrder===ListWidget.SortOrder.companyLastFirst||
listSortOrder===ListWidget.SortOrder.companyFirstLast){sortKey+=companyName||sortKeyDefaultItem;sortKey+=sortKeyDelimiter}if(givenName||familyName)if(listSortOrder===ListWidget.SortOrder.companyFirstLast||listSortOrder===ListWidget.SortOrder.firstLast){if(givenName)sortKey+=givenName+sortKeyDelimiter;if(familyName)sortKey+=familyName+sortKeyDelimiter}else{if(familyName)sortKey+=familyName+sortKeyDelimiter;if(givenName)sortKey+=givenName+sortKeyDelimiter}else sortKey+=displayName+sortKeyDelimiter;
sortKey=sortKey.trim();if(sortKey){firstChar=sortKey.charAt(0);if(firstChar!==SortKey.DEFAULT_CHAR&&firstChar!==sortKeyDelimiter&&!Globalization.Character.isLetter(firstChar))sortKey=SortKey.DEFAULT_CHAR+sortKey}else sortKey=sortKeyDefaultItem;return sortKey.toLocaleLowerCase().trim()};Utils.defineConstant("DEFAULT_CHAR","\ufad7",SortKey);Utils.defineConstant("DEFAULT_NAME_DIVIDER_TEXT","#",SortKey);Utils.defineConstant("DEFAULT_COMPANY_DIVIDER_TEXT",RB.$L("None"),SortKey);var SpeedDialHash=PropertyBase.create({data:[{dbFieldName:"hashedPhoneNumber",defaultValue:null,setterName:"setHashedPhoneNumber",getterName:"getHashedPhoneNumber"},{dbFieldName:"key",defaultValue:null,setterName:"setKey",getterName:"getKey"}]});SpeedDialHash.prototype.equals=function(value){if(value instanceof SpeedDialHash)return this.getHashedPhoneNumber()===value.getHashedPhoneNumber()&&this.getKey()===value.getKey();return false};
SpeedDialHash.prototype.setPlainValue=function(value){this.setHashedPhoneNumber(value?Crypto.MD5.b64_md5(value):null)};SpeedDialHash.prototype.isPlainValueEqual=function(value){return value?Crypto.MD5.b64_md5(value)===this.getHashedPhoneNumber():value===this.getHashedPhoneNumber()};var SyncSource=PropertyBase.create({data:[{dbFieldName:"name",defaultValue:null,setterName:"setName",getterName:"getName"},{dbFieldName:"extended",defaultValue:{},setterName:"setExtended",getterName:"getExtended"}]});SyncSource.prototype.equals=function(obj){if(obj instanceof SyncSource)return this.getName()===obj.getName();return false};var Tag=PropertyBase.create({data:[{dbFieldName:"",defaultValue:"",setterName:"setValue",getterName:"getValue"}]});var Url=exports.Url=PropertyBase.create({data:[{dbFieldName:"value",defaultValue:"",setterName:"setValue",getterName:"getValue"},{dbFieldName:"type",defaultValue:"",setterName:"setType",getterName:"getType"},{dbFieldName:"primary",defaultValue:false,setterName:"setPrimary",getterName:"getPrimary"}]});Url.prototype.getDisplayValue=function(){return this.getValue().toLocaleLowerCase()};Url.prototype.__defineGetter__("x_displayValue",function(){return this.getDisplayValue()});
Url.TYPE=Utils.defineConstants({HOME:"type_home",HOMEPAGE:"type_homepage",BLOG:"type_blog",FTP:"type_ftp",PROFILE:"type_profile",WORK:"type_work",OTHER:"type_other"});Url.prototype.getNormalizedHashKey=function(){return this.getValue().toLowerCase()};
Url.Labels=Utils.createLabelFunctions([{value:Url.TYPE.HOME,displayValue:RB.$L("Home"),isPopupLabel:false},{value:Url.TYPE.HOMEPAGE,displayValue:RB.$L("Homepage"),isPopupLabel:false},{value:Url.TYPE.BLOG,displayValue:RB.$L("Blog"),isPopupLabel:false},{value:Url.TYPE.FTP,displayValue:RB.$L("FTP"),isPopupLabel:false},{value:Url.TYPE.PROFILE,displayValue:RB.$L("Profile"),isPopupLabel:false},{value:Url.TYPE.WORK,displayValue:RB.$L("Work"),isPopupLabel:false},{value:Url.TYPE.OTHER,displayValue:RB.$L("Other"),
isPopupLabel:false}]);var AppPrefs=exports.AppPrefs=function(onReady,kind,defaults){kind=kind||AppPrefs.dbKind;defaults=defaults||{listSortOrder:ListWidget.SortOrder.defaultSortOrder,defaultAccountId:"",contactsPhoneRegion:"us",blockedNumbers:true,unknownNumbers:true,unknownContacts:{}};this.ready=false;this._kind=kind;this._defaults=defaults;this._onReady=onReady;Utils.mixInBroadcaster(this);this._doQuery()};Utils.defineConstant("dbKind","com.palm.app.contacts.prefs:1",AppPrefs);
AppPrefs.Pref=Utils.defineConstants({listSortOrder:"listSortOrder",defaultAccountId:"defaultAccountId",contactsPhoneRegion:"contactsPhoneRegion",blockedNumbers:"blockedNumbers",unknownNumbers:"unknownNumbers",unknownContacts:"unknownContacts"});AppPrefs.prototype._doQuery=function(){this._future=DB.find({from:this._kind,limit:2});this._future.then(this,this._handleResult)};
AppPrefs.prototype._handleResult=function(future){var length=future.result.results.length,shallowCopy;if(length>1)console.error("AppPrefs: Expected singleton object for "+this._kind+", but received >1 result.");else if(length===0){console.log("AppPrefs: No prefs found, creating "+this._kind);shallowCopy=_.clone(this._defaults);shallowCopy._kind=this._kind;DB.put([shallowCopy]);this._doQuery();return}this._prefs=future.result.results[0];this.ready=true;if(this._onReady){this._onReady();this._onReady=
undefined}};AppPrefs.prototype.get=function(propName){var result=this._prefs,props;if(!this.ready){console.error("AppPrefs: Access to pref "+propName+" before prefs object is ready. Using default.");result=this._defaults}props=propName.split(".");while(result&&props.length>0)result=result[props.shift()];if(props.length>0)console.warn("AppPrefs: Invalid attempt to access pref at "+propName);return result};
AppPrefs.prototype.set=function(propName,value){var prefs=this._prefs,mergeObj,objToSet,props,curProp;if(!this.ready){console.error("AppPrefs: Attempt to set pref "+propName+" before prefs object is ready. Ignoring.");return}mergeObj=objToSet={_id:this._prefs._id};props=propName.split(".");while(objToSet&&props.length>1){curProp=props.shift();if(!prefs[curProp])prefs[curProp]={};prefs=prefs[curProp];objToSet[curProp]={};objToSet=objToSet[curProp]}curProp=props.shift();prefs[curProp]=value;objToSet[curProp]=
value;DB.merge([mergeObj]);this.broadcast(propName,value)};var Contact=exports.Contact=Class.create({initialize:function(obj){if(!obj)obj={};var hasDatabaseId=!!obj._id,constructedFromPerson=obj instanceof Person,rawContact=!constructedFromPerson?obj:{},_origData=constructedFromPerson?obj.getDBObject():rawContact,_data={_kind:rawContact._kind||Contact.kind,_id:rawContact._id,_rev:rawContact._rev,_del:rawContact._del,remoteId:rawContact.remoteId,accounts:Utils.lazyWrapper(PropertyArray,[Account,rawContact.accounts,hasDatabaseId]),accountId:Utils.lazyWrapper(AccountId,
[rawContact.accountId,hasDatabaseId]),addresses:Utils.lazyWrapper(PropertyArray,[Address,rawContact.addresses,hasDatabaseId]),anniversary:Utils.lazyWrapper(Anniversary,[rawContact.anniversary,hasDatabaseId]),birthday:Utils.lazyWrapper(Birthday,[rawContact.birthday,hasDatabaseId]),displayName:Utils.lazyWrapper(DisplayName,[rawContact.displayName,hasDatabaseId]),emails:Utils.lazyWrapper(PropertyArray,[EmailAddress,rawContact.emails,hasDatabaseId]),gender:Utils.lazyWrapper(Gender,[rawContact.gender,
hasDatabaseId]),ims:Utils.lazyWrapper(PropertyArray,[IMAddress,rawContact.ims,hasDatabaseId]),name:Utils.lazyWrapper(Name,[rawContact.name,hasDatabaseId]),nickname:Utils.lazyWrapper(Nickname,[rawContact.nickname,hasDatabaseId]),note:Utils.lazyWrapper(Note,[rawContact.note,hasDatabaseId]),organizations:Utils.lazyWrapper(PropertyArray,[Organization,rawContact.organizations,hasDatabaseId]),phoneNumbers:Utils.lazyWrapper(PropertyArray,[PhoneNumber,rawContact.phoneNumbers,hasDatabaseId]),photos:Utils.lazyWrapper(PropertyArray,
[ContactPhoto,rawContact.photos,hasDatabaseId]),syncSource:Utils.lazyWrapper(SyncSource,[rawContact.syncSource,hasDatabaseId]),tags:Utils.lazyWrapper(PropertyArray,[Tag,rawContact.tags,hasDatabaseId]),urls:Utils.lazyWrapper(PropertyArray,[Url,rawContact.urls,hasDatabaseId]),relations:Utils.lazyWrapper(PropertyArray,[Relation,rawContact.relations,hasDatabaseId])};this.accessor=function(fieldName){var field=_data[fieldName];Assert.requireDefined(fieldName,"fieldName must be specified for the accessor");
if(field&&typeof field==="object"&&field.isLazyWrapper)field=_data[fieldName]=field.createInstance();return field};this.setId=function(id){_data._id=id};this.setRev=function(rev){_data._rev=rev};this.setKind=function(kind){_data._kind=kind};this._extendWithPropertyAndValue=function(propertyName,value){_data[propertyName]=value};this.getDBObject=function(){var newData=Utils.getDBObjectForAllProperties(this.accessor,_.keys(_data));return _.extend(_origData,newData)};this.getDirtyDBObject=function(){var newData=
_.extend(_origData,Utils.getDBObjectForAllDirtyProperties(this.accessor,_.keys(_data)));if(newData._rev)delete newData._rev;return newData};if(constructedFromPerson)this.populateFromPerson(obj)},populateFromPerson:function(person){Assert.requireDefined(person,"populateFromPerson requires a person argument");Assert.require(person instanceof Person,"populateFromPerson requires a person argument that is a child of Person");this.getOrganizations().set(person.getOrganization());this.getName().set(person.getName());
this.getNickname().setValue(person.getNickname().getValue());this.getEmails().set(person.getEmails().getArray());this.getIms().set(person.getIms());this.getPhoneNumbers().set(person.getPhoneNumbers());return true},addContactDataFromPerson:function(person){Assert.requireDefined(person,"populateFromPerson requires a person argument");Assert.require(person instanceof Person,"populateFromPerson requires a person argument that is a child of Person");this.getOrganizations().add(person.getOrganization().getDBObject());
this.getEmails().add(person.getEmails().getDBObject());this.getIms().add(person.getIms().getDBObject());this.getPhoneNumbers().add(person.getPhoneNumbers().getDBObject());return true},getKind:function(){return this.accessor("_kind")},getId:function(){return this.accessor("_id")},getRev:function(){return this.accessor("_rev")},getRemoteId:function(){return this.accessor("remoteId")},markedForDelete:function(){return this.accessor("_del")||false},getAccountId:function(){return this.accessor("accountId")},
getAccounts:function(){return this.accessor("accounts")},getAddresses:function(){return this.accessor("addresses")},getAnniversary:function(){return this.accessor("anniversary")},getBirthday:function(){return this.accessor("birthday")},getEmails:function(){return this.accessor("emails")},getGender:function(){return this.accessor("gender")},getIms:function(){return this.accessor("ims")},getName:function(){return this.accessor("name")},getNickname:function(){return this.accessor("nickname")},getNote:function(){return this.accessor("note")},
getOrganizations:function(){return this.accessor("organizations")},getPhoneNumbers:function(){return this.accessor("phoneNumbers")},getPhotos:function(){return this.accessor("photos")},getSyncSource:function(){return this.accessor("syncSource")},getTags:function(){return this.accessor("tags")},getUrls:function(){return this.accessor("urls")},getRelations:function(){return this.accessor("relations")},getKindName:function(includeVersion){var toReturn=this.getKind()||"";if(!includeVersion)toReturn=toReturn.split(":")[0];
return toReturn},getBestOrganization:function(){var orgs=this.getOrganizations().getArray(),i,org,bestOrg=null;for(i=0;i<orgs.length;i=i+1){org=orgs[i];if(!bestOrg){bestOrg=org;if(bestOrg.getName()&&bestOrg.getTitle())break}else if(org.getName()&&org.getTitle()||!bestOrg.getName()&&org.getName()||!bestOrg.getName()&&!bestOrg.getTitle()&&org.getTitle())bestOrg=org}return bestOrg},generateWorkInfoLine:function(){var arr=[],org=this.getBestOrganization(),orgTitle="",orgName="";if(org){orgTitle=org.getTitle();
orgName=org.getName();if(orgTitle)arr.push(orgTitle);if(orgName)arr.push(orgName)}return arr.join(", ")},generateDisplayName:function(includeBasedOnField){return Utils.generateDisplayName(this,includeBasedOnField)},clearPhotos:function(){var future=new Future;future.now(this,function(){var innerFuture,photos,i,localPath,expireFunction=function(futureSoBrightIGottaWearShades,localPath){try{var dummy=futureSoBrightIGottaWearShades.result}catch(e){console.error(e)}if(localPath&&typeof localPath==="string"&&
localPath.indexOf("/var")===0)futureSoBrightIGottaWearShades.nest(ContactPhoto.expire(localPath));return true};innerFuture=new Future({});photos=this.getPhotos().getArray();for(i=0;i<photos.length;i+=1)innerFuture.then(expireFunction.bind(this,innerFuture,photos[i].getLocalPath()));return innerFuture});future.then(this,function(){var dummy;try{dummy=future.result}catch(e){console.error(e)}this.getPhotos().clear();return dummy});return future},deleteContact:function(){var id=this.getId(),future=new Future;
Assert.requireDefined(id,"deleteContact unable to delete, there is no _id param");if(this.getKindName()==="com.palm.contact.sim"){future.now(this,function(){return PalmCall.call("palm://com.palm.service.contacts.sim/","deleteContact",{contact:this.getDBObject()})});future.then(this,function(){var dummy=future.result;PalmCall.cancel(future);return this.clearPhotos()})}else future.now(this,function(){return this.clearPhotos()});future.then(this,function(){var dummy=future.result;return DB.del([id])});
return future},save:function(){var future;if(this.getKindName()==="com.palm.contact.sim"){future=PalmCall.call("palm://com.palm.service.contacts.sim/","saveContact",{contact:this.getDBObject()});future.then(this,function(){var dummy=future.result;PalmCall.cancel(future);future.result=true})}else{if(this.getId())future=DB.merge([this.getDirtyDBObject()]);else future=DB.put([this.getDBObject()]);future.then(this,function(future){var result=Utils.DBResultHelper(future.result);Assert.require(result,"Contact save put - result is null");
Assert.requireArray(result,"Contact save");Assert.require(result.length,"Contact save put - result length is zero");this.setId(result[0].id);this.setRev(result[0].rev);this.markNotDirty();future.result=true})}return future},toString:function(){return JSON.stringify(this.getDBObject())},isDirty:function(){return Utils.callFunctionsOnProperties(this.accessor,Contact.PROPERTIES.objects,"isDirty",Contact.PROPERTIES.arrays,"containsDirtyEntry")},markNotDirty:function(){Utils.callFunctionsOnProperties(this.accessor,
Contact.PROPERTIES.objects,"markNotDirty",Contact.PROPERTIES.arrays,"markElementsNotDirty")},equals:function(otherContact){var isEqual=true,i,j,tempArray,otherTempArray,property="",properties=Contact.PROPERTIES.objects,propertyArrays=Contact.PROPERTIES.arrays;Assert.require(otherContact instanceof Contact,"The object passed into equals must be an instance of Contact");for(i=0;i<properties.length;i+=1){property=properties[i];isEqual=isEqual&&this.accessor(property).equals(otherContact.accessor(property))}for(j=
0;j<propertyArrays.length;j+=1){property=propertyArrays[j];tempArray=this.accessor(property).getArray();otherTempArray=otherContact.accessor(property).getArray();for(i=0;i<tempArray.length;i+=1)isEqual=isEqual&&tempArray[i].equals(otherTempArray[i])}return isEqual},setCroppedContactPhoto:function(path,cropInfo,photoType){var future=new Future,photos,croppedPath;future.now(this,function(){var i,photo,innerFuture,localPath,expireFunction=function(brightNewFuture,localPath){try{var dummy=brightNewFuture.result}catch(e){console.error(e)}if(localPath&&
typeof localPath==="string"&&localPath.indexOf("/var")===0)brightNewFuture.nest(ContactPhoto.expire(localPath));return true};photos=this.getPhotos().getArray();innerFuture=new Future({});for(i=photos.length-1;i>=0;i-=1){photo=photos[i];if(photo.getType()===photoType){innerFuture.then(expireFunction.bind(this,innerFuture,photos[i].getLocalPath()));photos.splice(i,1)}}future.nest(innerFuture)});future.then(this,function(){try{var dummy=future.result}catch(e){console.error(e)}return PalmCall.call("palm://com.palm.service.accounts",
"getAccountInfo",{accountId:this.getAccountId().getValue()})});future.then(this,function(){var template,innerFuture;try{template=future.result.result.templateId}catch(e){console.error(e)}if(template==="com.palm.palmprofile"){innerFuture=ContactPhoto.cropAndGetPathToMediaInternal(path,cropInfo,photoType);innerFuture.then(this,function(){path=innerFuture.result;return path});return innerFuture}else return ContactPhoto.cropAndGetPath(path,cropInfo,photoType)});future.then(this,function(){var contactPhoto,
croppedPath=future.result;contactPhoto=new ContactPhoto({value:path,localPath:croppedPath,type:photoType});contactPhoto.forceMarkDirty();photos.splice(0,0,contactPhoto);this.getPhotos().set(photos);return croppedPath});return future},stripTmpPhoneNumberField:function(){var i,phoneNumber,phoneNumbers=this.getPhoneNumbers().getDBObject();if(phoneNumbers){this.getPhoneNumbers().clear();for(i=0;i<phoneNumbers.length;i+=1){this.getPhoneNumbers().add(new PhoneNumber);phoneNumber=this.getPhoneNumbers().getArray()[i];
phoneNumber.setValue(phoneNumbers[i].value?phoneNumbers[i].value:phoneNumber.getValue());phoneNumber.setType(phoneNumbers[i].type?phoneNumbers[i].type:phoneNumber.getType());if(phoneNumbers[i].primary)phoneNumber.setPrimary(phoneNumbers[i].primary)}}}});Utils.defineConstant("kind","com.palm.contact:1",Contact);
Contact.PROPERTIES={objects:["anniversary","birthday","displayName","gender","name","nickname","note","syncSource"],arrays:["accounts","addresses","emails","ims","organizations","phoneNumbers","photos","tags","urls","relations"]};Contact.getIdFromLinkHash=function(linkHash){return ContactLinkable.getIdFromLinkHash(linkHash)};
Contact.getContactByRemoteId=function(remoteId){var future=new Future;future.now(function(){Assert.requireString(remoteId,"Contact.getContactByRemoteId requires a remoteId that is a valid string");return DB.find({from:Contact.kind,where:[{prop:"remoteId",op:"=",val:remoteId}]})});future.then(function(){var result=Utils.DBResultHelper(future.result);if(result&&result.length>0)return new Contact(result[0]);else return null});return future};
Contact.getContactsByAccountId=function(accountId){var future=new Future;future.now(function(){Assert.requireString(accountId,"Contact.getContactsByAccountId requires an accountId that is a valid string");return DB.find({from:Contact.kind,where:[{prop:"accountId",op:"=",val:accountId}]})});future.then(function(future){var result=Utils.DBResultHelper(future.result);if(result&&result.length>0)future.result=result.map(function(contact){return new Contact(contact)});else future.result=[]});return future};var ContactDisplay=Class.create(Contact,{initialize:function initialize(obj){this.$super(initialize)(obj);this._init();this.generateDisplayParams()},_init:function(){this.displayName="";this.fullName="";this.workInfoLine="";this.showWorkInfoClass="";this.freeformName="";this.dirty=true;this.primary="";this.singleItem=""},generateDisplayParams:function(){var displayNameData=this.generateDisplayName(true),photosArray,squarePhoto;this.displayName=displayNameData.displayName;this.fullName=this.getName().getFullName()||
this.displayName;this.workInfoLine=displayNameData.basedOnField!==DisplayNameType.TITLE_AND_ORGANIZATION_NAME&&displayNameData.basedOnField!==DisplayNameType.ORGANIZATION_NAME?this.generateWorkInfoLine():"";if(this.workInfoLine)this.showWorkInfoClass=ContactDisplay.SHOW_WORK_INFO_CLASS}});ContactDisplay.SHOW_WORK_INFO_CLASS="show-work-info";ContactDisplay.DEFAULT_DRAWER_PHOTO=ContactPhoto.DEFAULT_DRAWER_PHOTO;exports.ContactDisplay=ContactDisplay;var ContactLinkable=exports.ContactLinkable=Class.create(Contact,{initialize:function initialize(rawContact){this.$super(initialize)(rawContact);this._init();if(rawContact);},_init:function(){},getLinkHash:function(){return ContactLinkable.getLinkHash(this)},getPersonFromCLBObject:function(clbLink){var future=new Future,returningBothPersonRecords=false;future.now(this,function(){return this.getLinkHash()});future.then(this,function(){var linkHash=future.result.linkHash,idToFetch,clbLinkA,clbLinkB;
if(clbLink.contactEntityA===linkHash)idToFetch=clbLink.contactEntityB.split("|")[1];else if(clbLink.contactEntityB===linkHash)idToFetch=clbLink.contactEntityA.split("|")[1];else{returningBothPersonRecords=true;clbLinkA=clbLink.contactEntityA.split("|")[1];clbLinkB=clbLink.contactEntityB.split("|")[1]}if(returningBothPersonRecords)return ContactLinkable.getTwoPeopleFromLinkHashIds(clbLinkA,clbLinkB);else return ContactLinkable.getOnePersonFromLinkHashId(idToFetch)});future.then(this,function(){var result=
future.result;if(returningBothPersonRecords)return result;else return[result]});return future}});
ContactLinkable.getTwoPeopleFromLinkHashIds=function(linkHashId1,linkHashId2){var contactIdDelimIndex=linkHashId1.indexOf(ContactLinkable.LOCAL_ID_DELIM),bothContactIds=false,link1IsContactId=false,link2IsContactId=false,toReturn=[];if(contactIdDelimIndex!==-1){linkHashId1=linkHashId1.substring(contactIdDelimIndex+ContactLinkable.LOCAL_ID_DELIM.length);bothContactIds=true;link1IsContactId=true}contactIdDelimIndex=linkHashId2.indexOf(ContactLinkable.LOCAL_ID_DELIM);if(contactIdDelimIndex!==-1){linkHashId2=
linkHashId2.substring(contactIdDelimIndex+ContactLinkable.LOCAL_ID_DELIM.length);link2IsContactId=true}else bothContactIds=false;if(bothContactIds)return ContactLinkable.batchGetTwoPeopleWithContactIds(linkHashId1,linkHashId2);else if(link1IsContactId&&!link2IsContactId||!link1IsContactId&&link2IsContactId)return ContactLinkable.getOnePersonFromLinkHashId(linkHashId1).then(function(future){var result=future.result;toReturn.push(result);return ContactLinkable.getOnePersonFromLinkHashId(linkHashId2).then(function(secondPersonFuture){var result=
secondPersonFuture.result;toReturn.push(result);return toReturn})});else return ContactLinkable.batchGetTwoContactsWithRemoteIds(linkHashId1,linkHashId2).then(function(future){var result=future.result,contact1=result.contact1,contact2=result.contact2;if(contact1&&contact2)return ContactLinkable.batchGetTwoPeopleWithContactIds(contact1.getId(),contact2.getId());else return null})};
ContactLinkable.batchGetTwoContactsWithRemoteIds=function(remoteId1,remoteId2){var future=new Future;future.now(function(){return DB.execute("batch",{operations:[{method:"find",params:{query:{from:Contact.kind,where:[{prop:"remoteId",op:"=",val:remoteId1}]}}},{method:"find",params:{query:{from:Contact.kind,where:[{prop:"remoteId",op:"=",val:remoteId2}]}}}]})});future.then(function(){var result=future.result,contact1,contact2;if(result&&result.responses&&result.responses.length>1){contact1=new Contact(result.responses[0].results[0]);
contact2=new Contact(result.responses[1].results[0])}return{contact1:contact1,contact2:contact2}});return future};
ContactLinkable.batchGetTwoPeopleWithContactIds=function(contactId1,contactId2){var future=new Future;future.now(function(){return DB.execute("batch",{operations:[{method:"find",params:{query:{from:Person.kind,where:[{prop:"contactIds",op:"=",val:contactId1}]}}},{method:"find",params:{query:{from:Person.kind,where:[{prop:"contactIds",op:"=",val:contactId2}]}}}]})});future.then(function(){var result=future.result,toReturn=[];if(result&&result.responses&&result.responses.length>1){toReturn[0]=new Person(result.responses[0].results[0]);
toReturn[1]=new Person(result.responses[1].results[0])}return toReturn});return future};
ContactLinkable.getOnePersonFromLinkHashId=function(linkHashId){var contactIdDelimIndex=linkHashId.indexOf(ContactLinkable.LOCAL_ID_DELIM);if(contactIdDelimIndex!==-1){linkHashId=linkHashId.substring(contactIdDelimIndex+ContactLinkable.LOCAL_ID_DELIM.length);return Person.findByContactIds([linkHashId])}else return Contact.getContactByRemoteId(linkHashId).then(function(future){var result=future.result;if(result)return Person.findByContactIds([result.getId()]);else return null})};
ContactLinkable.getIdFromLinkHash=function(linkHash){var idPart=linkHash.split("|")[1],contactIdDelimIndex=idPart.indexOf(ContactLinkable.LOCAL_ID_DELIM),toReturn,future=new Future;future.now(function(){if(contactIdDelimIndex!==-1)return idPart.substring(contactIdDelimIndex+ContactLinkable.LOCAL_ID_DELIM.length);else return Contact.getContactByRemoteId(idPart).then(function(getContactFuture){var result=getContactFuture.result;if(result)return result.getId();else return null})});return future};
ContactLinkable.LOCAL_ID_DELIM="~~:(!)~~";
ContactLinkable.getLinkHash=function(contact){var future=new Future;future.now(function(){var contactKindName=contact.getKindName();switch(contactKindName){case "com.palm.contact.sim":return ContactLinkable.getSimContactHash(contact);case "com.palm.contact.attaddresssync":return{syncSource:"ATTBook",remoteId:contact.getRemoteId()};case "com.palm.contact.palmprofile":return{syncSource:"Local",remoteId:contact.getRemoteId()};default:return ContactLinkable.getRemoteContactHash(contact)}});future.then(function(){var result=
future.result,syncSource=result.syncSource,acctUsername=result.acctUsername,remoteId=result.remoteId,toReturn;if(remoteId)toReturn=syncSource+"|"+remoteId;else toReturn=syncSource+"|"+ContactLinkable.LOCAL_ID_DELIM+contact.getId();toReturn+=acctUsername?"|"+acctUsername:"";return{linkHash:toReturn,shouldBackup:!!remoteId}});return future};ContactLinkable.getSimContactHash=function(contact){return{syncSource:"SIM"}};
ContactLinkable.getRemoteContactHash=function(contact){var future=new Future;future.now(function(){return PalmCall.call("palm://com.palm.service.accounts","getAccountInfo",{accountId:contact.getAccountId().getValue()})});future.then(function(){var result=future.result,accountObject,capability,kindName=contact.getKindName(true);Assert.require(result.returnValue,"ContactLinkable.getRemoteContactHash failed because com.palm.service.accounts returned a falsy returnValue");Assert.require(result.result,
"ContactLinkable.getRemoteContactHash failed because com.palm.service.accounts did not return a result.result");accountObject=result.result;capability=_.detect(accountObject.capabilityProviders,function(capabilityProvider){return capabilityProvider&&capabilityProvider.dbkinds&&capabilityProvider.dbkinds.contact&&capabilityProvider.dbkinds.contact===kindName});return{syncSource:capability?capability.id:undefined,remoteId:contact.getRemoteId(),acctUsername:accountObject.username}});return future};var ContactPointTypes=exports.ContactPointTypes={PhoneNumber:"contact_point_type_phoneNumber",EmailAddress:"contact_point_type_emailAddress",IMAddress:"contact_point_type_imAddress",Address:"contact_point_type_address",Url:"contact_point_type_url"};
ContactPointTypes.getFavoritableTypeForInstanceOf=function(object){if(object instanceof PhoneNumberExtended)return ContactPointTypes.PhoneNumber;else if(object instanceof EmailAddressExtended)return ContactPointTypes.EmailAddress;else if(object instanceof IMAddressExtended)return ContactPointTypes.IMAddress;else return"Not_A_Favoriteable_Type"};var ContactType={DISPLAYABLE:"displayable",LINKABLE:"linkable",EDITABLE:"editable",RAWOBJECT:"rawobject"};exports.ContactType=ContactType;var ContactFactory=Class.create({initialize:function(){}});ContactFactory.ContactType=ContactType;ContactFactory.createContactDisplay=function(rawContactObject){return new ContactDisplay(rawContactObject)};ContactFactory.createContactLinkable=function(rawContactObject){return new ContactLinkable(rawContactObject)};ContactFactory.createContactEditable=function(rawContactObject){return new Contact(rawContactObject)};
ContactFactory.create=function(contactType,rawContactObject){switch(contactType){case ContactType.DISPLAYABLE:return ContactFactory.createContactDisplay(rawContactObject);case ContactType.LINKABLE:return ContactFactory.createContactLinkable(rawContactObject);case ContactType.EDITABLE:return ContactFactory.createContactEditable(rawContactObject);case ContactType.RAWOBJECT:return rawContactObject;default:return ContactFactory.createContactDisplay(rawContactObject)}};exports.ContactFactory=ContactFactory;var DisplayNameType={NAME:"name",NICKNAME:"nickname",TITLE_AND_ORGANIZATION_NAME:"title_and_organization_name",ORGANIZATION_NAME:"organization_name",TITLE:"title",EMAIL:"email",IM:"im",PHONE:"phone",NONE:"none"};exports.DisplayNameType=DisplayNameType;var ListWidget=exports.ListWidget=function(){var rcsAccounts,queryKeepAlive;function getRcsAccounts(){var future,collect;if(rcsAccounts===undefined){future=new Future;collect=function(accounts){var firstResponse=rcsAccounts===undefined;rcsAccounts=[];accounts.forEach(function(account){account.capabilityProviders.forEach(function(capabilityProvider){if(capabilityProvider.capability==="REMOTECONTACTS"){rcsAccounts.push(capabilityProvider);capabilityProvider.accountId=account._id}})});if(firstResponse)future.result=
rcsAccounts};future.now(function(){var AccountsLib=MojoLoader.require({name:"accounts.ui",version:"1.0"})["accounts.ui"];queryKeepAlive=AccountsLib.AccountsList.listAccounts(collect,{filterBy:{capability:"REMOTECONTACTS"},subscribe:true})});return future}else return new Future(rcsAccounts)}return{getTypedownDBDataSourceAssistant:function(params){Assert.requireDefined(Mojo,"ListWidget.getTypedownDBDataSourceAssistant requires the mojo framework to be loaded");params=params||{};var dsaParams={kind:"com.palm.person:1",
select:params.select||undefined,makeWhere:function(filterString){var requirements=[],favoriteQueryValue;if(params.favoritesOnly)favoriteQueryValue=true;else if(params.excludeFavorites)favoriteQueryValue=false;if(filterString){requirements.push({prop:"searchProperty",op:"?",val:filterString,collate:"primary"});if(favoriteQueryValue===undefined)favoriteQueryValue=[true,false]}if(favoriteQueryValue!==undefined)requirements.push({prop:"favorite",op:"=",val:favoriteQueryValue});return requirements},watch:true,
orderBy:"sortKey"},dataSourceAssistant=new Mojo.DataSource.TypedownDBDataSourceAssistant(dsaParams,{select:params.selectFn});dataSourceAssistant.watchDelay=1E3;return dataSourceAssistant},getAddressingWidgetDataSourceAssistant:function(params){Assert.requireDefined(Mojo,"ListWidget.getAddressingWidgetDataSourceAssistant requires the mojo framework to be loaded");Assert.requireObject(params,"getAddressingWidgetDataSourceAssistant requires a params object to be passed");var selectFn,dataSourceAssistant,
getItemsToRenderOriginal;selectFn=function(person){return params.includePhones&&person.phoneNumbers&&_.isArray(person.phoneNumbers)||params.includeEmails&&person.emails&&_.isArray(person.emails)||params.includeIMs&&person.ims&&_.isArray(person.ims)};params.selectFn=selectFn;params.select=["_id","favorite","phoneNumbers","emails","ims","name","names","nickname","organization"];dataSourceAssistant=ListWidget.getTypedownDBDataSourceAssistant(params);getItemsToRenderOriginal=dataSourceAssistant.getItemsToRender.bind(dataSourceAssistant);
dataSourceAssistant.getItemsToRender=function(response,callback){getItemsToRenderOriginal(response,function(items){var i,newItems=[];if(items)for(i=0;i<items.length;i+=1)newItems=newItems.concat(ListWidget.addressingWidgetRawPersonFormatter(items[i],params));callback(newItems)})};return dataSourceAssistant},addressingWidgetRawPersonFormatter:function(rawPerson,params){Assert.requireDefined(Mojo,"ListWidget.addressingWidgetRawPersonFormatter requires the mojo framework to be loaded");if(!params){params=
{};console.warn("ListWidget.addressingWidgetFormatter was not passed a params arg")}var items=[],displayName,imAddressTypesToInclude=params.imAddressTypes,includeAllIMTypes;if(rawPerson.displayName)displayName=rawPerson.displayName;else displayName=Person.generateDisplayNameFromRawPerson(rawPerson);if(params.includePhones&&rawPerson.phoneNumbers&&_.isArray(rawPerson.phoneNumbers))rawPerson.phoneNumbers.forEach(function(phoneNumber){items.push({personId:rawPerson._id,favorite:rawPerson.favorite,type:"PHONE",
value:phoneNumber.value,label:PhoneNumber.getDisplayType(phoneNumber.type),displayName:displayName})});if(params.includeEmails&&rawPerson.emails&&_.isArray(rawPerson.emails))rawPerson.emails.forEach(function(email){items.push({personId:rawPerson._id,favorite:rawPerson.favorite,type:"EMAIL",value:email.value,label:EmailAddress.getDisplayType(email.type),displayName:displayName})});if(params.includeIMs&&rawPerson.ims&&_.isArray(rawPerson.ims)){includeAllIMTypes=!imAddressTypesToInclude||!_.isArray(imAddressTypesToInclude);
rawPerson.ims.forEach(function(im){if(includeAllIMTypes||imAddressTypesToInclude.indexOf(im.type)!==-1)items.push({personId:rawPerson._id,favorite:rawPerson.favorite,type:"IM",value:im.value,label:IMAddress.getDisplayType(im.type),displayName:displayName,serviceName:im.type})})}return items},getTypedownRcsDataSourceAssistant:function(params){Assert.requireDefined(Mojo,"ListWidget.getTypedownRcsDataSourceAssistant requires the mojo framework to be loaded");var assistant,originalFetchData,remoteContactsAccounts,
callback;callback=params&&params.callback;assistant=new Mojo.DataSource.LocalDataSourceAssistant([],{});originalFetchData=assistant.fetchData;assistant.fetchData=function(info,done){var search,future;if(!this.filterString)return;search=function(rcsAccount){var future=PalmCall.call(rcsAccount.query,"",{accountId:rcsAccount.accountId,query:this.filterString,limit:100});future.then(function(){var result=future.result.results;PalmCall.cancel(future);future.result=result});return future}.bind(this);future=
Foundations.Control.mapReduce({map:search},rcsAccounts);future.then(this,function(){var results=[];future.result.forEach(function(r){results=results.concat(r.result)});results.sort(function(left,right){return left&&right&&left.displayName.localeCompare(right.displayName)});this.itemsArray=results;if(callback)callback(results.length);originalFetchData(info,done)})};return assistant},getAddressingWidgetRcsDataSourceAssistant:function(params){Assert.requireDefined(Mojo,"ListWidget.getAddressingWidgetDataSourceAssistant requires the mojo framework to be loaded");
Assert.requireObject(params,"getAddressingWidgetDataSourceAssistant requires a params object to be passed");var dataSourceAssistant,getItemsToRenderOriginal;dataSourceAssistant=ListWidget.getTypedownRcsDataSourceAssistant(params);getItemsToRenderOriginal=dataSourceAssistant.getItemsToRender.bind(dataSourceAssistant);dataSourceAssistant.getItemsToRender=function(response,callback){getItemsToRenderOriginal(response,function(items){var i,newItems=[];if(items)for(i=0;i<items.length;i+=1)newItems=newItems.concat(ListWidget.addressingWidgetRawPersonFormatter(items[i],
params));callback(newItems)})};return dataSourceAssistant},isRcsAvailable:function(){var future=getRcsAccounts();future.then(function(){return future.result.length>0});return future},SortOrder:Utils.defineConstants({defaultSortOrder:"LAST_FIRST",lastFirst:"LAST_FIRST",firstLast:"FIRST_LAST",companyLastFirst:"COMPANY_LAST_FIRST",companyFirstLast:"COMPANY_FIRST_LAST"})}}();var Person=Class.create({initialize:function(rawPerson){if(!rawPerson)rawPerson={};var hasDatabaseId=!!rawPerson._id,constructedFromContact=rawPerson instanceof Contact,_data={_kind:Person.kind,_id:rawPerson._id||undefined,_rev:rawPerson._rev,_del:rawPerson._del,favorite:Utils.lazyWrapper(Favorite,[rawPerson.favorite,hasDatabaseId]),contactIds:Utils.lazyWrapper(PropertyArray,[ContactId,rawPerson.contactIds,hasDatabaseId]),sortKey:Utils.lazyWrapper(SortKey,[rawPerson.sortKey,hasDatabaseId]),name:Utils.lazyWrapper(Name,
[rawPerson.name,hasDatabaseId]),names:Utils.lazyWrapper(PropertyArray,[Name,rawPerson.names,hasDatabaseId]),nickname:Utils.lazyWrapper(Nickname,[rawPerson.nickname,hasDatabaseId]),organization:Utils.lazyWrapper(Organization,[rawPerson.organization,hasDatabaseId]),searchTerms:Utils.lazyWrapper(PropertyArray,[SearchTerm,rawPerson.searchTerms,hasDatabaseId]),emails:Utils.lazyWrapper(PropertyArray,[EmailAddressExtended,rawPerson.emails,hasDatabaseId]),phoneNumbers:Utils.lazyWrapper(PropertyArray,[PhoneNumberExtended,
rawPerson.phoneNumbers,hasDatabaseId]),ims:Utils.lazyWrapper(PropertyArray,[IMAddressExtended,rawPerson.ims,hasDatabaseId]),photos:Utils.lazyWrapper(PersonPhotos,[rawPerson.photos,hasDatabaseId]),addresses:Utils.lazyWrapper(PropertyArray,[Address,rawPerson.addresses,hasDatabaseId]),urls:Utils.lazyWrapper(PropertyArray,[Url,rawPerson.urls,hasDatabaseId]),notes:Utils.lazyWrapper(PropertyArray,[Note,rawPerson.notes,hasDatabaseId]),birthday:Utils.lazyWrapper(Birthday,[rawPerson.birthday,hasDatabaseId]),
anniversary:Utils.lazyWrapper(Anniversary,[rawPerson.anniversary,hasDatabaseId]),gender:Utils.lazyWrapper(Gender,[rawPerson.gender,hasDatabaseId]),reminder:Utils.lazyWrapper(Reminder,[rawPerson.reminder,hasDatabaseId]),launcherId:Utils.lazyWrapper(LauncherId,[rawPerson.launcherId,hasDatabaseId]),relations:Utils.lazyWrapper(PropertyArray,[Relation,rawPerson.relations,hasDatabaseId]),ringtone:Utils.lazyWrapper(Ringtone,[rawPerson.ringtone,hasDatabaseId]),callAlert:Utils.lazyWrapper(CallAlert,[rawPerson.callAlert,hasDatabaseId]),callAction:Utils.lazyWrapper(CallAction,[rawPerson.callAction,hasDatabaseId]),msgRingtone:Utils.lazyWrapper(MsgRingtone,[rawPerson.msgRingtone,hasDatabaseId]),msgAlert:Utils.lazyWrapper(MsgAlert,[rawPerson.msgAlert,hasDatabaseId]),iMsgRingtone:Utils.lazyWrapper(IMsgRingtone,[rawPerson.iMsgRingtone,hasDatabaseId]),iMsgAlert:Utils.lazyWrapper(IMsgAlert,[rawPerson.iMsgAlert,hasDatabaseId])},_contacts=new PropertyArray(Contact,null),_transientFavoriteState=
{instantiationFavoriteValue:false,favoriteDefaultsChanged:false},_beingSaved=false;this.accessor=function(fieldName){var field=_data[fieldName];Assert.requireDefined(fieldName,"fieldName must be specified for the accessor");if(field&&typeof field==="object"&&field.isLazyWrapper)field=_data[fieldName]=field.createInstance();return field};_transientFavoriteState.instantiationFavoriteValue=this.accessor("favorite").getValue();this._getTransientFavoriteState=function(){return _transientFavoriteState};
this._isBeingSaved=function(){return _beingSaved};this._setBeingSaved=function(value){_beingSaved=value};this.setId=function(id){_data._id=id};this.setRev=function(rev){_data._rev=rev};this.getContacts=function(){return _contacts.getArray()};this.setContacts=function(contacts){_contacts.set(contacts)};this.getDBObject=function(){return Utils.getDBObjectForAllProperties(this.accessor,_.keys(_data))};this.getDirtyDBObject=function(){return Utils.getDBObjectForAllDirtyProperties(this.accessor,_.keys(_data))};
if(constructedFromContact)this.populateFromContact(rawPerson)},populateFromContact:function(contact){Assert.requireDefined(contact,"populateFromContact requires a person argument");Assert.require(contact instanceof Contact,"populateFromContact requires a person argument that is a child of Person");this.setContacts([contact]);this.fixupNoReloadContacts();return true},getKind:function(){return this.accessor("_kind")},getId:function(){return this.accessor("_id")},getLauncherId:function(){return this.accessor("launcherId")},
generateLauncherCallbackId:function(){var contactIds=this.getContactIds().getArray(),toReturn="";contactIds=contactIds.map(function(contactId){return contactId.getValue()});return contactIds.join(Person.DELIMITER)},getRev:function(){return this.accessor("_rev")},markedForDelete:function(){return this.accessor("_del")||false},makeFavorite:function(param){if(!param||typeof param!=="object")param={};param.personId=this.getId();return Person.favoritePerson(param)},unfavorite:function(param){if(!param||
typeof param!=="object")param={};param.personId=this.getId();return Person.unfavoritePerson(param)},isFavorite:function(){return this.accessor("favorite").getValue()||false},getFavorite:function(){return this.accessor("favorite")},setFavoriteDefault:function(param){if(!param||typeof param!=="object")param={};param.personId=this.getId();return Person.setFavoriteDefault(param)},_getDefaultContactPointsForTypeAndAppId:function(contactPointType,applicationID){var toReturn=[],tempData,tempArray,hasFavoriteDataEntry,
i,getAllFavorites=applicationID?false:true;tempArray=this._getContactPointArrayForType(contactPointType);for(i=0;i<tempArray.length;i+=1){tempData=tempArray[i];if(getAllFavorites)hasFavoriteDataEntry=tempData.hasFavoriteDataForAnyApp();else hasFavoriteDataEntry=tempData.getFavoriteDataForAppWithId(applicationID);if(hasFavoriteDataEntry)toReturn.push(tempData)}return toReturn},_setDefaultForContactPointType:function(contactPointType,normalizedValue,applicationID,listIndex,auxData){var contactPointArray,
contactPointPropertyArray,contactPoint,itemIndex;contactPointPropertyArray=this._getContactPointArrayForType(contactPointType,true);contactPointArray=contactPointPropertyArray.getArray();contactPoint=_.detect(contactPointArray,function(item,curIndex){if(item.getNormalizedValue()===normalizedValue){itemIndex=curIndex;return true}});if(contactPoint){contactPoint.addFavoriteData(applicationID,{listIndex:listIndex,auxData:auxData});contactPointArray.splice(itemIndex,1);contactPointPropertyArray.clear();
contactPointPropertyArray.add(contactPoint);contactPointPropertyArray.add(contactPointArray);return true}else return false},_getContactPointArrayForType:function(contactPointType,returnPropertyArray){var toReturn;switch(contactPointType){case ContactPointTypes.PhoneNumber:toReturn=this.getPhoneNumbers();break;case ContactPointTypes.EmailAddress:toReturn=this.getEmails();break;case ContactPointTypes.IMAddress:toReturn=this.getIms();break;default:if(returnPropertyArray){toReturn=new PropertyArray(Object,
{});toReturn.add(this.getPhoneNumbers().getArray());toReturn.add(this.getEmails().getArray());toReturn.add(this.getIms().getArray())}else{toReturn=[];toReturn=toReturn.concat(this.getPhoneNumbers().getArray());toReturn=toReturn.concat(this.getEmails().getArray());toReturn=toReturn.concat(this.getIms().getArray())}return toReturn}return returnPropertyArray?toReturn:toReturn.getArray()},hasInstantiationFavoriteValueChanged:function(){return this._getTransientFavoriteState().instantiationFavoriteValue!==
this.getFavorite().getValue()},_updateInstantiationFavoriteValueToCurrentState:function(){if(this._isBeingSaved())this._getTransientFavoriteState().instantiationFavoriteValue=this.getFavorite().getValue()},_hasFavoriteDefaultsChanged:function(){return this._getTransientFavoriteState().favoriteDefaultsChanged},_markFavoriteDefaultsChanged:function(){this._getTransientFavoriteState().favoriteDefaultsChanged=true},_markFavoriteDefaultsUnChanged:function(){this._getTransientFavoriteState().favoriteDefaultsChanged=
false},getContactIds:function(){return this.accessor("contactIds")},setContactWithIdAsPrimary:function(contactIdToSetPrimary){var contactIds=this.getContactIds().getArray(),indexFoundContactId=-1,removedContactId;contactIds.some(function(contactId,index){if(contactId.getValue()===contactIdToSetPrimary){indexFoundContactId=index;return true}return false});if(indexFoundContactId>0){removedContactId=contactIds[indexFoundContactId];contactIds.splice(indexFoundContactId,1);contactIds.splice(0,0,removedContactId);
this.getContactIds().set(contactIds);return true}else return false},getSortKey:function(){return this.accessor("sortKey")},getName:function(){return this.accessor("name")},getNames:function(){return this.accessor("names")},getNickname:function(){return this.accessor("nickname")},getOrganization:function(){return this.accessor("organization")},getEmails:function(){return this.accessor("emails")},getIms:function(){return this.accessor("ims")},getPhoneNumbers:function(){return this.accessor("phoneNumbers")},
getPhotos:function(){return this.accessor("photos")},getAddresses:function(){return this.accessor("addresses")},getUrls:function(){return this.accessor("urls")},getNotes:function(){return this.accessor("notes")},getBirthday:function(){return this.accessor("birthday")},getAnniversary:function(){return this.accessor("anniversary")},getGender:function(){return this.accessor("gender")},getSearchTerms:function(){return this.accessor("searchTerms")},getReminder:function(){return this.accessor("reminder")},
getRelations:function(){return this.accessor("relations")},getRingtone:function(){return this.accessor("ringtone")},getCallAlert:function(){return this.accessor("callAlert")},getCallAction:function(){return this.accessor("callAction")},getMsgAlert:function(){return this.accessor("msgAlert")},getMsgRingtone:function(){return this.accessor("msgRingtone")},getIMsgAlert:function(){return this.accessor("iMsgAlert")},getIMsgRingtone:function(){return this.accessor("iMsgRingtone")},generateDisplayName:function(includeBasedOnField){return Utils.generateDisplayName(this,includeBasedOnField)},generateWorkInfoLine:function(){var arr=[],title=this.getOrganization().getTitle(),orgName=this.getOrganization().getName();if(title)arr.push(title);if(orgName)arr.push(orgName);return arr.join(", ")},reloadContacts:function(contactType){var future=null;contactType=contactType||
this.getDefaultContactType();future=Person.getLinkedContacts(this,contactType);future.then(this,function getContactsFromResultsAndSetOnPerson(){var contacts;contacts=future.result||[];this.setContacts(contacts);future.result=contacts});return future},clearFieldsForFixup:function(){this.getName().clear();this.getNames().clear();this.getNickname().clear();this.getOrganization().clear();this.getSearchTerms().clear();this.getEmails().clear();this.getPhoneNumbers().clear();this.getIms().clear();this.getAddresses().clear();
this.getUrls().clear();this.getNotes().clear();this.getBirthday().setValue("");this.getAnniversary().setValue("");this.getGender().setValue("");this.getPhotos().clear();this.getSortKey().setValue("");this.getRelations().clear()},fixup:function(otherPeopleBeingLinked,configParams){return this.fixupFromObjects(undefined,ContactType.EDITABLE,otherPeopleBeingLinked,configParams)},fixupNoReloadContacts:function(otherPeopleBeingLinked,configParams){return this.fixupFromObjects(this.getContacts(),ContactType.EDITABLE,
otherPeopleBeingLinked,configParams)},fixupFromObjects:function(contacts,contactType,otherPeopleBeingLinked,configParams){var future,allPeopleBeingLinked,dupeFavoriteBackupData,notDupeFavoriteBackupData,speedDialSaver,rawNewPersonPhotos,newListContactPhoto,wasAFavoriteFromBackups=false,timingRecorder=configParams&&configParams.timingRecorder||{startTimingForJob:function(){},stopTimingForJob:function(){}};if(!contacts){timingRecorder.startTimingForJob("Fixup_Reload_Contacts");future=this.reloadContacts()}else{future=
new Future;future.now(function(){future.result=true})}future.then(this,function doneLoadingContactsForPerson(){var tempResult;if(!contacts){timingRecorder.stopTimingForJob("Fixup_Reload_Contacts");contacts=[];tempResult=future.result;contacts=tempResult}otherPeopleBeingLinked=Array.isArray(otherPeopleBeingLinked)?_.clone(otherPeopleBeingLinked):[];allPeopleBeingLinked=[this].concat(otherPeopleBeingLinked);speedDialSaver=new SpeedDialSaver(allPeopleBeingLinked);timingRecorder.startTimingForJob("Fixup_Fetch_Favorite_Backups");
future.nest(Person._getAllFavoriteBackupsForPeople(allPeopleBeingLinked))});future.then(this,function(){timingRecorder.stopTimingForJob("Fixup_Fetch_Favorite_Backups");var contact,allFavoriteBackups=future.result,favoriteBackupDefaultSavers=[],tempDupeObject,tempFavoriteBackup,nameBeenCopied=false,nicknameCopied=false,birthdayCopied=false,anniversaryCopied=false,genderCopied=false,organizationCopied=false,i,name,nickname,organization,birthday,gender,anniversary,emailArray,phoneNumberArray,imArray,
addressesArray,urlsArray,relationsArray,note,numbersToAdd,dupSearchTermsHash={},dupEmailHash={},dupNumberHash={},dupImHash={},dupName={},dupAddressHash={},dupUrlsHash={},dupRelationsHash={},dupNotesHash={};for(i=0;i<allFavoriteBackups.length;i+=1){tempFavoriteBackup=allFavoriteBackups[i];if(tempFavoriteBackup){wasAFavoriteFromBackups=true;favoriteBackupDefaultSavers=favoriteBackupDefaultSavers.concat(tempFavoriteBackup.getDefaultPropertyHashes().getArray())}}tempDupeObject=Person._discoverFavoriteSaverBackupDupes(favoriteBackupDefaultSavers);
dupeFavoriteBackupData=tempDupeObject.dupes;notDupeFavoriteBackupData=tempDupeObject.notDupes;this.clearFieldsForFixup();timingRecorder.startTimingForJob("Fixup_Copying_And_De-dupping_Contact_Point_Data");for(i=0;i<contacts.length;i+=1){contact=contacts[i];if(contact){name=contact.getName();if(name.getFullName()!==""){if(!nameBeenCopied){this.getName().set(name);nameBeenCopied=true}this.getNames().add(Utils.dedupeEntries(dupName,[name],"getNormalizedHashKey"))}if(!nicknameCopied){nickname=contact.getNickname();
if(nickname.getValue()){this.getNickname().setValue(nickname.getValue());nicknameCopied=true}}if(!organizationCopied){organization=contact.getBestOrganization();if(organization){this.getOrganization().initialize(organization);organizationCopied=true}}this.getSearchTerms().add(Utils.dedupeEntries(dupSearchTermsHash,Utils.getSearchTermsFromContact(contact)));emailArray=contact.getEmails().getArray();if(emailArray)this.getEmails().add(Utils.dedupeEntries(dupEmailHash,emailArray,"getNormalizedHashKey"));
phoneNumberArray=contact.getPhoneNumbers().getArray();if(phoneNumberArray){numbersToAdd=Utils.dedupeEntries(dupNumberHash,phoneNumberArray,"getNormalizedHashKey");if(numbersToAdd)this.getPhoneNumbers().add(numbersToAdd)}imArray=contact.getIms().getArray();if(imArray)this.getIms().add(Utils.dedupeEntries(dupImHash,imArray,"getNormalizedHashKey"));addressesArray=contact.getAddresses().getArray();if(addressesArray)this.getAddresses().add(Utils.dedupeEntries(dupAddressHash,addressesArray,"getNormalizedHashKey"));
urlsArray=contact.getUrls().getArray();if(urlsArray)this.getUrls().add(Utils.dedupeEntries(dupUrlsHash,urlsArray,"getNormalizedHashKey"));relationsArray=contact.getRelations().getArray();if(relationsArray)this.getRelations().add(Utils.dedupeEntries(dupRelationsHash,relationsArray,"getNormalizedHashKey"));note=contact.getNote();if(note.getValue())this.getNotes().add(Utils.dedupeEntries(dupNotesHash,[note],"getNormalizedHashKey"));if(!birthdayCopied){birthday=contact.getBirthday().getValue();if(birthday){this.getBirthday().setValue(birthday);
birthdayCopied=true}}if(!anniversaryCopied){anniversary=contact.getAnniversary().getValue();if(anniversary){this.getAnniversary().setValue(anniversary);anniversaryCopied=true}}if(!genderCopied){gender=contact.getGender().getValue();if(gender){this.getGender().setValue(gender);genderCopied=true}}}}if(!nicknameCopied)this.getNickname().setValue("");timingRecorder.stopTimingForJob("Fixup_Copying_And_De-dupping_Contact_Point_Data");timingRecorder.startTimingForJob("Fixup_Generating_SortKey");future.nest(SortKey.generateSortKey(this,
configParams))});future.then(this,function(){timingRecorder.stopTimingForJob("Fixup_Generating_SortKey");var sortKey=future.result,contactPhotosArray,newListPhotoSource,squareContactPhoto,bigContactPhoto,squareContactPhotoPath="",bigContactPhotoPath="",squareContactPhotoId="",bigContactPhotoId="",splitFilePath,oldPhotos,contactWithNewPhotos;this.getSortKey().setValue(sortKey);timingRecorder.startTimingForJob("Fixup_Prepping_Photos");oldPhotos=this.getPhotos();contactWithNewPhotos=_.detect(contacts,
function(contact){return contact.getPhotos().getArray().length>0});if(!contactWithNewPhotos){rawNewPersonPhotos={};return{returnValue:true,skippedImageConvertCall:true}}contactPhotosArray=contactWithNewPhotos.getPhotos().getArray();squareContactPhoto=_.detect(contactPhotosArray,function(contactPhoto){return contactPhoto.getType()===ContactPhoto.TYPE.SQUARE&&contactPhoto.getLocalPath()});bigContactPhoto=_.detect(contactPhotosArray,function(contactPhoto){return contactPhoto.getType()===ContactPhoto.TYPE.BIG&&
contactPhoto.getLocalPath()});if(squareContactPhoto)newListContactPhoto=squareContactPhoto;else if(bigContactPhoto)newListContactPhoto=bigContactPhoto;else{console.warn("Contacts library: fixup - no square or big photo found on a contact with photos (maybe they had photo objs without local paths?).  Not storing a photo on the person.");rawNewPersonPhotos={};return{returnValue:true,skippedImageConvertCall:true}}newListPhotoSource=newListContactPhoto.getType();if(squareContactPhoto){squareContactPhotoPath=
squareContactPhoto.getLocalPath();squareContactPhotoId=squareContactPhoto.getDBObject()._id}if(bigContactPhoto){bigContactPhotoPath=bigContactPhoto.getLocalPath();bigContactPhotoId=bigContactPhoto.getDBObject()._id}if(newListPhotoSource===oldPhotos.getListPhotoSource()&&newListContactPhoto.getValue()===oldPhotos.getListPhotoSourcePath()){rawNewPersonPhotos={bigPhotoPath:bigContactPhotoPath,squarePhotoPath:squareContactPhotoPath,listPhotoPath:oldPhotos.getListPhotoPath(),listPhotoSource:newListPhotoSource,
bigPhotoId:bigContactPhotoId,squarePhotoId:squareContactPhotoId,contactId:contactWithNewPhotos.getId(),accountId:contactWithNewPhotos.getAccountId().getValue()};return{returnValue:true,skippedImageConvertCall:true}}else{rawNewPersonPhotos={bigPhotoPath:bigContactPhotoPath,squarePhotoPath:squareContactPhotoPath,listPhotoSource:newListPhotoSource,bigPhotoId:bigContactPhotoId,squarePhotoId:squareContactPhotoId,contactId:contactWithNewPhotos.getId(),accountId:contactWithNewPhotos.getAccountId().getValue()};
return{returnValue:true}}});future.then(this,function(){timingRecorder.stopTimingForJob("Fixup_Prepping_Photos");var result=future.result,cropFuture;if(result.skippedImageConvertCall)return result;else{timingRecorder.startTimingForJob("Fixup_Cropping_Photo_And_File_Cache");cropFuture=ContactPhoto.cropAndGetPath(newListContactPhoto.getLocalPath(),{},PersonPhotos.TYPE.LIST,timingRecorder);cropFuture.then(function(){var result;try{result=cropFuture.result}catch(ex){console.warn("Person fixup: cropping list photo and got error.  We're ignoring it.  "+
ex);result=""}timingRecorder.stopTimingForJob("Fixup_Cropping_Photo_And_File_Cache");return{returnValue:true,skippedImageConvertCall:false,pathResult:result}});return cropFuture}});future.then(this,function(){var result=future.result,otherPersonWithLauncherId,completeReminder,otherPersonWithRingtone,that=this;if(result&&result.returnValue)if(!result.skippedImageConvertCall)rawNewPersonPhotos.listPhotoPath=result.pathResult;else console.log("Contact library: fixup - photo cropping was not necessary");
else if(rawNewPersonPhotos.squarePhotoPath){rawNewPersonPhotos.listPhotoPath="";rawNewPersonPhotos.listPhotoSource=ContactPhoto.TYPE.SQUARE}else if(rawNewPersonPhotos.bigPhotoPath){rawNewPersonPhotos.listPhotoPath="";rawNewPersonPhotos.listPhotoSource=ContactPhoto.TYPE.BIG}this.getPhotos().reinitialize(rawNewPersonPhotos);timingRecorder.startTimingForJob("Fixup_Restoring_Person_Specific_Stuff");if(!this.getLauncherId().getValue()){otherPersonWithLauncherId=_.detect(otherPeopleBeingLinked,function(otherPerson){if(!otherPerson||
!otherPerson.getLauncherId())return false;return!!otherPerson.getLauncherId().getValue()});if(otherPersonWithLauncherId)this.getLauncherId().setValue(otherPersonWithLauncherId.getLauncherId().getValue())}completeReminder=allPeopleBeingLinked.reduce(function(accumulatedReminder,currentPerson){var currentReminder=currentPerson.getReminder().getValue();if(currentReminder)return accumulatedReminder?accumulatedReminder+". "+currentReminder:currentReminder;else return accumulatedReminder},"");this.getReminder().setValue(completeReminder);
if(!this.getRingtone().getName()||!this.getRingtone().getLocation()){otherPersonWithRingtone=_.detect(otherPeopleBeingLinked,function(otherPerson){if(!otherPerson||!otherPerson.getRingtone())return false;return!!otherPerson.getRingtone().getName()&&!!otherPerson.getRingtone().getLocation()});if(otherPersonWithRingtone){this.getRingtone().setName(otherPersonWithRingtone.getRingtone().getName());this.getRingtone().setLocation(otherPersonWithRingtone.getRingtone().getLocation())}}timingRecorder.stopTimingForJob("Fixup_Restoring_Person_Specific_Stuff");
timingRecorder.startTimingForJob("Fixup_Restoring_SpeedDials");speedDialSaver.restoreSpeedDials(this);return speedDialSaver.restoreSpeedDialsFromBackups(this)});future.then(this,function(){var dummy=future.result,backupDataToRestore=[],tempFavoriteBackup,tempFavoriteBackupType,anyPersonWasFavorite,i,contactPointDataObject={},contactPointArray,contactPointArrayIndex,tempContactPoint,that=this;timingRecorder.stopTimingForJob("Fixup_Restoring_SpeedDials");timingRecorder.startTimingForJob("Fixup_Restoring_Favorite_Data");
anyPersonWasFavorite=_.isArray(otherPeopleBeingLinked)?_.clone(otherPeopleBeingLinked):[];anyPersonWasFavorite=anyPersonWasFavorite.some(function(otherPerson){return otherPerson.isFavorite()});if(anyPersonWasFavorite||wasAFavoriteFromBackups)this.getFavorite().setValue(true);backupDataToRestore=backupDataToRestore.concat(dupeFavoriteBackupData);backupDataToRestore=backupDataToRestore.concat(notDupeFavoriteBackupData);for(i=0;i<backupDataToRestore.length;i+=1){tempFavoriteBackup=backupDataToRestore[i];
tempFavoriteBackupType=tempFavoriteBackup.getType();if(!contactPointDataObject[tempFavoriteBackupType])contactPointDataObject[tempFavoriteBackupType]=this._getContactPointArrayForType(tempFavoriteBackupType);contactPointArray=contactPointDataObject[tempFavoriteBackupType];for(contactPointArrayIndex=0;contactPointArrayIndex<contactPointArray.length;contactPointArrayIndex+=1){tempContactPoint=contactPointArray[contactPointArrayIndex];if(tempFavoriteBackup.isPlainValueEqual(tempContactPoint.getNormalizedValue())){tempContactPoint.setFavoriteData(tempFavoriteBackup.getFavoriteData());
break}}}Person.supportedFavoriteTypes.forEach(function(contactPointType){var contactPointPropertyArray=that._getContactPointArrayForType(contactPointType,true),contactPointArray=contactPointPropertyArray.getArray(),objectsToPromote=[];contactPointArray.forEach(function(contactPoint,currentIndex){if(contactPoint.hasFavoriteDataForAnyApp()){contactPointArray.splice(currentIndex,1);objectsToPromote.push(contactPoint)}});if(objectsToPromote.length>0){contactPointPropertyArray.clear();contactPointPropertyArray.add(objectsToPromote);
contactPointPropertyArray.add(contactPointArray)}});timingRecorder.stopTimingForJob("Fixup_Restoring_Favorite_Data");return this.getDBObject()});return future},watchForDatabaseChanges:function(){Assert.require(this.getId(),"watchForDatabaseChanges - cannot watch person that has no id");var query={from:this.getKind(),where:[{prop:"_id",op:"=",val:this.getId()}]},revId=this.getRev(),dbFuture;dbFuture=DB.find(query,true);dbFuture.then(function(){var result=Utils.DBResultHelper(dbFuture.result);if(result&&
Array.isArray(result))result=result[0];dbFuture.result=result});return dbFuture},stopWatchingForDatabaseChanges:function(future){PalmCall.cancel(future);return true},favoriteFixup:function(){},getDefaultContactType:function(){if(this instanceof PersonDisplay)return ContactType.DISPLAYABLE;else if(this instanceof PersonLinkable)return ContactType.LINKABLE;else return ContactType.EDITABLE},deletePerson:function(){var id=this.getId();Assert.require(id,"deletePerson unable to delete because there is no _id.");
return DB.del([id])},_addFavoriteBackupDBEntries:function(){var toMapReduce=[],tempBackup,future=new Future,that=this;if(this._isBeingSaved()){future.now(this,function(){return this.reloadContacts()});future.then(this,function(){var contacts=future.result;return Foundations.Control.mapReduce({map:function(contact){var mapFuture=new Future,linkHash;mapFuture.now(function(){return ContactLinkable.getLinkHash(contact)});mapFuture.then(function(){linkHash=mapFuture.result.linkHash;return FavoriteBackup.getBackupForLinkhash(linkHash)});
mapFuture.then(function(){var result=mapFuture.result,tempBackup;if(result)tempBackup=result;else tempBackup=new FavoriteBackup({contactBackupHash:linkHash,defaultPropertyHashes:[]});that._setAllDefaultsInBackup(tempBackup);toMapReduce.push({"function":tempBackup.save,object:tempBackup});return true});return mapFuture}},contacts)});future.then(this,function(){var result=future.result;return Utils.mapReduceAndVerifyResultsTrue(toMapReduce)});return future}else throw new Error("_addFavoriteBackupDBEntries: cannot call this method when the person is not being saved! Actually you probably shouldn't be calling this anyway!!");
},_updateFavoriteBackupDBEntries:function(){var toMapReduce=[],i,future,tempId,j,contacts,that=this;if(this._isBeingSaved()){future=new Future;future.now(this,function(){return this.reloadContacts()});future.then(this,function(){var result=future.result;contacts=result;contacts.forEach(function(contact){toMapReduce.push({"function":Utils.curry(FavoriteBackup.getBackupForContact,contact)})});return Utils.mapReduceAndReturnResults(toMapReduce)});future.then(this,function(){var favoriteBackups=future.result,
i,tempBackup;toMapReduce=[];return Foundations.Control.mapReduce({map:function(tempBackup){var mapFuture=new Future;mapFuture.now(function(){if(tempBackup)return tempBackup.getContactBackupHashContactId();else{console.log("_updateFavoriteBackupDBEntries: One of the backup entries for this person did not exist in the database.");console.log("_updateFavoriteBackupDBEntries (cont.d): Instead of failing we will go ahead and add this missing entry.");return null}});mapFuture.then(function(){var result=
mapFuture.result;if(result){for(j=0;j<contacts.length;j+=1)if(result===contacts[j].getId())contacts.splice(j,1);that._setAllDefaultsInBackup(tempBackup);toMapReduce.push({"function":tempBackup.save,object:tempBackup})}return true});return mapFuture}},favoriteBackups)});future.then(this,function(){var result=future.result;return Foundations.Control.mapReduce({map:function(contact){var mapFuture=new Future;mapFuture.now(function(){return ContactLinkable.getLinkHash(contact)});mapFuture.then(function(){var result=
mapFuture.result.linkHash,tempBackup;tempBackup=new FavoriteBackup({contactBackupHash:result,defaultPropertyHashes:[]});that._setAllDefaultsInBackup(tempBackup);toMapReduce.push({"function":tempBackup.save,object:tempBackup})});return mapFuture}},contacts)});future.then(this,function(){var result=future.result;return Utils.mapReduceAndVerifyResultsTrue(toMapReduce)});return future}else throw new Error("_updateFavoriteBackupDBEntries: cannot call this method when the person is not being saved! Actually you probably shouldn't be calling this anyway!!");
},_setAllDefaultsInBackup:function(favoriteBackup){var currentSupportedType,tempDefaults,tempDefault,i,j;for(i=0;i<Person.supportedFavoriteTypes.length;i+=1){currentSupportedType=Person.supportedFavoriteTypes[i];tempDefaults=this._getDefaultContactPointsForTypeAndAppId(currentSupportedType);for(j=0;j<tempDefaults.length;j+=1){tempDefault=tempDefaults[j];favoriteBackup.setDefaultForContactPointType(tempDefault.getNormalizedValue(),currentSupportedType,tempDefault.getFavoriteData())}}},_removeFavoriteBackupDBEntries:function(){var toMapReduce=
[],future=new Future;if(this._isBeingSaved()){future.now(this,function(){return this.reloadContacts()});future.then(this,function(){var contacts=future.result;contacts.forEach(function(contact){toMapReduce.push({"function":Utils.curry(FavoriteBackup.removeBackupForContact,contact)})});return Utils.mapReduceAndVerifyResultsTrue(toMapReduce)});return future}else throw new Error("_removeFavoriteBackupDBEntries: cannot call this method when the person is not being saved! Actually you probably shouldn't be calling this anyway!!");
},save:function(){if(!this._isBeingSaved()){this._setBeingSaved(true);var future;if(this.getId())future=DB.merge([this.getDirtyDBObject()]);else future=DB.put([this.getDBObject()]);future.then(this,function(future){var result=Utils.DBResultHelper(future.result),favoriteValue=this.getFavorite().getValue(),updatingFavorites=false;Assert.require(result,"savePerson put - result is null");Assert.requireArray(result,"savePerson put - result is not an array");Assert.require(result.length,"savePerson put - result length is zero");
if(favoriteValue)if(this.hasInstantiationFavoriteValueChanged()||!this.getId()){updatingFavorites=true;future.nest(this._addFavoriteBackupDBEntries())}else{if(this._hasFavoriteDefaultsChanged()){updatingFavorites=true;future.nest(this._updateFavoriteBackupDBEntries())}}else if(this.hasInstantiationFavoriteValueChanged()&&this.getId()){updatingFavorites=true;future.nest(this._removeFavoriteBackupDBEntries())}this.setId(result[0].id);this.setRev(result[0].rev);this.markNotDirty();if(!updatingFavorites)future.result=
true}).then(this,function(future){var result=future.result,speedDialSaver;speedDialSaver=new SpeedDialSaver(this);return speedDialSaver.saveBackupRecordsForSpeedDials()}).then(this,function(future){var result=true;if(future&&!future.result){console.log("Person save ERROR!: Updating the favorites data failed");result=false}else{this._updateInstantiationFavoriteValueToCurrentState();this._markFavoriteDefaultsUnChanged()}this._setBeingSaved(false);future.result=result});return future}throw new Error("You can't call save on a person that is currently being saved");
},_savePersonAttachingTheseContacts:function(newContacts,callSaveContactInDBOnly){Assert.requireDefined(newContacts,"You must pass an array of contacts to _savePersonAttachingTheseContacts");Assert.requireArray(newContacts,"The parameter to _savePersonAttachingTheseContacts must be an array");Assert.require(newContacts.length>0,"There must be contacts in the param to use _savePersonAttachingTheseContacts");var future=new Future,contactsToGetIds=[],contactIds=[],reservedContactIds,contactsToSave=[],
newContactIds=[],i,contactSaveFutureFunction,saveSuccessful=true;if(!this._isBeingSaved()){this._setBeingSaved(true);future.now(this,function(){for(i=0;i<newContacts.length;i+=1)if(newContacts[i].getId()){contactIds.push(newContacts[i].getId());contactsToSave.push(newContacts[i]);newContacts.splice(i,1)}if(newContacts.length>0)future.nest(DB.reserveIds(newContacts.length));else future.result={ids:[]}});future.then(this,function(){var result=future.result;reservedContactIds=result.ids;if(reservedContactIds.length!==
newContacts.length)throw new Error("_savePersonAttachingTheseContacts failed because there were not enough reserved ids return to give to all the contacts");for(i=0;i<newContacts.length;i+=1){newContacts[i].setId(reservedContactIds[i]);contactIds.push(reservedContactIds[i]);contactsToSave.push(newContacts[i])}if(this.getContacts().length===0)future.nest(this.reloadContacts());else future.result=true});future.then(this,function(){this.getContactIds().clear();this.getContactIds().add(contactIds);future.nest(this.fixupFromObjects(this.getContacts().concat(newContacts),
ContactType.EDITABLE))});future.then(this,function(){this._setBeingSaved(false);future.nest(this.save())});future.then(this,function(){var result=future.result,toMapReduce=[];if(result){for(i=0;i<contactsToSave.length;i+=1)if(callSaveContactInDBOnly&&contactsToSave[i].saveContactInDBOnly)toMapReduce.push({"function":contactsToSave[i].saveContactInDBOnly,object:contactsToSave[i]});else toMapReduce.push({"function":contactsToSave[i].save,object:contactsToSave[i]});future.nest(Utils.mapReduceAndVerifyResultsTrue(toMapReduce))}else{console.log("There was an error saving person from _savePersonAttachingTheseContacts");
this._setBeingSaved(true);saveSuccessful=false;future.nest(this._removeFavoriteBackupDBEntries())}});future.then(this,function(){var result=future.result;this._setBeingSaved(false);if(result&&saveSuccessful)future.result=true;else future.result=false});return future}throw new Error("You can't call _savePersonAttachingTheseContacts on a person that is currently being saved");},toString:function(){return JSON.stringify(this.getDBObject())},isDirty:function(){return Utils.callFunctionsOnProperties(this.accessor,
Person.PROPERTIES.objects,"isDirty",Person.PROPERTIES.arrays,"containsDirtyEntry")},markNotDirty:function(){Utils.callFunctionsOnProperties(this.accessor,Person.PROPERTIES.objects,"markNotDirty",Person.PROPERTIES.arrays,"markElementsNotDirty")},equals:function(otherPerson){var isEqual=true,i,j,tempArray,otherTempArray,property="",properties=Person.PROPERTIES.objects,propertyArrays=Person.PROPERTIES.arrays;Assert.require(otherPerson instanceof Person,"The object passed into equals must be an instance of Person");
for(i=0;i<properties.length;i+=1){property=properties[i];isEqual=isEqual&&this.accessor(property).equals(otherPerson.accessor(property))}for(j=0;j<propertyArrays.length;j+=1){property=propertyArrays[j];tempArray=this.accessor(property).getArray();otherTempArray=otherPerson.accessor(property).getArray();for(i=0;i<tempArray.length;i+=1)isEqual=isEqual&&tempArray[i].equals(otherTempArray[i])}return isEqual},setCroppedContactPhoto:function(path,cropInfo,photoType){var future,param={};param.personId=this.getId();
param.path=path;param.cropInfo=cropInfo;param.photoType=photoType;future=PalmCall.call("palm://com.palm.service.contacts/","setCroppedContactPhoto",param);future.then(function(){var result=future.result;PalmCall.cancel(future);future.result=result});return future},stripTmpPhoneNumberField:function(obj){var i,phoneNumber,contacts,contact,future;if(obj.length>0){this.getPhoneNumbers().clear();for(i=0;i<obj.length;i+=1){this.getPhoneNumbers().add(new PhoneNumber);phoneNumber=this.getPhoneNumbers().getArray()[i];
phoneNumber.setValue(obj[i].value?obj[i].value:phoneNumber.getValue());phoneNumber.setType(obj[i].type?obj[i].type:phoneNumber.getType());phoneNumber.setPrimary(obj[i].primary?obj[i].primary:phoneNumber.getPrimary());phoneNumber.setNormalizedValue(obj[i].normalizedValue?obj[i].normalizedValue:phoneNumber.getNormalizedValue());phoneNumber.setSpeedDial(obj[i].speedDial?obj[i].speedDial:phoneNumber.getSpeedDial())}future=Person.getLinkedContacts(this,ContactType.RAWOBJECT);future.then(this,function(){contacts=
future.result||[];for(i=0;i<contacts.length;i+=1){contact=new Contact(contacts[0]);contact.stripTmpPhoneNumberField();contact.save()}future.result=contacts});return future}}});Utils.defineConstant("kind","com.palm.person:1",Person);Person.PROPERTIES={objects:["favorite","sortKey","name","nickname","organization","photos","reminder","ringtone","callAlert","callAction","msgAlert","msgRingtone","iMsgAlert","iMsgRingtone"],arrays:["contactIds","names","searchTerms","emails","phoneNumbers","ims"]};
Person.generateDisplayNameFromRawPerson=function(rawPerson,includeBasedOnField){var obj=rawPerson,displayName="",basedOnField=null,fullName=Name.getFullNameFromRawObject(obj.name),org;if(fullName){displayName=fullName;basedOnField=DisplayNameType.NAME}else if(obj.nickname){displayName=obj.nickname;basedOnField=DisplayNameType.NICKNAME}if(!displayName&&obj.organization)if(obj.organization.title&&obj.organization.name){displayName=obj.organization.title+", "+obj.organization.name;basedOnField=DisplayNameType.TITLE_AND_ORGANIZATION_NAME}else if(!obj.organization.title&&
obj.organization.name){displayName=obj.organization.name;basedOnField=DisplayNameType.ORGANIZATION_NAME}else if(obj.organization.title&&!obj.organization.name){displayName=obj.organization.title;basedOnField=DisplayNameType.TITLE}if(!displayName)if(obj.emails&&obj.emails.length){displayName=obj.emails[0].value;basedOnField=DisplayNameType.EMAIL}else if(obj.ims&&obj.ims.length){displayName=obj.ims[0].value;basedOnField=DisplayNameType.IM}else if(obj.phoneNumbers&&obj.phoneNumbers.length){displayName=
obj.phoneNumbers[0].value;basedOnField=DisplayNameType.PHONE}else{displayName=RB.$L("[No Name Available]");basedOnField=DisplayNameType.NONE}if(includeBasedOnField)return{displayName:displayName,basedOnField:basedOnField};else return displayName};Person.getDisplayablePersonAndContactsById=function(id){return Person.getPersonAndContactsById(id,PersonType.DISPLAYABLE,ContactType.DISPLAYABLE)};
Person.getLinkablePersonAndContactsById=function(id){return Person.getPersonAndContactsById(id,PersonType.LINKABLE,ContactType.LINKABLE)};
Person.getPersonAndContactsById=function(id,personType,contactType){Assert.requireString(id,"getPersonAndContactsById requires an id that is a String");Assert.requireString(personType,"getPersonAndContactsById requires a person type that is a String");Assert.requireString(contactType,"getPersonAndContactsById requires a contact type that is a String");var person=null,contacts=null;return Person.findById(id,personType).then(function(personFuture){person=personFuture.result;Assert.require(person,"Unable to find person by Id");
personFuture.nest(Person.getLinkedContacts(person,contactType))}).then(function(contactFuture){contacts=contactFuture.result||[];person.setContacts(contacts);contactFuture.result=person})};
Person.getLinkedContacts=function(person,contactType){Assert.require(person instanceof Person,"getLinkedContacts requires a decorated person arg");Assert.requireString(contactType,"getContacts requires a contactType that is a string");return DB.get(person.getContactIds().getDBObject()).then(function(theFuture){var contacts=Utils.DBResultHelper(theFuture.result)||[],decoratedContacts=[],i;for(i=0;i<contacts.length;i=i+1)decoratedContacts.push(ContactFactory.create(contactType,contacts[i]));theFuture.result=
decoratedContacts})};Person.manualLink=function(personToLinkTo,personToLink){Assert.requireDefined(personToLinkTo,"manualLink: missing required argument - personToLinkTo");Assert.requireDefined(personToLink,"manualLink: missing required argument - personToLink");var future=PalmCall.call("palm://com.palm.service.contacts.linker/","manualLink",{personToLinkTo:personToLinkTo,personToLink:personToLink});future.then(function(){var result=future.result;PalmCall.cancel(future);future.result=result});return future};
Person.manualUnlink=function(personToRemoveLinkFrom,contactToRemoveFromPerson){Assert.requireDefined(personToRemoveLinkFrom,"manualUnlink: missing required argument - personToRemoveLinkFrom");Assert.requireDefined(contactToRemoveFromPerson,"manualUnlink: missing required argument - contactToRemoveFromPerson");var future=PalmCall.call("palm://com.palm.service.contacts.linker/","manualUnlink",{personToRemoveLinkFrom:personToRemoveLinkFrom,contactToRemoveFromPerson:contactToRemoveFromPerson});future.then(function(){var result=
future.result;PalmCall.cancel(future);future.result=result});return future};Person.favoritePerson=function(param){var future=PalmCall.call("palm://com.palm.service.contacts/","favoritePerson",param);future.then(function(){var result=future.result;PalmCall.cancel(future);future.result=result});return future};
Person._favoritePerson=function(param,applicationID){var personId,defaultData,personToFavorite,future=new Future;future.now(function(){personId=param.personId;defaultData=param.defaultData;future.nest(Person._getPersonAndSetFavoriteValueTo(personId,true))});future.then(function(){personToFavorite=future.result;if(defaultData)future.nest(Person._setFavoriteDefault(param,applicationID));else future.result=true});future.then(function(){var result=future.result;future.nest(personToFavorite.save())});
return future};Person.setFavoriteDefault=function(param){var future=PalmCall.call("palm://com.palm.service.contacts/","setFavoriteDefault",param);future.then(function(){var result=future.result;PalmCall.cancel(future);future.result=result});return future};
Person._setFavoriteDefault=function(param,applicationID){var personId,defaultData,personToSetDefaultOn,defaultsForApp,contactPointType,listIndex,value,i,future=new Future;future.now(function(){var contactPointTypeIsSupported=false;Assert.requireDefined(applicationID,"_setFavoriteDefault: missing required argument - applicationID");applicationID=applicationID.split(" ")[0];personId=param.personId;Assert.requireDefined(personId,"_setFavoriteDefault: missing required argument - personId");defaultData=
param.defaultData;Assert.requireDefined(defaultData,"_setFavoriteDefault: missing required argument - defaultData");contactPointType=defaultData.contactPointType;listIndex=defaultData.listIndex;value=defaultData.value;Assert.requireDefined(contactPointType,"_setFavoriteDefault: missing required defaultData property - contactPointType");contactPointTypeIsSupported=Person.supportedFavoriteTypes.some(function(supportedFavoriteType){return contactPointType===supportedFavoriteType});Assert.require(contactPointTypeIsSupported,
"_setFavoriteDefault: unsupported contact point type specified");Assert.requireDefined(listIndex,"_setFavoriteDefault: missing required defaultData property - listIndex");Assert.requireDefined(value,"_setFavoriteDefault: missing required defaultData property - value");future.nest(Person.findById(personId))});future.then(function(){var setDefaultSuccess=false,defaultContactPointsForApp,tempDefaultContactPointForApp,normalizedValueForContactPoint;personToSetDefaultOn=future.result;Assert.requireDefined(personToSetDefaultOn,
"_setFavoriteDefault: could not find the person with id - "+personId);Assert.require(personToSetDefaultOn.isFavorite(),"_setFavoriteDefault: cannot set a default on a person that is not a favorite");normalizedValueForContactPoint=Person._getNormalizedValueForContactPointType(contactPointType,value);setDefaultSuccess=personToSetDefaultOn._setDefaultForContactPointType(contactPointType,normalizedValueForContactPoint,applicationID,listIndex,defaultData.auxData);if(setDefaultSuccess){defaultContactPointsForApp=
personToSetDefaultOn._getDefaultContactPointsForTypeAndAppId(undefined,applicationID);for(i=0;i<defaultContactPointsForApp.length;i+=1){tempDefaultContactPointForApp=defaultContactPointsForApp[i];if(tempDefaultContactPointForApp.getNormalizedValue()!==normalizedValueForContactPoint)tempDefaultContactPointForApp.removeFavoriteDefaultForAppWithId(applicationID)}personToSetDefaultOn._markFavoriteDefaultsChanged();future.nest(personToSetDefaultOn.save())}else throw new Error("Setting favorite default on person - "+
personId+" - failed! Could not find a contact point with value - "+value+" - on person");});return future};Person.unfavoritePerson=function(param){var future=PalmCall.call("palm://com.palm.service.contacts/","unfavoritePerson",param);future.then(function(){var result=future.result;PalmCall.cancel(future);future.result=result});return future};
Person._unfavoritePerson=function(param){var personId,future=new Future,personToUnfavorite;future.now(function(){personId=param.personId;future.nest(Person._getPersonAndSetFavoriteValueTo(personId,false))});future.then(function(){personToUnfavorite=future.result;Person._removeFavoriteDefaults(personToUnfavorite);future.nest(personToUnfavorite.save())});return future};
Person._setCroppedContactPhotoPerson=function(param){var personId=param.personId,contact,future=new Future;future.now(function(){console.log("Person._setCroppedContactPhotoPerson finding person for person ID: "+personId);return Person.getDisplayablePersonAndContactsById(personId)});future.then(function(){var personToSet=future.result;contact=personToSet.getContacts()[0];return contact.setCroppedContactPhoto(param.path,param.cropInfo,param.photoType)});future.then(function(){var result=future.result;
return contact.save()});return future};Person._removeFavoriteDefaults=function(person){Assert.require(person,"Person passed to _removeFavoriteDefaults must be defined");var i,defaults,tempDefault;defaults=person._getDefaultContactPointsForTypeAndAppId();for(i=0;i<defaults.length;i+=1){tempDefault=defaults[i];tempDefault.removeAllFavoriteData()}};
Person._discoverFavoriteSaverBackupDupes=function(favoriteSavers){var i,j,tempSaverA,tempSaverAValue,tempSaverAType,tempSaverB,dupes=[],dupesDifferentFavoriteData=[],notDupes=[],wasDupe=false,tempSaverBType;Assert.requireArray(favoriteSavers,"You must pass in a valid array to Person._removeFavoriteSaverDupes");for(i=0;i<favoriteSavers.length;i+=1){wasDupe=false;tempSaverA=favoriteSavers[i];tempSaverAValue=tempSaverA.getValue();tempSaverAType=tempSaverA.getType();for(j=i+1;j<favoriteSavers.length;j+=
1){tempSaverB=favoriteSavers[j];tempSaverBType=tempSaverB.getType();if(tempSaverAValue===tempSaverB.getValue()&&tempSaverAType===tempSaverBType){wasDupe=true;if(_.isEqual(tempSaverA.getFavoriteData(),tempSaverB.getFavoriteData()))dupes.push(tempSaverA);else{dupesDifferentFavoriteData.push(tempSaverA);dupesDifferentFavoriteData.push(tempSaverB)}}}if(!wasDupe)notDupes.push(tempSaverA)}return{dupesDifferentFavoriteData:dupesDifferentFavoriteData,dupes:dupes,notDupes:notDupes}};
Person._getAllFavoriteBackupsForPeople=function(people){var contactIds=[],tempContactIds,i,j,future=new Future,toMapReduce=[];future.now(function(){Assert.requireArray(people,"You must pass in a valid array to Person._getAllFavoriteBackupsForPeople");for(i=0;i<people.length;i+=1){tempContactIds=people[i].getContactIds().getArray();for(j=0;j<tempContactIds.length;j+=1)contactIds.push(tempContactIds[j].getValue())}contactIds=_.uniq(contactIds)||[];return DB.get(contactIds).then(function(theFuture){var contacts=
Utils.DBResultHelper(theFuture.result)||[],decoratedContacts=[];contacts.forEach(function(contact){decoratedContacts.push(new Contact(contact))});return decoratedContacts})});future.then(function(){var result=future.result,contacts=result;contacts.forEach(function(contact){toMapReduce.push({"function":Utils.curry(FavoriteBackup.getBackupForContact,contact)})});return Utils.mapReduceAndReturnResults(toMapReduce)});return future};
Person._getPersonAndSetFavoriteValueTo=function(personId,favoriteValue){var future=new Future;future.now(function(){Assert.requireDefined(personId,"_getPersonAndSetFavoriteValueTo: missing required argument - personId");future.nest(Person.findById(personId))});future.then(function(){var person=future.result;Assert.requireDefined(person,"_getPersonAndSetFavoriteValueTo: could not find the person with id - "+personId);person.getFavorite().setValue(favoriteValue);future.result=person});return future};
Person._getNormalizedValueForContactPointType=function(contactPointType,value){var toReturn=value;switch(contactPointType){case ContactPointTypes.PhoneNumber:toReturn=PhoneNumber.normalizePhoneNumber(value);break;case ContactPointTypes.EmailAddress:toReturn=EmailAddress.normalizeEmail(value);break;case ContactPointTypes.IMAddress:toReturn=IMAddress.normalizeIm(value);break}return toReturn};
Person.getReminder=function(personId){Assert.requireString(personId,"Person.getReminder requires an id that is a string");return Person.findById(personId).then(function(getPersonFuture){var person=getPersonFuture.result;getPersonFuture.result=person.getReminder().getValue()})};
Person.findById=function(id,personType){var future=new Future;future.now(function(){personType=personType||PersonType.DISPLAYABLE;Assert.requireString(id,"Person.findById requires an id that is a string");Assert.requireString(personType,"Person.findById requires a personType that is a string");future.nest(DB.get([id]))});future.then(function(){var result=Utils.DBResultHelper(future.result);if(result&&result[0]&&result[0]._kind===Person.kind)future.result=PersonFactory.create(result[0],personType);
else future.result=undefined});return future};
Person.findByEmail=function(emailAddress,params){var future=new Future,personType,normalizedEmail;future.now(function(){params=params||{};Assert.requireString(emailAddress,"Person.findByEmail requires an email address that is a string");personType=params.personType||PersonType.DISPLAYABLE;Assert.requireString(personType,"Person.findByEmail requires a personType that is a string");normalizedEmail=EmailAddress.normalizeEmail(emailAddress);var where=[{prop:"emails.normalizedValue",op:"=",val:normalizedEmail}];
return Person._find(where,true,PersonType.RAWOBJECT)});future.then(function(){var potentiallyMatchingPersons=future.result,curPerson,i,matchesToReturn=[],match,matchingEmail,compareNormValue=function(email){return email.normalizedValue===normalizedEmail};if(!potentiallyMatchingPersons||potentiallyMatchingPersons.length===0)return Person._findByReturnEmpty(params.returnAllMatches);for(i=0;i<potentiallyMatchingPersons.length;i+=1){curPerson=potentiallyMatchingPersons[i];matchingEmail=_.detect(curPerson.emails,
compareNormValue);if(matchingEmail){match=Person._findByGenerateReturnValue(params.includeMatchingItem,personType,EmailAddressExtended,curPerson,matchingEmail);if(params.returnAllMatches)matchesToReturn.push(match);else return match}}if(matchesToReturn.length===0)return Person._findByReturnEmpty(params.returnAllMatches);else return matchesToReturn});return future};
Person.findByIM=function(imAddress,type,params){var future=new Future,normalizedIMAddress,personType;future.now(function(){var where;params=params||{};Assert.requireString(imAddress,"Person.findByIM requires an im address that is a string");if(type)Assert.requireString(type,"Person.findByIM requires the provided service name be a string");personType=params.personType||PersonType.DISPLAYABLE;Assert.requireString(personType,"Person.findByIM requires a personType that is a string");normalizedIMAddress=
IMAddress.normalizeIm(imAddress);where=[{prop:"ims.normalizedValue",op:"=",val:normalizedIMAddress}];return Person._find(where,true,PersonType.RAWOBJECT)});future.then(function(){var potentiallyMatchingPersons=future.result,curPerson,i,matchesToReturn=[],match,matchingIM,compareNormValueAndType=function(im){return im.normalizedValue===normalizedIMAddress&&(!type||im.type===type)};if(!potentiallyMatchingPersons||potentiallyMatchingPersons.length===0)return Person._findByReturnEmpty(params.returnAllMatches);
for(i=0;i<potentiallyMatchingPersons.length;i+=1){curPerson=potentiallyMatchingPersons[i];matchingIM=_.detect(curPerson.ims,compareNormValueAndType);if(matchingIM){match=Person._findByGenerateReturnValue(params.includeMatchingItem,personType,IMAddressExtended,curPerson,matchingIM);if(params.returnAllMatches)matchesToReturn.push(match);else return match}}if(matchesToReturn.length===0)return Person._findByReturnEmpty(params.returnAllMatches);else return matchesToReturn});return future};
Person.findByPhone=function(phoneNumber,params){var future=new Future,parsedPhoneNumber,personType;future.now(function(){params=params||{};Assert.requireString(phoneNumber,"Person.findByPhone requires a phone number that is a string");personType=params.personType||PersonType.DISPLAYABLE;Assert.requireString(personType,"Person.findByPhone requires a personType that is a string");var normalizedPhoneNumber,where;parsedPhoneNumber=Globalization.Phone.parsePhoneNumber(phoneNumber,undefined,params.mcc);
if(!parsedPhoneNumber)return null;normalizedPhoneNumber=PhoneNumber.normalizePhoneNumber(parsedPhoneNumber,true);if(!normalizedPhoneNumber)return null;where=[{prop:"phoneNumbers.normalizedValue",op:"%",val:normalizedPhoneNumber}];return Person._find(where,true,PersonType.RAWOBJECT)});future.then(function(){var potentiallyMatchingPersons=future.result,potentiallyMatchingPerson,realMatches,i,j,pmpPhoneNumbers,pmpPhoneNumber,parsedPmpPhoneNumber,matchQuality,match;if(!potentiallyMatchingPersons||potentiallyMatchingPersons.length===
0)return Person._findByReturnEmpty(params.returnAllMatches);realMatches=[];for(i=0;i<potentiallyMatchingPersons.length;i+=1){potentiallyMatchingPerson=potentiallyMatchingPersons[i];pmpPhoneNumbers=potentiallyMatchingPerson.phoneNumbers;for(j=0;j<pmpPhoneNumbers.length;j+=1){pmpPhoneNumber=pmpPhoneNumbers[j];parsedPmpPhoneNumber=Globalization.Phone.parsePhoneNumber(pmpPhoneNumber.value);matchQuality=Globalization.Phone.comparePhoneNumbers(parsedPhoneNumber,parsedPmpPhoneNumber);if(matchQuality>0){match=
Person._findByGenerateReturnValue(params.includeMatchingItem,personType,PhoneNumberExtended,potentiallyMatchingPerson,pmpPhoneNumber);if(params.returnAllMatches)realMatches.push({match:match,quality:matchQuality});else return match}}}if(realMatches.length===0)return Person._findByReturnEmpty(params.returnAllMatches);else{realMatches.sort(function(elem1,elem2){return elem1.quality-elem2.quality});return realMatches.map(function(elem){return elem.match})}});return future};
Person._findByGenerateReturnValue=function(includeMatchingItem,personType,ItemConstructor,person,item){if(personType!==PersonType.RAWOBJECT)item=new ItemConstructor(item);if(includeMatchingItem)return{person:PersonFactory.create(person,personType),item:item};else return PersonFactory.create(person,personType)};Person._findByReturnEmpty=function(returnAllMatches){if(returnAllMatches)return[];else return null};
Person._find=function(where,returnAllMatches,personType){var future=DB.find({from:Person.kind,where:where});personType=personType||PersonType.DISPLAYABLE;Assert.requireString(personType,"Person._find requires a personType that is a string");future.then(function(future){var result=future.result;if(!result||!result.results||result.results.length===0)return null;if(returnAllMatches)return result.results.map(function(person){return PersonFactory.create(person,personType)});else return PersonFactory.create(result.results[0],
personType)});return future};Person.getContactIdsFromLauncherCallbackId=function(launcherCallbackId){Assert.requireString(launcherCallbackId,"Person.getContactIdsFromLauncherCallbackId requires launcherCallbackId to be a string");return launcherCallbackId.split(Person.DELIMITER)};
Person.findByContactIds=function(contactIds,personType){var future=new Future;future.now(function(){var where;Assert.requireArray(contactIds,"Person.findByContactIds requires a contactIds parameter that is an array");personType=personType||PersonType.DISPLAYABLE;Assert.requireString(personType,"Person.findByContactIds requires a personType parameter that is a string");Assert.require(personType!==PersonType.RAWOBJECT,"Person.findByContactIds does not allow personType of RAWOBJECT");where={prop:"contactIds",
op:"=",val:contactIds};return Person._find([where],true,personType)});future.then(function(){var result=future.result,personsAlreadySeen={},bestPersonMatch,mostMatchedContactIdsCount=0;if(result&&result.length>0){result.some(function(person){var personsContactIds,matchedContactIdsCount;if(personsAlreadySeen[person.getId()])return false;personsContactIds=person.getContactIds().getArray();personsContactIds=personsContactIds.map(function(contactId){return contactId.getValue()});if(personsContactIds.indexOf(contactIds[0])>=
0){bestPersonMatch=person;return true}else{matchedContactIdsCount=_.intersect(personsContactIds,contactIds).length;if(matchedContactIdsCount>mostMatchedContactIdsCount){bestPersonMatch=person;mostMatchedContactIdsCount=matchedContactIdsCount}personsAlreadySeen[person.getId()]=true}return false});return bestPersonMatch}else return null});return future};
Person.orderContactIds=function(person,otherPeopleToMerge,newContactToMerge){var arraysToSort=[],primaryContactToSave,tempContactsArray,fingerWalkerSorter,sortedContacts,sortedContactIds;tempContactsArray=person.getContacts();if(newContactToMerge)arraysToSort.push([newContactToMerge]);else primaryContactToSave=tempContactsArray.shift();arraysToSort.push(tempContactsArray);if(otherPeopleToMerge&&_.isArray(otherPeopleToMerge))otherPeopleToMerge.forEach(function(personToMerge){arraysToSort.push(personToMerge.getContacts())});
fingerWalkerSorter=new FingerWalkerSorter(arraysToSort,Person.contactOrderComparator);sortedContacts=fingerWalkerSorter.sort();sortedContactIds=_.map(sortedContacts,function(contact){return contact.getId()});if(primaryContactToSave)sortedContactIds.splice(0,0,primaryContactToSave.getId());return sortedContactIds};
Person.contactOrderComparator=function(contactsToCompare){var lowestContactPriorityValue,lowestIndex,getPriorityValue=function(contact){var priorityValue=Person.SYNC_SOURCE_PRIORITY_LIST[contact.getKindName()];if(priorityValue===undefined)priorityValue=Person.SYNC_SOURCE_PRIORITY_LIST.thirdParty;return priorityValue};contactsToCompare.forEach(function(contactToCompare,currentIndex){var tempContactPriorityValue;if(lowestIndex===undefined){lowestContactPriorityValue=getPriorityValue(contactToCompare);
lowestIndex=currentIndex;return}tempContactPriorityValue=getPriorityValue(contactToCompare);if(tempContactPriorityValue<lowestContactPriorityValue){lowestContactPriorityValue=tempContactPriorityValue;lowestIndex=currentIndex}});return lowestIndex};Person.supportedFavoriteTypes=[ContactPointTypes.PhoneNumber,ContactPointTypes.EmailAddress,ContactPointTypes.IMAddress];
Person.SYNC_SOURCE_PRIORITY_LIST={"com.palm.contact.linkedin":1,"com.palm.contact.facebook":2,"com.palm.contact.eas":3,"com.palm.contact.palmprofile":4,thirdParty:5,"com.palm.contact.google":6,"com.palm.contact.yahoo":7,"com.palm.contact.sim":8,"com.palm.contact.attaddresssync":9,"com.palm.contact.skype":10,"com.palm.contact.libpurple":11,"com.palm.contact.imyahoo":12};Person.DELIMITER=":(|)";exports.Person=Person;var PersonDisplay=exports.PersonDisplay=Class.create(Person,{initialize:function initialize(rawPerson){this.$super(initialize)(rawPerson);this._init();if(rawPerson)this.generateDisplayParams()},_init:function(){this.displayName="";this.fullName="";this.nickname="";this.workInfoLine="";this.contactCount="";this.isFavoriteClass=""},generateDisplayParams:function(){var photos,contactIds,displayNameData=this.generateDisplayName(true),listPhotoPath,squarePhotoPath;this.displayName=displayNameData.displayName;
this.fullName=this.getName().getFullName()||this.displayName;this.workInfoLine=displayNameData.basedOnField!==DisplayNameType.TITLE_AND_ORGANIZATION_NAME&&displayNameData.basedOnField!==DisplayNameType.ORGANIZATION_NAME&&displayNameData.basedOnField!==DisplayNameType.TITLE?this.generateWorkInfoLine():"";this.nickname=displayNameData.basedOnField===DisplayNameType.NICKNAME?"":this.getNickname().getValue();this.headerPhotoPath=this.getPhotos().getSquarePhotoPath()||PersonPhotos.DEFAULT_DETAILS_AVATAR;
this.imageId="contactImage_"+this.getId();if(this.isFavorite()){this.favoritesHeaderClass=PersonDisplay.FAVORITES_HEADER_CLASS;this.favoriteIcon=PersonDisplay.FAVORITE_ICON;this.favoriteClass="favorite"}contactIds=this.getContactIds().getArray();this.contactCount=contactIds.length;if(!contactIds||contactIds.length<=1)this.hideContactCountClass=PersonDisplay.HIDE_CONTACT_COUNT_CLASS},toggleFavoriteAppearance:function(newFavoriteState){if(newFavoriteState){this.favoritesHeaderClass=PersonDisplay.FAVORITES_HEADER_CLASS;
this.favoriteIcon=PersonDisplay.FAVORITE_ICON}else{this.favoritesHeaderClass="";this.favoriteIcon=""}}});PersonDisplay.getImStatusClassName=function(status){switch(status){case IMAddress.STATUS.ONLINE:return"status-available";case IMAddress.STATUS.BUSY:return"status-busy";case IMAddress.STATUS.OFFLINE:return"status-offline";case IMAddress.STATUS.NO_PRESENCE:return"hide-status";default:return"hide-status"}};PersonDisplay.DEFAULT_LIST_AVATAR=PersonPhotos.DEFAULT_LIST_AVATAR;
PersonDisplay.DEFAULT_DETAILS_AVATAR=PersonPhotos.DEFAULT_DETAILS_AVATAR;PersonDisplay.FAVORITE_ICON='<img class="list-favorite" src="'+LIB_ROOT+'images/favorites-star-blue.png" height="24" width="24" alt="" />';PersonDisplay.HIDE_CONTACT_COUNT_CLASS="count-hidden";PersonDisplay.FAVORITES_HEADER_CLASS="favorites-header";PersonDisplay.FAVORITES_LIST_CLASS="favorites-list";PersonDisplay.IS_CLIPPED_CLASS={CLIPPED:"clipped",NOT_CLIPPED:"not-clipped"};var PersonDisplayLite={create:function(rawPersonObject,sortOrder){var sortKey,dividerText;rawPersonObject.displayName=Person.generateDisplayNameFromRawPerson(rawPersonObject);rawPersonObject.imageId="personImage_"+rawPersonObject._id;rawPersonObject.listPhotoPath=rawPersonObject.photos&&rawPersonObject.photos.listPhotoPath||PersonPhotos.DEFAULT_LIST_AVATAR;if(rawPersonObject.favorite)rawPersonObject.favoriteClass="favorite";else rawPersonObject.favoriteClass="";sortKey=rawPersonObject.sortKey;if(sortOrder===
ListWidget.SortOrder.firstLast||sortOrder===ListWidget.SortOrder.lastFirst)if(sortKey&&sortKey.slice(0,1)!==SortKey.DEFAULT_CHAR){dividerText=sortKey.slice(0,1);dividerText=Globalization.Locale.getBaseString(dividerText);dividerText=dividerText.slice(0,1);rawPersonObject.dividerText=Globalization.Character.toUpperCase(dividerText)}else rawPersonObject.dividerText=SortKey.DEFAULT_NAME_DIVIDER_TEXT;else if(sortKey&&sortKey.slice(0,1)!==SortKey.DEFAULT_CHAR){dividerText=rawPersonObject.organization&&
rawPersonObject.organization.name;if(dividerText){dividerText=Globalization.Locale.getBaseString(dividerText);rawPersonObject.dividerText=Globalization.Character.toUpperCase(dividerText)}else{dividerText=SortKey.DEFAULT_COMPANY_DIVIDER_TEXT;rawPersonObject.dividerText=Globalization.Character.toUpperCase(dividerText)}}else{dividerText=SortKey.DEFAULT_COMPANY_DIVIDER_TEXT;rawPersonObject.dividerText=Globalization.Character.toUpperCase(dividerText)}return rawPersonObject}};var PersonLinkable=Class.create(Person,{initialize:function initialize(rawPerson){this.$super(initialize)(rawPerson);this._init();if(rawPerson);},_init:function(){},addContact:function(contact){if(contact)if(contact.getId())this.getContactIds().add(contact.getId())},removeContactId:function(contactId){if(contactId)return this.getContactIds().remove(contactId)},copyOfContactIds:function(){return ArrayUtil.copyOfArray(this.getContactIds().getDBObject())},mergeContactIds:function(otherContactIds){if(otherContactIds)this.getContactIds().add(otherContactIds)},
linkSingleContact:function(contact){this.mergeContactIds([contact.getId()])},mergePeople:function(peopleToMerge,doneMergeFuture){this.mergePeopleAndContact(peopleToMerge,undefined,doneMergeFuture)},mergePeopleAndContact:function(peopleToMerge,contact,doneMergeFuture){var doneSaveUpdatedPersonFuture=new Future,doneRemovePeopleFromDBFuture=new Future,doneGettingPersonForFutureSaving=new Future,ids=[],i,tempPerson;if(peopleToMerge)for(i=0;i<peopleToMerge.length;i+=1){tempPerson=peopleToMerge[i];if(tempPerson.getId()!==
this.getId()){ids.push(tempPerson.getId());this.mergeContactIds(tempPerson.getContactIds().getArray())}}if(contact)this.mergeContactIds([contact.getId()]);doneSaveUpdatedPersonFuture.nest(this.save());doneSaveUpdatedPersonFuture.then(this,function(doneSaveFuture){if(doneSaveFuture.result)doneRemovePeopleFromDBFuture.nest(DB.del(ids));else doneMergeFuture.result={newPerson:undefined}});doneRemovePeopleFromDBFuture.then(this,function(doneRemove){if(doneRemove.result&&doneRemove.result.results);else;
doneGettingPersonForFutureSaving.nest(DB.find({from:Person.kind,where:[{prop:"_id",op:"=",val:this.getId()}]}))});doneGettingPersonForFutureSaving.then(this,function(doneGettingCurrent){var result=Utils.DBResultHelper(doneGettingCurrent.result);if(result)if(result.length>0)doneMergeFuture.result={newPerson:PersonFactory.createPersonLinkable(result[0])};else doneMergeFuture.result={newPerson:this};else doneMergeFuture.result={newPerson:this}})}});var PersonType={DISPLAYABLE:"displayable",DISPLAYLITE:"displaylite",LINKABLE:"linkable",RAWOBJECT:"rawobject"};exports.PersonType=PersonType;var PersonFactory={createPersonDisplayLite:function(rawPersonObject,sortOrder){return PersonDisplayLite.create(rawPersonObject,sortOrder)},createPersonDisplay:function(rawPersonObject){return new PersonDisplay(rawPersonObject)},createPersonLinkable:function(rawPersonObject){return new PersonLinkable(rawPersonObject)},create:function(rawPersonObject,personType,sortOrder){switch(personType){case PersonType.DISPLAYABLE:return PersonFactory.createPersonDisplay(rawPersonObject);case PersonType.DISPLAYLITE:return PersonDisplayLite.create(rawPersonObject,
sortOrder);case PersonType.LINKABLE:return PersonFactory.createPersonLinkable(rawPersonObject);case PersonType.RAWOBJECT:return rawPersonObject;default:return PersonFactory.createPersonDisplay(rawPersonObject)}}};exports.PersonFactory=PersonFactory;var SimContact=Class.create(Contact,{initialize:function initialize(obj){this.$super(initialize)(obj);this._init(obj)},_init:function(obj){if(!obj)obj={};var hasDatabaseId=!!obj._id;this.setKind(SimContact.kind);this._extendWithPropertyAndValue("simIndex",Utils.lazyWrapper(SimIndex,[obj.simIndex,hasDatabaseId]));this._extendWithPropertyAndValue("simEntryType",Utils.lazyWrapper(SimEntryType,[obj.simEntryType,hasDatabaseId]))},getSimIndex:function(){return this.accessor("simIndex")},setSimIndex:function(value){this.getSimIndex().setValue(value)},
getSimEntryType:function(){return this.accessor("simEntryType")},setSimEntryType:function(value){this.getSimEntryType().setValue(value)},setPhoneNumber:function(obj){var phoneNumbers=this.getPhoneNumbers().getArray(),phoneNumber;if(phoneNumbers.length>0){phoneNumber=this.getPhoneNumbers().getArray()[0];phoneNumber.setValue(obj.value?obj.value:phoneNumber.getValue());phoneNumber.setType(obj.type?obj.type:phoneNumber.getType())}else this.getPhoneNumbers().add(new PhoneNumber(obj))},deleteContactInDBOnly:function(){var id=
this.getId();Assert.requireDefined(id,"deleteContactInDBOnly unable to delete, there is no _id param");return DB.del([id])},saveContactInDBOnly:function(){var future;if(this.getId())future=DB.merge([this.getDBObject()]);else future=DB.put([this.getDBObject()]);future.then(this,function(future){var result=Utils.DBResultHelper(future.result);Assert.require(result,"SimContact save put - result is null");Assert.requireArray(result,"SimContact save");Assert.require(result.length,"SimContact save put - result length is zero");
this.setId(result[0].id);this.setRev(result[0].rev);this.markNotDirty();future.result=true});return future}});exports.SimContact=SimContact;
SimContact.getSimContactbyId=function(id){Assert.requireDefined(id,"getSimContactById unable to get contact, there is no _id param");return DB.get([id]).then(function(future){var result=Utils.DBResultHelper(future.result),contactsToReturn=[];if(result&&result.length>0){result.forEach(function(contact){contactsToReturn.push(new SimContact(contact))});future.result=contactsToReturn}else future.result=[]})};
SimContact.getContactsByAccountId=function(accountId){Assert.requireString(accountId,"SimContact.getContactsByAccountId requires an accountId that is a valid string");return DB.find({from:SimContact.kind,where:[{prop:"accountId",op:"=",val:accountId}],orderBy:"simIndex"}).then(function(future){var result=Utils.DBResultHelper(future.result),contactsToReturn=[];if(result&&result.length>0){result.forEach(function(contact){contactsToReturn.push(new SimContact(contact))});future.result=contactsToReturn}else future.result=
[]})};SimContact.kind="com.palm.contact.sim:1";var SpeedDialBackup=exports.SpeedDialBackup=Class.create({initialize:function(obj){if(!obj)obj={};var rawSpeedDialBackup=obj,_data={_kind:SpeedDialBackup.kind,_id:rawSpeedDialBackup._id,_rev:rawSpeedDialBackup._rev,_del:rawSpeedDialBackup._del,contactBackupHash:Utils.lazyWrapper(ContactBackupHash,[rawSpeedDialBackup.contactBackupHash,true]),speedDials:Utils.lazyWrapper(PropertyArray,[SpeedDialHash,rawSpeedDialBackup.speedDials,true])};this.accessor=function(fieldName){var field=_data[fieldName];Assert.requireDefined(fieldName,
"fieldName must be specified for the accessor");if(field&&typeof field==="object"&&field.isLazyWrapper)field=_data[fieldName]=field.createInstance();return field};this.setId=function(id){_data._id=id};this.setRev=function(rev){_data._rev=rev};this.getDBObject=function(){return Utils.getDBObjectForAllProperties(this.accessor,_.keys(_data))}},getId:function(){return this.accessor("_id")},getKind:function(){return this.accessor("_kind")},getContactBackupHash:function(){return this.accessor("contactBackupHash")},
getContactBackupHashContactId:function(){var backupHash=this.getContactBackupHash().getValue();return Contact.getIdFromLinkHash(backupHash)},getSpeedDials:function(){return this.accessor("speedDials")},deleteSpeedDialBackup:function(){var id=this.getId();Assert.requireDefined(id,"deleteSpeedDialBackup unable to delete, there is no _id param");return DB.del([id])},save:function(){return DB.put([this.getDBObject()]).then(this,function(future){var result=Utils.DBResultHelper(future.result);Assert.require(result,
"SpeedDialBackup save put - result is null");Assert.requireArray(result,"SpeedDialBackup save");Assert.require(result.length,"SpeedDialBackup save put - result length is zero");this.setId(result[0].id);this.setRev(result[0].rev);future.result=true})},toString:function(){return JSON.stringify(this.getDBObject())}});SpeedDialBackup.kind="com.palm.person.speeddialbackup:1";
SpeedDialBackup.getBackupForContact=function(contact){Assert.require(contact,"SpeedDialBackup.getBackupForContact requires a contact");var future=new Future;future.now(function(){return ContactLinkable.getLinkHash(contact)});future.then(function(){var result=future.result.linkHash;return SpeedDialBackup.getBackupForLinkhash(result)});return future};
SpeedDialBackup.getBackupsForLinkHashes=function(linkHashes){var future=new Future;future.now(function(){return DB.find({from:SpeedDialBackup.kind,where:[{prop:"contactBackupHash",op:"=",val:linkHashes}]})});future.then(function(){var result=Utils.DBResultHelper(future.result),speedDialBackups=[];if(result){result.forEach(function(rawSpeedDialBackup){speedDialBackups.push(new SpeedDialBackup(result[0]))});return speedDialBackups}else future.result=undefined});return future};
SpeedDialBackup.getBackupForLinkHash=function(linkHash){var future=new Future;future.now(function(){return DB.find({from:SpeedDialBackup.kind,where:[{prop:"contactBackupHash",op:"=",val:linkHash}]})});future.then(function(){var result=Utils.DBResultHelper(future.result);if(result&&result[0])future.result=new SpeedDialBackup(result[0]);else future.result=undefined});return future};
SpeedDialBackup.removeBackupForContact=function(contact){Assert.require(contact,"SpeedDialBackup.removeBackupForContact requires a contact");var future=new Future;future.now(function(){return ContactLinkable.getLinkHash(contact)});future.then(function(){var contactHash=future.result.linkHash,query={from:SpeedDialBackup.kind,where:[{prop:"contactBackupHash",op:"=",val:contactHash}]};return DB.del(query)});future.then(function(){var result=Utils.DBResultHelper(future.result);return result&&result.count>
0});return future};var VCard=exports.VCard=Class.create({initialize:function(obj){}});VCard.VERSIONS={TWO_POINT_ONE:"2.1",THREE:"3.0"};VCard.CHARSET={ASCII:"US-ASCII",UTF8:"UTF-8"};
VCard.MARKERS={BEGIN:"BEGIN:VCARD",SEPERATOR:":",CHARSET_UTF8:"CHARSET=UTF-8",VERSION:"VERSION",NICKNAME:"NICKNAME",NAME:"N",FULL_NAME:"FN",COMPANY:"ORG",JOBTITLE:"TITLE",PHONE:"TEL",EMAIL:"EMAIL",ADDRESS:"ADR",BIRTHDAY:"BDAY",URL:"URL",NOTE:"NOTE",RELATED:"X-ABRELATEDNAMES",GTALK:"X-GTALK",AIM:"X-AIM",MSN:"X-MSN",YAHOO:"X-YAHOO",JABBER:"X-JABBER",QQ:"X-QQ",ICQ:"X-ICQ",SKYPE:"X-SKYPE",IM:"X-IM",SPOUSE_ONE_LINE:"X-SPOUSE",CHILD_ONE_LINE:"X-CHILD",END:"END:VCARD"};
VCard.TYPEMARKERS={HOME:"HOME",WORK:"WORK",FAX:"FAX",FAX_WORK:"FAX_WORK",FAX_HOME:"FAX_HOME",CELL:"CELL",PAGER:"PAGER",MAIN:"MAIN",OTHER:"OTHER",ASSISTANT:"ASSISTANT",BROTHER:"BROTHER",CHILD:"CHILD",FATHER:"FATHER",FRIEND:"FRIEND",MANAGER:"MANAGER",MOTHER:"MOTHER",PARENT:"PARENT",PARTNER:"PARTNER",RELATIVE:"RELATIVE",SISTER:"SISTER",SPOUSE:"SPOUSE",SPOUSE_ONE_LINER:"item1.X-ABLabel:_$!<SPOUSE>!$_",CHILD_ONE_LINER:"item1.X-ABLabel:_$!<CHILD>!$_",REFERRED_BY:"REFFERRED_BY",DOMESTIC_PARTNER:"DOMESTIC_PARTNER"};
VCard.TYPES={};VCard._PHONE_NUMBER_CONTACT_POINT_VALUE={FAX_HOME:PhoneNumber.TYPE.PERSONAL_FAX,FAX_WORK:PhoneNumber.TYPE.WORK_FAX,HOME:PhoneNumber.TYPE.HOME,WORK:PhoneNumber.TYPE.WORK,CELL:PhoneNumber.TYPE.MOBILE,PAGER:PhoneNumber.TYPE.PAGER,MAIN:PhoneNumber.TYPE.MAIN,OTHER:PhoneNumber.TYPE.OTHER};
VCard.TYPES.PHONE_NUMBER={FAX:{VCARD_VALUE:VCard.TYPEMARKERS.FAX},FAX_HOME:{VCARD_VALUE:VCard.TYPEMARKERS.FAX_HOME,CONTACT_POINT_VALUE:VCard._PHONE_NUMBER_CONTACT_POINT_VALUE.FAX_HOME},FAX_WORK:{VCARD_VALUE:VCard.TYPEMARKERS.FAX_WORK,CONTACT_POINT_VALUE:VCard._PHONE_NUMBER_CONTACT_POINT_VALUE.FAX_WORK},HOME:{VCARD_VALUE:VCard.TYPEMARKERS.HOME,CONTACT_POINT_VALUE:VCard._PHONE_NUMBER_CONTACT_POINT_VALUE.HOME},WORK:{VCARD_VALUE:VCard.TYPEMARKERS.WORK,CONTACT_POINT_VALUE:VCard._PHONE_NUMBER_CONTACT_POINT_VALUE.WORK},
CELL:{VCARD_VALUE:VCard.TYPEMARKERS.CELL,CONTACT_POINT_VALUE:VCard._PHONE_NUMBER_CONTACT_POINT_VALUE.CELL},PAGER:{VCARD_VALUE:VCard.TYPEMARKERS.PAGER,CONTACT_POINT_VALUE:VCard._PHONE_NUMBER_CONTACT_POINT_VALUE.PAGER},MAIN:{VCARD_VALUE:VCard.TYPEMARKERS.MAIN,CONTACT_POINT_VALUE:VCard._PHONE_NUMBER_CONTACT_POINT_VALUE.MAIN},OTHER:{CONTACT_POINT_VALUE:VCard._PHONE_NUMBER_CONTACT_POINT_VALUE.OTHER}};
VCard.PHONE_LABELS={HOME:{CONTACT_POINT_VALUE:VCard._PHONE_NUMBER_CONTACT_POINT_VALUE.HOME,LABELS:["HOME","VOICE"]},WORK:{CONTACT_POINT_VALUE:VCard._PHONE_NUMBER_CONTACT_POINT_VALUE.WORK,LABELS:["WORK","VOICE"]},CELL:{CONTACT_POINT_VALUE:VCard._PHONE_NUMBER_CONTACT_POINT_VALUE.CELL,LABELS:["CELL","VOICE"]},PAGER:{CONTACT_POINT_VALUE:VCard._PHONE_NUMBER_CONTACT_POINT_VALUE.PAGER,LABELS:["PAGER"]},FAX_HOME:{CONTACT_POINT_VALUE:VCard._PHONE_NUMBER_CONTACT_POINT_VALUE.FAX_HOME,LABELS:["HOME","FAX"]},
FAX_WORK:{CONTACT_POINT_VALUE:VCard._PHONE_NUMBER_CONTACT_POINT_VALUE.FAX_WORK,LABELS:["WORK","FAX"]},OTHER:{CONTACT_POINT_VALUE:VCard._PHONE_NUMBER_CONTACT_POINT_VALUE.OTHER,LABELS:["OTHER"]}};VCard._EMAIL_CONTACT_POINT_VALUE={HOME:EmailAddress.TYPE.HOME,WORK:EmailAddress.TYPE.WORK,OTHER:EmailAddress.TYPE.OTHER};
VCard.TYPES.EMAIL={HOME:{VCARD_VALUE:VCard.TYPEMARKERS.HOME,CONTACT_POINT_VALUE:VCard._EMAIL_CONTACT_POINT_VALUE.HOME},WORK:{VCARD_VALUE:VCard.TYPEMARKERS.WORK,CONTACT_POINT_VALUE:VCard._EMAIL_CONTACT_POINT_VALUE.WORK},OTHER:{CONTACT_POINT_VALUE:VCard._EMAIL_CONTACT_POINT_VALUE.OTHER}};
VCard.EMAIL_LABELS={HOME:{CONTACT_POINT_VALUE:VCard._EMAIL_CONTACT_POINT_VALUE.HOME,LABELS:["HOME","INTERNET"]},WORK:{CONTACT_POINT_VALUE:VCard._EMAIL_CONTACT_POINT_VALUE.WORK,LABELS:["WORK","INTERNET"]},OTHER:{CONTACT_POINT_VALUE:VCard._EMAIL_CONTACT_POINT_VALUE.OTHER,LABELS:["INTERNET"]}};VCard._URL_CONTACT_POINT_VALUE={HOME:Url.TYPE.HOME,WORK:Url.TYPE.WORK,OTHER:Url.TYPE.OTHER};
VCard.TYPES.URL={HOME:{VCARD_VALUE:VCard.TYPEMARKERS.HOME,CONTACT_POINT_VALUE:VCard._URL_CONTACT_POINT_VALUE.HOME},WORK:{VCARD_VALUE:VCard.TYPEMARKERS.WORK,CONTACT_POINT_VALUE:VCard._URL_CONTACT_POINT_VALUE.WORK},OTHER:{CONTACT_POINT_VALUE:VCard._URL_CONTACT_POINT_VALUE.OTHER}};
VCard.URL_LABELS={HOME:{CONTACT_POINT_VALUE:VCard._URL_CONTACT_POINT_VALUE.WORK,LABELS:["HOME"]},WORK:{CONTACT_POINT_VALUE:VCard._URL_CONTACT_POINT_VALUE.WORK,LABELS:["WORK"]},OTHER:{CONTACT_POINT_VALUE:VCard._URL_CONTACT_POINT_VALUE.OTHER,LABELS:[]}};VCard._IMADDRESS_CONTACT_POINT_VALUE={HOME:IMAddress.TYPE.HOME,WORK:IMAddress.TYPE.WORK,OTHER:IMAddress.TYPE.OTHER};
VCard.TYPES.IM_ADDRESS={HOME:{VCARD_VALUE:VCard.TYPEMARKERS.HOME,CONTACT_POINT_VALUE:VCard._IMADDRESS_CONTACT_POINT_VALUE.HOME},WORK:{VCARD_VALUE:VCard.TYPEMARKERS.WORK,CONTACT_POINT_VALUE:VCard._IMADDRESS_CONTACT_POINT_VALUE.WORK},OTHER:{CONTACT_POINT_VALUE:VCard._IMADDRESS_CONTACT_POINT_VALUE.OTHER}};
VCard.IM_SERVICES={GTALK:{VCARD_VALUE:VCard.MARKERS.GTALK,SERVICE_NAME:IMAddress.TYPE.GTALK,LABELS:[VCard.MARKERS.GTALK]},AIM:{VCARD_VALUE:VCard.MARKERS.AIM,SERVICE_NAME:IMAddress.TYPE.AIM,LABELS:[VCard.MARKERS.AIM]},MSN:{VCARD_VALUE:VCard.MARKERS.MSN,SERVICE_NAME:IMAddress.TYPE.MSN,LABELS:[VCard.MARKERS.MSN]},YAHOO:{VCARD_VALUE:VCard.MARKERS.YAHOO,SERVICE_NAME:IMAddress.TYPE.YAHOO,LABELS:[VCard.MARKERS.YAHOO]},JABBER:{VCARD_VALUE:VCard.MARKERS.JABBER,SERVICE_NAME:IMAddress.TYPE.JABBER,LABELS:[VCard.MARKERS.JABBER]},
QQ:{VCARD_VALUE:VCard.MARKERS.QQ,SERVICE_NAME:IMAddress.TYPE.QQ,LABELS:[VCard.MARKERS.QQ]},ICQ:{VCARD_VALUE:VCard.MARKERS.ICQ,SERVICE_NAME:IMAddress.TYPE.ICQ,LABELS:[VCard.MARKERS.ICQ]},SKYPE:{VCARD_VALUE:VCard.MARKERS.SKYPE,SERVICE_NAME:IMAddress.TYPE.SKYPE,LABELS:[VCard.MARKERS.SKYPE]},OTHER:{SERVICE_NAME:IMAddress.TYPE.DEFAULT,LABELS:[VCard.MARKERS.IM]}};VCard._ADDRESS_CONTACT_POINT_VALUE={HOME:Address.TYPE.HOME,WORK:Address.TYPE.WORK,OTHER:Address.TYPE.OTHER};
VCard.TYPES.ADDRESS={HOME:{VCARD_VALUE:VCard.TYPEMARKERS.HOME,CONTACT_POINT_VALUE:VCard._ADDRESS_CONTACT_POINT_VALUE.HOME},WORK:{VCARD_VALUE:VCard.TYPEMARKERS.WORK,CONTACT_POINT_VALUE:VCard._ADDRESS_CONTACT_POINT_VALUE.WORK},OTHER:{CONTACT_POINT_VALUE:VCard._ADDRESS_CONTACT_POINT_VALUE.OTHER}};
VCard.ADDRESS_LABELS={HOME:{CONTACT_POINT_VALUE:VCard._ADDRESS_CONTACT_POINT_VALUE.HOME,LABELS:["HOME"]},WORK:{CONTACT_POINT_VALUE:VCard._ADDRESS_CONTACT_POINT_VALUE.WORK,LABELS:["WORK"]},OTHER:{CONTACT_POINT_VALUE:VCard._ADDRESS_CONTACT_POINT_VALUE.OTHER,LABELS:["OTHER"]}};
VCard._RELATION_CONTACT_POINT_VALUE={ASSISTANT:Relation.TYPE.ASSISTANT,BROTHER:Relation.TYPE.BROTHER,CHILD:Relation.TYPE.CHILD,DOMESTIC_PARTNER:Relation.TYPE.DOMESTIC_PARTNER,FATHER:Relation.TYPE.FATHER,FRIEND:Relation.TYPE.FRIEND,MANAGER:Relation.TYPE.MANAGER,MOTHER:Relation.TYPE.MOTHER,PARENT:Relation.TYPE.PARENT,PARTNER:Relation.TYPE.PARTNER,REFERRED_BY:Relation.TYPE.REFERRED_BY,RELATIVE:Relation.TYPE.RELATIVE,SISTER:Relation.TYPE.SISTER,SPOUSE:Relation.TYPE.SPOUSE,OTHER:Relation.TYPE.OTHER};
VCard.TYPES.RELATION={ASSISTANT:{VCARD_VALUE:VCard.TYPEMARKERS.ASSISTANT,CONTACT_POINT_VALUE:VCard._RELATION_CONTACT_POINT_VALUE.ASSISTANT},BROTHER:{VCARD_VALUE:VCard.TYPEMARKERS.BROTHER,CONTACT_POINT_VALUE:VCard._RELATION_CONTACT_POINT_VALUE.BROTHER},CHILD:{VCARD_VALUE:VCard.TYPEMARKERS.CHILD,CONTACT_POINT_VALUE:VCard._RELATION_CONTACT_POINT_VALUE.CHILD},DOMESTIC_PARTNER:{VCARD_VALUE:VCard.TYPEMARKERS.DOMESTIC_PARTNER,CONTACT_POINT_VALUE:VCard._RELATION_CONTACT_POINT_VALUE.DOMESTIC_PARTNER},FATHER:{VCARD_VALUE:VCard.TYPEMARKERS.FATHER,
CONTACT_POINT_VALUE:VCard._RELATION_CONTACT_POINT_VALUE.FATHER},FRIEND:{VCARD_VALUE:VCard.TYPEMARKERS.FRIEND,CONTACT_POINT_VALUE:VCard._RELATION_CONTACT_POINT_VALUE.FRIEND},MANAGER:{VCARD_VALUE:VCard.TYPEMARKERS.MANAGER,CONTACT_POINT_VALUE:VCard._RELATION_CONTACT_POINT_VALUE.MANAGER},MOTHER:{VCARD_VALUE:VCard.TYPEMARKERS.MOTHER,CONTACT_POINT_VALUE:VCard._RELATION_CONTACT_POINT_VALUE.MOTHER},PARENT:{VCARD_VALUE:VCard.TYPEMARKERS.PARENT,CONTACT_POINT_VALUE:VCard._RELATION_CONTACT_POINT_VALUE.PARENT},
PARTNER:{VCARD_VALUE:VCard.TYPEMARKERS.PARTNER,CONTACT_POINT_VALUE:VCard._RELATION_CONTACT_POINT_VALUE.PARTNER},REFERRED_BY:{VCARD_VALUE:VCard.TYPEMARKERS.REFERRED_BY,CONTACT_POINT_VALUE:VCard._RELATION_CONTACT_POINT_VALUE.REFERRED_BY},RELATIVE:{VCARD_VALUE:VCard.TYPEMARKERS.RELATIVE,CONTACT_POINT_VALUE:VCard._RELATION_CONTACT_POINT_VALUE.RELATIVE},SISTER:{VCARD_VALUE:VCard.TYPEMARKERS.SISTER,CONTACT_POINT_VALUE:VCard._RELATION_CONTACT_POINT_VALUE.SISTER},SPOUSE:{VCARD_VALUE:VCard.TYPEMARKERS.SPOUSE,
CONTACT_POINT_VALUE:VCard._RELATION_CONTACT_POINT_VALUE.SPOUSE},OTHER:{CONTACT_POINT_VALUE:VCard._RELATION_CONTACT_POINT_VALUE.OTHER}};var VCardExporter=exports.VCardExporter=Class.create({initialize:function(obj){if(!obj||!obj.filePath)throw new Error("File path must be specified to make a VCardImporter");this.filePath=obj.filePath;this.vCardVersion=obj.version?obj.version:VCard.VERSIONS.THREE;this.charset=obj.charset?obj.charset:VCard.CHARSET.UTF8;this.useFileCache=obj.useFileCache||false;this.vCardFileWriter=new VCardFileWriter({filePath:this.filePath});this.onlyPhoneNumber=false},exportOne:function(personId,onlyPhoneNumber){var filecacheFuture,
future=new Future;future.now(this,function(){Assert.require(personId,"personId passed to export was not truthy. export requires a valid personId to export");this.onlyPhoneNumber=onlyPhoneNumber;future.nest(Person.getDisplayablePersonAndContactsById(personId))});future.then(this,function(){var person=future.result;Assert.require(person,"The personId passed into export was not a person that currently exists");this.vCardFileWriter.open();this._exportVCard(person);future.result={size:this.vCardFileWriter.getSize()}});
if(this.useFileCache)future.then(this,function(){var result=future.result,size=result.size;filecacheFuture=PalmCall.call("palm://com.palm.filecache/","InsertCacheObject",{typeName:"contactvcard",fileName:this.filePath,size:size,subscribe:true});return filecacheFuture});future.then(this,function(){var result=future.result,path=result.pathName||this.filePath;future.result={success:this.vCardFileWriter.close(path),filePath:path}});if(this.useFileCache)future.then(this,function(){var result=future.result;
PalmCall.cancel(filecacheFuture);future.result=result});return future},exportAll:function(onlyPhoneNumber){var future=new Future;future.now(this,function(){var dbFuture,findParams={query:{from:Person.kind,limit:500}};this.onlyPhoneNumber=onlyPhoneNumber;this.vCardFileWriter.open();dbFuture=DB.execute("find",findParams);dbFuture.then(this,this._getNextPageForExportAll);future.nest(dbFuture)});return future},_getNextPageForExportAll:function(nestedFuture){var innerNestedFuture,result=nestedFuture.result,
currentPagePeople,nextPageKey=result.next,i,tempPerson,findParams={query:{from:Person.kind,limit:500}};try{currentPagePeople=result.results;for(i=0;i<currentPagePeople.length;i+=1){tempPerson=new Person(currentPagePeople[i]);this._exportVCard(tempPerson)}currentPagePeople=undefined;if(!nextPageKey)nestedFuture.result={success:this.vCardFileWriter.close(),filePath:this.filePath};else{findParams.query.page=nextPageKey;innerNestedFuture=DB.execute("find",findParams);innerNestedFuture.then(this,this._getNextPageForExportAll);
nestedFuture.nest(innerNestedFuture)}}catch(e){this.vCardFileWriter.close();throw e;}},_exportVCard:function(person){var phoneNumbers,emailAddresses,addresses,urls,ims,notes,nameToUse,i;if(!person){console.warn("_exportVCard: encountered a false person. Skipping");return}phoneNumbers=person.getPhoneNumbers().getArray();if(this.onlyPhoneNumber&&phoneNumbers.length<1){console.warn("_exportVCard: encountered a person with no phone numbers where onlyPhoneNumber is true. Skipping that person.");return}nameToUse=
this._pickNameToUse(person);this.vCardFileWriter.writeLine(VCard.MARKERS.BEGIN+"\r");if(this.vCardVersion===VCard.VERSIONS.TWO_POINT_ONE)this.vCardFileWriter.writeLine(VCard.MARKERS.VERSION+":"+VCard.VERSIONS.TWO_POINT_ONE+"\r");else this.vCardFileWriter.writeLine(VCard.MARKERS.VERSION+":"+VCard.VERSIONS.THREE+"\r");this._writeNameToVCard(nameToUse);this._writeFullNameToVCard(person);if(!this.onlyPhoneNumber){this._writeOrganizationToVCard(person.getOrganization());this._writeNicknameToVCard(person.getNickname())}for(i=
0;i<phoneNumbers.length;i+=1)this._writePhoneNumberToVCard(phoneNumbers[i],this.onlyPhoneNumber);if(!this.onlyPhoneNumber){emailAddresses=person.getEmails().getArray();for(i=0;i<emailAddresses.length;i+=1)this._writeEmailAddressToVCard(emailAddresses[i]);addresses=person.getAddresses().getArray();for(i=0;i<addresses.length;i+=1)this._writeAddressToVCard(addresses[i]);urls=person.getUrls().getArray();for(i=0;i<urls.length;i+=1)this._writeUrlToVCard(urls[i]);ims=person.getIms().getArray();for(i=0;i<
ims.length;i+=1)this._writeIMAddressToVCard(ims[i]);this._writeBirthdayToVCard(person.getBirthday());notes=person.getNotes().getArray();for(i=0;i<notes.length;i+=1)if(notes[i]){this._writeNoteToVCard(notes[i]);break}}this.vCardFileWriter.writeLine(VCard.MARKERS.END+"\r\n\r")},_pickNameToUse:function(person){var generateNameFromCompany=false,generateNameFromDisplayText=false,toReturn;if(!person||!person.getName())return new Name;if(!person.getName().getGivenName()&&!person.getName().getFamilyName()){toReturn=
new Name;toReturn.setFamilyName(person.generateDisplayName())}else toReturn=person.getName();return toReturn},_writeNameToVCard:function(nameObject){if(!nameObject)return;Assert.require(nameObject instanceof Name,"Object passed to _writeNameToVCard must be an instance of Name");var nameLine="",nameValue="";nameLine+=VCard.MARKERS.NAME;if(this.charset===VCard.CHARSET.UTF8&&this.vCardVersion===VCard.VERSIONS.TWO_POINT_ONE)nameLine+=";"+VCard.MARKERS.CHARSET_UTF8;nameLine+=":";if(nameObject.getFamilyName())nameLine+=
nameObject.getFamilyName();nameLine+=";";if(nameObject.getGivenName())nameLine+=nameObject.getGivenName();nameLine+=";";if(nameObject.getMiddleName())nameLine+=nameObject.getMiddleName();nameLine+=";";if(nameObject.getHonorificPrefix())nameLine+=nameObject.getHonorificPrefix();nameLine+=";";if(nameObject.getHonorificSuffix())nameLine+=nameObject.getHonorificSuffix();nameLine+="\r";this.vCardFileWriter.writeLine(nameLine)},_writeFullNameToVCard:function(personObject){if(!personObject)return;Assert.require(personObject instanceof
Person,"Object passed to _writeFullNameToVCard must be an instance of Person");var fullNameLine="",displayValue=personObject.generateDisplayName();if(!displayValue||displayValue.length<1){console.warn("VCardExporter bad person passed into _writeFullNameToVCard");return}fullNameLine+=VCard.MARKERS.FULL_NAME;if(this.charset===VCard.CHARSET.UTF8&&this.vCardVersion===VCard.VERSIONS.TWO_POINT_ONE)fullNameLine+=";"+VCard.MARKERS.CHARSET_UTF8;fullNameLine+=":";fullNameLine+=displayValue+"\r";this.vCardFileWriter.writeLine(fullNameLine)},
_writeNicknameToVCard:function(nicknameObject){if(!nicknameObject)return;Assert.require(nicknameObject instanceof Nickname,"Object passed to _writeNicknameToVCard must be an instance of Nickname");var nicknameLine="",nicknameValue=nicknameObject.getValue();if(!nicknameValue||nicknameValue.length<1){console.warn("VCardExporter bad nickname passed into _writeNicknameToVCard. Not writing nickname.");return}nicknameLine+=VCard.MARKERS.NICKNAME+":";nicknameLine+=nicknameValue+"\r";this.vCardFileWriter.writeLine(nicknameLine)},
_writeOrganizationToVCard:function(organizationObject){if(!organizationObject)return;Assert.require(organizationObject instanceof Organization,"Object passed to _writeOrganizationToVCard must be an instance of Organization");var organizationLine="",jobTitleLine="",organizationValue=organizationObject.getName(),jobTitleValue=organizationObject.getTitle();if(!organizationValue&&!jobTitleValue){console.warn("VCardExporter bad organization passed into _writeOrganizationToVCard. Not writing organization.");
return}if(organizationValue){organizationLine+=VCard.MARKERS.COMPANY+":";organizationLine+=organizationValue+";\r";this.vCardFileWriter.writeLine(organizationLine)}if(jobTitleValue){jobTitleLine+=VCard.MARKERS.JOBTITLE+":";jobTitleLine+=jobTitleValue+"\r";this.vCardFileWriter.writeLine(jobTitleLine)}},_writePhoneNumberToVCard:function(phoneNumber,stripFormatting){if(!phoneNumber)return;Assert.require(phoneNumber instanceof PhoneNumber,"Object passed to _writePhoneNumberToVCard must be an instance of PhoneNumber");
var phoneNumberValue=phoneNumber.getValue(),phoneNumberLine="",label;if(stripFormatting)phoneNumberValue=PhoneNumber.unformatForVCard(phoneNumberValue);if(!phoneNumberValue){console.warn("VCardExporter bad phone number: number = "+phoneNumberValue+" type = "+phoneNumber.getType());return}phoneNumberLine+=VCard.MARKERS.PHONE;if(this.charset===VCard.CHARSET.UTF8&&this.vCardVersion===VCard.VERSIONS.TWO_POINT_ONE)phoneNumberLine+=";"+VCard.MARKERS.CHARSET_UTF8;label=VCardExporter._buildCorrectLabelBasedOnVersion(this.vCardVersion,
VCardExporter._getPhoneLabels(phoneNumber.getType()));if(label.length>0)phoneNumberLine+=";"+label;phoneNumberLine+=":"+phoneNumberValue+"\r";this.vCardFileWriter.writeLine(phoneNumberLine)},_writeEmailAddressToVCard:function(emailAddress){if(!emailAddress)return;Assert.require(emailAddress instanceof EmailAddress,"Object passed to _writeEmailAddressToVCard must be an instance of EmailAddress");var emailAddressValue=emailAddress.getValue(),emailAddressLine="",label;if(!emailAddressValue||emailAddressValue.length<
1){console.warn("VCardExporter bad email address passed into _writeEmailAddressToVCard. Not writing email.");return}emailAddressLine+=VCard.MARKERS.EMAIL+";";emailAddressLine+=VCardExporter._buildCorrectLabelBasedOnVersion(this.vCardVersion,VCardExporter._getEmailLabels(emailAddress.getType()));emailAddressLine+=":"+emailAddressValue+"\r";this.vCardFileWriter.writeLine(emailAddressLine)},_writeIMAddressToVCard:function(imAddress){if(!imAddress)return;Assert.require(imAddress instanceof IMAddress,
"Object passed to _writeIMAddressToVCard must be an instance of IMAddress");var imAddressValue=imAddress.getValue(),imAddressLine="";if(!imAddressValue||imAddressValue.length<1){console.warn("VCardExporter bad IM Address passed into _writeIMAddressToVCard. Not writing IM.");return}imAddressLine+=VCardExporter._getIMLabels(imAddress.getType())+":";imAddressLine+=imAddressValue+"\r";this.vCardFileWriter.writeLine(imAddressLine)},_writeUrlToVCard:function(urlObject){if(!urlObject)return;Assert.require(urlObject instanceof
Url,"Object passed to _writeUrlToVCard must be an instance of Url");var urlValue=urlObject.getValue(),urlLine="";if(!urlValue||urlValue.length<1){console.warn("VCardExporter bad Url passed into _writeUrlToVCard. Not writing URL.");return}urlLine+=VCardExporter._buildCorrectLabelBasedOnVersion(this.vCardVersion,VCardExporter._getUrlLabels(urlObject.getType()))+":";urlLine+=urlValue+"\r";this.vCardFileWriter.writeLine(urlLine)},_writeAddressToVCard:function(addressObject){if(!addressObject)return;Assert.require(addressObject instanceof
Address,"Object passed to _writeAddressToVCard must be an instance of Address");var addressLine="",formattedAddressValue=VCardExporter._formatAddress(addressObject);if(!formattedAddressValue||formattedAddressValue.length<1){console.warn("VCardExporter bad address passed into _writeAddressToVCard. Not writing address.");return}addressLine+=VCard.MARKERS.ADDRESS+";";addressLine+=VCardExporter._buildCorrectLabelBasedOnVersion(this.vCardVersion,VCardExporter._getAddressLabels(addressObject.getType()));
addressLine+=":;;";addressLine+=formattedAddressValue+"\r";this.vCardFileWriter.writeLine(addressLine)},_writeNoteToVCard:function(noteObject){if(!noteObject)return;Assert.require(noteObject instanceof Note,"Object passed to _writeNoteToVCard must be an instance of Note");var noteLine="",noteValue=noteObject.getValue();if(!noteValue||noteValue.length<1){console.warn("VCardExporter bad note passed into _writeNoteToVCard. Not writing note.");return}noteValue=noteValue.replace(/\n/g,"\\n");noteValue=
noteValue.replace(/\r/g,"\\r");noteLine+=VCard.MARKERS.NOTE+":";noteLine+=noteValue+"\r";this.vCardFileWriter.writeLine(noteLine)},_writeBirthdayToVCard:function(birthdayObject){if(!birthdayObject)return;Assert.require(birthdayObject instanceof Birthday,"Object passed to _writeBirthdayToVCard must be an instance of Birthday");var birthdayLine="",birthdayValue=birthdayObject.getValue();if(!birthdayValue||birthdayValue.length<1){console.warn("VCardExporter bad birthday passed into _writeBirthdayToVCard. Not writing birthday.");
return}birthdayLine+=VCard.MARKERS.BIRTHDAY+":";birthdayLine+=birthdayValue+"\r";this.vCardFileWriter.writeLine(birthdayLine)}});
VCardExporter._formatAddress=function(address){Assert.require(address instanceof Address,"Object passed to VCardExporter._formatAddress must be an instance of Address");var toReturn="";if(address.getStreetAddress())toReturn+=address.getStreetAddress().replace(/\n/g," ");toReturn+=";";if(address.getLocality())toReturn+=address.getLocality();toReturn+=";";if(address.getRegion())toReturn+=address.getRegion();toReturn+=";";if(address.getPostalCode())toReturn+=address.getPostalCode();toReturn+=";";if(address.getCountry())toReturn+=
address.getCountry();return toReturn};VCardExporter._buildCorrectLabelBasedOnVersion=function(vCardVersion,labels){if(vCardVersion===VCard.VERSIONS.TWO_POINT_ONE)return VCardExporter._build2_1TypeLabel(labels);else return VCardExporter._build3_0TypeLabel(labels)};VCardExporter._build3_0TypeLabel=function(labels){if(labels)return VCardExporter._buildTypeLabelHelper(labels,",","TYPE=");else return""};
VCardExporter._build2_1TypeLabel=function(labels){if(labels)return VCardExporter._buildTypeLabelHelper(labels,";");else return""};VCardExporter._buildTypeLabelHelper=function(labels,seperator,prefix){var toReturn=prefix?prefix:"",i;for(i=0;i<labels.length;i+=1){toReturn+=labels[i];if(i<labels.length-1)toReturn+=seperator}return toReturn};VCardExporter._sanitizeCustomLabel=function(label){var toReturn="";label.replace(/[a-zA-Z0-9\-]/g,function(substr){toReturn+=substr});return toReturn};
VCardExporter._getPhoneLabels=function(contactPointValue,customType){return this._getLabelsHelper(VCard.PHONE_LABELS,contactPointValue,false,customType)};VCardExporter._getEmailLabels=function(contactPointValue,customType){return this._getLabelsHelper(VCard.EMAIL_LABELS,contactPointValue,false,customType,["INTERNET"])};VCardExporter._getIMLabels=function(serviceName){return this._getLabelsHelper(VCard.IM_SERVICES,serviceName,true)};
VCardExporter._getAddressLabels=function(contactPointValue,customType){return this._getLabelsHelper(VCard.ADDRESS_LABELS,contactPointValue,false,customType)};VCardExporter._getUrlLabels=function(contactPointValue,customType){return this._getLabelsHelper(VCard.URL_LABELS,contactPointValue,false,customType)};
VCardExporter._getLabelsHelper=function(labelObjects,contactPointValue,isIMServiceName,customType,customTypeLabelsToAppend){var toReturn,labelObject,otherObject,i;otherObject=labelObjects.OTHER?labelObjects.OTHER.LABELS:[];if(!contactPointValue)return otherObject;for(labelObject in labelObjects)if(labelObjects.hasOwnProperty(labelObject)){labelObject=labelObjects[labelObject];if(isIMServiceName){if(labelObject.SERVICE_NAME===contactPointValue)return labelObject.LABELS}else if(labelObject.CONTACT_POINT_VALUE===
contactPointValue)if(labelObject.CONTACT_POINT_VALUE===labelObjects.OTHER.CONTACT_POINT_VALUE){if(customType){toReturn=["X-"+VCardExporter._sanitizeCustomLabel(customType)];if(customTypeLabelsToAppend)for(i=0;i<customTypeLabelsToAppend.length;i+=1)toReturn.push(customTypeLabelsToAppend[i]);return toReturn}break}else return labelObject.LABELS}return otherObject};var VCardFileReader=Class.create({initialize:function(obj){if(!obj||!obj.filePath)throw new Error("Must create VCardFileReader with an object containing filePath");this.fileName=obj.filePath;this.fileHandler={currentLine:0,lines:Foundations.Comms.loadFile(this.fileName).split("\n"),readLine:function(){if(this.currentLine<this.lines.length){this.currentLine+=1;return this.lines[this.currentLine-1]}else return null},restartFile:function(){this.currentLine=0}};this.peekedLine=""},readLine:function(){var toReturn;
if(this.peekedLine){toReturn=this.peekedLine;this.peekedLine=undefined}else toReturn=this.fileHandler.readLine();return toReturn},peek:function(){if(!this.peekedLine)this.peekedLine=this.fileHandler.readLine();return this.peekedLine}});var VCardFileWriter=Class.create({initialize:function(obj){if(!obj||!obj.filePath)throw new Error("Must create VCardFileWriter with an object containing filePath");this.fileName=obj.filePath;this.fileHandler={fileName:this.fileName,fileOutput:"",writeLine:function(line){this.fileOutput+=line+"\n"},close:function(path){var usePath=path||this.fileName,fs;try{if(Foundations.EnvironmentUtils.isNode()){fs=require("fs");fs.writeFileSync(usePath,this.fileOutput,"utf8")}else palmPutResource(usePath,this.fileOutput);
this.fileOutput="";return true}catch(e){console.log("Writing file failed!");console.log(e.stack);throw e;}}}},open:function(){this.fileHandler.fileOutput=""},writeLine:function(line){this.fileHandler.writeLine(line)},getSize:function(){return this.fileHandler.fileOutput.length},close:function(path){return this.fileHandler.close(path)}});var VCardImporter=exports.vCardImporter=Class.create({initialize:function(obj){if(!obj||!obj.filePath)throw new Error("File path must be specified to make a VCardImporter");this.filePath=obj.filePath;this.vCardVersion=obj.version?obj.version:VCard.VERSIONS.THREE;this.importToAccountId=obj.importToAccountId?obj.importToAccountId:"";this.importToContactSetId=obj.importToContactSetId?obj.importToContactSetId:1;this.currentContact=null;this.vCardFileReader=null},readVCard:function(processedContactCallback){return this._importVCard(processedContactCallback,
false)},importVCard:function(processedContactCallback){return this._setupImport(processedContactCallback,false)},importVCardNoDuplicates:function(processedContactCallback){return this._setupImport(processedContactCallback,true)},_importVCard:function(processedContactCallback,saveToDB){var currentLine,currentContact,processedContactCallbackValue,future=new Future,contactProcessedFunction,savedProcessedContactFuture=new Future,allContacts=[];future.now(this,function(){if(processedContactCallback&&typeof processedContactCallback!==
"function")throw new Error("importVCard exception: cannot specify a processedContactCallback parameter that is not a function");this.vCardFileReader=new VCardFileReader({filePath:this.filePath});future.result=true});contactProcessedFunction=function(contactProcessedFuture){var result=contactProcessedFuture.result;if(result.keepProcessing){if(!saveToDB&&result.processedContact)allContacts.push(result.processedContact);processedContactCallbackValue=processedContactCallback?processedContactCallback(result.result):
true;if(processedContactCallbackValue){savedProcessedContactFuture.then(this,contactProcessedFunction);savedProcessedContactFuture.nest(this._processOneContact(saveToDB))}else{console.log("importVCard: Consumer cancelled processing of vCard!!");if(saveToDB)future.result=true;else future.result=allContacts;return}}else{if(saveToDB)future.result=true;else future.result=allContacts;return}};future.then(this,function(){var processOneContactReturnValue,result;savedProcessedContactFuture.then(this,contactProcessedFunction);
savedProcessedContactFuture.nest(this._processOneContact(saveToDB))});return future},_processOneContact:function(saveToDB){var currentLine=this.vCardFileReader.readLine(),currentContact,duplicate,hash,onContactSaveFunction=function(future){var result=future.result;future.result={keepProcessing:true,result:result,processedContact:currentContact}};while(currentLine!==null){if(VCardImporter._isLineBeginVCard(currentLine)){this._setCurrentContact(new Contact);currentLine=this.vCardFileReader.readLine();
continue}if(VCardImporter._isLineEndVCard(currentLine)){currentContact=this._getCurrentContact();if(saveToDB){duplicate=false;if(this._hashes){hash=this._generateHash(currentContact);duplicate=this._hashes[hash]?true:false}if(duplicate)return new Future({keepProcessing:true,result:true,processedContact:currentContact});else{currentContact.setKind(this._importContactDBKind);currentContact.getAccountId().setValue(this.importToAccountId);return currentContact.save().then(onContactSaveFunction)}}else return new Future({keepProcessing:true,
result:true,processedContact:currentContact})}else this._handleLine(currentLine,this.vCardFileReader);currentLine=this.vCardFileReader.readLine()}return new Future({keepProcessing:false})},countContacts:function(){return VCardImporter.countContacts(this.filePath)},_getCurrentContact:function(){return this.currentContact},_setCurrentContact:function(contactToAdd){this.currentContact=contactToAdd},_handleLine:function(line,fileReader){var lineType=this._getVCardLinePrefixType(line),currentContact=this._getCurrentContact(),
tempOrganization,tempLine2,endCardRegex;if(!currentContact){currentContact=new Contact;this._setCurrentContact(currentContact)}if(!lineType)return;switch(lineType){case VCard.MARKERS.NAME:currentContact.getName().set(this._handleName(line));break;case VCard.MARKERS.NICKNAME:currentContact.getNickname().setValue(this._handleNickname(line));break;case VCard.MARKERS.COMPANY:this._doOrganizationLine(currentContact,line,this._handleCompanyName);break;case VCard.MARKERS.JOBTITLE:this._doOrganizationLine(currentContact,
line,this._handleJobTitle);break;case VCard.MARKERS.PHONE:currentContact.getPhoneNumbers().add(this._handlePhoneNumber(line));break;case VCard.MARKERS.EMAIL:currentContact.getEmails().add(this._handleEmail(line));break;case VCard.MARKERS.ADDRESS:currentContact.getAddresses().add(this._handleAddress(line));break;case VCard.MARKERS.BIRTHDAY:currentContact.getBirthday().setValue(this._handleBirthday(line));break;case VCard.MARKERS.URL:currentContact.getUrls().add(this._handleUrl(line));break;case VCard.MARKERS.RELATED:tempLine2=
fileReader.peek();endCardRegex=new RegExp(VCard.MARKERS.END);if(endCardRegex.exec(VCardImporter._handleBadPeoplesImplementationOfvCardsFixupLine(tempLine2))){console.warn("vCardImporter._handleLine ERROR: ran into a malformed vCard entry when handling related line");return}tempLine2=fileReader.readLine();currentContact.getRelations().add(this._handleRelation(line,tempLine2));break;case VCard.MARKERS.SPOUSE_ONE_LINE:currentContact.getRelations().add(this._handleRelation(line,VCard.TYPEMARKERS.SPOUSE_ONE_LINER));
break;case VCard.MARKERS.CHILD_ONE_LINE:currentContact.getRelations().add(this._handleRelation(line,VCard.TYPEMARKERS.CHILD_ONE_LINER));break;case VCard.MARKERS.GTALK:currentContact.getIms().add(this._handleIM(VCard.IM_SERVICES.GTALK.VCARD_VALUE,line));break;case VCard.MARKERS.AIM:currentContact.getIms().add(this._handleIM(VCard.IM_SERVICES.AIM.VCARD_VALUE,line));break;case VCard.MARKERS.MSN:currentContact.getIms().add(this._handleIM(VCard.IM_SERVICES.MSN.VCARD_VALUE,line));break;case VCard.MARKERS.YAHOO:currentContact.getIms().add(this._handleIM(VCard.IM_SERVICES.YAHOO.VCARD_VALUE,
line));break;case VCard.MARKERS.JABBER:currentContact.getIms().add(this._handleIM(VCard.IM_SERVICES.JABBER.VCARD_VALUE,line));break;case VCard.MARKERS.QQ:currentContact.getIms().add(this._handleIM(VCard.IM_SERVICES.QQ.VCARD_VALUE,line));break;case VCard.MARKERS.ICQ:currentContact.getIms().add(this._handleIM(VCard.IM_SERVICES.ICQ.VCARD_VALUE,line));break;case VCard.MARKERS.SKYPE:currentContact.getIms().add(this._handleIM(VCard.IM_SERVICES.SKYPE.VCARD_VALUE,line));break;case VCard.MARKERS.IM:currentContact.getIms().add(this._handleIM(VCard.IM_SERVICES.OTHER.SERVICE_NAME,
line));break;case VCard.MARKERS.NOTE:currentContact.getNote().setValue(this._handleNote(line));break}},_doOrganizationLine:function(currentContact,line,handleOrganizationFunction){var tempOrganization=currentContact.getOrganizations().getArray()[0];if(!tempOrganization){tempOrganization=handleOrganizationFunction.apply(this,[line,tempOrganization]);currentContact.getOrganizations().add(tempOrganization)}else handleOrganizationFunction.apply(this,[line,tempOrganization])},_handlePhoneNumber:function(line){var toReturn=
new PhoneNumber;toReturn.setValue(this._getLineValue(line));toReturn.setType(this._setThisTypeIfUndefined(this._mapVCardValueToContactPointType(this._extractLabel(line),VCard.TYPES.PHONE_NUMBER),VCard.TYPES.PHONE_NUMBER.OTHER.CONTACT_POINT_VALUE));return toReturn},_handleEmail:function(line){var toReturn=new EmailAddress;toReturn.setValue(this._getLineValue(line));toReturn.setType(this._setThisTypeIfUndefined(this._mapVCardValueToContactPointType(this._extractLabel(line),VCard.TYPES.EMAIL),VCard.TYPES.EMAIL.OTHER.CONTACT_POINT_VALUE));
return toReturn},_handleNickname:function(line){return this._unescapeString(this._getLineValue(line))},_handleUrl:function(line){var toReturn=new Url;toReturn.setValue(this._getLineValue(line));toReturn.setType(this._setThisTypeIfUndefined(this._mapVCardValueToContactPointType(this._extractLabel(line),VCard.TYPES.URL),VCard.TYPES.URL.OTHER.CONTACT_POINT_VALUE));return toReturn},_handleBirthday:function(line){var toReturn,bdayValue=this._getLineValue(line);if(bdayValue.length<8){console.log("Birthday for vCard contact is too short to parse");
return undefined}if(bdayValue.length===8)bdayValue=bdayValue.substring(0,4)+"-"+bdayValue.substring(4,6)+"-"+bdayValue.substring(6,8);else if(bdayValue.length>10)return undefined;return bdayValue},_handleName:function(line){var name=this._getLineValue(line),namePieces=this._splitValues(name),i=0,namePiece,toReturn;toReturn=new Name;if(namePieces.length===0)return toReturn;for(i=0;i<namePieces.length;i+=1){namePiece=namePieces[i];switch(i){case 0:toReturn.setFamilyName(namePiece);break;case 1:toReturn.setGivenName(namePiece);
break;case 2:toReturn.setMiddleName(namePiece);break;case 3:toReturn.setHonorificPrefix(namePiece);break;case 4:toReturn.setHonorificSuffix(namePiece);break}}return toReturn},_handleIM:function(type,line){var im=new IMAddress;if(!type||!line)return undefined;switch(type){case VCard.IM_SERVICES.GTALK.VCARD_VALUE:im.setType(VCard.IM_SERVICES.GTALK.SERVICE_NAME);break;case VCard.IM_SERVICES.AIM.VCARD_VALUE:im.setType(VCard.IM_SERVICES.AIM.SERVICE_NAME);break;case VCard.IM_SERVICES.MSN.VCARD_VALUE:im.setType(VCard.IM_SERVICES.MSN.SERVICE_NAME);
break;case VCard.IM_SERVICES.JABBER.VCARD_VALUE:im.setType(VCard.IM_SERVICES.JABBER.SERVICE_NAME);break;case VCard.IM_SERVICES.YAHOO.VCARD_VALUE:im.setType(VCard.IM_SERVICES.YAHOO.SERVICE_NAME);break;case VCard.IM_SERVICES.ICQ.VCARD_VALUE:im.setType(VCard.IM_SERVICES.ICQ.SERVICE_NAME);break;case VCard.IM_SERVICES.QQ.VCARD_VALUE:im.setType(VCard.IM_SERVICES.QQ.SERVICE_NAME);break;case VCard.IM_SERVICES.SKYPE.VCARD_VALUE:im.setType(VCard.IM_SERVICES.SKYPE.SERVICE_NAME);break;default:im.setType(VCard.IM_SERVICES.OTHER.SERVICE_NAME);
break}im.setValue(this._getLineValue(line));return im},_handleCompanyName:function(line,organization){var companyString=this._getLineValue(line),splitCompany=this._splitValues(companyString),companyName=splitCompany[0];organization=organization?organization:new Organization;organization.setName(companyName?companyName:"");return organization},_handleJobTitle:function(line,organization){var jobTitle=this._unescapeString(this._getLineValue(line));organization=organization?organization:new Organization;
organization.setTitle(jobTitle?jobTitle:"");return organization},_handleAddress:function(line){var toReturn=new Address,poBox="",street="",extended="",addressValue=this._getLineValue(line),addressParts,addressPart,strippedAddress,i;addressParts=addressValue.split(";");for(i=0;i<addressParts.length;i+=1){addressPart=addressParts[i];switch(i){case 0:poBox=addressPart;break;case 1:strippedAddress=addressPart.replace(/\\n/g,"\n");strippedAddress=strippedAddress.replace(/\\\,/g,",");extended=strippedAddress;
break;case 2:street=addressPart;break;case 3:toReturn.setLocality(addressPart);break;case 4:toReturn.setRegion(addressPart);break;case 5:toReturn.setPostalCode(addressPart);break;case 6:toReturn.setCountry(addressPart);break}}poBox=poBox&&(street||extended)?poBox+", ":poBox;street=street&&extended?street+", ":street;toReturn.setStreetAddress(poBox+street+extended);toReturn.setType(this._setThisTypeIfUndefined(this._mapVCardValueToContactPointType(this._extractLabel(line),VCard.TYPES.ADDRESS),VCard.TYPES.ADDRESS.OTHER.CONTACT_POINT_VALUE));
return toReturn},_handleRelation:function(relationNameLine,relationTypeLine){var name=relationNameLine?this._getLineValue(relationNameLine):undefined,type=relationTypeLine?this._setThisTypeIfUndefined(this._mapVCardValueToContactPointType(this._extractRelationLabel(relationTypeLine),VCard.TYPES.RELATION),VCard.TYPES.RELATION.OTHER.CONTACT_POINT_VALUE):undefined;if(name&&type)return new Relation({value:name,type:type,primary:false})},_getTypeInfo:function(line){var seperatorIndex=line.indexOf(VCard.MARKERS.SEPERATOR),
typeInfo,toReturn=VCard.TYPEMARKERS.OTHER;seperatorIndex=seperatorIndex===-1?undefined:seperatorIndex;typeInfo=line.substring(0,seperatorIndex);typeInfo=VCardImporter._handleBadPeoplesImplementationOfvCardsFixupLine(typeInfo);return typeInfo},_extractRelationLabel:function(line){var typeInfo=this._getLineValue(line),toReturn=VCard.TYPEMARKERS.OTHER;typeInfo=typeInfo?VCardImporter._handleBadPeoplesImplementationOfvCardsFixupLine(typeInfo):"";if(typeInfo.indexOf(VCard.TYPEMARKERS.ASSISTANT)!==-1)toReturn=
VCard.TYPEMARKERS.ASSISTANT;else if(typeInfo.indexOf(VCard.TYPEMARKERS.BROTHER)!==-1)toReturn=VCard.TYPEMARKERS.BROTHER;else if(typeInfo.indexOf(VCard.TYPEMARKERS.CHILD)!==-1)toReturn=VCard.TYPEMARKERS.CHILD;else if(typeInfo.indexOf(VCard.TYPEMARKERS.FATHER)!==-1)toReturn=VCard.TYPEMARKERS.FATHER;else if(typeInfo.indexOf(VCard.TYPEMARKERS.FRIEND)!==-1)toReturn=VCard.TYPEMARKERS.FRIEND;else if(typeInfo.indexOf(VCard.TYPEMARKERS.MANAGER)!==-1)toReturn=VCard.TYPEMARKERS.MANAGER;else if(typeInfo.indexOf(VCard.TYPEMARKERS.MOTHER)!==
-1)toReturn=VCard.TYPEMARKERS.MOTHER;else if(typeInfo.indexOf(VCard.TYPEMARKERS.PARENT)!==-1)toReturn=VCard.TYPEMARKERS.PARENT;else if(typeInfo.indexOf(VCard.TYPEMARKERS.PARTNER)!==-1)toReturn=VCard.TYPEMARKERS.PARTNER;else if(typeInfo.indexOf(VCard.TYPEMARKERS.RELATIVE)!==-1)toReturn=VCard.TYPEMARKERS.RELATIVE;else if(typeInfo.indexOf(VCard.TYPEMARKERS.SISTER)!==-1)toReturn=VCard.TYPEMARKERS.SISTER;else if(typeInfo.indexOf(VCard.TYPEMARKERS.SPOUSE)!==-1)toReturn=VCard.TYPEMARKERS.SPOUSE;else if(typeInfo.indexOf(VCard.TYPEMARKERS.REFERRED_BY)!==
-1)toReturn=VCard.TYPEMARKERS.REFERRED_BY;else if(typeInfo.indexOf(VCard.TYPEMARKERS.DOMESTIC_PARTNER)!==-1)toReturn=VCard.TYPEMARKERS.DOMESTIC_PARTNER;return toReturn},_extractLabel:function(line){var typeInfo=this._getTypeInfo(line),toReturn=VCard.TYPEMARKERS.OTHER;if(typeInfo.indexOf(VCard.TYPEMARKERS.FAX)!==-1)if(typeInfo.indexOf(VCard.TYPEMARKERS.HOME)!==-1)toReturn=VCard.TYPEMARKERS.FAX_HOME;else toReturn=VCard.TYPEMARKERS.FAX_WORK;else if(typeInfo.indexOf(VCard.TYPEMARKERS.WORK)!==-1)toReturn=
VCard.TYPEMARKERS.WORK;else if(typeInfo.indexOf(VCard.TYPEMARKERS.HOME)!==-1)toReturn=VCard.TYPEMARKERS.HOME;else if(typeInfo.indexOf(VCard.TYPEMARKERS.CELL)!==-1)toReturn=VCard.TYPEMARKERS.CELL;else if(typeInfo.indexOf(VCard.TYPEMARKERS.PAGER)!==-1)toReturn=VCard.TYPEMARKERS.PAGER;else if(typeInfo.indexOf(VCard.TYPEMARKERS.MAIN)!==-1)toReturn=VCard.TYPEMARKERS.MAIN;return toReturn},_getLineValue:function(line){line=Foundations.StringUtils.escapeHTML(line);return line.substring(line.indexOf(VCard.MARKERS.SEPERATOR)+
1).replace(/\r$/,"")},_getVCardLinePrefixType:function(line){var prefixMatcher=new RegExp(VCardImporter.PREFIX_REGEX,"i"),items=prefixMatcher.exec(line);if(items&&items.length>2)return items[2].toUpperCase();return undefined},_mapVCardValueToContactPointType:function(vCardType,contactPointTypeObjects){var contactPointType,contactPointTypeObject,defaultContactPointType;for(contactPointType in contactPointTypeObjects)if(contactPointTypeObjects.hasOwnProperty(contactPointType)){contactPointTypeObject=
contactPointTypeObjects[contactPointType];if(contactPointTypeObject.VCARD_VALUE&&contactPointTypeObject.VCARD_VALUE===vCardType)return contactPointTypeObject.CONTACT_POINT_VALUE?contactPointTypeObject.CONTACT_POINT_VALUE:undefined;else if(!contactPointTypeObject.VCARD_VALUE&&!defaultContactPointType)defaultContactPointType=contactPointTypeObject.CONTACT_POINT_VALUE?contactPointTypeObject.CONTACT_POINT_VALUE:undefined}return defaultContactPointType},_setThisTypeIfUndefined:function(returnedContactPointType,
typeToSetIfUndefined){return returnedContactPointType?returnedContactPointType:typeToSetIfUndefined},_splitValues:function(string){var values=[],value="",ch,backslashes,i;if(/\\;/.test(string)){for(i=0;i<string.length;i=i+1){ch=string.charAt(i);if(ch===";"){backslashes=value.match(/[\\]+$/);if(backslashes)if(backslashes[0].length%2===0){values.push(value);value=""}else value+=ch;else{values.push(value);value=""}}else value+=ch}if(value)values.push(value)}else values=string.split(";");for(i=0;i<values.length;i=
i+1)values[i]=StringUtils.escapeCommon(values[i],/(\\\\)|(\\:)|(\\;)|(\\,)/g,{"\\\\":"\\","\\:":":","\\;":";","\\,":","});return values},_unescapeString:function(string){return StringUtils.escapeCommon(string,/(\\\\)|(\\:)|(\\;)|(\\,)|(\\N)|(\\n)/g,{"\\\\":"\\","\\:":":","\\;":";","\\,":",","\\N":"\n","\\n":"\n"})},_handleNote:function(line){return this._unescapeString(this._getLineValue(line))},_setupImport:function(processedContactCallback,deduplicate){var future=new Future;future.now(this,function(){if(this.importToAccountId===
"")var appPrefs=new AppPrefs(future.callback(function(){return appPrefs.get(AppPrefs.Pref.defaultAccountId)}));else return this.importToAccountId});future.then(this,function(){this.importToAccountId=future.result;console.log("vcards imported to account:"+this.importToAccountId);PalmCall.call("palm://com.palm.service.accounts/","getAccountInfo",{accountId:this.importToAccountId}).then(this,function(accountFuture){var account=accountFuture.result.result,provider,i,noDBKinds=false,hash,hashes={},hasHashes=
false,query={};if(accountFuture.result&&accountFuture.result.returnValue&&accountFuture.result.returnValue===true){for(i=0;i<account.capabilityProviders.length&&!this._importContactDBKind&&!noDBKinds;i=i+1){provider=account.capabilityProviders[i];if(provider.capability==="CONTACTS")if(provider.id==="com.palm.palmprofile.contacts")this._importContactDBKind="com.palm.contact.palmprofile:1";else if(provider.dbkinds&&provider.dbkinds.contact)this._importContactDBKind=provider.dbkinds.contact;else noDBKinds=
true}if(this._importContactDBKind)if(deduplicate){query.from=Contact.kind;query.where=[{prop:"accountId",op:"=",val:this.importToAccountId}];DB.find(query,false,true).then(this,function processContacts(contactsFuture){var contacts,contact,count;if(contactsFuture.result&&contactsFuture.result.returnValue&&contactsFuture.result.returnValue===true&&contactsFuture.result.results.length>0){contacts=contactsFuture.result.results;count=contactsFuture.result.results.length;for(i=0;i<count;i=i+1){hash=this._generateHash(new Contact(contacts[i]));
if(hash){hashes[hash]=true;hasHashes=true}}if(hasHashes)this._hashes=hashes}if(contactsFuture.next){query={};query.from=Contact.kind;query.next=contactsFuture.next;DB.find(query,false,true).then(_.bind(processContacts,this))}else this._importVCard(processedContactCallback,true).then(this,function(){future.result=true})})}else this._importVCard(processedContactCallback,true).then(this,function(){future.result=true});else future.exception={errorCode:"NO_PROVIDER_FOR_CONTACTS",errorText:'no provider for contacts could be retrieved for account: "'+
this.importToAccountId+'"'}}else future.exception={errorCode:"NO_ACCOUNT_INFO",errorText:'no account info could be retrieved for account: "'+this.importToAccountId+'"'}})});return future},_generateHash:function(contact){var i,j,item,data="",hash,ar;item=contact.getAnniversary().getValue();data+=item?item:"";item=contact.getBirthday().getValue();data+=item?item:"";item=contact.getGender().getValue();data+=item?item:"";item=contact.getNickname().getValue();data+=item?item:"";item=contact.getNote().getValue()?
contact.getNote().getNormalizedHashKey():null;data+=item?item:"";item=contact.getName().getNormalizedHashKey();data+=item?item:"";ar=contact.getAddresses().getArray();for(i=0;i<ar.length;i=i+1){item=ar[i].getNormalizedHashKey();data+=item}ar=contact.getEmails().getArray();for(i=0;i<ar.length;i=i+1){item=ar[i].getNormalizedHashKey();data+=item}ar=contact.getIms().getArray();for(i=0;i<ar.length;i=i+1){item=ar[i].getNormalizedHashKey();data+=item}ar=contact.getOrganizations().getArray();for(i=0;i<ar.length;i=
i+1){item=ar[i].getName();item+=ar[i].getDepartment();item+=ar[i].getTitle();item+=ar[i].getType();item+=ar[i].getStartDate();item+=ar[i].getEndDate();if(ar[i].getLocation())item+=ar[i].getLocation().getNormalizedHashKey();data+=item}ar=contact.getPhoneNumbers().getArray();for(i=0;i<ar.length;i=i+1){item=ar[i].getNormalizedHashKey();data+=item}ar=contact.getUrls().getArray();for(i=0;i<ar.length;i=i+1){item=ar[i].getNormalizedHashKey();data+=item}ar=contact.getRelations().getArray();for(i=0;i<ar.length;i=
i+1){item=ar[i].getNormalizedHashKey();data+=item}hash=data.length>0?Crypto.MD5.b64_md5(data):null;return hash}});VCardImporter._handleBadPeoplesImplementationOfvCardsFixupLine=function(line){return line.toUpperCase()};VCardImporter._isLineBeginVCard=function(line){var newCardRegex=new RegExp(VCard.MARKERS.BEGIN);return newCardRegex.exec(VCardImporter._handleBadPeoplesImplementationOfvCardsFixupLine(line))};
VCardImporter._isLineEndVCard=function(line){var newCardRegex=new RegExp(VCard.MARKERS.END);return newCardRegex.exec(VCardImporter._handleBadPeoplesImplementationOfvCardsFixupLine(line))};
VCardImporter.countContacts=function(filePath){Assert.require(Foundations.Comms.loadFile(filePath),"File to count vCards does not exist");var vCardReader=new VCardFileReader({filePath:filePath}),currentLine=null,contactCount=0;currentLine=vCardReader.readLine();while(currentLine!==null){if(VCardImporter._isLineBeginVCard(currentLine))contactCount+=1;currentLine=vCardReader.readLine()}return contactCount};VCardImporter.PREFIX_REGEX="^(item[0-9]*?.)?([A-Z-]+)[;|:].*";var App=exports.App={launchContactsAppToPseudoDetailScene:function(launchParams){Assert.require(launchParams&&(launchParams.person||launchParams.contact),"launchContactsAppToPseudoDetailScene requires a person or contact object to be passed");Assert.require(!(launchParams.person&&launchParams.contact),"launchContactsAppToPseudoDetailScene You must specify a person OR a contact. Not both.");launchParams.launchType="pseudo-card";if(launchParams.person&&launchParams.person instanceof Person)launchParams.person=
launchParams.person.getDBObject();if(launchParams.contact&&launchParams.contact instanceof Contact)launchParams.contact=launchParams.contact.getDBObject();return PalmCall.call("palm://com.palm.applicationManager/","open",{id:"com.palm.app.contacts",params:launchParams})}};

	};

	inBuiltinEnv = false;

	exports.__setGlobal__ = function(inWin, loader) {
		window = inWin;
		document = window.document;
		console = window.console;
		MojoLoader = loader;
		PalmServiceBridge = window.PalmServiceBridge;
		PalmSystem = window.PalmSystem;
		XMLHttpRequest = window.XMLHttpRequest;
		if (typeof Mojo === 'undefined') {
			Mojo = window.Mojo;
		}
	};

	
	;%ToFastProperties(exports);
	;%SetProperty(global, "palmcontactsVersion1_0", exports, 2);
}

SetuppalmcontactsVersion1_0();
