
function Setuppalmmojo_coreVersion1_0() {
	
	var Infinity = global.Infinity,
		NaN = global.NaN,
		undefined = global.undefined;

	
	var Array = global.Array,
		Boolean = global.Boolean,
		Date = global.Date,
		Error = global.Error,
		Function = global.Function,
		Number = global.Number,
		Object = global.Object,
		RegExp = global.RegExp,
		String = global.String,
		EvalError = global.EvalError,
		RangeError = global.RangeError,
		ReferenceError = global.ReferenceError,
		SyntaxError = global.SyntaxError,
		TypeError = global.TypeError,
		URIError = global.URIError;

	
	var Math = global.Math;

	
	var JSON = global.JSON;

	
	var PalmSystem = global.PalmSystem;

	
	var window = global;
	var MojoLoader;
	var Mojo;
	var document = window.document;
	var console;
	var PalmServiceBridge;
	var XMLHttpRequest;

	var inBuiltinEnv = true;

	
	function setPrototype(fn, proto) {
		;%FunctionSetPrototype(fn, proto);
	}

	
	
	function setInterval() {
		return window.setInterval.apply(window, arguments);
	}
	function clearInterval() {
		return window.clearInterval.apply(window, arguments);
	}
	function setTimeout() {
		return window.setTimeout.apply(window, arguments);
	}
	function clearTimeout() {
		return window.clearTimeout.apply(window, arguments);
	}
	function palmGetResource() {
		return window.palmGetResource.apply(window, arguments);
	}
	function palmRequire() {
		return window.palmRequire.apply(window, arguments);
	}
	function palmInclude() {
		return window.palmInclude.apply(window, arguments);
	}
	function eval() {
		return window.eval.apply(window, arguments);
	}
	function encodeURIComponent() {
		return window.encodeURIComponent.apply(window, arguments);
	}
	function decodeURIComponent() {
		return window.decodeURIComponent.apply(window, arguments);
	}
	function encodeURI() {
		return window.encodeURI.apply(window, arguments);
	}
	function decodeURI() {
		return window.decodeURI.apply(window, arguments);
	}
	function parseInt() {
		return window.parseInt.apply(window, arguments);
	}
	function parseFloat() {
		return window.parseFloat.apply(window, arguments);
	}
	function isNaN() {
		return window.isNaN.apply(window, arguments);
	}
	function isFinite() {
		return window.isFinite.apply(window, arguments);
	}

	var exports = new $Object();

	var _;if(typeof Object.create!=="function")Object.create=function(o){function F(){}F.prototype=o;return new F};if(Function.prototype.bind===undefined)Function.prototype.bind=function(){if(arguments.length<2&&arguments[0]===undefined)return this;var __method=this,args=Array.prototype.slice.call(arguments),object=args.shift();return function(){return __method.apply(object,args.concat(Array.prototype.slice.call(arguments)))}};
exports.onLoad=function(){TypeError.prototype.toString=function(){console.error(this.message);if(this.stack)console.log(this.stack)};if(typeof window==="undefined"&&typeof global!=="undefined"){global.window=global;window.addEventListener=function(){};window.document={addEventListener:function(){}}}Event.setup();App.setup();Service.setup()};function assertElement(el){if(!(el&&el.nodeType==1))throw new TypeError("A DOM element is required.");}
function assignPrototype(fn,proto){if(typeof inBuiltinEnv!=="undefined"&&inBuiltinEnv)setPrototype(fn,proto);else fn.prototype=proto};function GarbageStats(){var self=this;self.request=Service.createRequest("palm://com.palm.lunastats/getStats",{},function(result){self.originalBytes=result.counters.jsHeap.used;self.originalGcCount=result.counters.jsHeap["gc-count"]})}
assignPrototype(GarbageStats,{reportStats:function(){var self=this;self.request=Service.createRequest("palm://com.palm.lunastats/getStats",{},function(result){var bytes=(result.counters.jsHeap.used-self.originalBytes)/1024;var gcs=result.counters.jsHeap["gc-count"]-self.originalGcCount;console.log("Used "+bytes+" kb");console.log("Ran GC "+gcs+" times")})}});var Service=function(){function Request(url,parameters,callback){var subscribed;if(!parameters.$activity)if(!PalmSystem.activityId)console.warn("No activity id available for service request!");else parameters.$activity={activityId:PalmSystem.activityId};subscribed=parameters&&(parameters.subscribe===true||parameters.watch===true);parameters=JSON.stringify(parameters);this.cancelled=false;this.psRequest=new PalmServiceBridge;var req=this.psRequest;var firstResponse=true;this.f=function(message){var response;
try{response=JSON.parse(message)}catch(e){response={errorCode:-1,errorText:"Bad JSON response: "+e.message}}if(!subscribed&&!firstResponse&&response.errorText&&response.errorText.match(/is not running.$/))req.cancel();else{firstResponse=false;callback(response)}};this.psRequest.onservicecallback=this.f;this.psRequest.call(url,parameters)}assignPrototype(Request,{cancel:function cancel(){if(this.psRequest){this.cancelled=true;this.psRequest.cancel();this.psRequest=undefined}else throw Error("cancelling a request that is not in progress");
}});var module={createRequest:function(url,parameters,callback){return new Request(url,parameters,callback)},setup:function(){if(typeof PalmServiceBridge==="undefined")if(typeof global!=="undefined")(function(){var handle;global.PalmServiceBridge=function(){};global.PalmServiceBridge.prototype={call:function(url,paramString){var that=this;if(!handle)handle=new webOS.Handle("",false);this.request=handle.call(url,paramString,function(responseObj){if(that.request)that.onservicecallback(responseObj.payload())})},
cancel:function(){if(this.request){handle.cancel(this.request);this.request=undefined}}}})();else(function(){function toQueryString(obj){var key;var pairs=[];var len;for(key in obj)if(obj.hasOwnProperty(key)){var val=obj[key];var encKey=encodeURIComponent(key);if(val===null||val===undefined)pairs.push(encKey);else if(typeof val=="number"||typeof val=="string"||val===true||val===false)pairs.push(encKey+"="+encodeURIComponent(val));else if(val.length){len=val.length;for(var i=0;i<len;++i)pairs.push(encKey+
"="+encodeURIComponent(val[i]))}else throw new Error("Can't convert unknown object \""+key+'" to a query string');}return pairs.join("&")}window.PalmServiceBridge=function(){};window.PalmServiceBridge.prototype={call:function(fullUrl,parameters){this.fullUrl=fullUrl;this.parameters=parameters;var matches=fullUrl.match(this.serviceExpression);if(matches&&matches.length==3){this.identifier=matches[1];this.method=matches[2];this.sendRequestToMojoHost()}else{var error=this.makeError(this.cannotExtractIdentifierError);
error.errorText+=this.fullUrl;this.sendResponse(error)}},sendRequestToMojoHost:function(){var params=this.parameters||"{}";var self=this;var ajaxParams={sessionID:window.parent.top.name,methodParams:params,serviceMethod:this.method,serviceName:this.identifier};var url=this.makeLunaHostUrl();var req=new XMLHttpRequest;req.onreadystatechange=function(){if(req.readyState==4)if(req.status>=200&&req.status<300){req.responseJSON=JSON.parse(req.responseText);self.onSuccess(req)}else self.onFailure(req)};
req.open("GET",url+"?"+toQueryString(ajaxParams));req.send(null)},makeLunaHostUrl:function(){return"/bridge/handle_method.js"},makeError:function(original){var key;var error={};for(key in original)if(original.hasOwnProperty(key))error[key]=original[key];return error},makeNoSuchServiceError:function(){var error=this.makeError(this.noSuchServiceError);return error},makeUnknownServiceError:function(transport){var error=this.makeError(this.unknownServiceError);error.errorText+=transport.status;error.errorText+=
":";error.errorText+=transport.responseText;return error},onSuccess:function(transport){var response=transport.responseJSON;if(window.parent&&window.parent.comet)window.parent.comet.serviceBridgeManager.requests[response.token]=this},onFailure:function(transport){if(transport.status==501)this.sendResponse(this.makeNoSuchServiceError());else this.sendResponse(this.makeUnknownServiceError(transport))},sendResponse:function(error){var self=this;setTimeout(function(){self.onservicecallback(JSON.stringify(error))},
0)},cancel:function(){},serviceExpression:/palm:\/\/([\w.]+)\/(.*)/,cannotExtractIdentifierError:{returnValue:false,errorCode:-1,errorText:"Cannot extract identifier and method from "},noSuchServiceError:{returnValue:false,errorCode:-1,errorText:"mojo-host provides no service '<%= identifier %>' with method '<%= method %>'"},unknownServiceError:{returnValue:false,errorCode:-1,errorText:"mojo-host error: "}}})()}};exports.Service=module;return module}();var Event=function(){var key;var logEvents=false;var PASS_EVENT_ATTRIBUTE="x-palm-pass-event";var ESC_KEY=27;var module,events;function logEvent(prefix,event,targetElement,mojoDetails){if(logEvents)console.log("%s event '%s' targeting element '%s#%s' %s",prefix,event.type,targetElement.tagName,targetElement.id||"<no id>")}function getStyle(el,style){var value=el.style[style];var css;if(!value||value=="auto"){css=el.ownerDocument.defaultView.getComputedStyle(el,null);value=css?css[style]:null}if(style==
"opacity")return value?parseFloat(value):1;return value=="auto"?null:value}module={make:function(name,details,doc,bubbles,cancel){var newEvent,key;bubbles=bubbles!==undefined?bubbles:true;cancel=cancel!==undefined?cancel:true;doc=doc||document;newEvent=doc.createEvent("HTMLEvents");newEvent.initEvent(name,bubbles,cancel);for(key in details)if(details.hasOwnProperty(key))newEvent[key]=details[key];return newEvent},send:function(element,name,details,bubbles,cancel){var newEvent=module.make(name,details,
element.ownerDocument,bubbles,cancel);logEvent("sending",newEvent,element,details);element.dispatchEvent(newEvent);return newEvent},stop:function(e){if(e.preventDefault)e.preventDefault();if(e.stopPropagation)e.stopPropagation()},pointer:function(e){return{x:e.pageX,y:e.pageY}},setup:function(){var win=window;var doc=win.document;var dragStarted=false;var mouseDown,mouseUp,mouseMove;var lastDownPointer,lastMouseDownEvent;mouseDown=function(e){var tagName=e.target.tagName;lastMouseDownEvent=e;var passEvent=
e.target.getAttribute(PASS_EVENT_ATTRIBUTE);var userModify=getStyle(e.target,"-webkit-user-modify")==="read-write"||tagName==="INPUT"||tagName==="TEXTAREA"||tagName==="OBJECT";lastDownPointer=module.pointer(lastMouseDownEvent);doc.addEventListener("mousemove",mouseMove);doc.addEventListener("mouseup",mouseUp);if(!passEvent&&!userModify)module.stop(e)};mouseMove=function(e){var pt2=module.pointer(e);var distance={x:Math.abs(lastDownPointer.x-pt2.x),y:Math.abs(lastDownPointer.y-pt2.y)};e.filteredPointer=
pt2;var info={filteredDistance:distance,down:lastMouseDownEvent,move:e};if(!dragStarted){module.send(lastMouseDownEvent.target,events.dragStart,info);dragStarted=true}else module.send(lastMouseDownEvent.target,events.dragging,info);module.stop(e)};mouseUp=function(e){if(dragStarted){module.send(lastMouseDownEvent.target,events.dragEnd,{down:lastMouseDownEvent,up:e});dragStarted=false;module.stop(e)}doc.removeEventListener("mousemove",mouseMove);doc.removeEventListener("mouseup",mouseUp)};function keyUp(e){var newEvent;
if(e.keyCode===ESC_KEY){newEvent=module.send(doc,events.back,e);if(newEvent.defaultPrevented)e.preventDefault();if(newEvent._mojoPropagationStopped)e.stopPropagation()}}function dispatchGesture(type,properties){var newProps={};switch(type){case "flick":newProps.velocity={x:properties.xVel,y:properties.yVel};newProps.origin={x:properties.x,y:properties.y};module.send(lastMouseDownEvent.target,events.flick,newProps);break;default:module.send(doc,"mojo-"+type,properties);break}}function orientationChanged(orientation){module.send(doc,
events.screenRotate,{orientation:orientation})}function fireWindowActivate(){module.send(doc,events.windowActivate)}function fireWindowDeactivate(){module.send(doc,events.windowDeactivate)}function fireRelaunch(){var params=PalmSystem.launchParams;if(params&&params!=="")params=JSON.parse(PalmSystem.launchParams);else params={};module.send(doc,events.relaunch,{params:params})}function fireLowMemory(params){module.send(doc,events.lowMemory,{data:params})}doc.addEventListener("mousedown",mouseDown);
doc.addEventListener("keyup",keyUp);win.addEventListener("unload",function(e){doc.removeEventListener("mousedown",mouseDown);doc.removeEventListener("keyup",keyUp)});if(!win.Mojo)win.Mojo={};win.Mojo.handleGesture=dispatchGesture;win.Mojo.screenOrientationChanged=orientationChanged;win.Mojo.stageActivated=fireWindowActivate;win.Mojo.stageDeactivated=fireWindowDeactivate;win.Mojo.relaunch=fireRelaunch;win.Mojo.lowMemoryNotification=fireLowMemory}};events={back:"mojo-back",forward:"mojo-forward",up:"mojo-up",
down:"mojo-down",command:"mojo-command",windowDeactivate:"mojo-window-deactivate",windowActivate:"mojo-window-activate",flick:"mojo-flick",screenRotate:"mojo-screen-rotate",dragStart:"mojo-drag-start",dragging:"mojo-dragging",dragEnd:"mojo-drag-end",relaunch:"mojo-relaunch",lowMemory:"mojo-lowmemory"};for(key in events)module[key]=events[key];exports.Event=module;return module}();var Child=function(){var defaultHeight={card:432,dashboard:48,popupAlert:200};var windowTypes={card:"card",dashboard:"dashboard",popupAlert:"popupalert",bannerAlert:"banneralert",activeBanner:"activebanner",stackedCard:"childcard",dockMode:"dockMode"};var browserFeatures="resizable=no,scrollbars=no,status=yes,width=320";function buildFeatures(features,attributes){var key;var strFeatures=browserFeatures;if(features)for(key in features)if(features.hasOwnProperty(key))strFeatures+=[",",key,"=",features[key]].join("");
strFeatures+=",attributes="+JSON.stringify(attributes);return strFeatures}function Banner(message,options){var soundClass,soundPath,soundDuration;options=options||{};if(!message)throw new TypeError("Banner: must have message");if(options.sound){soundClass=options.sound.audioClass;soundPath=options.sound.path;soundDuration=options.sound.duration}this.id=PalmSystem.addBannerMessage(message,JSON.stringify(options.launchArguments||{}),options.icon,soundClass,soundPath,soundDuration)}assignPrototype(Banner,
{close:function(){PalmSystem.removeBannerMessage(this.id)}});var module={createWindow:function(url,name,features,attributes){var strFeatures;var newWindow;features=features||{};attributes=attributes||{};attributes.window=attributes.window||windowTypes.card;features.height=features.height||defaultHeight[attributes.window];strFeatures=buildFeatures(features,attributes);newWindow=window.open(url,name,strFeatures);return newWindow},createBanner:function(message,options){return new Banner(message,options)}};
module.Types=windowTypes;exports.Child=module;return module}();var Animation=function(){var targetFPS=60;var stepRate=1/targetFPS*1E3;var showFPSUpdate=1E3;var maxExtraFrames=1;var fpsBoxId="mojo-fps-display-box";function createFpsEl(doc){var el=doc.createElement("div");el.id=fpsBoxId;el.style.position="fixed";el.style.width="60px";el.style.height="1em";el.style.top="90px";el.style.right="130px";el.style.margin="0px auto";el.style.border="1px solid #999";el.style["text-align"]="center";doc.querySelector("body").appendChild(el);return el}var Queue=function(targetWindow){this.window=
targetWindow||window;this.animations=[];this.frameTimeStamps=[];this.showFPS=false;this.nextFPSUpdate=(new Date).getTime()+showFPSUpdate};assignPrototype(Queue,{cleanup:function(){if(this.timer){this.window.clearInterval(this.timer);this.timer=undefined}},add:function(animation){if(!animation.animate)throw new TypeError('animation object must contain an "animate" property that is a function.');var index=this.animations.indexOf(animation);if(index===-1){this.animations.push(animation);if(this.animations.length==
1){this.timer=this.window.setInterval(this._step.bind(this),stepRate);this.frameTimeStamps=[];this.renderTime=Date.now()+stepRate}}},remove:function(animation){var index=this.animations.indexOf(animation);if(index!==-1){this.animations.splice(index,1);if(this.animations.length===0){this.window.clearInterval(this.timer);this.timer=undefined;if(this.showFPS)this.reportFPS()}}},_step:function(){var animations,i,now,fpsEl;var framesToRun;var showFPS=this.showFPS;framesToRun=Math.max(0,Date.now()-this.renderTime);
framesToRun/=stepRate;framesToRun=Math.floor(framesToRun+1);framesToRun=Math.min(framesToRun,maxExtraFrames);animations=this.animations;while(framesToRun>0){if(showFPS){this.frameTimeStamps.push(Date.now());if(this.frameTimeStamps.length>10)this.frameTimeStamps.shift()}for(i=animations.length-1;i>=0;i--)this._invokeAnimator(animations[i],framesToRun>1);framesToRun--;this.renderTime+=stepRate}if(showFPS){now=Date.now();if(this.frameTimeStamps.length>1&&now>this.nextFPSUpdate){fpsEl=this.window.document.getElementById(fpsBoxId);
fpsEl.innerHTML=this.reportFPS();this.nextFPSUpdate=now+showFPSUpdate}}},_invokeAnimator:function(a,catchingUp){try{a.animate(this,catchingUp)}catch(e){this.remove(a);if(a.handleError)try{a.handleError(e)}catch(e2){console.log(e2,"exception during animator error handler")}}},reportFPS:function(){var delta,averageTime,fps;var totalTime=0;var frameTimeStamps=this.frameTimeStamps;for(var i=1;i<frameTimeStamps.length;i++){delta=frameTimeStamps[i]-frameTimeStamps[i-1];totalTime+=delta}averageTime=totalTime/
(frameTimeStamps.length-1);fps=Math.round(1E3/averageTime);return fps},toggleFPSBox:function(){var doc=this.window.document;var fpsEl;if(this.showFps){fpsEl=doc.getElementById(fpsBoxId);doc.querySelector("body").removeChild(fpsEl)}else fpsEl=createFpsEl(doc);this.showFps=!this.showFps;return fpsEl}});var module={getQueue:function(el){var q,win;var oDoc=el.ownerDocument;function cleanup(e){if(win&&win._mojoAnimationQueue)win._mojoAnimationQueue.cleanup()}if(oDoc)win=oDoc.defaultView;else win=el.defaultView;
if(win){q=win._mojoAnimationQueue;if(!q){q=new Queue(win);win._mojoAnimationQueue=q;win.addEventListener("unload",cleanup)}}else throw new TypeError("Animation.getQueue: Could not find window for element");return q}};module.targetFPS=targetFPS;module.stepRate=stepRate;exports.Animation=module;return module}();var Scroll=function(){var key;var STEP_RATE=Animation.stepRate*1.2,MAX_TIME_SKIP=STEP_RATE*3,FLICK_SPEED=0.06,FLICK_RATIO=0.5,OVERSCROLL_TARGET_SPEED=0.25,CORRECT_OVERSCROLL_SPEED=0.3,DELAYED_STOP_MS=150,MIN_SCROLL_DELTA_SIZE=3,MIN_MOVE_DELTA=1,SCROLL_EVENT_RATE=10;var PROPERTY_MAP={x:"width",y:"height"};var SCROLL_MAP={x:"scrollLeft",y:"scrollTop"};function getBorderWidth(el,border){var width=0;var styleName="border-"+border+"-width";var style=el.style[styleName];if(style){width=parseInt(style,10);
if(!width)width=0}return width}function getUsableDimensions(el){var dimensions={width:el.offsetWidth,height:el.offsetHeight};dimensions.width-=getBorderWidth(el,"left");dimensions.width-=getBorderWidth(el,"right");dimensions.height-=getBorderWidth(el,"top");dimensions.height-=getBorderWidth(el,"bottom");return dimensions}function getScrollPosition(el){return{x:el.scrollLeft,y:el.scrollTop}}function getContentSize(el){return{width:el.scrollWidth,height:el.scrollHeight}}function positionedOffset(el){var x=
0,y=0;do{y+=el.offsetTop||0;x+=el.offsetLeft||0;el=el.offsetParent;if(el){if(el.tagName.toLowerCase()=="body")break;if(el.style.position!=="static")break}}while(el);return{x:x,y:y}}function roundTowardZero(num){return num|0}function zenoCalculate(fdr,elapsedFrames){var approachFDR;var unitDistanceRemaining;var unitDistanceTraveled;approachFDR=1-fdr;unitDistanceRemaining=Math.pow(approachFDR,elapsedFrames);unitDistanceTraveled=1-unitDistanceRemaining;return unitDistanceTraveled}var events={scrollStart:"mojo-core-scroll-start",
scrolling:"mojo-core-scrolling",scrollEnd:"mojo-core-scroll-end"};var DragAnimator={done:false,lastUpdateTime:0,target:0,current:0,initialized:false,initialize:function(position,min,max){if(!this.initialized){this.current=position;this.target=position;this.min=min;this.max=max;this.initialized=true}},updateTarget:function(newTarget){this.target=newTarget},animate:function(){var deltaDist=this.target-this.current;this.current+=deltaDist;this.done=true;return this.current},overscroll:function(){var elapsed,
elapsedFrames;var now=Date.now();var fdr=CORRECT_OVERSCROLL_SPEED;var current=this.current;var target=this.target;var lastUpdateTime=this.lastUpdateTime;if(!lastUpdateTime)lastUpdateTime=now-STEP_RATE;elapsed=Math.min(MAX_TIME_SKIP,now-lastUpdateTime);this.lastUpdateTime=lastUpdateTime+elapsed;elapsedFrames=elapsed/STEP_RATE;if(Math.abs(target-current)<=MIN_MOVE_DELTA)current=target;else current+=zenoCalculate(fdr,elapsedFrames)*(target-current);this.current=current;this.done=elapsedFrames&&roundTowardZero(current)===
0;return this.current},checkOverscroll:function(){if(this.current>this.max){this.dontStop=true;this.target=this.max;this.animate=this.overscroll}else if(this.current<this.min){this.dontStop=true;this.target=this.min;this.animate=this.overscroll}}};var FlickAnimator=Object.create(DragAnimator);FlickAnimator.animate=function(){var fdr;var now=Date.now();var lastUpdateTime=this.lastUpdateTime;var target=this.target;var current=this.current;var deltaDist=target-current;var elapsed,elapsedFrames;if(!this.lastUpdateTime)lastUpdateTime=
now-STEP_RATE;fdr=FLICK_SPEED;elapsed=Math.min(MAX_TIME_SKIP,now-lastUpdateTime);this.lastUpdateTime=lastUpdateTime+elapsed;elapsedFrames=elapsed/STEP_RATE;current+=zenoCalculate(fdr,elapsedFrames)*deltaDist;this.current=current;this.done=elapsedFrames&&roundTowardZero(target-current)===0;return current};FlickAnimator.checkOverscroll=function(){if(this.target>this.max||this.target<this.min){this.dontStop=true;this.animate=this.overscroll}};FlickAnimator.overscroll=function(){var lastUpdate,elapsed,
elapsedFrames,limit,isMaxLimit,ret,bothOutside,numFrames,frac;var now=Date.now();var amountToMoveTarget;var adjustedTarget=this.target;var fdr=CORRECT_OVERSCROLL_SPEED;var adjustedCurrent=this.current;if(!this.lastUpdateTime)this.lastUpdateTime=now-STEP_RATE;lastUpdate=this.lastUpdateTime;elapsed=Math.min(MAX_TIME_SKIP,now-lastUpdate);this.lastUpdateTime+=elapsed;elapsedFrames=elapsed/STEP_RATE;if(adjustedTarget<this.min&&adjustedCurrent<this.min){bothOutside=true;limit=this.min}else if(adjustedTarget>
this.max&&adjustedCurrent>this.max){bothOutside=true;limit=this.max}if(bothOutside){numFrames=roundTowardZero(elapsedFrames);frac=elapsedFrames-numFrames;if(roundTowardZero(limit-adjustedTarget)===0)adjustedTarget=limit;while(numFrames){amountToMoveTarget=(limit-adjustedTarget)*0.25;adjustedTarget+=amountToMoveTarget;adjustedCurrent+=(adjustedTarget-adjustedCurrent)*fdr;--numFrames}if(frac){amountToMoveTarget=(limit-adjustedTarget)*0.25*frac;adjustedTarget+=amountToMoveTarget;adjustedCurrent+=(adjustedTarget-
adjustedCurrent)*fdr*frac}}else if(Math.abs(adjustedTarget-adjustedCurrent)<=MIN_MOVE_DELTA)adjustedCurrent=adjustedTarget;else adjustedCurrent+=zenoCalculate(fdr,elapsedFrames)*(adjustedTarget-adjustedCurrent);this.target=adjustedTarget;this.current=adjustedCurrent;this.done=elapsedFrames&&roundTowardZero(adjustedCurrent-adjustedTarget)===0;return this.current};function Engine(el,axes){this.el=el;this.axes=axes||["x","y"];this.calculateLimits()}assignPrototype(Engine,{perAxis:function(fn){var i;
var len=this.axes.length;for(i=0;i<len;i++)fn.call(this,this.axes[i])},move:function(motions,animators){var self=this;var elementPos=getScrollPosition(this.el);var target;self.animators=animators;self.perAxis(function(axis){var motion=motions[axis];var limit=self.limits[axis];var animator=animators[axis];if(motion===undefined)return;animator.initialize(elementPos[axis],limit.min,limit.max);target=animator.target;if(target>limit.max||target<limit.min)motion=0.5*motion;target+=motion;target=Math.max(limit.minOverLimit,
target);target=Math.min(limit.maxOverLimit,target);animator.updateTarget(target)});if(!self.animating)self.startAnimating()},brake:function(){if(this.animating)this.braking=setTimeout(this.finishStop.bind(this),DELAYED_STOP_MS)},stopBraking:function(){clearTimeout(this.braking);this.braking=undefined},finishStop:function(){var self=this;var stop=true;if(!self.braking)return;self.braking=undefined;self.perAxis(function(axis){var animator=self.animators[axis];if(!animator.dontStop)animator.updateTarget(animator.current);
else stop=false});if(stop)self.stopAnimating()},calculateMax:function(){var self=this;var contentSize,scrollerSize,property,max;var ret={x:0,y:0};self.perAxis(function(axis){property=PROPERTY_MAP[axis];scrollerSize=getUsableDimensions(self.el)[property];contentSize=getContentSize(self.el)[property];max=contentSize-scrollerSize;if(max<MIN_SCROLL_DELTA_SIZE)max=0;ret[axis]=max});return ret},calculateLimits:function(){var self=this;var limit;var ratio=2;var margin;var dimensions=getUsableDimensions(self.el);
var max=self.calculateMax();self.limits={};self.perAxis(function(axis){self.limits[axis]=limit={};margin=Math.floor(dimensions[PROPERTY_MAP[axis]]*ratio);limit.min=0;limit.max=max[axis];limit.minOverLimit=limit.min-margin;limit.maxOverLimit=limit.max+margin})},startAnimating:function(){if(!this.animating){Animation.getQueue(this.el).add(this);this.animating=true;this.frames=0;Event.send(this.el,events.scrollStart)}},stopAnimating:function(){if(this.animating){this.animating=false;Animation.getQueue(this.el).remove(this);
Event.send(this.el,events.scrollEnd)}},animate:function(queue){var axis,target,current,animator,scrollProperty,newPosition,oldAnimator,limit,i,len;var done=true;var el=this.el;len=this.axes.length;for(i=0;i<len;i++){axis=this.axes[i];animator=this.animators[axis];scrollProperty=SCROLL_MAP[axis];newPosition=animator.animate();done&=animator.done;el[scrollProperty]=newPosition}this.frames++;if(this.frames%SCROLL_EVENT_RATE===0)Event.send(el,events.scrolling);if(done)this.stopAnimating()}});function ScrollableElement(el,
direction){assertElement(el);var axes;switch(direction){case "vertical":axes=["y"];break;case "horizontal":axes=["x"];break;case "free":axes=["x","y"];break;default:axes=["x","y"];break}this.el=el;this.el.style.overflow="hidden";this.el.style.overflow="-webkit-palm-overflow";this.dragStart=this.dragStart.bind(this);this.dragged=this.dragged.bind(this);this.dragEnd=this.dragEnd.bind(this);this.flick=this.flick.bind(this);this.flickStop=this.flickStop.bind(this);this.cleanup=this.cleanup.bind(this);
this.engine=new Engine(el,axes);el.addEventListener(Event.dragStart,this.dragStart);el.addEventListener(Event.flick,this.flick);el.addEventListener(el,"mousedown",this.flickStop);el.addEventListener("DOMNodeRemovedFromDocument",this.cleanup)}assignPrototype(ScrollableElement,{cleanup:function(e){var el=this.el;el.removeEventListener(Event.dragStart,this.dragStart);el.removeEventListener(Event.flick,this.flick);el.removeEventListener("mousedown",this.flickStop);el.removeEventListener("DOMNodeRemovedFromDocument",
this.cleanup)},dragStart:function(e){this.el.addEventListener(Event.dragging,this.dragged);this.el.addEventListener(Event.dragEnd,this.dragEnd);this.lastPointer=Event.pointer(e.down);this.dragAnimators={x:Object.create(DragAnimator),y:Object.create(DragAnimator)};this.dragged(e);Event.stop(e)},dragged:function(e){var self=this;var i,last,current,axis;var moveEvent=e.move||e;var pointer=Event.pointer(moveEvent);var motions={x:0,y:0};var axes=[];for(i in motions)if(motions.hasOwnProperty(i))axes.push(i);
var len=axes.length;for(i=0;i<len;i++){axis=axes[i];last=self.lastPointer[axis];current=pointer[axis];if(last!=current)motions[axis]=last-current}self.lastPointer=pointer;self.engine.move(motions,self.dragAnimators)},dragEnd:function(e){this.dragAnimators.x.checkOverscroll();this.dragAnimators.y.checkOverscroll();this.dragged(e.up);this.stopDrag();Event.stop(e)},stopDrag:function(e){this.dragAnimators=undefined;this.el.removeEventListener(Event.dragging,this.dragged);this.el.removeEventListener(Event.dragEnd,
this.dragEnd)},flick:function(e){var motion={};var animators={x:Object.create(FlickAnimator),y:Object.create(FlickAnimator)};this.stopDrag();this.engine.stopBraking();for(axis in e.velocity)if(e.velocity.hasOwnProperty(axis))motion[axis]=e.velocity[axis]*-FLICK_RATIO;this.engine.move(motion,animators);animators.x.checkOverscroll();animators.y.checkOverscroll();Event.stop(e)},flickStop:function(e){this.engine.brake()},revealTop:function(animate){return this.scrollTo(undefined,0,animate)},revealBottom:function(animate){return this.scrollTo(undefined,
this.el.scrollHeight-this.el.offsetHeight,animate)},revealElement:function(el,animate){assertElement(el);if(!this.el.contains(el))throw new Error("scrollable element does not contain element to reveal");var currentTop=-getScrollPosition(this.el).y;var currentBottom=currentTop+getUsableDimensions(this.el).height;var elHeight=el.offsetHeight;var elOffset=positionedOffset(el);var currentlyShowing=currentBottom-elOffset.y;var remainingToShow=elHeight-currentlyShowing;if(Math.abs(remainingToShow)>0)this.adjustBy(0,
remainingToShow);return remainingToShow},adjustBy:function(dx,dy){this.engine.move({x:dx,y:dy},{x:Object.create(DragAnimator),y:Object.create(DragAnimator)})},scrollTo:function(x,y,animate){var animator=animate?FlickAnimator:DragAnimator;var movement={x:x!==undefined?-(this.el.scrollLeft-x):x,y:y!==undefined?-(this.el.scrollTop-y):y};this.engine.move(movement,{x:Object.create(animator),y:Object.create(animator)})},getScrollPosition:function(){return{top:this.el.scrollTop,left:this.el.scrollLeft}}});
var module={createScrollableElement:function(el,direction){return new ScrollableElement(el,direction)},makeViewportScrollable:function(doc,axes){if(!(doc&&doc.nodeType==9))throw new TypeError("must pass a document to make scrollable");var children=Array.prototype.slice.call(doc.body.childNodes);var contentEl=doc.createElement("div");function setDimensions(){contentEl.style.height=doc.documentElement.clientHeight+"px";contentEl.style.width=doc.documentElement.clientWidth+"px"}function cleanup(){doc.defaultView.removeEventListener("resize",
setDimensions);doc.defaultView.removeEventListener("unload",cleanup)}contentEl.name="mojo-core-viewport-scroller";setDimensions();doc.body.appendChild(contentEl);for(var i=0;i<children.length;i++)contentEl.appendChild(children[i]);doc.defaultView.addEventListener("resize",setDimensions);doc.defaultView.addEventListener("unload",cleanup);return module.createScrollableElement(contentEl,axes)}};for(key in events)module[key]=events[key];exports.Scroll=module;return module}();var App=function(){var module={setup:function(){var jsonText;var match=document.baseURI.match(/file:\/\/\/.*\/(.*)\//);if(match)this.path=match[0];else this.path=document.baseURI.match(/http:\/\/.*\//)[0];jsonText=palmGetResource(this.path+"appinfo.json");if(jsonText)this.info=JSON.parse(jsonText);else if(window.opener)this.info=window.opener.mojoAppInfo;else this.info={};mojoAppInfo=this.info;if(!("noWindow"in this.info))this.info.noWindow=false}};exports.App=module;return module}();var AppMenu=function(){var request;return{setup:function(config){request=Service.createRequest("palm://com.palm.applicationManager/launch",{id:"com.palm.systemui",params:{action:"configureAppMenu",appId:App.info.id,config:config||{}}},function(){request=null});if(typeof document!=="undefined")document.addEventListener(Event.relaunch,function(e){if(e.params&&e.params.appMenuCommand){Event.send(document,"mojo-app-menu-command",{command:e.params.appMenuCommand});Event.stop(e)}})}}}();
exports.AppMenu=AppMenu;var AltChar=function(){var SYM_CODE=17;var request,target;function showAltCharPicker(){request=Service.createRequest("palm://com.palm.applicationManager/launch",{id:"com.palm.systemui",params:{action:"showAltChar"}},function(){request=null})}function sendFakeKey(type,charCode){var e=document.createEvent("Events");e.initEvent(type,true,true);e.keyCode=charCode;e.charCode=charCode;e.which=charCode;target.dispatchEvent(e);return e}return{setup:function(){if(typeof document!=="undefined"){document.addEventListener("keydown",
function(e){if(e.keyCode===SYM_CODE){target=e.target;console.log("saving off target: "+target);showAltCharPicker()}});document.addEventListener(Event.relaunch,function(e){var selection,newEvent,charCode;if(e.params&&e.params.altCharSelected){selection=window.getSelection();if(selection&&selection.rangeCount>0&&selection.getRangeAt(0))document.execCommand("insertText",true,e.params.altCharSelected);charCode=e.params.altCharSelected.charCodeAt(0);sendFakeKey("keydown",charCode);sendFakeKey("keypress",
charCode);sendFakeKey("keyup",charCode);Event.stop(e)}})}}}}();exports.AltChar=AltChar;


	inBuiltinEnv = false;

	exports.__setGlobal__ = function(inWin, loader) {
		window = inWin;
		document = window.document;
		console = window.console;
		MojoLoader = loader;
		PalmServiceBridge = window.PalmServiceBridge;
		PalmSystem = window.PalmSystem;
		XMLHttpRequest = window.XMLHttpRequest;
		if (typeof Mojo === 'undefined') {
			Mojo = window.Mojo;
		}
	};

	
	;%ToFastProperties(exports);
	;%SetProperty(global, "palmmojo_coreVersion1_0", exports, 2);
}

Setuppalmmojo_coreVersion1_0();
