/*jslint white: true, onevar: true, undef: true, eqeqeq: true, plusplus: true, bitwise: true, 
regexp: true, newcap: true, immed: true, nomen: false, maxerr: 500 */
/*global Class, Assert, console, AjaxCall, stringify, Utils, XMLHttpRequest:true */

var XMLHttpRequest = Class.create({
	open: function (httpMethod, url, isAsync) {
		Assert.requireString(httpMethod);
		Assert.requireString(url);
		
		// Utils.log("\n\n\n--->>> open called. httpMethod: " + httpMethod + " url: " + url + " isAsync: " + isAsync + " \n\n");
		this.httpMethod = httpMethod.toUpperCase();
		this.url = url;
		this.options = {
			// verbose: true
		};
		this.options.headers = {};
		
		this.readyState = 0;
		this.status = undefined;
		this.responseText = undefined;
		this.result = undefined;
		this._error = undefined;
	},
	
	onreadystatechange: function () {
		Utils.log("\n\n\n--->>> Error!!  onreadystatechange not overridden!! \n\n");
	},
	
	readyState: 0,
	
	setRequestHeader: function (name, value) {
		//Utils.log("\n\n\n--->>> new request header. name: " + name + " value: " + value + " \n\n");
		if (name == "Content-Length") {
			return;
		}
		this.options.headers[name] = value;
	},
	
	send: function (postBody) {
		this.result = undefined;
		var future = AjaxCall.call(this.httpMethod, this.url, postBody, this.options);

		future.onError(function () {
			Utils.log("\n\n\n--->>> error response received!");
			Utils.log("--->>> future with error: " + stringify(future) + " \n\n");

			this._error = future.getException();
			this.readyState = 4;
			this.onreadystatechange();
		});

		future.then(this, function (join) {
			this.result = join.result;
			
			this.status = this.result.status;
			/*jslint eqeqeq: false */
			if (this.status != 412) {	// Implicit string to int conversion OK here
				/*jslint eqeqeq: true */
				Utils.log("\n\n\n--->>> send called. post body: " + postBody + "");
				Utils.log("--->>> method: " + this.httpMethod + ", url: " + this.url + ", options: " + stringify(this.options));
				Utils.log("\n\n\n--->>> status: " + this.result.status);
				Utils.log("\n--->>> responseText: " + this.result.responseText + " \n");
				Utils.log("\n--->>> responseJSON: " + this.result.responseJSON + " \n");
				Utils.log("\n--->>> response headers: " + stringify(this.result.getAllResponseHeaders()));
			}
			this.responseText = this.result.responseText;
			
			this.readyState = 4;
			this.onreadystatechange();
		});
	},
	
	getResponseHeader: function (name) {
		// Utils.log("\n\n--->>> getResponseHeader called. name: " + name + ", value: " + (this.result && this.result.getResponseHeader(name)));
		return this.result && this.result.getResponseHeader(name);
	},
	
	getAllResponseHeaders: function () {
		// Utils.log("\n\n--->>> getAllResponseHeaders called\n");
		return this.result && this.result.getAllResponseHeaders();
	}
});
