/*jslint white: true, onevar: true, undef: true, eqeqeq: true, plusplus: true, bitwise: true, 
regexp: true, newcap: true, immed: true, nomen: false, maxerr: 500 */
/*global Class, Assert, console, AjaxCall, Contacts, printXhrLogs */

var XMLHttpRequest = Class.create({
	_consoleLog: function () {
		if (printXhrLogs) {
			var argsArray = Array.prototype.slice.call(arguments, 0),
				message = argsArray.reduce(function (accumulatedMessage, curArg) {
					if (typeof curArg === "string") {
						return accumulatedMessage + curArg;
					} else {
						return accumulatedMessage + Contacts.Utils.stringify(curArg);
					}
				}, "");
			
			console.log(message);
		}
	},
	
	open: function (httpMethod, url, isAsync) {
		Assert.requireString(httpMethod);
		Assert.requireString(url);
		
		this._consoleLog("\n\n\n--->>> open called. httpMethod: ", httpMethod, " url: ", url, " isAsync: ", isAsync, " \n\n");
		
		this.httpMethod = httpMethod.toUpperCase();
		this.url = url;
		this.options = {};
		this.options.headers = {};
		
		this.readyState = 0;
		this.status = undefined;
		this.responseText = undefined;
		this._error = undefined;
	},
	
	onreadystatechange: function () {
		throw new Error("Error!!  onreadystatechange not overridden!!");
	},
	
	setRequestHeader: function (name, value) {
		this._consoleLog("\n\n\n--->>> new request header. name: ", name, " value: ", value, " \n\n");
		if (name == "Content-Length") {
			return;
		}
		this.options.headers[name] = value;
	},
	
	send: function (postBody) {
		this._consoleLog("\n\n\n--->>> send called. post body: ", postBody, " \n\n post options: ", this.options, "\n\n");
		
		//for anything other than POST, HEAD, and GET, we use POST with a customRequest property
		if (this.httpMethod !== AjaxCall.RequestMethod.POST && this.httpMethod !== AjaxCall.RequestMethod.HEAD && this.httpMethod !== AjaxCall.RequestMethod.GET) {
			this.options.customRequest = this.httpMethod;
			this.httpMethod = AjaxCall.RequestMethod.POST;
		}
		
		var future = AjaxCall.call(this.httpMethod, this.url, postBody, this.options);
		
		future.onError(function () {
			this._consoleLog("\n\n\n--->>> error response received!");
			this._consoleLog("--->>> future with error: ", future, " \n\n");
			
			this._error = future.getException();
			this.readyState = 4;
			this.onreadystatechange();
		});
		
		future.then(this, function () {
			var result = future.result;
			this._consoleLog("\n\n\n--->>> result: ", result, " \n\n");
			
			this.status = result.status;
			this._consoleLog("\n\n\n--->>> responseText: ", result.responseText, " \n\n");
			this.responseText = result.responseText;
			this.getResponseHeader = result.getResponseHeader;
			this.getAllResponseHeaders = result.getAllResponseHeaders;
			
			this.readyState = 4;
			this.onreadystatechange();
		});
	},
	
	getResponseHeader: function (name) {
		throw new Error("Error: getResponseHeader called, but not yet overridden by response. name: " + name + " \n\n");
	},
	
	getAllResponseHeaders: function () {
		throw new Error("Error: getAllResponseHeaders called, but not yet overridden by response\n\n");
	}
});
